package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateSamplingRuleRequest(
    samplingRuleUpdate: zio.aws.xray.model.SamplingRuleUpdate
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.UpdateSamplingRuleRequest = {
    import UpdateSamplingRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.UpdateSamplingRuleRequest
      .builder()
      .samplingRuleUpdate(samplingRuleUpdate.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.xray.model.UpdateSamplingRuleRequest.ReadOnly =
    zio.aws.xray.model.UpdateSamplingRuleRequest.wrap(buildAwsValue())
}
object UpdateSamplingRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.UpdateSamplingRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.UpdateSamplingRuleRequest =
      zio.aws.xray.model
        .UpdateSamplingRuleRequest(samplingRuleUpdate.asEditable)
    def samplingRuleUpdate: zio.aws.xray.model.SamplingRuleUpdate.ReadOnly
    def getSamplingRuleUpdate
        : ZIO[Any, Nothing, zio.aws.xray.model.SamplingRuleUpdate.ReadOnly] =
      ZIO.succeed(samplingRuleUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.UpdateSamplingRuleRequest
  ) extends zio.aws.xray.model.UpdateSamplingRuleRequest.ReadOnly {
    override val samplingRuleUpdate
        : zio.aws.xray.model.SamplingRuleUpdate.ReadOnly =
      zio.aws.xray.model.SamplingRuleUpdate.wrap(impl.samplingRuleUpdate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.UpdateSamplingRuleRequest
  ): zio.aws.xray.model.UpdateSamplingRuleRequest.ReadOnly = new Wrapper(impl)
}
