package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateSamplingRuleResponse(
    samplingRuleRecord: Optional[zio.aws.xray.model.SamplingRuleRecord] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.UpdateSamplingRuleResponse = {
    import UpdateSamplingRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.UpdateSamplingRuleResponse
      .builder()
      .optionallyWith(samplingRuleRecord.map(value => value.buildAwsValue()))(
        _.samplingRuleRecord
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.UpdateSamplingRuleResponse.ReadOnly =
    zio.aws.xray.model.UpdateSamplingRuleResponse.wrap(buildAwsValue())
}
object UpdateSamplingRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.UpdateSamplingRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.UpdateSamplingRuleResponse =
      zio.aws.xray.model.UpdateSamplingRuleResponse(
        samplingRuleRecord.map(value => value.asEditable)
      )
    def samplingRuleRecord
        : Optional[zio.aws.xray.model.SamplingRuleRecord.ReadOnly]
    def getSamplingRuleRecord
        : ZIO[Any, AwsError, zio.aws.xray.model.SamplingRuleRecord.ReadOnly] =
      AwsError.unwrapOptionField("samplingRuleRecord", samplingRuleRecord)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.UpdateSamplingRuleResponse
  ) extends zio.aws.xray.model.UpdateSamplingRuleResponse.ReadOnly {
    override val samplingRuleRecord
        : Optional[zio.aws.xray.model.SamplingRuleRecord.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.samplingRuleRecord())
        .map(value => zio.aws.xray.model.SamplingRuleRecord.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.UpdateSamplingRuleResponse
  ): zio.aws.xray.model.UpdateSamplingRuleResponse.ReadOnly = new Wrapper(impl)
}
