package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ValueWithServiceIds(
    annotationValue: Optional[zio.aws.xray.model.AnnotationValue] =
      Optional.Absent,
    serviceIds: Optional[Iterable[zio.aws.xray.model.ServiceId]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.ValueWithServiceIds = {
    import ValueWithServiceIds.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.ValueWithServiceIds
      .builder()
      .optionallyWith(annotationValue.map(value => value.buildAwsValue()))(
        _.annotationValue
      )
      .optionallyWith(
        serviceIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceIds)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.ValueWithServiceIds.ReadOnly =
    zio.aws.xray.model.ValueWithServiceIds.wrap(buildAwsValue())
}
object ValueWithServiceIds {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.ValueWithServiceIds
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.ValueWithServiceIds =
      zio.aws.xray.model.ValueWithServiceIds(
        annotationValue.map(value => value.asEditable),
        serviceIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def annotationValue: Optional[zio.aws.xray.model.AnnotationValue.ReadOnly]
    def serviceIds: Optional[List[zio.aws.xray.model.ServiceId.ReadOnly]]
    def getAnnotationValue
        : ZIO[Any, AwsError, zio.aws.xray.model.AnnotationValue.ReadOnly] =
      AwsError.unwrapOptionField("annotationValue", annotationValue)
    def getServiceIds
        : ZIO[Any, AwsError, List[zio.aws.xray.model.ServiceId.ReadOnly]] =
      AwsError.unwrapOptionField("serviceIds", serviceIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.ValueWithServiceIds
  ) extends zio.aws.xray.model.ValueWithServiceIds.ReadOnly {
    override val annotationValue
        : Optional[zio.aws.xray.model.AnnotationValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.annotationValue())
        .map(value => zio.aws.xray.model.AnnotationValue.wrap(value))
    override val serviceIds
        : Optional[List[zio.aws.xray.model.ServiceId.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.ServiceId.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.ValueWithServiceIds
  ): zio.aws.xray.model.ValueWithServiceIds.ReadOnly = new Wrapper(impl)
}
