package zio.aws.xray
import zio.prelude.Subtype
import zio.aws.xray.model.primitives.{
  TraceSegmentDocument,
  AnnotationKey,
  AttributeKey,
  TraceId,
  AttributeValue,
  TagKey
}
import java.time.Instant
import zio.aws.xray.model.primitives.RuleName.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AmazonResourceName extends Subtype[String]
    type AmazonResourceName =
      zio.aws.xray.model.primitives.AmazonResourceName.Type
    object AnnotationKey extends Subtype[String]
    type AnnotationKey = zio.aws.xray.model.primitives.AnnotationKey.Type
    object AttributeKey extends Subtype[String]
    type AttributeKey = zio.aws.xray.model.primitives.AttributeKey.Type
    object AttributeValue extends Subtype[String]
    type AttributeValue = zio.aws.xray.model.primitives.AttributeValue.Type
    object BorrowCount extends Subtype[Int]
    type BorrowCount = zio.aws.xray.model.primitives.BorrowCount.Type
    object ClientID extends Subtype[String]
    type ClientID = zio.aws.xray.model.primitives.ClientID.Type
    object EC2InstanceId extends Subtype[String]
    type EC2InstanceId = zio.aws.xray.model.primitives.EC2InstanceId.Type
    object EncryptionKeyId extends Subtype[String]
    type EncryptionKeyId = zio.aws.xray.model.primitives.EncryptionKeyId.Type
    object EntitySelectorExpression extends Subtype[String]
    type EntitySelectorExpression =
      zio.aws.xray.model.primitives.EntitySelectorExpression.Type
    object EventSummaryText extends Subtype[String]
    type EventSummaryText = zio.aws.xray.model.primitives.EventSummaryText.Type
    object FilterExpression extends Subtype[String]
    type FilterExpression = zio.aws.xray.model.primitives.FilterExpression.Type
    object FixedRate extends Subtype[Double]
    type FixedRate = zio.aws.xray.model.primitives.FixedRate.Type
    object GetGroupsNextToken extends Subtype[String]
    type GetGroupsNextToken =
      zio.aws.xray.model.primitives.GetGroupsNextToken.Type
    object GetInsightEventsMaxResults extends Subtype[Int]
    type GetInsightEventsMaxResults =
      zio.aws.xray.model.primitives.GetInsightEventsMaxResults.Type
    object GetInsightSummariesMaxResults extends Subtype[Int]
    type GetInsightSummariesMaxResults =
      zio.aws.xray.model.primitives.GetInsightSummariesMaxResults.Type
    object GroupARN extends Subtype[String]
    type GroupARN = zio.aws.xray.model.primitives.GroupARN.Type
    object GroupName extends Subtype[String]
    type GroupName = zio.aws.xray.model.primitives.GroupName.Type
    object HTTPMethod extends Subtype[String]
    type HTTPMethod = zio.aws.xray.model.primitives.HTTPMethod.Type
    object Host extends Subtype[String]
    type Host = zio.aws.xray.model.primitives.Host.Type
    object Hostname extends Subtype[String]
    type Hostname = zio.aws.xray.model.primitives.Hostname.Type
    object InsightId extends Subtype[String]
    type InsightId = zio.aws.xray.model.primitives.InsightId.Type
    object InsightSummaryText extends Subtype[String]
    type InsightSummaryText =
      zio.aws.xray.model.primitives.InsightSummaryText.Type
    type Integer = Int
    type NullableBoolean = Boolean
    type NullableDouble = Double
    type NullableInteger = Int
    type NullableLong = Long
    object Priority extends Subtype[Int]
    type Priority = zio.aws.xray.model.primitives.Priority.Type
    object RequestCount extends Subtype[Int]
    type RequestCount = zio.aws.xray.model.primitives.RequestCount.Type
    object ReservoirSize extends Subtype[Int]
    type ReservoirSize = zio.aws.xray.model.primitives.ReservoirSize.Type
    object ResourceARN extends Subtype[String]
    type ResourceARN = zio.aws.xray.model.primitives.ResourceARN.Type
    object RuleName extends Subtype[String]
    type RuleName = zio.aws.xray.model.primitives.RuleName.Type
    object SampledCount extends Subtype[Int]
    type SampledCount = zio.aws.xray.model.primitives.SampledCount.Type
    object SegmentDocument extends Subtype[String]
    type SegmentDocument = zio.aws.xray.model.primitives.SegmentDocument.Type
    object SegmentId extends Subtype[String]
    type SegmentId = zio.aws.xray.model.primitives.SegmentId.Type
    object ServiceName extends Subtype[String]
    type ServiceName = zio.aws.xray.model.primitives.ServiceName.Type
    object ServiceType extends Subtype[String]
    type ServiceType = zio.aws.xray.model.primitives.ServiceType.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.xray.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.xray.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.xray.model.primitives.Timestamp.Type
    object Token extends Subtype[String]
    type Token = zio.aws.xray.model.primitives.Token.Type
    object TraceId extends Subtype[String]
    type TraceId = zio.aws.xray.model.primitives.TraceId.Type
    object TraceSegmentDocument extends Subtype[String]
    type TraceSegmentDocument =
      zio.aws.xray.model.primitives.TraceSegmentDocument.Type
    object URLPath extends Subtype[String]
    type URLPath = zio.aws.xray.model.primitives.URLPath.Type
    object Version extends Subtype[Int]
    type Version = zio.aws.xray.model.primitives.Version.Type
  }
  type AliasList = List[zio.aws.xray.model.Alias]
  type AliasNames = List[String]
  type Annotations =
    Map[AnnotationKey, Iterable[zio.aws.xray.model.ValueWithServiceIds]]
  type AnomalousServiceList = List[zio.aws.xray.model.AnomalousService]
  type AttributeMap = Map[AttributeKey, AttributeValue]
  type EdgeList = List[zio.aws.xray.model.Edge]
  type ErrorRootCauseEntityPath = List[zio.aws.xray.model.ErrorRootCauseEntity]
  type ErrorRootCauseServices = List[zio.aws.xray.model.ErrorRootCauseService]
  type ErrorRootCauses = List[zio.aws.xray.model.ErrorRootCause]
  type FaultRootCauseEntityPath = List[zio.aws.xray.model.FaultRootCauseEntity]
  type FaultRootCauseServices = List[zio.aws.xray.model.FaultRootCauseService]
  type FaultRootCauses = List[zio.aws.xray.model.FaultRootCause]
  type GroupSummaryList = List[zio.aws.xray.model.GroupSummary]
  type Histogram = List[zio.aws.xray.model.HistogramEntry]
  type InsightCategoryList = List[zio.aws.xray.model.InsightCategory]
  type InsightEventList = List[zio.aws.xray.model.InsightEvent]
  type InsightImpactGraphEdgeList =
    List[zio.aws.xray.model.InsightImpactGraphEdge]
  type InsightImpactGraphServiceList =
    List[zio.aws.xray.model.InsightImpactGraphService]
  type InsightStateList = List[zio.aws.xray.model.InsightState]
  type InsightSummaryList = List[zio.aws.xray.model.InsightSummary]
  type ResponseTimeRootCauseEntityPath =
    List[zio.aws.xray.model.ResponseTimeRootCauseEntity]
  type ResponseTimeRootCauseServices =
    List[zio.aws.xray.model.ResponseTimeRootCauseService]
  type ResponseTimeRootCauses = List[zio.aws.xray.model.ResponseTimeRootCause]
  type RootCauseExceptions = List[zio.aws.xray.model.RootCauseException]
  type SamplingRuleRecordList = List[zio.aws.xray.model.SamplingRuleRecord]
  type SamplingStatisticSummaryList =
    List[zio.aws.xray.model.SamplingStatisticSummary]
  type SamplingStatisticsDocumentList =
    List[zio.aws.xray.model.SamplingStatisticsDocument]
  type SamplingTargetDocumentList =
    List[zio.aws.xray.model.SamplingTargetDocument]
  type SegmentList = List[zio.aws.xray.model.Segment]
  type ServiceIds = List[zio.aws.xray.model.ServiceId]
  type ServiceList = List[zio.aws.xray.model.Service]
  type ServiceNames = List[String]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.xray.model.Tag]
  type TelemetryRecordList = List[zio.aws.xray.model.TelemetryRecord]
  type TimeSeriesServiceStatisticsList =
    List[zio.aws.xray.model.TimeSeriesServiceStatistics]
  type TraceAvailabilityZones = List[zio.aws.xray.model.AvailabilityZoneDetail]
  type TraceIdList = List[TraceId]
  type TraceInstanceIds = List[zio.aws.xray.model.InstanceIdDetail]
  type TraceList = List[zio.aws.xray.model.Trace]
  type TraceResourceARNs = List[zio.aws.xray.model.ResourceARNDetail]
  type TraceSegmentDocumentList = List[TraceSegmentDocument]
  type TraceSummaryList = List[zio.aws.xray.model.TraceSummary]
  type TraceUsers = List[zio.aws.xray.model.TraceUser]
  type UnprocessedStatisticsList =
    List[zio.aws.xray.model.UnprocessedStatistics]
  type UnprocessedTraceIdList = List[TraceId]
  type UnprocessedTraceSegmentList =
    List[zio.aws.xray.model.UnprocessedTraceSegment]
  type ValuesWithServiceIds = List[zio.aws.xray.model.ValueWithServiceIds]
}
