/*
 * Decompiled with CFR 0.152.
 */
package zio.json.yaml;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.reader.StreamReader;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.math.BigDecimal$;
import scala.math.BigInt$;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;
import zio.Chunk;
import zio.Chunk$;
import zio.json.ast.Json;
import zio.json.yaml.YamlOptions;
import zio.json.yaml.internal.YamlValueConstruction;

public final class package$ {
    public static final package$ MODULE$ = new package$();
    private static final Regex multiline = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[\n\u0085\u2028\u2029]"));

    public final Json JsonOps(Json json) {
        return json;
    }

    public final <A> A EncoderYamlOps(A a) {
        return a;
    }

    public final String DecoderYamlOps(String raw) {
        return raw;
    }

    private Regex multiline() {
        return multiline;
    }

    public final Node zio$json$yaml$package$$jsonToYaml(Json json, YamlOptions options) {
        ScalarNode scalarNode;
        if (json instanceof Json.Obj) {
            Chunk fields = ((Json.Obj)json).fields();
            Chunk finalFields = options.dropNulls() ? fields.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)package$.$anonfun$jsonToYaml$1(x0$1))) : fields;
            scalarNode = new MappingNode(Tag.MAP, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)finalFields.map((Function1 & Serializable)x0$2 -> {
                if (x0$2 == null) {
                    throw new MatchError(null);
                }
                String key = (String)x0$2._1();
                Json value = (Json)x0$2._2();
                NodeTuple nodeTuple = new NodeTuple((Node)new ScalarNode(Tag.STR, key, null, null, (DumperOptions.ScalarStyle)options.keyStyle().apply((Object)key)), MODULE$.zio$json$yaml$package$$jsonToYaml(value, options));
                return nodeTuple;
            }).toList()).asJava(), (DumperOptions.FlowStyle)options.flowStyle().apply((Object)json));
        } else if (json instanceof Json.Arr) {
            Chunk elements = ((Json.Arr)json).elements();
            scalarNode = new SequenceNode(Tag.SEQ, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)elements.map((Function1 & Serializable)x$6 -> MODULE$.zio$json$yaml$package$$jsonToYaml((Json)x$6, options)).toList()).asJava(), (DumperOptions.FlowStyle)options.flowStyle().apply((Object)json));
        } else if (json instanceof Json.Bool) {
            boolean value = ((Json.Bool)json).value();
            scalarNode = new ScalarNode(Tag.BOOL, Boolean.toString(value), null, null, (DumperOptions.ScalarStyle)options.scalarStyle().apply((Object)json));
        } else if (json instanceof Json.Str) {
            ScalarNode scalarNode2;
            String value = ((Json.Str)json).value();
            DumperOptions.NonPrintableStyle nonPrintableStyle = options.nonPrintableStyle();
            DumperOptions.NonPrintableStyle nonPrintableStyle2 = DumperOptions.NonPrintableStyle.BINARY;
            if (!(nonPrintableStyle != null ? !nonPrintableStyle.equals(nonPrintableStyle2) : nonPrintableStyle2 != null) && !StreamReader.isPrintable((String)value)) {
                scalarNode2 = new ScalarNode(Tag.BINARY, Base64.getEncoder().encodeToString(value.getBytes(StandardCharsets.UTF_8)), null, null, DumperOptions.ScalarStyle.LITERAL);
            } else {
                DumperOptions.ScalarStyle style;
                boolean isMultiLine = this.multiline().findFirstIn((CharSequence)value).isDefined();
                DumperOptions.ScalarStyle scalarStyle = style = (DumperOptions.ScalarStyle)options.scalarStyle().apply((Object)json);
                DumperOptions.ScalarStyle scalarStyle2 = DumperOptions.ScalarStyle.PLAIN;
                DumperOptions.ScalarStyle finalStyle = !(scalarStyle != null ? !scalarStyle.equals(scalarStyle2) : scalarStyle2 != null) && isMultiLine ? DumperOptions.ScalarStyle.LITERAL : style;
                scalarNode2 = new ScalarNode(Tag.STR, value, null, null, finalStyle);
            }
            scalarNode = scalarNode2;
        } else if (json instanceof Json.Num) {
            BigDecimal stripped = ((Json.Num)json).value().stripTrailingZeros();
            scalarNode = stripped.scale() <= 0 ? new ScalarNode(Tag.INT, Integer.toString(stripped.intValue()), null, null, (DumperOptions.ScalarStyle)options.scalarStyle().apply((Object)json)) : new ScalarNode(Tag.FLOAT, stripped.toString(), null, null, (DumperOptions.ScalarStyle)options.scalarStyle().apply((Object)json));
        } else if (Json.Null$.MODULE$.equals(json)) {
            scalarNode = new ScalarNode(Tag.NULL, "null", null, null, (DumperOptions.ScalarStyle)options.scalarStyle().apply((Object)json));
        } else {
            throw new MatchError((Object)json);
        }
        return scalarNode;
    }

    public final Json zio$json$yaml$package$$yamlToJson(Node yaml) {
        YamlValueConstruction construction = new YamlValueConstruction();
        return package$.loop$1(yaml, construction);
    }

    public static final /* synthetic */ boolean $anonfun$jsonToYaml$1(Tuple2 x0$1) {
        boolean bl;
        if (x0$1 != null) {
            Json value = (Json)x0$1._2();
            bl = !Json.Null$.MODULE$.equals(value);
        } else {
            throw new MatchError(null);
        }
        return bl;
    }

    private static final Json loop$1(Node node, YamlValueConstruction construction$1) {
        Json.Null$ null$;
        if (node instanceof ScalarNode) {
            Json.Null$ null$2;
            ScalarNode scalarNode = (ScalarNode)node;
            Object object = construction$1.toJavaValue((Node)scalarNode);
            if (object == null) {
                null$2 = Json.Null$.MODULE$;
            } else if (object instanceof String) {
                String string = (String)object;
                null$2 = new Json.Str(string);
            } else if (object instanceof Boolean) {
                Boolean bl = (Boolean)object;
                null$2 = new Json.Bool(Predef$.MODULE$.Boolean2boolean(bl));
            } else if (object instanceof Integer) {
                Integer n = (Integer)object;
                null$2 = Json.Num$.MODULE$.apply(Predef$.MODULE$.Integer2int(n));
            } else if (object instanceof Long) {
                Long l = (Long)object;
                null$2 = Json.Num$.MODULE$.apply(Predef$.MODULE$.Long2long(l));
            } else if (object instanceof BigInteger) {
                BigInteger bigInteger = (BigInteger)object;
                null$2 = Json.Num$.MODULE$.apply(BigDecimal$.MODULE$.apply(BigInt$.MODULE$.javaBigInteger2bigInt(bigInteger)));
            } else if (object instanceof Float) {
                Float f = (Float)object;
                null$2 = Json.Num$.MODULE$.apply(Predef$.MODULE$.Float2float(f));
            } else if (object instanceof Double) {
                Double d = (Double)object;
                null$2 = Json.Num$.MODULE$.apply(Predef$.MODULE$.Double2double(d));
            } else if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                null$2 = new Json.Str(new String(byArray, StandardCharsets.UTF_8));
            } else {
                null$2 = new Json.Str(scalarNode.getValue());
            }
            null$ = null$2;
        } else if (node instanceof SequenceNode) {
            SequenceNode sequenceNode = (SequenceNode)node;
            null$ = new Json.Arr(Chunk$.MODULE$.fromIterable((Iterable)CollectionConverters$.MODULE$.ListHasAsScala(sequenceNode.getValue()).asScala().map((Function1 & Serializable)yaml -> MODULE$.zio$json$yaml$package$$yamlToJson((Node)yaml))));
        } else if (node instanceof MappingNode) {
            MappingNode mappingNode = (MappingNode)node;
            null$ = new Json.Obj(Chunk$.MODULE$.fromIterable((Iterable)CollectionConverters$.MODULE$.ListHasAsScala(construction$1.processMappingNode(mappingNode).getValue()).asScala().map((Function1 & Serializable)tuple -> {
                Node node = tuple.getKeyNode();
                if (!(node instanceof ScalarNode)) {
                    throw new YAMLException("Mapping key is not scalar");
                }
                String string = ((ScalarNode)node).getValue();
                Json jsonValue = package$.loop$1(tuple.getValueNode(), construction$1);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)string), (Object)jsonValue);
            })));
        } else {
            throw new YAMLException(new StringBuilder(23).append("Unsupported node type: ").append(node.getClass().getSimpleName()).toString());
        }
        return null$;
    }

    private package$() {
    }
}

