/*
 * Decompiled with CFR 0.152.
 */
package zio.rocksdb;

import java.io.Serializable;
import scala.Product;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import zio.rocksdb.DeserializeError$;
import zio.rocksdb.DeserializeError$ChunkError$;
import zio.rocksdb.DeserializeError$TooShort$;
import zio.rocksdb.DeserializeError$UnexpectedByte$;

public abstract class DeserializeError {
    private final String message;

    public static int ordinal(DeserializeError deserializeError) {
        return DeserializeError$.MODULE$.ordinal(deserializeError);
    }

    public DeserializeError(String message) {
        this.message = message;
    }

    public String message() {
        return this.message;
    }

    public static final class ChunkError
    extends DeserializeError
    implements Product,
    Serializable {
        private final Throwable underlying;

        public static ChunkError apply(Throwable throwable) {
            return DeserializeError$ChunkError$.MODULE$.apply(throwable);
        }

        public static ChunkError fromProduct(Product product) {
            return DeserializeError$ChunkError$.MODULE$.fromProduct(product);
        }

        public static ChunkError unapply(ChunkError chunkError) {
            return DeserializeError$ChunkError$.MODULE$.unapply(chunkError);
        }

        public ChunkError(Throwable underlying) {
            this.underlying = underlying;
            super(underlying.getMessage());
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ChunkError)) return false;
            ChunkError chunkError = (ChunkError)object;
            Throwable throwable = this.underlying();
            Throwable throwable2 = chunkError.underlying();
            if (throwable != null) {
                if (!throwable.equals(throwable2)) return false;
                return true;
            }
            if (throwable2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ChunkError;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ChunkError";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "underlying";
        }

        public Throwable underlying() {
            return this.underlying;
        }

        public ChunkError copy(Throwable underlying) {
            return new ChunkError(underlying);
        }

        public Throwable copy$default$1() {
            return this.underlying();
        }

        public Throwable _1() {
            return this.underlying();
        }
    }

    public static final class TooShort
    extends DeserializeError
    implements Product,
    Serializable {
        private final int got;
        private final int expected;

        public static TooShort apply(int n, int n2) {
            return DeserializeError$TooShort$.MODULE$.apply(n, n2);
        }

        public static TooShort fromProduct(Product product) {
            return DeserializeError$TooShort$.MODULE$.fromProduct(product);
        }

        public static TooShort unapply(TooShort tooShort) {
            return DeserializeError$TooShort$.MODULE$.unapply(tooShort);
        }

        public TooShort(int got, int expected) {
            this.got = got;
            this.expected = expected;
            super(new StringBuilder(33).append("chunk too short, was ").append(got).append(", expected: ").append(expected).toString());
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.got());
            n = Statics.mix((int)n, (int)this.expected());
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TooShort)) return false;
            TooShort tooShort = (TooShort)object;
            if (this.got() != tooShort.got()) return false;
            if (this.expected() != tooShort.expected()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof TooShort;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "TooShort";
        }

        public Object productElement(int n) {
            int n2;
            int n3 = n;
            if (0 == n3) {
                n2 = this._1();
            } else if (1 == n3) {
                n2 = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToInteger((int)n2);
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "got";
            } else if (1 == n2) {
                string = "expected";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public int got() {
            return this.got;
        }

        public int expected() {
            return this.expected;
        }

        public TooShort copy(int got, int expected) {
            return new TooShort(got, expected);
        }

        public int copy$default$1() {
            return this.got();
        }

        public int copy$default$2() {
            return this.expected();
        }

        public int _1() {
            return this.got();
        }

        public int _2() {
            return this.expected();
        }
    }

    public static final class UnexpectedByte
    extends DeserializeError
    implements Product,
    Serializable {
        private final byte got;
        private final List expected;

        public static UnexpectedByte apply(byte by, List<Object> list) {
            return DeserializeError$UnexpectedByte$.MODULE$.apply(by, list);
        }

        public static UnexpectedByte fromProduct(Product product) {
            return DeserializeError$UnexpectedByte$.MODULE$.fromProduct(product);
        }

        public static UnexpectedByte unapply(UnexpectedByte unexpectedByte) {
            return DeserializeError$UnexpectedByte$.MODULE$.unapply(unexpectedByte);
        }

        public UnexpectedByte(byte got, List<Object> expected) {
            this.got = got;
            this.expected = expected;
            super(new StringBuilder(23).append("Got ").append(got).append(", expected one of: ").append(expected.mkString(",")).toString());
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.got());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.expected()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UnexpectedByte)) return false;
            UnexpectedByte unexpectedByte = (UnexpectedByte)object;
            if (this.got() != unexpectedByte.got()) return false;
            List<Object> list = this.expected();
            List<Object> list2 = unexpectedByte.expected();
            if (list != null) {
                if (!list.equals(list2)) return false;
                return true;
            }
            if (list2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof UnexpectedByte;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "UnexpectedByte";
        }

        public Object productElement(int n) {
            List<Object> list;
            int n2 = n;
            if (0 == n2) {
                list = BoxesRunTime.boxToByte((byte)this._1());
            } else if (1 == n2) {
                list = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return list;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "got";
            } else if (1 == n2) {
                string = "expected";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public byte got() {
            return this.got;
        }

        public List<Object> expected() {
            return this.expected;
        }

        public UnexpectedByte copy(byte got, List<Object> expected) {
            return new UnexpectedByte(got, expected);
        }

        public byte copy$default$1() {
            return this.got();
        }

        public List<Object> copy$default$2() {
            return this.expected();
        }

        public byte _1() {
            return this.got();
        }

        public List<Object> _2() {
            return this.expected();
        }
    }
}

