/*
 * Decompiled with CFR 0.152.
 */
package zio.rocksdb;

import java.io.Serializable;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ReadOptions;
import org.rocksdb.TransactionDB;
import org.rocksdb.WriteOptions;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.function.JProcedure1;
import zio.Scope;
import zio.Semaphore;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.rocksdb.Transaction$;
import zio.rocksdb.Transaction$Live$;

public interface Transaction {
    public static ZLayer<Object, Throwable, Transaction> live(TransactionDB transactionDB) {
        return Transaction$.MODULE$.live(transactionDB);
    }

    public static ZLayer<Object, Throwable, Transaction> live(TransactionDB transactionDB, WriteOptions writeOptions) {
        return Transaction$.MODULE$.live(transactionDB, writeOptions);
    }

    public ZIO<Object, Throwable, Option<byte[]>> get(ReadOptions var1, byte[] var2);

    public static ZIO get$(Transaction $this, byte[] key) {
        return $this.get(key);
    }

    default public ZIO<Object, Throwable, Option<byte[]>> get(byte[] key) {
        return this.get(new ReadOptions(), key);
    }

    public ZIO<Object, Throwable, Option<byte[]>> getForUpdate(ReadOptions var1, byte[] var2, boolean var3);

    public static ZIO getForUpdate$(Transaction $this, byte[] key, boolean exclusive) {
        return $this.getForUpdate(key, exclusive);
    }

    default public ZIO<Object, Throwable, Option<byte[]>> getForUpdate(byte[] key, boolean exclusive) {
        return this.getForUpdate(new ReadOptions(), key, exclusive);
    }

    public ZIO<Object, Throwable, Option<byte[]>> getForUpdate(ReadOptions var1, ColumnFamilyHandle var2, byte[] var3, boolean var4);

    public static ZIO getForUpdate$(Transaction $this, ColumnFamilyHandle cf, byte[] key, boolean exclusive) {
        return $this.getForUpdate(cf, key, exclusive);
    }

    default public ZIO<Object, Throwable, Option<byte[]>> getForUpdate(ColumnFamilyHandle cf, byte[] key, boolean exclusive) {
        return this.getForUpdate(new ReadOptions(), cf, key, exclusive);
    }

    public ZIO<Object, Throwable, BoxedUnit> put(byte[] var1, byte[] var2);

    public ZIO<Object, Throwable, BoxedUnit> put(ColumnFamilyHandle var1, byte[] var2, byte[] var3);

    public ZIO<Object, Throwable, BoxedUnit> delete(byte[] var1);

    public ZIO<Object, Throwable, BoxedUnit> delete(ColumnFamilyHandle var1, byte[] var2);

    public ZIO<Object, Throwable, BoxedUnit> commit();

    public ZIO<Object, Nothing$, BoxedUnit> close();

    public ZIO<Object, Throwable, BoxedUnit> rollback();

    public static final class Live
    implements Transaction {
        private final Semaphore semaphore;
        private final org.rocksdb.Transaction transaction;

        public static ZIO<Scope, Throwable, Transaction> begin(TransactionDB transactionDB, WriteOptions writeOptions) {
            return Transaction$Live$.MODULE$.begin(transactionDB, writeOptions);
        }

        public Live(Semaphore semaphore, org.rocksdb.Transaction transaction) {
            this.semaphore = semaphore;
            this.transaction = transaction;
        }

        public <A> ZIO<Object, Throwable, A> taskWithPermit(Function0<A> task) {
            return this.semaphore.withPermit(ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$1 -> task.apply(), (Object)"zio.rocksdb.Transaction$.Live.taskWithPermit.macro(Transaction.scala:86)"), (Object)"zio.rocksdb.Transaction$.Live.taskWithPermit.macro(Transaction.scala:86)");
        }

        public <A> ZIO<Object, Nothing$, A> uioWithPermit(Function0<A> task) {
            return this.semaphore.withPermit(ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$2 -> task.apply(), (Object)"zio.rocksdb.Transaction$.Live.uioWithPermit.macro(Transaction.scala:88)"), (Object)"zio.rocksdb.Transaction$.Live.uioWithPermit.macro(Transaction.scala:88)");
        }

        @Override
        public ZIO<Object, Throwable, Option<byte[]>> get(ReadOptions readOptions, byte[] key) {
            return this.taskWithPermit(() -> this.get$$anonfun$1(readOptions, key));
        }

        @Override
        public ZIO<Object, Throwable, Option<byte[]>> getForUpdate(ReadOptions readOptions, byte[] key, boolean exclusive) {
            return this.taskWithPermit(() -> this.getForUpdate$$anonfun$1(readOptions, key, exclusive));
        }

        @Override
        public ZIO<Object, Throwable, BoxedUnit> put(byte[] key, byte[] value) {
            return this.semaphore.withPermit(ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$3 -> this.transaction.put(key, value), (Object)"zio.rocksdb.Transaction$.Live.put.macro(Transaction.scala:104)"), (Object)"zio.rocksdb.Transaction$.Live.put.macro(Transaction.scala:105)");
        }

        @Override
        public ZIO<Object, Throwable, BoxedUnit> delete(byte[] key) {
            return this.taskWithPermit((Function0 & Serializable)() -> {
                this.delete$$anonfun$1(key);
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public ZIO<Object, Throwable, BoxedUnit> delete(ColumnFamilyHandle cfHandle, byte[] key) {
            return this.taskWithPermit((Function0 & Serializable)() -> {
                this.delete$$anonfun$2(cfHandle, key);
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public ZIO<Object, Throwable, BoxedUnit> commit() {
            return this.taskWithPermit((Function0 & Serializable)() -> {
                this.commit$$anonfun$1();
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public ZIO<Object, Nothing$, BoxedUnit> close() {
            return this.uioWithPermit((Function0 & Serializable)() -> {
                this.close$$anonfun$1();
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public ZIO<Object, Throwable, BoxedUnit> rollback() {
            return this.taskWithPermit((Function0 & Serializable)() -> {
                this.rollback$$anonfun$1();
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public ZIO<Object, Throwable, Option<byte[]>> getForUpdate(ReadOptions readOptions, ColumnFamilyHandle cf, byte[] key, boolean exclusive) {
            return this.taskWithPermit(() -> this.getForUpdate$$anonfun$2(readOptions, cf, key, exclusive));
        }

        @Override
        public ZIO<Object, Throwable, BoxedUnit> put(ColumnFamilyHandle cf, byte[] key, byte[] value) {
            return this.taskWithPermit((Function0 & Serializable)() -> {
                this.put$$anonfun$2(cf, key, value);
                return BoxedUnit.UNIT;
            });
        }

        private final Option get$$anonfun$1(ReadOptions readOptions$1, byte[] key$1) {
            return Option$.MODULE$.apply((Object)this.transaction.get(readOptions$1, key$1));
        }

        private final Option getForUpdate$$anonfun$1(ReadOptions readOptions$2, byte[] key$2, boolean exclusive$1) {
            return Option$.MODULE$.apply((Object)this.transaction.getForUpdate(readOptions$2, key$2, exclusive$1));
        }

        private final void delete$$anonfun$1(byte[] key$4) {
            this.transaction.delete(key$4);
        }

        private final void delete$$anonfun$2(ColumnFamilyHandle cfHandle$1, byte[] key$5) {
            this.transaction.delete(cfHandle$1, key$5);
        }

        private final void commit$$anonfun$1() {
            this.transaction.commit();
        }

        private final void close$$anonfun$1() {
            this.transaction.close();
        }

        private final void rollback$$anonfun$1() {
            this.transaction.rollback();
        }

        private final Option getForUpdate$$anonfun$2(ReadOptions readOptions$3, ColumnFamilyHandle cf$1, byte[] key$6, boolean exclusive$2) {
            return Option$.MODULE$.apply((Object)this.transaction.getForUpdate(readOptions$3, cf$1, key$6, exclusive$2));
        }

        private final void put$$anonfun$2(ColumnFamilyHandle cf$2, byte[] key$7, byte[] value$2) {
            this.transaction.put(cf$2, key$7, value$2);
        }
    }
}

