/*
 * Decompiled with CFR 0.152.
 */
package zio.s3;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.S3Exception;
import zio.CanFail$;
import zio.Chunk;
import zio.Chunk$;
import zio.Has;
import zio.IO$;
import zio.NeedsEnv$;
import zio.Ref$;
import zio.Task$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZManaged$;
import zio.ZRef;
import zio.ZRef$;
import zio.blocking.package;
import zio.nio.channels.FileChannel$;
import zio.nio.core.file.Path;
import zio.nio.file.Files$;
import zio.s3.ListObjectOptions;
import zio.s3.ListObjectOptions$;
import zio.s3.MultipartUploadOptions;
import zio.s3.ObjectMetadata;
import zio.s3.PartSize$;
import zio.s3.S3Bucket;
import zio.s3.S3ObjectListing;
import zio.s3.S3ObjectSummary;
import zio.s3.Test$;
import zio.s3.UploadOptions;
import zio.s3.package;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public final class Test$ {
    public static Test$ MODULE$;

    static {
        new Test$();
    }

    public S3Exception zio$s3$Test$$fileNotFound(FileNotFoundException err) {
        return (S3Exception)S3Exception.builder().message("Key does not exist.").cause((Throwable)err).statusCode(404).build();
    }

    public Function1<Has<package.Blocking.Service>, package.S3.Service> connect(Path path) {
        return (Function1 & Serializable & scala.Serializable)blocking -> new package.S3.Service(path, (Has)blocking){
            private final ZRef<Nothing$, Nothing$, Map<String, Tuple2<String, Map<String, String>>>, Map<String, Tuple2<String, Map<String, String>>>> refDb;
            private final ZIO<Object, S3Exception, Chunk<S3Bucket>> listBuckets;
            private final Path path$1;
            private final Has blocking$1;

            public ZIO<Object, S3Exception, S3ObjectListing> listObjects(String bucketName) {
                return package.S3.Service.listObjects$(this, bucketName);
            }

            public <R> UploadOptions putObject$default$5() {
                return package.S3.Service.putObject$default$5$(this);
            }

            public <R> MultipartUploadOptions multipartUpload$default$4() {
                return package.S3.Service.multipartUpload$default$4$(this);
            }

            public ZStream<Object, S3Exception, String> streamLines(String bucketName, String key) {
                return package.S3.Service.streamLines$(this, bucketName, key);
            }

            public ZStream<Object, S3Exception, S3ObjectSummary> listAllObjects(String bucketName) {
                return package.S3.Service.listAllObjects$(this, bucketName);
            }

            public ZStream<Object, S3Exception, S3ObjectSummary> listAllObjects(String bucketName, ListObjectOptions options) {
                return package.S3.Service.listAllObjects$(this, bucketName, options);
            }

            public ZStream<Object, S3Exception, S3ObjectListing> paginate(S3ObjectListing initialListing) {
                return package.S3.Service.paginate$(this, initialListing);
            }

            private ZRef<Nothing$, Nothing$, Map<String, Tuple2<String, Map<String, String>>>, Map<String, Tuple2<String, Map<String, String>>>> refDb() {
                return this.refDb;
            }

            public ZIO<Object, S3Exception, BoxedUnit> createBucket(String bucketName) {
                return Files$.MODULE$.createDirectory(this.path$1.$div(bucketName), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileAttribute[0])).orDie(Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail()).provide((Object)this.blocking$1, NeedsEnv$.MODULE$.needsEnv());
            }

            public ZIO<Object, S3Exception, BoxedUnit> deleteBucket(String bucketName) {
                return Files$.MODULE$.delete(this.path$1.$div(bucketName)).orDie(Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail()).provide((Object)this.blocking$1, NeedsEnv$.MODULE$.needsEnv());
            }

            public ZIO<Object, S3Exception, Object> isBucketExists(String bucketName) {
                return Files$.MODULE$.exists(this.path$1.$div(bucketName), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new LinkOption[0])).provide((Object)this.blocking$1, NeedsEnv$.MODULE$.needsEnv());
            }

            public ZIO<Object, S3Exception, Chunk<S3Bucket>> listBuckets() {
                return this.listBuckets;
            }

            public ZIO<Object, S3Exception, BoxedUnit> deleteObject(String bucketName, String key) {
                return Files$.MODULE$.deleteIfExists(this.path$1.$div(bucketName).$div(key)).orDie(Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail()).provide((Object)this.blocking$1, NeedsEnv$.MODULE$.needsEnv()).unit();
            }

            public ZStream<Object, S3Exception, Object> getObject(String bucketName, String key) {
                return ZStream$.MODULE$.managed(ZManaged$.MODULE$.fromAutoCloseable(Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new FileInputStream($this.path$1.$div(bucketName).$div(key).toFile())))).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> ZStream$.MODULE$.fromInputStream((Function0 & Serializable & scala.Serializable)() -> x$2, 2048)).refineOrDie((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        if (x1 instanceof FileNotFoundException) {
                            FileNotFoundException fileNotFoundException = (FileNotFoundException)x1;
                            object = Test$.MODULE$.zio$s3$Test$$fileNotFound(fileNotFoundException);
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        boolean bl = x1 instanceof FileNotFoundException;
                        return bl;
                    }
                }, Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail()).provide((Object)this.blocking$1, NeedsEnv$.MODULE$.needsEnv());
            }

            public ZIO<Object, S3Exception, ObjectMetadata> getObjectMetadata(String bucketName, String key) {
                return ZIO.ZIOWithFilterOps$.MODULE$.withFilter$extension(ZIO$.MODULE$.ZIOWithFilterOps(this.refDb().get().map((Function1 & Serializable & scala.Serializable)x$3 -> (Tuple2)x$3.getOrElse((Object)new StringBuilder(0).append(bucketName).append(key).toString(), (Function0 & Serializable & scala.Serializable)() -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)Predef$.MODULE$.Map().empty())))), (Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$getObjectMetadata$3(check$ifrefutable$1)), ZIO.CanFilter$.MODULE$.canFilter()).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
                    if (x$4 == null) {
                        throw new MatchError(null);
                    }
                    String contentType = (String)x$4._1();
                    Map metadata = (Map)x$4._2();
                    ZIO zIO = Files$.MODULE$.readAttributes($this.path$1.$div(bucketName).$div(key), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new LinkOption[0]), ClassTag$.MODULE$.apply(BasicFileAttributes.class)).map((Function1 & Serializable & scala.Serializable)p -> new ObjectMetadata((Map<String, String>)metadata, contentType, p.size())).provide((Object)$this.blocking$1, NeedsEnv$.MODULE$.needsEnv()).map((Function1 & Serializable & scala.Serializable)file -> file);
                    return zIO;
                }).orDie(Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
            }

            public ZIO<Object, S3Exception, S3ObjectListing> listObjects(String bucketName, ListObjectOptions options) {
                return Files$.MODULE$.find(this.path$1.$div(bucketName), Files$.MODULE$.find$default$2(), Files$.MODULE$.find$default$3(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$listObjects$1(this, options, bucketName, x0$1, x1$1))).mapM((Function1 & Serializable & scala.Serializable)p -> Files$.MODULE$.readAttributes(p, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new LinkOption[0]), ClassTag$.MODULE$.apply(BasicFileAttributes.class)).map((Function1 & Serializable & scala.Serializable)a -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(a), p))).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$listObjects$8(x0$2))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    if (x0$3 == null) {
                        throw new MatchError(null);
                    }
                    BasicFileAttributes attr = (BasicFileAttributes)x0$3._1();
                    Path f = (Path)x0$3._2();
                    S3ObjectSummary s3ObjectSummary = new S3ObjectSummary(bucketName, $this.path$1.$div(bucketName).relativize(f).toString(), attr.lastModifiedTime().toInstant(), attr.size());
                    return s3ObjectSummary;
                }).runCollect().map((Function1 & Serializable & scala.Serializable)x$5 -> ((Chunk)((Chunk)x$5.sortBy((Function1 & Serializable & scala.Serializable)x$6 -> x$6.key(), (Ordering)Ordering.String$.MODULE$)).mapAccum(options.starAfter(), (Function2 & Serializable & scala.Serializable)(x0$4, x1$2) -> {
                    String startWith;
                    Tuple2 tuple2 = x0$4 instanceof Some ? ((startWith = (String)((Some)x0$4).value()).startsWith(x1$2.key()) ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)None$.MODULE$), (Object)Chunk$.MODULE$.empty()) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Some((Object)startWith)), (Object)Chunk$.MODULE$.empty())) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)None$.MODULE$), (Object)Chunk$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new S3ObjectSummary[]{x1$2})));
                    return tuple2;
                })._2()).flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable & scala.Serializable)x0$5 -> {
                    S3ObjectListing s3ObjectListing = (long)x0$5.size() > options.maxKeys() ? new S3ObjectListing(bucketName, options.delimiter(), options.starAfter(), (Chunk<S3ObjectSummary>)x0$5.take((int)options.maxKeys()), (Option<String>)new Some((Object)UUID.randomUUID().toString()), (Option<String>)None$.MODULE$) : new S3ObjectListing(bucketName, options.delimiter(), options.starAfter(), (Chunk<S3ObjectSummary>)x0$5, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
                    return s3ObjectListing;
                }).orDie(Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail()).provide((Object)this.blocking$1, NeedsEnv$.MODULE$.needsEnv());
            }

            public ZIO<Object, S3Exception, S3ObjectListing> getNextObjects(S3ObjectListing listing) {
                String token;
                Option<String> option = listing.nextContinuationToken();
                ZIO<Object, S3Exception, S3ObjectListing> zIO = option instanceof Some && new StringOps(Predef$.MODULE$.augmentString(token = (String)((Some)option).value())).nonEmpty() ? this.listObjects(listing.bucketName(), ListObjectOptions$.MODULE$.fromMaxKeys(100L)) : ZIO$.MODULE$.dieMessage((Function0 & Serializable & scala.Serializable)() -> "Empty token is invalid");
                return zIO;
            }

            public <R> ZIO<R, S3Exception, BoxedUnit> putObject(String bucketName, String key, long contentLength, ZStream<R, Throwable, Object> content, UploadOptions options) {
                return ZRef.UnifiedSyntax$.MODULE$.update$extension(ZRef$.MODULE$.UnifiedSyntax(this.refDb()), (Function1 & Serializable & scala.Serializable)db -> db.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(bucketName).append(key).toString()), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(options.contentType().getOrElse((Function0 & Serializable & scala.Serializable)() -> "application/octet-stream")), options.metadata())))).map((Function1 & Serializable & scala.Serializable)x$7 -> {
                    Path filePath = $this.path$1.$div(bucketName).$div(key);
                    return new Tuple2(x$7, (Object)filePath);
                }).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> {
                    if (x$8 == null) {
                        throw new MatchError(null);
                    }
                    Path filePath = (Path)x$8._2();
                    ZIO zIO = ((ZIO)filePath.parent().map((Function1 & Serializable & scala.Serializable)parentPath -> Files$.MODULE$.createDirectories(parentPath, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileAttribute[0])).provide((Object)$this.blocking$1, NeedsEnv$.MODULE$.needsEnv())).getOrElse((Function0 & Serializable & scala.Serializable)() -> ZIO$.MODULE$.unit())).flatMap((Function1 & Serializable & scala.Serializable)_2 -> FileChannel$.MODULE$.open(filePath, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW})).provide((Object)$this.blocking$1, NeedsEnv$.MODULE$.needsEnv()).use((Function1 & Serializable & scala.Serializable)channel -> content.foreachChunk((Function1 & Serializable & scala.Serializable)src -> channel.writeChunk(src))).map((Function1 & Serializable & scala.Serializable)_ -> {
                        anon.1.$anonfun$putObject$10(_);
                        return BoxedUnit.UNIT;
                    }));
                    return zIO;
                }).orDie(Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
            }

            public <T> ZIO<Object, S3Exception, T> execute(Function1<S3AsyncClient, CompletableFuture<T>> f) {
                return IO$.MODULE$.dieMessage((Function0 & Serializable & scala.Serializable)() -> "Not implemented error - please don't call execute() S3 Test mode");
            }

            public <R> ZIO<R, S3Exception, BoxedUnit> multipartUpload(String bucketName, String key, ZStream<R, Throwable, Object> content, MultipartUploadOptions options, int parallelism) {
                Option _contentType = options.uploadOptions().contentType().orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)"binary/octet-stream"));
                return ZIO$.MODULE$.dieMessage((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("parallelism must be > 0. ").append(parallelism).append(" is invalid").toString()).unless((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> parallelism > 0).flatMap((Function1 & Serializable & scala.Serializable)_ -> ZIO$.MODULE$.dieMessage((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Invalid part size ").append(Math.floor((double)options.partSize() / (double)PartSize$.MODULE$.Mega() * 100.0) / 100.0).append(" Mb, minimum size is ").append(PartSize$.MODULE$.Min() / PartSize$.MODULE$.Mega()).append(" Mb").toString()).unless((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> options.partSize() >= PartSize$.MODULE$.Min()).flatMap((Function1 & Serializable & scala.Serializable)_2 -> {
                    Map<String, String> x$2 = options.uploadOptions().copy$default$1();
                    ObjectCannedACL x$3 = options.uploadOptions().copy$default$2();
                    return this.putObject(bucketName, key, 0L, content.chunkN(options.partSize()), options.uploadOptions().copy(x$2, x$3, (Option<String>)_contentType)).map((Function1 & Serializable & scala.Serializable)_ -> {
                        anon.1.$anonfun$multipartUpload$8(_);
                        return BoxedUnit.UNIT;
                    });
                }));
            }

            public static final /* synthetic */ boolean $anonfun$listBuckets$2(BasicFileAttributes x$1) {
                return x$1.isDirectory();
            }

            public static final /* synthetic */ boolean $anonfun$getObjectMetadata$3(Tuple2 check$ifrefutable$1) {
                boolean bl = check$ifrefutable$1 != null;
                return bl;
            }

            public static final /* synthetic */ boolean $anonfun$listObjects$3(String eta$0$1$1, String x$1) {
                return eta$0$1$1.startsWith(x$1);
            }

            public static final /* synthetic */ boolean $anonfun$listObjects$5(String eta$0$2$1, String x$1) {
                return eta$0$2$1.startsWith(x$1);
            }

            public static final /* synthetic */ boolean $anonfun$listObjects$1(anon.1 $this, ListObjectOptions options$1, String bucketName$3, Path x0$1, BasicFileAttributes x1$1) {
                boolean bl = options$1.delimiter().nonEmpty() ? BoxesRunTime.unboxToBoolean((Object)options$1.prefix().fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true, arg_0 -> anon.1.$anonfun$listObjects$3$adapted($this.path$1.$div(bucketName$3).relativize(x0$1).toString(), arg_0))) : BoxesRunTime.unboxToBoolean((Object)options$1.prefix().fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true, arg_0 -> anon.1.$anonfun$listObjects$5$adapted(x0$1.filename().toString(), arg_0)));
                return bl;
            }

            public static final /* synthetic */ boolean $anonfun$listObjects$8(Tuple2 x0$2) {
                if (x0$2 == null) {
                    throw new MatchError(null);
                }
                boolean bl = ((BasicFileAttributes)x0$2._1()).isRegularFile();
                return bl;
            }

            public static final /* synthetic */ void $anonfun$putObject$10(BoxedUnit _) {
            }

            public static final /* synthetic */ void $anonfun$multipartUpload$8(BoxedUnit _) {
            }
            {
                this.path$1 = path$1;
                this.blocking$1 = blocking$1;
                package.S3.Service.$init$(this);
                this.refDb = Ref$.MODULE$.unsafeMake((Object)Predef$.MODULE$.Map().empty());
                this.listBuckets = Files$.MODULE$.list(path$1).filterM((Function1 & Serializable & scala.Serializable)p -> Files$.MODULE$.readAttributes(p, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new LinkOption[0]), ClassTag$.MODULE$.apply(BasicFileAttributes.class)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$listBuckets$2(x$1)))).mapM((Function1 & Serializable & scala.Serializable)p -> Files$.MODULE$.readAttributes(p, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new LinkOption[0]), ClassTag$.MODULE$.apply(BasicFileAttributes.class)).map((Function1 & Serializable & scala.Serializable)attr -> new S3Bucket(p.filename().toString(), attr.creationTime().toInstant()))).runCollect().orDie(Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail()).provide((Object)blocking$1, NeedsEnv$.MODULE$.needsEnv());
            }

            public static final /* synthetic */ Object $anonfun$listObjects$3$adapted(String eta$0$1$1, String x$1) {
                return BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$listObjects$3(eta$0$1$1, x$1));
            }

            public static final /* synthetic */ Object $anonfun$listObjects$5$adapted(String eta$0$2$1, String x$1) {
                return BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$listObjects$5(eta$0$2$1, x$1));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$getObject$1(zio.s3.Test$$anon$1 java.lang.String java.lang.String ), $anonfun$getObject$2(java.io.FileInputStream ), $anonfun$getObjectMetadata$1(java.lang.String java.lang.String scala.collection.immutable.Map ), $anonfun$getObjectMetadata$3$adapted(scala.Tuple2 ), $anonfun$getObjectMetadata$4(zio.s3.Test$$anon$1 java.lang.String java.lang.String scala.Tuple2 ), $anonfun$listObjects$1$adapted(zio.s3.Test$$anon$1 zio.s3.ListObjectOptions java.lang.String zio.nio.core.file.Path java.nio.file.attribute.BasicFileAttributes ), $anonfun$listObjects$6(zio.nio.core.file.Path ), $anonfun$listObjects$8$adapted(scala.Tuple2 ), $anonfun$listObjects$9(zio.s3.Test$$anon$1 java.lang.String scala.Tuple2 ), $anonfun$listObjects$10(zio.s3.ListObjectOptions zio.Chunk ), $anonfun$listObjects$13(zio.s3.ListObjectOptions java.lang.String zio.Chunk ), $anonfun$getNextObjects$1(), $anonfun$putObject$1(java.lang.String java.lang.String zio.s3.UploadOptions scala.collection.immutable.Map ), $anonfun$putObject$3(zio.s3.Test$$anon$1 java.lang.String java.lang.String scala.runtime.BoxedUnit ), $anonfun$putObject$4(zio.s3.Test$$anon$1 zio.stream.ZStream scala.Tuple2 ), $anonfun$execute$1(), $anonfun$multipartUpload$1(), $anonfun$multipartUpload$2(int ), $anonfun$multipartUpload$3(int ), $anonfun$multipartUpload$4(zio.s3.Test$$anon$1 zio.s3.MultipartUploadOptions java.lang.String java.lang.String zio.stream.ZStream scala.Option scala.runtime.BoxedUnit ), $anonfun$listBuckets$2$adapted(java.nio.file.attribute.BasicFileAttributes ), $anonfun$listBuckets$4(zio.nio.core.file.Path java.nio.file.attribute.BasicFileAttributes ), $anonfun$getObject$3(java.io.FileInputStream ), $anonfun$getObjectMetadata$2(), $anonfun$getObjectMetadata$5(scala.collection.immutable.Map java.lang.String java.nio.file.attribute.BasicFileAttributes ), $anonfun$getObjectMetadata$6(zio.s3.ObjectMetadata ), $anonfun$listObjects$2(), $anonfun$listObjects$3$adapted(java.lang.String java.lang.String ), $anonfun$listObjects$4(), $anonfun$listObjects$5$adapted(java.lang.String java.lang.String ), $anonfun$listObjects$7(zio.nio.core.file.Path java.nio.file.attribute.BasicFileAttributes ), $anonfun$listObjects$11(zio.s3.S3ObjectSummary ), $anonfun$listObjects$12(scala.Option zio.s3.S3ObjectSummary ), $anonfun$putObject$2(), $anonfun$putObject$9(zio.nio.channels.FileChannel zio.Chunk ), $anonfun$putObject$8(zio.stream.ZStream zio.nio.channels.FileChannel ), $anonfun$putObject$10$adapted(scala.runtime.BoxedUnit ), $anonfun$putObject$5(zio.s3.Test$$anon$1 zio.nio.core.file.Path ), $anonfun$putObject$6(), $anonfun$putObject$7(zio.s3.Test$$anon$1 zio.nio.core.file.Path zio.stream.ZStream scala.runtime.BoxedUnit ), $anonfun$multipartUpload$8$adapted(scala.runtime.BoxedUnit ), $anonfun$multipartUpload$5(zio.s3.MultipartUploadOptions ), $anonfun$multipartUpload$6(zio.s3.MultipartUploadOptions ), $anonfun$multipartUpload$7(zio.s3.Test$$anon$1 java.lang.String java.lang.String zio.stream.ZStream zio.s3.MultipartUploadOptions scala.Option scala.runtime.BoxedUnit ), $anonfun$listBuckets$1(zio.nio.core.file.Path ), $anonfun$listBuckets$3(zio.nio.core.file.Path )}, serializedLambda);
            }
        };
    }

    private Test$() {
        MODULE$ = this;
    }
}

