/*
 * Decompiled with CFR 0.152.
 */
package zio.s3;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.LinearSeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.NotGiven$;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.utils.builder.SdkBuilder;
import zio.CanFail$;
import zio.Chunk;
import zio.Chunk$;
import zio.IsSubtypeOfError$;
import zio.Unsafe;
import zio.ZIO;
import zio.ZIO$;
import zio.interop.reactivestreams.package;
import zio.s3.ListObjectOptions;
import zio.s3.Live$;
import zio.s3.Live$StreamAsyncResponseTransformer$;
import zio.s3.MultipartUploadOptions;
import zio.s3.ObjectMetadata;
import zio.s3.ObjectMetadata$;
import zio.s3.PartSize$;
import zio.s3.S3;
import zio.s3.S3Bucket;
import zio.s3.S3Bucket$;
import zio.s3.S3ObjectListing;
import zio.s3.S3ObjectListing$;
import zio.s3.S3ObjectSummary;
import zio.s3.S3Region;
import zio.s3.UploadOptions;
import zio.s3.errors;
import zio.s3.errors$SdkError$;
import zio.s3.errors$syntax$;
import zio.stream.ZChannel;
import zio.stream.ZSink;
import zio.stream.ZSink$;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public final class Live
implements S3 {
    private final S3AsyncClient unsafeClient;
    private final ZIO listBuckets;

    public static <R> ZIO<R, errors.ConnectionError, S3> connect(S3AsyncClientBuilder s3AsyncClientBuilder) {
        return Live$.MODULE$.connect(s3AsyncClientBuilder);
    }

    public static <R> ZIO<R, errors.ConnectionError, S3> connect(S3Region s3Region, ZIO<R, Throwable, AwsCredentialsProvider> zIO, Option<URI> option) {
        return Live$.MODULE$.connect(s3Region, zIO, option);
    }

    public Live(S3AsyncClient unsafeClient) {
        this.unsafeClient = unsafeClient;
        this.listBuckets = this.execute((Function1 & Serializable)_$4 -> _$4.listBuckets()).map((Function1 & Serializable)r -> S3Bucket$.MODULE$.fromBuckets((List<Bucket>)CollectionConverters$.MODULE$.ListHasAsScala(r.buckets()).asScala().toList()), (Object)"zio.s3.Live.listBuckets(Live.scala:59)");
    }

    @Override
    public ZIO<Object, S3Exception, BoxedUnit> createBucket(String bucketName) {
        return this.execute((Function1 & Serializable)_$1 -> _$1.createBucket((CreateBucketRequest)CreateBucketRequest.builder().bucket(bucketName).build())).unit((Object)"zio.s3.Live.createBucket(Live.scala:45)");
    }

    @Override
    public ZIO<Object, S3Exception, BoxedUnit> deleteBucket(String bucketName) {
        return this.execute((Function1 & Serializable)_$2 -> _$2.deleteBucket((DeleteBucketRequest)DeleteBucketRequest.builder().bucket(bucketName).build())).unit((Object)"zio.s3.Live.deleteBucket(Live.scala:48)");
    }

    @Override
    public ZIO<Object, S3Exception, Object> isBucketExists(String bucketName) {
        return this.execute((Function1 & Serializable)_$3 -> _$3.headBucket((HeadBucketRequest)HeadBucketRequest.builder().bucket(bucketName).build())).as(Live::isBucketExists$$anonfun$2, (Object)"zio.s3.Live.isBucketExists(Live.scala:52)").catchSome((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(S3Exception x) {
                S3Exception s3Exception = x;
                return s3Exception instanceof NoSuchBucketException;
            }

            public final Object applyOrElse(S3Exception x, Function1 function1) {
                S3Exception s3Exception = x;
                if (s3Exception instanceof NoSuchBucketException) {
                    return ZIO$.MODULE$.succeed(Live::zio$s3$Live$$anon$1$$_$applyOrElse$$anonfun$1, (Object)"zio.s3.Live.isBucketExists(Live.scala:54)");
                }
                return function1.apply((Object)x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{zio$s3$Live$$anon$1$$_$applyOrElse$$anonfun$1(zio.Unsafe )}, serializedLambda);
            }
        }, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.s3.Live.isBucketExists(Live.scala:55)");
    }

    @Override
    public ZIO<Object, S3Exception, Chunk<S3Bucket>> listBuckets() {
        return this.listBuckets;
    }

    @Override
    public ZStream<Object, S3Exception, Object> getObject(String bucketName, String key) {
        return ZStream$.MODULE$.fromZIO(() -> this.getObject$$anonfun$1(bucketName, key), (Object)"zio.s3.Live.getObject(Live.scala:70)").flatMap((Function1 & Serializable)x -> (ZStream)Predef$.MODULE$.identity(x), (Object)"zio.s3.Live.getObject(Live.scala:71)").flattenChunks((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Object)"zio.s3.Live.getObject(Live.scala:72)").mapErrorCause((Function1 & Serializable)_$6 -> _$6.flatMap((Function1 & Serializable)_$7 -> errors$syntax$.MODULE$.S3ExceptionOps((Throwable)_$7).asS3Exception()), (Object)"zio.s3.Live.getObject(Live.scala:73)");
    }

    @Override
    public ZIO<Object, S3Exception, ObjectMetadata> getObjectMetadata(String bucketName, String key) {
        return this.execute((Function1 & Serializable)_$8 -> _$8.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(bucketName).key(key).build())).map((Function1 & Serializable)r -> ObjectMetadata$.MODULE$.fromResponse((HeadObjectResponse)r), (Object)"zio.s3.Live.getObjectMetadata(Live.scala:77)");
    }

    @Override
    public ZIO<Object, S3Exception, BoxedUnit> deleteObject(String bucketName, String key) {
        return this.execute((Function1 & Serializable)_$9 -> _$9.deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(bucketName).key(key).build())).unit((Object)"zio.s3.Live.deleteObject(Live.scala:80)");
    }

    @Override
    public ZIO<Object, S3Exception, S3ObjectListing> listObjects(String bucketName, ListObjectOptions options) {
        return this.execute((Function1 & Serializable)_$10 -> _$10.listObjectsV2((ListObjectsV2Request)ListObjectsV2Request.builder().maxKeys(Predef$.MODULE$.int2Integer(Predef$.MODULE$.long2Long(options.maxKeys()).intValue())).bucket(bucketName).delimiter((String)options.delimiter().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).startAfter((String)options.starAfter().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).prefix((String)options.prefix().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).build())).map((Function1 & Serializable)r -> S3ObjectListing$.MODULE$.fromResponse((ListObjectsV2Response)r), (Object)"zio.s3.Live.listObjects(Live.scala:94)");
    }

    @Override
    public ZIO<Object, S3Exception, S3ObjectListing> getNextObjects(S3ObjectListing listing) {
        return (ZIO)listing.nextContinuationToken().fold(() -> Live.getNextObjects$$anonfun$1(listing), (Function1 & Serializable)token -> this.execute((Function1 & Serializable)_$11 -> _$11.listObjectsV2((ListObjectsV2Request)ListObjectsV2Request.builder().bucket(listing.bucketName()).continuationToken(token).prefix((String)listing.prefix().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).build())).map((Function1 & Serializable)r -> S3ObjectListing$.MODULE$.fromResponse((ListObjectsV2Response)r), (Object)"zio.s3.Live.getNextObjects(Live.scala:110)"));
    }

    @Override
    public <R> ZIO<R, S3Exception, BoxedUnit> putObject(String bucketName, String key, long contentLength, ZStream<R, Throwable, Object> content, UploadOptions options, Option<String> contentMD5) {
        ZStream zStream = zio.interop.reactivestreams.package$.MODULE$.streamToPublisher(content.mapErrorCause((Function1 & Serializable)_$12 -> _$12.flatMap((Function1 & Serializable)_$13 -> errors$syntax$.MODULE$.S3ExceptionOps((Throwable)_$13).asS3Exception()), (Object)"zio.s3.Live.putObject(Live.scala:122)").mapChunks((Function1 & Serializable)c -> Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ByteBuffer[]{ByteBuffer.wrap((byte[])c.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)))})), (Object)"zio.s3.Live.putObject(Live.scala:123)"));
        return package.streamToPublisher$.MODULE$.toPublisher$extension(zStream, (Object)"zio.s3.Live.putObject(Live.scala:124)").flatMap((Function1 & Serializable)publisher -> this.execute((Function1 & Serializable)_$14 -> {
            PutObjectRequest.Builder builder = PutObjectRequest.builder().bucket(bucketName).contentLength(Predef$.MODULE$.long2Long(contentLength)).key(key).metadata(CollectionConverters$.MODULE$.MapHasAsJava(options.metadata()).asJava()).acl(options.cannedAcl());
            return _$14.putObject((PutObjectRequest)((SdkBuilder)((LinearSeqOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)b -> (PutObjectRequest.Builder)options.contentType().fold(() -> Live.putObject$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$1(b), (Function1 & Serializable)x$0 -> b.contentType(x$0)), (Function1 & Serializable)b -> (PutObjectRequest.Builder)contentMD5.fold(() -> Live.putObject$$anonfun$3$$anonfun$1$$anonfun$2$$anonfun$1(b), (Function1 & Serializable)x$0 -> b.contentMD5(x$0))}))).foldLeft((Object)builder, (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    PutObjectRequest.Builder b = (PutObjectRequest.Builder)tuple2._1();
                    Function1 f = (Function1)tuple2._2();
                    return (PutObjectRequest.Builder)f.apply((Object)b);
                }
                throw new MatchError((Object)tuple2);
            })).build(), AsyncRequestBody.fromPublisher((Publisher)publisher));
        }), (Object)"zio.s3.Live.putObject(Live.scala:149)").unit((Object)"zio.s3.Live.putObject(Live.scala:150)");
    }

    @Override
    public <R> Option<String> putObject$default$6() {
        return None$.MODULE$;
    }

    @Override
    public <R> ZIO<R, S3Exception, BoxedUnit> multipartUpload(String bucketName, String key, ZStream<R, Throwable, Object> content, MultipartUploadOptions options, int parallelism) {
        return ZIO$.MODULE$.dieMessage(() -> Live.multipartUpload$$anonfun$1(parallelism), (Object)"zio.s3.Live.multipartUpload(Live.scala:159)").unless(() -> Live.multipartUpload$$anonfun$2(parallelism), (Object)"zio.s3.Live.multipartUpload(Live.scala:159)").flatMap((Function1 & Serializable)x$12 -> {
            Option option = x$12;
            return ZIO$.MODULE$.dieMessage(() -> Live.multipartUpload$$anonfun$3$$anonfun$1(options), (Object)"zio.s3.Live.multipartUpload(Live.scala:164)").unless(() -> Live.multipartUpload$$anonfun$3$$anonfun$2(options), (Object)"zio.s3.Live.multipartUpload(Live.scala:165)").flatMap((Function1 & Serializable)x$1 -> {
                Option option = x$1;
                return this.execute((Function1 & Serializable)_$15 -> {
                    CreateMultipartUploadRequest.Builder builder = CreateMultipartUploadRequest.builder().bucket(bucketName).key(key).metadata(CollectionConverters$.MODULE$.MapHasAsJava(options.uploadOptions().metadata()).asJava()).acl(options.uploadOptions().cannedAcl());
                    return _$15.createMultipartUpload((CreateMultipartUploadRequest)((SdkBuilder)options.uploadOptions().contentType().fold(() -> Live.multipartUpload$$anonfun$3$$anonfun$3$$anonfun$1$$anonfun$1(builder), (Function1 & Serializable)x$0 -> builder.contentType(x$0))).build());
                }).map((Function1 & Serializable)_$16 -> _$16.uploadId(), (Object)"zio.s3.Live.multipartUpload(Live.scala:179)").flatMap((Function1 & Serializable)uploadId -> {
                    boolean bl = ZStream$.MODULE$.scoped();
                    return ZStream.ScopedPartiallyApplied$.MODULE$.apply$extension(bl, () -> Live.multipartUpload$$anonfun$3$$anonfun$3$$anonfun$3$$anonfun$1(content, options), (Object)"zio.s3.Live.multipartUpload(Live.scala:187)").flatMap((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            Option option = (Option)tuple2._1();
                            if (option instanceof Some) {
                                Chunk head = (Chunk)((Some)option).value();
                                ZStream rest = (ZStream)tuple2._2();
                                return ZStream$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Chunk[]{head}), (Object)"zio.s3.Live.multipartUpload(Live.scala:189)").$plus$plus(() -> Live.multipartUpload$$anonfun$3$$anonfun$3$$anonfun$3$$anonfun$2$$anonfun$1(rest), (Object)"zio.s3.Live.multipartUpload(Live.scala:189)");
                            }
                            if (None$.MODULE$.equals(option)) {
                                return ZStream$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Chunk[]{Chunk$.MODULE$.empty()}), (Object)"zio.s3.Live.multipartUpload(Live.scala:190)");
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }, (Object)"zio.s3.Live.multipartUpload(Live.scala:191)").zipWithIndex((Object)"zio.s3.Live.multipartUpload(Live.scala:192)").mapZIOPar(() -> Live.multipartUpload$$anonfun$3$$anonfun$3$$anonfun$3$$anonfun$3(parallelism), (Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            Chunk chunk = (Chunk)tuple2._1();
                            long partNumber = BoxesRunTime.unboxToLong((Object)tuple2._2());
                            return this.execute((Function1 & Serializable)_$17 -> _$17.uploadPart((UploadPartRequest)UploadPartRequest.builder().bucket(bucketName).key(key).partNumber(Predef$.MODULE$.int2Integer((int)partNumber + 1)).uploadId(uploadId).contentLength(Predef$.MODULE$.long2Long((long)chunk.length())).build(), AsyncRequestBody.fromBytes((byte[])((byte[])chunk.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)))))).map((Function1 & Serializable)r -> (CompletedPart)CompletedPart.builder().partNumber(Predef$.MODULE$.int2Integer((int)partNumber + 1)).eTag(r.eTag()).build(), (Object)"zio.s3.Live.multipartUpload(Live.scala:207)");
                        }
                        throw new MatchError((Object)tuple2);
                    }, (Object)"zio.s3.Live.multipartUpload(Live.scala:208)").runCollect((Object)"zio.s3.Live.multipartUpload(Live.scala:209)").mapErrorCause((Function1 & Serializable)_$18 -> _$18.flatMap((Function1 & Serializable)_$19 -> errors$syntax$.MODULE$.S3ExceptionOps((Throwable)_$19).asS3Exception()), (Object)"zio.s3.Live.multipartUpload(Live.scala:210)").flatMap((Function1 & Serializable)parts -> this.execute((Function1 & Serializable)_$20 -> _$20.completeMultipartUpload((CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().bucket(bucketName).key(key).multipartUpload((CompletedMultipartUpload)CompletedMultipartUpload.builder().parts(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)parts).asJavaCollection()).build()).uploadId(uploadId).build())).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                        CompleteMultipartUploadResponse completeMultipartUploadResponse = x$1;
                    }, (Object)"zio.s3.Live.multipartUpload(Live.scala:223)"), (Object)"zio.s3.Live.multipartUpload(Live.scala:223)");
                }, (Object)"zio.s3.Live.multipartUpload(Live.scala:223)");
            }, (Object)"zio.s3.Live.multipartUpload(Live.scala:223)");
        }, (Object)"zio.s3.Live.multipartUpload(Live.scala:223)");
    }

    @Override
    public <T> ZIO<Object, S3Exception, T> execute(Function1<S3AsyncClient, CompletableFuture<T>> f) {
        return ZIO$.MODULE$.fromCompletionStage(() -> this.execute$$anonfun$1(f), (Object)"zio.s3.Live.execute(Live.scala:226)").refineOrDie((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof S3Exception) {
                    S3Exception s3 = (S3Exception)throwable;
                    return true;
                }
                if (throwable instanceof SdkException) {
                    SdkException sdk = (SdkException)throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof S3Exception) {
                    S3Exception s3 = (S3Exception)throwable;
                    return s3;
                }
                if (throwable instanceof SdkException) {
                    SdkException sdk = (SdkException)throwable;
                    return errors$SdkError$.MODULE$.apply(sdk);
                }
                return function1.apply((Object)x);
            }
        }, IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.s3.Live.execute(Live.scala:229)");
    }

    private static final boolean isBucketExists$$anonfun$2() {
        return true;
    }

    public static final /* synthetic */ boolean zio$s3$Live$$anon$1$$_$applyOrElse$$anonfun$1(Unsafe evidence$1) {
        return false;
    }

    private final ZIO getObject$$anonfun$1(String bucketName$5, String key$1) {
        return this.execute((Function1 & Serializable)_$5 -> _$5.getObject((GetObjectRequest)GetObjectRequest.builder().bucket(bucketName$5).key(key$1).build(), (AsyncResponseTransformer)Live$StreamAsyncResponseTransformer$.MODULE$.apply(new CompletableFuture<ZStream<Object, Throwable, Chunk<Object>>>())));
    }

    private static final ZIO getNextObjects$$anonfun$1(S3ObjectListing listing$1) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$2 -> {
            None$ none$ = None$.MODULE$;
            Chunk chunk = Chunk$.MODULE$.empty();
            String string = listing$1.copy$default$1();
            Option<String> option = listing$1.copy$default$2();
            Option<String> option2 = listing$1.copy$default$3();
            Option<String> option3 = listing$1.copy$default$6();
            return listing$1.copy(string, option, option2, (Chunk<S3ObjectSummary>)chunk, (Option<String>)none$, option3);
        }, (Object)"zio.s3.Live.getNextObjects(Live.scala:99)");
    }

    private static final PutObjectRequest.Builder putObject$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$1(PutObjectRequest.Builder b$1) {
        return b$1;
    }

    private static final PutObjectRequest.Builder putObject$$anonfun$3$$anonfun$1$$anonfun$2$$anonfun$1(PutObjectRequest.Builder b$3) {
        return b$3;
    }

    private static final String multipartUpload$$anonfun$1(int parallelism$1) {
        return new StringBuilder(36).append("parallelism must be > 0. ").append(parallelism$1).append(" is invalid").toString();
    }

    private static final boolean multipartUpload$$anonfun$2(int parallelism$2) {
        return parallelism$2 > 0;
    }

    private static final String multipartUpload$$anonfun$3$$anonfun$1(MultipartUploadOptions options$6) {
        return new StringBuilder(42).append("Invalid part size ").append(Math.floor((double)options$6.partSize() / (double)PartSize$.MODULE$.Mega() * 100.0) / 100.0).append(" Mb, minimum size is ").append(PartSize$.MODULE$.Min() / PartSize$.MODULE$.Mega()).append(" Mb").toString();
    }

    private static final boolean multipartUpload$$anonfun$3$$anonfun$2(MultipartUploadOptions options$7) {
        return options$7.partSize() >= PartSize$.MODULE$.Min();
    }

    private static final CreateMultipartUploadRequest.Builder multipartUpload$$anonfun$3$$anonfun$3$$anonfun$1$$anonfun$1(CreateMultipartUploadRequest.Builder builder$1) {
        return builder$1;
    }

    private static final int multipartUpload$$anonfun$3$$anonfun$3$$anonfun$3$$anonfun$1$$anonfun$1(MultipartUploadOptions options$12) {
        return options$12.partSize();
    }

    private static final ZChannel multipartUpload$$anonfun$3$$anonfun$3$$anonfun$3$$anonfun$1$$anonfun$3() {
        return ZSink$.MODULE$.head((Object)"zio.s3.Live.multipartUpload(Live.scala:186)");
    }

    private static final ZIO multipartUpload$$anonfun$3$$anonfun$3$$anonfun$3$$anonfun$1(ZStream content$4, MultipartUploadOptions options$11) {
        return content$4.rechunk(() -> Live.multipartUpload$$anonfun$3$$anonfun$3$$anonfun$3$$anonfun$1$$anonfun$1(options$11), (Object)"zio.s3.Live.multipartUpload(Live.scala:184)").mapChunks((Function1 & Serializable)a -> Chunk$.MODULE$.single(a), (Object)"zio.s3.Live.multipartUpload(Live.scala:185)").peel((Function0 & Serializable)() -> new ZSink(Live.multipartUpload$$anonfun$3$$anonfun$3$$anonfun$3$$anonfun$1$$anonfun$3()), (Object)"zio.s3.Live.multipartUpload(Live.scala:186)");
    }

    private static final ZStream multipartUpload$$anonfun$3$$anonfun$3$$anonfun$3$$anonfun$2$$anonfun$1(ZStream rest$1) {
        return rest$1;
    }

    private static final int multipartUpload$$anonfun$3$$anonfun$3$$anonfun$3$$anonfun$3(int parallelism$6) {
        return parallelism$6;
    }

    private final CompletionStage execute$$anonfun$1(Function1 f$1) {
        return (CompletionStage)f$1.apply((Object)this.unsafeClient);
    }

    public static final class StreamAsyncResponseTransformer
    implements AsyncResponseTransformer<GetObjectResponse, ZStream<Object, Throwable, Chunk<Object>>>,
    Product,
    Serializable {
        private final CompletableFuture cf;

        public static StreamAsyncResponseTransformer apply(CompletableFuture<ZStream<Object, Throwable, Chunk<Object>>> completableFuture) {
            return Live$StreamAsyncResponseTransformer$.MODULE$.apply(completableFuture);
        }

        public static StreamAsyncResponseTransformer fromProduct(Product product) {
            return Live$StreamAsyncResponseTransformer$.MODULE$.fromProduct(product);
        }

        public static StreamAsyncResponseTransformer unapply(StreamAsyncResponseTransformer streamAsyncResponseTransformer) {
            return Live$StreamAsyncResponseTransformer$.MODULE$.unapply(streamAsyncResponseTransformer);
        }

        public StreamAsyncResponseTransformer(CompletableFuture<ZStream<Object, Throwable, Chunk<Object>>> cf) {
            this.cf = cf;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StreamAsyncResponseTransformer)) return false;
            StreamAsyncResponseTransformer streamAsyncResponseTransformer = (StreamAsyncResponseTransformer)object;
            CompletableFuture<ZStream<Object, Throwable, Chunk<Object>>> completableFuture = this.cf();
            CompletableFuture<ZStream<Object, Throwable, Chunk<Object>>> completableFuture2 = streamAsyncResponseTransformer.cf();
            if (completableFuture != null) {
                if (!completableFuture.equals(completableFuture2)) return false;
                return true;
            }
            if (completableFuture2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StreamAsyncResponseTransformer;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "StreamAsyncResponseTransformer";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "cf";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public CompletableFuture<ZStream<Object, Throwable, Chunk<Object>>> cf() {
            return this.cf;
        }

        public CompletableFuture<ZStream<Object, Throwable, Chunk<Object>>> prepare() {
            return this.cf();
        }

        public void onResponse(GetObjectResponse response) {
        }

        public void onStream(SdkPublisher<ByteBuffer> publisher) {
            Publisher publisher2 = zio.interop.reactivestreams.package$.MODULE$.publisherToStream(publisher);
            this.cf().complete((ZStream<Object, Throwable, Chunk<Object>>)package.publisherToStream$.MODULE$.toZIOStream$extension(publisher2, package.publisherToStream$.MODULE$.toZIOStream$default$1$extension(publisher2), (Object)"zio.s3.Live.StreamAsyncResponseTransformer.onStream(Live.scala:266)").map((Function1 & Serializable)buffer -> Chunk$.MODULE$.fromByteBuffer(buffer), (Object)"zio.s3.Live.StreamAsyncResponseTransformer.onStream(Live.scala:266)"));
        }

        public void exceptionOccurred(Throwable error) {
            this.cf().completeExceptionally(error);
        }

        public StreamAsyncResponseTransformer copy(CompletableFuture<ZStream<Object, Throwable, Chunk<Object>>> cf) {
            return new StreamAsyncResponseTransformer(cf);
        }

        public CompletableFuture<ZStream<Object, Throwable, Chunk<Object>>> copy$default$1() {
            return this.cf();
        }

        public CompletableFuture<ZStream<Object, Throwable, Chunk<Object>>> _1() {
            return this.cf();
        }
    }
}

