/*
 * Decompiled with CFR 0.152.
 */
package zio.s3;

import java.io.Serializable;
import java.nio.charset.CharacterCodingException;
import java.util.concurrent.CompletableFuture;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.runtime.BoxedUnit;
import scala.util.NotGiven$;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.S3Exception;
import zio.CanFail$;
import zio.Chunk;
import zio.ZIO;
import zio.ZIO$;
import zio.s3.ListObjectOptions;
import zio.s3.ListObjectOptions$;
import zio.s3.MultipartUploadOptions;
import zio.s3.MultipartUploadOptions$;
import zio.s3.ObjectMetadata;
import zio.s3.S3Bucket;
import zio.s3.S3ObjectListing;
import zio.s3.S3ObjectListing$;
import zio.s3.S3ObjectSummary;
import zio.s3.UploadOptions;
import zio.s3.UploadOptions$;
import zio.s3.errors$DecodingException$;
import zio.stream.ZPipeline;
import zio.stream.ZPipeline$;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public interface S3 {
    public ZIO<Object, S3Exception, BoxedUnit> createBucket(String var1);

    public ZIO<Object, S3Exception, BoxedUnit> deleteBucket(String var1);

    public ZIO<Object, S3Exception, Object> isBucketExists(String var1);

    public ZIO<Object, S3Exception, Chunk<S3Bucket>> listBuckets();

    public ZIO<Object, S3Exception, BoxedUnit> deleteObject(String var1, String var2);

    public ZStream<Object, S3Exception, Object> getObject(String var1, String var2);

    public ZIO<Object, S3Exception, ObjectMetadata> getObjectMetadata(String var1, String var2);

    public static ZIO listObjects$(S3 $this, String bucketName) {
        return $this.listObjects(bucketName);
    }

    default public ZIO<Object, S3Exception, S3ObjectListing> listObjects(String bucketName) {
        return this.listObjects(bucketName, ListObjectOptions$.MODULE$.default());
    }

    public ZIO<Object, S3Exception, S3ObjectListing> listObjects(String var1, ListObjectOptions var2);

    public ZIO<Object, S3Exception, S3ObjectListing> getNextObjects(S3ObjectListing var1);

    public <R> ZIO<R, S3Exception, BoxedUnit> putObject(String var1, String var2, long var3, ZStream<R, Throwable, Object> var5, UploadOptions var6, Option<String> var7);

    public static UploadOptions putObject$default$5$(S3 $this) {
        return $this.putObject$default$5();
    }

    default public <R> UploadOptions putObject$default$5() {
        return UploadOptions$.MODULE$.default();
    }

    public static Option putObject$default$6$(S3 $this) {
        return $this.putObject$default$6();
    }

    default public <R> Option<String> putObject$default$6() {
        return None$.MODULE$;
    }

    public <R> ZIO<R, S3Exception, BoxedUnit> multipartUpload(String var1, String var2, ZStream<R, Throwable, Object> var3, MultipartUploadOptions var4, int var5);

    public static MultipartUploadOptions multipartUpload$default$4$(S3 $this) {
        return $this.multipartUpload$default$4();
    }

    default public <R> MultipartUploadOptions multipartUpload$default$4() {
        return MultipartUploadOptions$.MODULE$.default();
    }

    public static ZStream streamLines$(S3 $this, String bucketName, String key) {
        return $this.streamLines(bucketName, key);
    }

    default public ZStream<Object, S3Exception, String> streamLines(String bucketName, String key) {
        return this.getObject(bucketName, key).$greater$greater$greater(S3::streamLines$$anonfun$1, (Object)"zio.s3.S3.streamLines(S3.scala:145)").$greater$greater$greater(S3::streamLines$$anonfun$2, (Object)"zio.s3.S3.streamLines(S3.scala:145)").refineOrDie((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Exception x) {
                Exception exception = x;
                if (exception instanceof S3Exception) {
                    S3Exception ex = (S3Exception)exception;
                    return true;
                }
                if (exception instanceof CharacterCodingException) {
                    CharacterCodingException ex = (CharacterCodingException)exception;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Exception x, Function1 function1) {
                Exception exception = x;
                if (exception instanceof S3Exception) {
                    S3Exception ex = (S3Exception)exception;
                    return ex;
                }
                if (exception instanceof CharacterCodingException) {
                    CharacterCodingException ex = (CharacterCodingException)exception;
                    return errors$DecodingException$.MODULE$.apply(ex);
                }
                return function1.apply((Object)x);
            }
        }, (.less.colon.less)$less$colon$less$.MODULE$.refl(), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.s3.S3.streamLines(S3.scala:148)");
    }

    public static ZStream listAllObjects$(S3 $this, String bucketName) {
        return $this.listAllObjects(bucketName);
    }

    default public ZStream<Object, S3Exception, S3ObjectSummary> listAllObjects(String bucketName) {
        return this.listAllObjects(bucketName, ListObjectOptions$.MODULE$.default());
    }

    public static ZStream listAllObjects$(S3 $this, String bucketName, ListObjectOptions options) {
        return $this.listAllObjects(bucketName, options);
    }

    default public ZStream<Object, S3Exception, S3ObjectSummary> listAllObjects(String bucketName, ListObjectOptions options) {
        return ZStream$.MODULE$.fromZIO(() -> this.listAllObjects$$anonfun$1(bucketName, options), (Object)"zio.s3.S3.listAllObjects(S3.scala:163)").flatMap((Function1 & Serializable)_$1 -> this.paginate((S3ObjectListing)_$1).mapConcat((Function1 & Serializable)_$2 -> _$2.objectSummaries(), (Object)"zio.s3.S3.listAllObjects(S3.scala:165)"), (Object)"zio.s3.S3.listAllObjects(S3.scala:166)");
    }

    public static ZStream paginate$(S3 $this, S3ObjectListing initialListing) {
        return $this.paginate(initialListing);
    }

    default public ZStream<Object, S3Exception, S3ObjectListing> paginate(S3ObjectListing initialListing) {
        return ZStream$.MODULE$.paginateZIO(() -> S3.paginate$$anonfun$1(initialListing), (Function1 & Serializable)x$1 -> {
            S3ObjectListing s3ObjectListing = x$1;
            if (s3ObjectListing != null) {
                S3ObjectListing s3ObjectListing2 = S3ObjectListing$.MODULE$.unapply(s3ObjectListing);
                String string = s3ObjectListing2._1();
                Option<String> option = s3ObjectListing2._2();
                Option<String> option2 = s3ObjectListing2._3();
                Chunk<S3ObjectSummary> chunk = s3ObjectListing2._4();
                Option<String> option3 = s3ObjectListing2._5();
                Option<String> option4 = s3ObjectListing2._6();
                if (None$.MODULE$.equals(option3)) {
                    S3ObjectListing current = s3ObjectListing;
                    return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$1 -> {
                        S3ObjectListing s3ObjectListing = (S3ObjectListing)Predef$.MODULE$.ArrowAssoc((Object)current);
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)s3ObjectListing, (Object)None$.MODULE$);
                    }, (Object)"zio.s3.S3.paginate(S3.scala:176)");
                }
            }
            S3ObjectListing current = s3ObjectListing;
            return this.getNextObjects(current).map((Function1 & Serializable)next -> {
                S3ObjectListing s3ObjectListing = (S3ObjectListing)Predef$.MODULE$.ArrowAssoc((Object)current);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)s3ObjectListing, (Object)Some$.MODULE$.apply(next));
            }, (Object)"zio.s3.S3.paginate(S3.scala:177)");
        }, (Object)"zio.s3.S3.paginate(S3.scala:178)");
    }

    public <T> ZIO<Object, S3Exception, T> execute(Function1<S3AsyncClient, CompletableFuture<T>> var1);

    private static ZPipeline streamLines$$anonfun$1() {
        return ZPipeline$.MODULE$.utf8Decode((Object)"zio.s3.S3.streamLines(S3.scala:145)");
    }

    private static ZPipeline streamLines$$anonfun$2() {
        return ZPipeline$.MODULE$.splitLines((Object)"zio.s3.S3.streamLines(S3.scala:145)");
    }

    private ZIO listAllObjects$$anonfun$1(String bucketName$1, ListObjectOptions options$1) {
        return this.listObjects(bucketName$1, options$1);
    }

    private static S3ObjectListing paginate$$anonfun$1(S3ObjectListing initialListing$1) {
        return initialListing$1;
    }
}

