/*
 * Decompiled with CFR 0.152.
 */
package zio.sbt;

import io.circe.Encoder$;
import io.circe.Json;
import io.circe.syntax.package;
import io.circe.syntax.package$;
import io.circe.yaml.Printer;
import io.circe.yaml.Printer$;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import zio.ZIO;
import zio.ZIO$;
import zio.sbt.WebsiteUtils;
import zio.sbt.WebsiteUtils$DocsVersioning$SemanticVersioning$;
import zio.sbt.githubactions.ActionRef;
import zio.sbt.githubactions.Branch;
import zio.sbt.githubactions.Condition;
import zio.sbt.githubactions.Job;
import zio.sbt.githubactions.Job$;
import zio.sbt.githubactions.Service;
import zio.sbt.githubactions.Step;
import zio.sbt.githubactions.Step$SingleStep$;
import zio.sbt.githubactions.Strategy;
import zio.sbt.githubactions.Trigger;
import zio.sbt.githubactions.Trigger$PullRequest$;
import zio.sbt.githubactions.Trigger$Push$;
import zio.sbt.githubactions.Trigger$WorkflowDispatch$;
import zio.sbt.githubactions.Workflow;
import zio.sbt.githubactions.Workflow$;

public final class WebsiteUtils$ {
    public static WebsiteUtils$ MODULE$;
    private volatile byte bitmap$init$0;

    static {
        new WebsiteUtils$();
    }

    public String removeYamlHeader(String markdown) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])markdown.split("\n"))).dropWhile((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)WebsiteUtils$.$anonfun$removeYamlHeader$1(x$1))))).dropWhile((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)WebsiteUtils$.$anonfun$removeYamlHeader$2(x$2))))).dropWhile((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)WebsiteUtils$.$anonfun$removeYamlHeader$3(x$3))))).mkString("\n");
    }

    public ZIO<Object, Throwable, String> readFile(String pathname) {
        return ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> {
            BufferedSource source = Source$.MODULE$.fromFile(new File(pathname), Codec$.MODULE$.fallbackSystemCodec());
            String result = source.getLines().mkString("\n");
            source.close();
            return result;
        }, (Object)"zio.sbt.WebsiteUtils.readFile(WebsiteUtils.scala:45)");
    }

    public String githubBadge(String githubUser, String githubRepo, String projectName) {
        String githubBadge = new StringBuilder(50).append("https://img.shields.io/github/stars/").append(githubUser).append("/").append(githubRepo).append("?style=social").toString();
        String repoUrl = new StringBuilder(20).append("https://github.com/").append(githubUser).append("/").append(githubRepo).toString();
        return new StringBuilder(9).append("[![").append(projectName).append("](").append(githubBadge).append(")](").append(repoUrl).append(")").toString();
    }

    public String javadocBadge(String groupId, String artifactId) {
        String badge = new StringBuilder(39).append("https://javadoc.io/badge2/").append(groupId).append("/").append(artifactId).append("/javadoc.svg").toString();
        String javadocUrl = new StringBuilder(24).append("https://javadoc.io/doc/").append(groupId).append("/").append(artifactId).toString();
        return new StringBuilder(16).append("[![javadoc](").append(badge).append(")](").append(javadocUrl).append(")").toString();
    }

    public String discord() {
        return "[![Chat on Discord!](https://img.shields.io/discord/629491597070827530?logo=discord)](https://discord.gg/2ccFBr4)";
    }

    public String ciBadge(String githubUser, String githubRepo) {
        return new StringBuilder(56).append("![CI Badge](https://github.com/").append(githubUser).append("/").append(githubRepo).append("/workflows/CI/badge.svg)").toString();
    }

    public String snapshotBadge(String groupId, String artifact) {
        String badge = new StringBuilder(85).append("https://img.shields.io/nexus/s/https/oss.sonatype.org/").append(groupId).append("/").append(artifact).append(".svg?label=Sonatype%20Snapshot").toString();
        String link = new StringBuilder(58).append("https://oss.sonatype.org/content/repositories/snapshots/").append(groupId.replace('.', '/')).append("/").append(artifact).append("/").toString();
        return new StringBuilder(27).append("[![Sonatype Snapshots](").append(badge).append(")](").append(link).append(")").toString();
    }

    public String releaseBadge(String groupId, String artifact) {
        String badge = new StringBuilder(84).append("https://img.shields.io/nexus/r/https/oss.sonatype.org/").append(groupId).append("/").append(artifact).append(".svg?label=Sonatype%20Release").toString();
        String link = new StringBuilder(57).append("https://oss.sonatype.org/content/repositories/releases/").append(groupId.replace('.', '/')).append("/").append(artifact).append("/").toString();
        return new StringBuilder(26).append("[![Sonatype Releases](").append(badge).append(")](").append(link).append(")").toString();
    }

    public String projectStageBadge(WebsiteUtils.ProjectStage stage) {
        return new StringBuilder(9).append("[![").append(stage.name()).append("](").append(stage.badge()).append(")](").append(stage.stagePage()).append(")").toString();
    }

    public String generateProjectBadges(WebsiteUtils.ProjectStage projectStage, String groupId, String artifactId, String docsArtifactId, String githubUser, String githubRepo, String projectName) {
        String stage = this.projectStageBadge(projectStage);
        String ci = this.ciBadge(githubUser, githubRepo);
        String release = this.releaseBadge(groupId, artifactId);
        String snapshot = this.snapshotBadge(groupId, artifactId);
        String github = this.githubBadge(githubUser, githubRepo, projectName);
        String javadoc = this.javadocBadge(groupId, docsArtifactId);
        return new StringBuilder(5).append(stage).append(" ").append(ci).append(" ").append(release).append(" ").append(snapshot).append(" ").append(javadoc).append(" ").append(github).toString();
    }

    public ZIO<Object, Throwable, BoxedUnit> generateReadme(String projectName, String banner, String introduction, String documentation, String codeOfConduct, String contribution, String support, String license, String acknowledgement, String credits, String maintainers) {
        String commentSection = new StringOps(Predef$.MODULE$.augmentString("|[//]: # (This file was autogenerated using `zio-sbt-website` plugin via `sbt generateReadme` command.)\n         |[//]: # (So please do not edit it manually. Instead, change \"docs/index.md\" file or sbt setting keys)\n         |[//]: # (e.g. \"readmeDocumentation\" and \"readmeSupport\".)\n         |")).stripMargin();
        String introductionSection = new StringBuilder(6).append("\n# ").append(projectName).append("\n\n").append(introduction).append("\n").toString();
        String creditsSection = new StringOps(Predef$.MODULE$.augmentString(credits)).nonEmpty() ? new StringBuilder(14).append("\n## Credits\n\n").append(credits).append("\n").toString() : "";
        String supportSection = new StringBuilder(14).append("\n## Support\n\n").append(support).append("\n").toString();
        String codeOfConductSection = new StringBuilder(22).append("\n## Code of Conduct\n\n").append(codeOfConduct).append("\n").toString();
        String contributingSection = new StringBuilder(19).append("\n## Contributing\n\n").append(contribution).append("\n").toString();
        String documentationSection = new StringBuilder(20).append("\n## Documentation\n\n").append(documentation).append("\n").toString();
        String maintainersSection = new StringOps(Predef$.MODULE$.augmentString(maintainers)).nonEmpty() ? new StringBuilder(18).append("\n## Maintainers\n\n").append(maintainers).append("\n").toString() : "";
        String acknowledgementSection = new StringOps(Predef$.MODULE$.augmentString(acknowledgement)).nonEmpty() ? new StringBuilder(22).append("\n## Acknowledgement\n\n").append(acknowledgement).append("\n").toString() : "";
        String licenseSection = new StringBuilder(14).append("\n## License\n\n").append(license).append("\n").toString();
        String readme = new StringBuilder(0).append(commentSection).append(banner).append(introductionSection).append(documentationSection).append(contributingSection).append(codeOfConductSection).append(supportSection).append(maintainersSection).append(creditsSection).append(acknowledgementSection).append(licenseSection).toString();
        return ZIO$.MODULE$.attemptBlocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Files.write(Paths.get("README.md", new String[0]), readme.getBytes(StandardCharsets.UTF_8), new OpenOption[0]), (Object)"zio.sbt.WebsiteUtils.generateReadme(WebsiteUtils.scala:151)");
    }

    public String websiteWorkflow(String docsPublishBranch, List<String> sbtBuildOptions, WebsiteUtils.DocsVersioning versioning) {
        boolean x$1 = true;
        boolean x$2 = true;
        boolean x$3 = false;
        Printer.LineBreak$.Unix$ x$4 = Printer.LineBreak$.Unix$.MODULE$;
        Printer.YamlVersion$.Auto$ x$5 = Printer.YamlVersion$.Auto$.MODULE$;
        int x$6 = Printer$.MODULE$.apply$default$3();
        int x$7 = Printer$.MODULE$.apply$default$4();
        int x$8 = Printer$.MODULE$.apply$default$6();
        Map x$9 = Printer$.MODULE$.apply$default$7();
        Printer.FlowStyle x$10 = Printer$.MODULE$.apply$default$8();
        Printer.FlowStyle x$11 = Printer$.MODULE$.apply$default$9();
        Printer.StringStyle x$12 = Printer$.MODULE$.apply$default$10();
        boolean x$13 = Printer$.MODULE$.apply$default$12();
        boolean x$14 = Printer$.MODULE$.apply$default$13();
        String x$39 = "build";
        String x$40 = "Build and Test";
        Some x$41 = new Some((Object)new Condition.Expression("github.event_name == 'pull_request'"));
        Step.SingleStep[] singleStepArray = new Step.SingleStep[4];
        String x$15 = "Git Checkout";
        Some x$16 = new Some((Object)new ActionRef("actions/checkout@v3.2.0"));
        Map x$17 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fetch-depth"), (Object)package.EncoderOps$.MODULE$.asJson$extension(package$.MODULE$.EncoderOps((Object)"0"), Encoder$.MODULE$.encodeString()))}));
        Option<Condition> x$18 = Step$SingleStep$.MODULE$.apply$default$3();
        Option<String> x$19 = Step$SingleStep$.MODULE$.apply$default$5();
        Map<String, String> x$20 = Step$SingleStep$.MODULE$.apply$default$6();
        singleStepArray[0] = new Step.SingleStep(x$15, (Option<ActionRef>)x$16, x$18, (Map<String, Json>)x$17, x$19, x$20);
        String x$21 = "Setup Scala";
        Some x$22 = new Some((Object)new ActionRef("actions/setup-java@v3.9.0"));
        Map x$23 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"distribution"), (Object)package.EncoderOps$.MODULE$.asJson$extension(package$.MODULE$.EncoderOps((Object)"temurin"), Encoder$.MODULE$.encodeString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java-version"), (Object)package.EncoderOps$.MODULE$.asJson$extension(package$.MODULE$.EncoderOps((Object)BoxesRunTime.boxToInteger((int)17)), Encoder$.MODULE$.encodeInt())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"check-latest"), (Object)package.EncoderOps$.MODULE$.asJson$extension(package$.MODULE$.EncoderOps((Object)BoxesRunTime.boxToBoolean((boolean)true)), Encoder$.MODULE$.encodeBoolean()))}));
        Option<Condition> x$24 = Step$SingleStep$.MODULE$.apply$default$3();
        Option<String> x$25 = Step$SingleStep$.MODULE$.apply$default$5();
        Map<String, String> x$26 = Step$SingleStep$.MODULE$.apply$default$6();
        singleStepArray[1] = new Step.SingleStep(x$21, (Option<ActionRef>)x$22, x$24, (Map<String, Json>)x$23, x$25, x$26);
        String x$27 = "Check that site workflow is up to date";
        Some x$28 = new Some((Object)new StringBuilder(29).append("sbt ").append(sbtBuildOptions.mkString(" ")).append(" docs/checkGithubWorkflow").toString());
        Option<ActionRef> x$29 = Step$SingleStep$.MODULE$.apply$default$2();
        Option<Condition> x$30 = Step$SingleStep$.MODULE$.apply$default$3();
        Map<String, Json> x$31 = Step$SingleStep$.MODULE$.apply$default$4();
        Map<String, String> x$32 = Step$SingleStep$.MODULE$.apply$default$6();
        singleStepArray[2] = new Step.SingleStep(x$27, x$29, x$30, x$31, (Option<String>)x$28, x$32);
        String x$33 = "Check website build process";
        Some x$34 = new Some((Object)new StringBuilder(22).append("sbt ").append(sbtBuildOptions.mkString(" ")).append(" docs/buildWebsite").toString());
        Option<ActionRef> x$35 = Step$SingleStep$.MODULE$.apply$default$2();
        Option<Condition> x$36 = Step$SingleStep$.MODULE$.apply$default$3();
        Map<String, Json> x$37 = Step$SingleStep$.MODULE$.apply$default$4();
        Map<String, String> x$38 = Step$SingleStep$.MODULE$.apply$default$6();
        singleStepArray[3] = new Step.SingleStep(x$33, x$35, x$36, x$37, (Option<String>)x$34, x$38);
        .colon.colon x$42 = new .colon.colon((Object)new Step.StepSequence((Seq<Step>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])singleStepArray)))), (List)Nil$.MODULE$);
        String x$43 = Job$.MODULE$.apply$default$3();
        Option<Strategy> x$44 = Job$.MODULE$.apply$default$4();
        Seq<String> x$45 = Job$.MODULE$.apply$default$6();
        Seq<Service> x$46 = Job$.MODULE$.apply$default$7();
        String x$71 = "publish-docs";
        String x$72 = "Publish Docs";
        Some x$73 = new Some((Object)new Condition.Expression("github.event_name == 'release'").$amp$amp(new Condition.Expression("github.event.action == 'published'")).$bar$bar(new Condition.Expression("github.event_name == 'workflow_dispatch'")));
        Step.SingleStep[] singleStepArray2 = new Step.SingleStep[4];
        String x$47 = "Git Checkout";
        Some x$48 = new Some((Object)new ActionRef("actions/checkout@v3.2.0"));
        Map x$49 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fetch-depth"), (Object)package.EncoderOps$.MODULE$.asJson$extension(package$.MODULE$.EncoderOps((Object)"0"), Encoder$.MODULE$.encodeString()))}));
        Option<Condition> x$50 = Step$SingleStep$.MODULE$.apply$default$3();
        Option<String> x$51 = Step$SingleStep$.MODULE$.apply$default$5();
        Map<String, String> x$52 = Step$SingleStep$.MODULE$.apply$default$6();
        singleStepArray2[0] = new Step.SingleStep(x$47, (Option<ActionRef>)x$48, x$50, (Map<String, Json>)x$49, x$51, x$52);
        String x$53 = "Setup Scala";
        Some x$54 = new Some((Object)new ActionRef("actions/setup-java@v3.9.0"));
        Map x$55 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"distribution"), (Object)package.EncoderOps$.MODULE$.asJson$extension(package$.MODULE$.EncoderOps((Object)"temurin"), Encoder$.MODULE$.encodeString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java-version"), (Object)package.EncoderOps$.MODULE$.asJson$extension(package$.MODULE$.EncoderOps((Object)BoxesRunTime.boxToInteger((int)17)), Encoder$.MODULE$.encodeInt())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"check-latest"), (Object)package.EncoderOps$.MODULE$.asJson$extension(package$.MODULE$.EncoderOps((Object)BoxesRunTime.boxToBoolean((boolean)true)), Encoder$.MODULE$.encodeBoolean()))}));
        Option<Condition> x$56 = Step$SingleStep$.MODULE$.apply$default$3();
        Option<String> x$57 = Step$SingleStep$.MODULE$.apply$default$5();
        Map<String, String> x$58 = Step$SingleStep$.MODULE$.apply$default$6();
        singleStepArray2[1] = new Step.SingleStep(x$53, (Option<ActionRef>)x$54, x$56, (Map<String, Json>)x$55, x$57, x$58);
        String x$59 = "Setup NodeJs";
        Some x$60 = new Some((Object)new ActionRef("actions/setup-node@v3"));
        Map x$61 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"node-version"), (Object)package.EncoderOps$.MODULE$.asJson$extension(package$.MODULE$.EncoderOps((Object)"16.x"), Encoder$.MODULE$.encodeString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"registry-url"), (Object)package.EncoderOps$.MODULE$.asJson$extension(package$.MODULE$.EncoderOps((Object)"https://registry.npmjs.org"), Encoder$.MODULE$.encodeString()))}));
        Option<Condition> x$62 = Step$SingleStep$.MODULE$.apply$default$3();
        Option<String> x$63 = Step$SingleStep$.MODULE$.apply$default$5();
        Map<String, String> x$64 = Step$SingleStep$.MODULE$.apply$default$6();
        singleStepArray2[2] = new Step.SingleStep(x$59, (Option<ActionRef>)x$60, x$62, (Map<String, Json>)x$61, x$63, x$64);
        String x$65 = "Publish Docs to NPM Registry";
        Some x$66 = new Some((Object)new StringBuilder(10).append("sbt ").append(sbtBuildOptions.mkString(" ")).append(" docs/").append(versioning.npmCommand()).toString());
        Map x$67 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NODE_AUTH_TOKEN"), (Object)"${{ secrets.NPM_TOKEN }}")}));
        Option<ActionRef> x$68 = Step$SingleStep$.MODULE$.apply$default$2();
        Option<Condition> x$69 = Step$SingleStep$.MODULE$.apply$default$3();
        Map<String, Json> x$70 = Step$SingleStep$.MODULE$.apply$default$4();
        singleStepArray2[3] = new Step.SingleStep(x$65, x$68, x$69, x$70, (Option<String>)x$66, (Map<String, String>)x$67);
        .colon.colon x$74 = new .colon.colon((Object)new Step.StepSequence((Seq<Step>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])singleStepArray2)))), (List)Nil$.MODULE$);
        String x$75 = Job$.MODULE$.apply$default$3();
        Option<Strategy> x$76 = Job$.MODULE$.apply$default$4();
        Seq<String> x$77 = Job$.MODULE$.apply$default$6();
        Seq<Service> x$78 = Job$.MODULE$.apply$default$7();
        String x$109 = "generate-readme";
        String x$110 = "Generate README";
        Some x$111 = new Some((Object)new Condition.Expression("github.event_name == 'push'"));
        Step.SingleStep[] singleStepArray3 = new Step.SingleStep[5];
        String x$79 = "Git Checkout";
        Some x$80 = new Some((Object)new ActionRef("actions/checkout@v3.2.0"));
        Map x$81 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ref"), (Object)package.EncoderOps$.MODULE$.asJson$extension(package$.MODULE$.EncoderOps((Object)"${{ github.head_ref }}"), Encoder$.MODULE$.encodeString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fetch-depth"), (Object)package.EncoderOps$.MODULE$.asJson$extension(package$.MODULE$.EncoderOps((Object)"0"), Encoder$.MODULE$.encodeString()))}));
        Option<Condition> x$82 = Step$SingleStep$.MODULE$.apply$default$3();
        Option<String> x$83 = Step$SingleStep$.MODULE$.apply$default$5();
        Map<String, String> x$84 = Step$SingleStep$.MODULE$.apply$default$6();
        singleStepArray3[0] = new Step.SingleStep(x$79, (Option<ActionRef>)x$80, x$82, (Map<String, Json>)x$81, x$83, x$84);
        String x$85 = "Setup Scala";
        Some x$86 = new Some((Object)new ActionRef("actions/setup-java@v3.9.0"));
        Map x$87 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"distribution"), (Object)package.EncoderOps$.MODULE$.asJson$extension(package$.MODULE$.EncoderOps((Object)"temurin"), Encoder$.MODULE$.encodeString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java-version"), (Object)package.EncoderOps$.MODULE$.asJson$extension(package$.MODULE$.EncoderOps((Object)BoxesRunTime.boxToInteger((int)17)), Encoder$.MODULE$.encodeInt())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"check-latest"), (Object)package.EncoderOps$.MODULE$.asJson$extension(package$.MODULE$.EncoderOps((Object)BoxesRunTime.boxToBoolean((boolean)true)), Encoder$.MODULE$.encodeBoolean()))}));
        Option<Condition> x$88 = Step$SingleStep$.MODULE$.apply$default$3();
        Option<String> x$89 = Step$SingleStep$.MODULE$.apply$default$5();
        Map<String, String> x$90 = Step$SingleStep$.MODULE$.apply$default$6();
        singleStepArray3[1] = new Step.SingleStep(x$85, (Option<ActionRef>)x$86, x$88, (Map<String, Json>)x$87, x$89, x$90);
        String x$91 = "Generate Readme";
        Some x$92 = new Some((Object)new StringBuilder(24).append("sbt ").append(sbtBuildOptions.mkString(" ")).append(" docs/generateReadme").toString());
        Option<ActionRef> x$93 = Step$SingleStep$.MODULE$.apply$default$2();
        Option<Condition> x$94 = Step$SingleStep$.MODULE$.apply$default$3();
        Map<String, Json> x$95 = Step$SingleStep$.MODULE$.apply$default$4();
        Map<String, String> x$96 = Step$SingleStep$.MODULE$.apply$default$6();
        singleStepArray3[2] = new Step.SingleStep(x$91, x$93, x$94, x$95, (Option<String>)x$92, x$96);
        String x$97 = "Commit Changes";
        Some x$98 = new Some((Object)new StringOps(Predef$.MODULE$.augmentString("|git config --local user.email \"github-actions[bot]@users.noreply.github.com\"\n                                |git config --local user.name \"github-actions[bot]\"\n                                |git add README.md\n                                |git commit -m \"Update README.md\" || echo \"No changes to commit\"\n                                |")).stripMargin());
        Option<ActionRef> x$99 = Step$SingleStep$.MODULE$.apply$default$2();
        Option<Condition> x$100 = Step$SingleStep$.MODULE$.apply$default$3();
        Map<String, Json> x$101 = Step$SingleStep$.MODULE$.apply$default$4();
        Map<String, String> x$102 = Step$SingleStep$.MODULE$.apply$default$6();
        singleStepArray3[3] = new Step.SingleStep(x$97, x$99, x$100, x$101, (Option<String>)x$98, x$102);
        String x$103 = "Create Pull Request";
        Some x$104 = new Some((Object)new ActionRef("peter-evans/create-pull-request@v4.2.3"));
        Map x$105 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"title"), (Object)package.EncoderOps$.MODULE$.asJson$extension(package$.MODULE$.EncoderOps((Object)"Update README.md"), Encoder$.MODULE$.encodeString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"commit-message"), (Object)package.EncoderOps$.MODULE$.asJson$extension(package$.MODULE$.EncoderOps((Object)"Update README.md"), Encoder$.MODULE$.encodeString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"branch"), (Object)package.EncoderOps$.MODULE$.asJson$extension(package$.MODULE$.EncoderOps((Object)"zio-sbt-website/update-readme"), Encoder$.MODULE$.encodeString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete-branch"), (Object)package.EncoderOps$.MODULE$.asJson$extension(package$.MODULE$.EncoderOps((Object)BoxesRunTime.boxToBoolean((boolean)true)), Encoder$.MODULE$.encodeBoolean())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"body"), (Object)package.EncoderOps$.MODULE$.asJson$extension(package$.MODULE$.EncoderOps((Object)new StringOps(Predef$.MODULE$.augmentString("|Autogenerated changes after running the `sbt docs/generateReadme` command of the [zio-sbt-website](https://zio.dev/zio-sbt) plugin.\n                         |\n                         |I will automatically update the README.md file whenever there is new change for README.md, e.g.\n                         |  - After each release, I will update the version in the installation section.\n                         |  - After any changes to the \"docs/index.md\" file, I will update the README.md file accordingly.")).stripMargin()), Encoder$.MODULE$.encodeString()))}));
        Option<Condition> x$106 = Step$SingleStep$.MODULE$.apply$default$3();
        Option<String> x$107 = Step$SingleStep$.MODULE$.apply$default$5();
        Map<String, String> x$108 = Step$SingleStep$.MODULE$.apply$default$6();
        singleStepArray3[4] = new Step.SingleStep(x$103, (Option<ActionRef>)x$104, x$106, (Map<String, Json>)x$105, x$107, x$108);
        Seq x$112 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])singleStepArray3));
        String x$113 = Job$.MODULE$.apply$default$3();
        Option<Strategy> x$114 = Job$.MODULE$.apply$default$4();
        Seq<String> x$115 = Job$.MODULE$.apply$default$6();
        Seq<Service> x$116 = Job$.MODULE$.apply$default$7();
        return new Printer(x$1, x$2, x$6, x$7, x$3, x$8, x$9, x$10, x$11, x$12, (Printer.LineBreak)x$4, x$13, x$14, (Printer.YamlVersion)x$5).pretty(package.EncoderOps$.MODULE$.asJson$extension(package$.MODULE$.EncoderOps((Object)new Workflow("Website", (Seq<Trigger>)new .colon.colon((Object)new Trigger.WorkflowDispatch(Trigger$WorkflowDispatch$.MODULE$.apply$default$1()), (List)new .colon.colon((Object)new Trigger.Release((Seq<String>)new .colon.colon((Object)"published", (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new Trigger.Push((Seq<Branch>)new .colon.colon((Object)new Branch.Named(docsPublishBranch), (List)Nil$.MODULE$), Trigger$Push$.MODULE$.apply$default$2()), (List)new .colon.colon((Object)new Trigger.PullRequest(Trigger$PullRequest$.MODULE$.apply$default$1(), Trigger$PullRequest$.MODULE$.apply$default$2()), (List)Nil$.MODULE$)))), (Seq<Job>)new .colon.colon((Object)new Job(x$39, x$40, x$43, x$44, (Seq<Step>)x$42, x$45, x$46, (Option<Condition>)x$41), (List)new .colon.colon((Object)new Job(x$71, x$72, x$75, x$76, (Seq<Step>)x$74, x$77, x$78, (Option<Condition>)x$73), (List)new .colon.colon((Object)new Job(x$109, x$110, x$113, x$114, (Seq<Step>)x$112, x$115, x$116, (Option<Condition>)x$111), (List)Nil$.MODULE$))))), Workflow$.MODULE$.encoder()));
    }

    public List<String> websiteWorkflow$default$2() {
        return List$.MODULE$.empty();
    }

    public WebsiteUtils.DocsVersioning websiteWorkflow$default$3() {
        return WebsiteUtils$DocsVersioning$SemanticVersioning$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$removeYamlHeader$1(String x$1) {
        String string = x$1;
        String string2 = "---";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$removeYamlHeader$2(String x$2) {
        String string = x$2;
        String string2 = "---";
        return string == null || !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$removeYamlHeader$3(String x$3) {
        String string = x$3;
        String string2 = "---";
        return string != null && string.equals(string2);
    }

    private WebsiteUtils$() {
        MODULE$ = this;
    }
}

