/*
 * Decompiled with CFR 0.152.
 */
package dk.acto.fafnir.api.model;

import dk.acto.fafnir.api.model.FailureReason;
import dk.acto.fafnir.api.model.conf.FafnirConf;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Optional;

public class AuthenticationResult {
    private final String jwt;
    private final FailureReason failureReason;
    private final String redirectUrl;

    public static AuthenticationResult success(String jwt) {
        return new AuthenticationResult(jwt, null, null);
    }

    public static AuthenticationResult failure(FailureReason failureReason) {
        return new AuthenticationResult(null, failureReason, null);
    }

    public static AuthenticationResult redirect(String redirectUrl) {
        return new AuthenticationResult(null, null, redirectUrl);
    }

    public String getUrl(FafnirConf fafnirConf) {
        if (this.redirectUrl != null) {
            return this.redirectUrl;
        }
        return Optional.ofNullable(this.jwt).map(token -> fafnirConf.getSuccessRedirect() + "#" + token).orElseGet(() -> fafnirConf.getFailureRedirect() + "#" + (Serializable)(this.failureReason != null ? Integer.valueOf(this.failureReason.getErrorCode()) : ""));
    }

    @ConstructorProperties(value={"jwt", "failureReason", "redirectUrl"})
    public AuthenticationResult(String jwt, FailureReason failureReason, String redirectUrl) {
        this.jwt = jwt;
        this.failureReason = failureReason;
        this.redirectUrl = redirectUrl;
    }
}

