/*
 * Decompiled with CFR 0.152.
 */
package dk.acto.fafnir.api.model;

import dk.acto.fafnir.api.model.UserData;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Locale;

public final class FafnirUser
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final UserData data;
    private final String organisationId;
    private final String organisationName;
    private final String provider;
    private final String[] roles;

    @ConstructorProperties(value={"data", "organisationId", "organisationName", "provider", "roles"})
    FafnirUser(UserData data, String organisationId, String organisationName, String provider, String[] roles) {
        this.data = data;
        this.organisationId = organisationId;
        this.organisationName = organisationName;
        this.provider = provider;
        this.roles = roles;
    }

    public static FafnirUserBuilder builder() {
        return new FafnirUserBuilder();
    }

    public FafnirUserBuilder toBuilder() {
        return new FafnirUserBuilder().data(this.data).organisationId(this.organisationId).organisationName(this.organisationName).provider(this.provider).roles(this.roles);
    }

    public UserData getData() {
        return this.data;
    }

    public String getOrganisationId() {
        return this.organisationId;
    }

    public String getOrganisationName() {
        return this.organisationName;
    }

    public String getProvider() {
        return this.provider;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FafnirUser)) {
            return false;
        }
        FafnirUser other = (FafnirUser)o;
        UserData this$data = this.getData();
        UserData other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        String this$organisationId = this.getOrganisationId();
        String other$organisationId = other.getOrganisationId();
        if (this$organisationId == null ? other$organisationId != null : !this$organisationId.equals(other$organisationId)) {
            return false;
        }
        String this$organisationName = this.getOrganisationName();
        String other$organisationName = other.getOrganisationName();
        if (this$organisationName == null ? other$organisationName != null : !this$organisationName.equals(other$organisationName)) {
            return false;
        }
        String this$provider = this.getProvider();
        String other$provider = other.getProvider();
        if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
            return false;
        }
        return Arrays.deepEquals(this.getRoles(), other.getRoles());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UserData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        String $organisationId = this.getOrganisationId();
        result = result * 59 + ($organisationId == null ? 43 : $organisationId.hashCode());
        String $organisationName = this.getOrganisationName();
        result = result * 59 + ($organisationName == null ? 43 : $organisationName.hashCode());
        String $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getRoles());
        return result;
    }

    public String toString() {
        return "FafnirUser(data=" + this.getData() + ", organisationId=" + this.getOrganisationId() + ", organisationName=" + this.getOrganisationName() + ", provider=" + this.getProvider() + ", roles=" + Arrays.deepToString(this.getRoles()) + ")";
    }

    public UserData partialUpdate(UserData updated) {
        return this.getData().partialUpdate(updated);
    }

    public String getSubject() {
        return this.getData().getSubject();
    }

    public String getPassword() {
        return this.getData().getPassword();
    }

    public String getName() {
        return this.getData().getName();
    }

    public String getMetaId() {
        return this.getData().getMetaId();
    }

    public String getProviderOrg() {
        return this.getData().getProviderOrg();
    }

    public Locale getLocale() {
        return this.getData().getLocale();
    }

    public Instant getCreated() {
        return this.getData().getCreated();
    }

    public static class FafnirUserBuilder {
        private UserData data;
        private String organisationId;
        private String organisationName;
        private String provider;
        private String[] roles;

        FafnirUserBuilder() {
        }

        public FafnirUserBuilder data(UserData data) {
            this.data = data;
            return this;
        }

        public FafnirUserBuilder organisationId(String organisationId) {
            this.organisationId = organisationId;
            return this;
        }

        public FafnirUserBuilder organisationName(String organisationName) {
            this.organisationName = organisationName;
            return this;
        }

        public FafnirUserBuilder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public FafnirUserBuilder roles(String[] roles) {
            this.roles = roles;
            return this;
        }

        public FafnirUser build() {
            return new FafnirUser(this.data, this.organisationId, this.organisationName, this.provider, this.roles);
        }

        public String toString() {
            return "FafnirUser.FafnirUserBuilder(data=" + this.data + ", organisationId=" + this.organisationId + ", organisationName=" + this.organisationName + ", provider=" + this.provider + ", roles=" + Arrays.deepToString(this.roles) + ")";
        }
    }
}

