/*
 * Decompiled with CFR 0.152.
 */
package dk.acto.fafnir.api.model;

import dk.acto.fafnir.api.model.ProviderConfiguration;
import dk.acto.fafnir.api.provider.metadata.MetadataProvider;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.time.Instant;
import java.util.Optional;

public final class OrganisationData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String organisationId;
    private final String organisationName;
    private final String contactEmail;
    private final ProviderConfiguration providerConfiguration;
    private final Instant created;
    public static final OrganisationData DEFAULT = OrganisationData.builder().created(Instant.now()).organisationId("default").organisationName("Default Organisation").providerConfiguration(ProviderConfiguration.builder().providerId(MetadataProvider.HAZELCAST.getProviderId()).build()).build();

    public OrganisationData partialUpdate(OrganisationData updated) {
        return OrganisationData.builder().organisationId(this.organisationId).organisationName(Optional.ofNullable(updated.getOrganisationName()).orElse(this.organisationName)).contactEmail(Optional.ofNullable(updated.contactEmail).orElse(this.contactEmail)).providerConfiguration(Optional.ofNullable(updated.getProviderConfiguration()).orElse(this.providerConfiguration)).created(Optional.ofNullable(this.created).or(() -> Optional.ofNullable(updated.getCreated())).orElse(Instant.now())).build();
    }

    public static OrganisationDataBuilder builder() {
        return new OrganisationDataBuilder();
    }

    public OrganisationDataBuilder toBuilder() {
        return new OrganisationDataBuilder().organisationId(this.organisationId).organisationName(this.organisationName).contactEmail(this.contactEmail).providerConfiguration(this.providerConfiguration).created(this.created);
    }

    public String getOrganisationId() {
        return this.organisationId;
    }

    public String getOrganisationName() {
        return this.organisationName;
    }

    public String getContactEmail() {
        return this.contactEmail;
    }

    public ProviderConfiguration getProviderConfiguration() {
        return this.providerConfiguration;
    }

    public Instant getCreated() {
        return this.created;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrganisationData)) {
            return false;
        }
        OrganisationData other = (OrganisationData)o;
        String this$organisationId = this.getOrganisationId();
        String other$organisationId = other.getOrganisationId();
        if (this$organisationId == null ? other$organisationId != null : !this$organisationId.equals(other$organisationId)) {
            return false;
        }
        String this$organisationName = this.getOrganisationName();
        String other$organisationName = other.getOrganisationName();
        if (this$organisationName == null ? other$organisationName != null : !this$organisationName.equals(other$organisationName)) {
            return false;
        }
        String this$contactEmail = this.getContactEmail();
        String other$contactEmail = other.getContactEmail();
        if (this$contactEmail == null ? other$contactEmail != null : !this$contactEmail.equals(other$contactEmail)) {
            return false;
        }
        ProviderConfiguration this$providerConfiguration = this.getProviderConfiguration();
        ProviderConfiguration other$providerConfiguration = other.getProviderConfiguration();
        if (this$providerConfiguration == null ? other$providerConfiguration != null : !((Object)this$providerConfiguration).equals(other$providerConfiguration)) {
            return false;
        }
        Instant this$created = this.getCreated();
        Instant other$created = other.getCreated();
        return !(this$created == null ? other$created != null : !((Object)this$created).equals(other$created));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $organisationId = this.getOrganisationId();
        result = result * 59 + ($organisationId == null ? 43 : $organisationId.hashCode());
        String $organisationName = this.getOrganisationName();
        result = result * 59 + ($organisationName == null ? 43 : $organisationName.hashCode());
        String $contactEmail = this.getContactEmail();
        result = result * 59 + ($contactEmail == null ? 43 : $contactEmail.hashCode());
        ProviderConfiguration $providerConfiguration = this.getProviderConfiguration();
        result = result * 59 + ($providerConfiguration == null ? 43 : ((Object)$providerConfiguration).hashCode());
        Instant $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        return result;
    }

    public String toString() {
        return "OrganisationData(organisationId=" + this.getOrganisationId() + ", organisationName=" + this.getOrganisationName() + ", contactEmail=" + this.getContactEmail() + ", providerConfiguration=" + this.getProviderConfiguration() + ", created=" + this.getCreated() + ")";
    }

    @ConstructorProperties(value={"organisationId", "organisationName", "contactEmail", "providerConfiguration", "created"})
    public OrganisationData(String organisationId, String organisationName, String contactEmail, ProviderConfiguration providerConfiguration, Instant created) {
        this.organisationId = organisationId;
        this.organisationName = organisationName;
        this.contactEmail = contactEmail;
        this.providerConfiguration = providerConfiguration;
        this.created = created;
    }

    public static class OrganisationDataBuilder {
        private String organisationId;
        private String organisationName;
        private String contactEmail;
        private ProviderConfiguration providerConfiguration;
        private Instant created;

        OrganisationDataBuilder() {
        }

        public OrganisationDataBuilder organisationId(String organisationId) {
            this.organisationId = organisationId;
            return this;
        }

        public OrganisationDataBuilder organisationName(String organisationName) {
            this.organisationName = organisationName;
            return this;
        }

        public OrganisationDataBuilder contactEmail(String contactEmail) {
            this.contactEmail = contactEmail;
            return this;
        }

        public OrganisationDataBuilder providerConfiguration(ProviderConfiguration providerConfiguration) {
            this.providerConfiguration = providerConfiguration;
            return this;
        }

        public OrganisationDataBuilder created(Instant created) {
            this.created = created;
            return this;
        }

        public OrganisationData build() {
            return new OrganisationData(this.organisationId, this.organisationName, this.contactEmail, this.providerConfiguration, this.created);
        }

        public String toString() {
            return "OrganisationData.OrganisationDataBuilder(organisationId=" + this.organisationId + ", organisationName=" + this.organisationName + ", contactEmail=" + this.contactEmail + ", providerConfiguration=" + this.providerConfiguration + ", created=" + this.created + ")";
        }
    }
}

