/*
 * Decompiled with CFR 0.152.
 */
package dk.acto.fafnir.api.model;

import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Slice<T> {
    public static final Long PAGE_SIZE = 30L;
    private final BigInteger totalPages;
    private final List<T> pageData;

    public static Long getOffset(Long pageNumber) {
        return pageNumber * PAGE_SIZE;
    }

    public static Long lastPage(Long maxValue) {
        if (maxValue == 0L) {
            return 0L;
        }
        return (maxValue - 1L) / PAGE_SIZE;
    }

    public static Long cropPage(Long purePageNumber, Long maxValue) {
        long result = purePageNumber - 1L;
        long lastPage = maxValue / PAGE_SIZE;
        if (result < 1L) {
            return 0L;
        }
        if (result > lastPage) {
            return lastPage;
        }
        return result;
    }

    public static <T, R> Slice<R> fromPartial(Stream<T> source, Long totalElements, Function<T, R> transform) {
        return Slice.builder().totalPages(BigDecimal.valueOf(totalElements).divide(BigDecimal.valueOf(PAGE_SIZE), RoundingMode.CEILING).toBigInteger()).pageData(source.map(transform).collect(Collectors.toList())).build();
    }

    @ConstructorProperties(value={"totalPages", "pageData"})
    Slice(BigInteger totalPages, List<T> pageData) {
        this.totalPages = totalPages;
        this.pageData = pageData;
    }

    public static <T> SliceBuilder<T> builder() {
        return new SliceBuilder();
    }

    public BigInteger getTotalPages() {
        return this.totalPages;
    }

    public List<T> getPageData() {
        return this.pageData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Slice)) {
            return false;
        }
        Slice other = (Slice)o;
        BigInteger this$totalPages = this.getTotalPages();
        BigInteger other$totalPages = other.getTotalPages();
        if (this$totalPages == null ? other$totalPages != null : !((Object)this$totalPages).equals(other$totalPages)) {
            return false;
        }
        List<T> this$pageData = this.getPageData();
        List<T> other$pageData = other.getPageData();
        return !(this$pageData == null ? other$pageData != null : !((Object)this$pageData).equals(other$pageData));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $totalPages = this.getTotalPages();
        result = result * 59 + ($totalPages == null ? 43 : ((Object)$totalPages).hashCode());
        List<T> $pageData = this.getPageData();
        result = result * 59 + ($pageData == null ? 43 : ((Object)$pageData).hashCode());
        return result;
    }

    public String toString() {
        return "Slice(totalPages=" + this.getTotalPages() + ", pageData=" + this.getPageData() + ")";
    }

    public static class SliceBuilder<T> {
        private BigInteger totalPages;
        private List<T> pageData;

        SliceBuilder() {
        }

        public SliceBuilder<T> totalPages(BigInteger totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        public SliceBuilder<T> pageData(List<T> pageData) {
            this.pageData = pageData;
            return this;
        }

        public Slice<T> build() {
            return new Slice<T>(this.totalPages, this.pageData);
        }

        public String toString() {
            return "Slice.SliceBuilder(totalPages=" + this.totalPages + ", pageData=" + this.pageData + ")";
        }
    }
}

