/*
 * Decompiled with CFR 0.152.
 */
package dk.acto.fafnir.api.model;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.time.Instant;
import java.util.Locale;
import java.util.Optional;

public final class UserData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String subject;
    private final String password;
    private final String name;
    private final String metaId;
    private final String providerOrg;
    private final Locale locale;
    private final Instant created;

    public UserData partialUpdate(UserData updated) {
        return UserData.builder().subject(this.subject).name(Optional.ofNullable(updated.getName()).orElse(this.name)).password(Optional.ofNullable(updated.getPassword()).orElse(this.password)).metaId(Optional.ofNullable(updated.getMetaId()).orElse(this.metaId)).providerOrg(Optional.ofNullable(updated.providerOrg).orElse(this.providerOrg)).locale(Optional.ofNullable(updated.getLocale()).orElse(this.locale)).created(Optional.ofNullable(this.created).or(() -> Optional.ofNullable(updated.getCreated())).orElse(Instant.now())).build();
    }

    @ConstructorProperties(value={"subject", "password", "name", "metaId", "providerOrg", "locale", "created"})
    UserData(String subject, String password, String name, String metaId, String providerOrg, Locale locale, Instant created) {
        this.subject = subject;
        this.password = password;
        this.name = name;
        this.metaId = metaId;
        this.providerOrg = providerOrg;
        this.locale = locale;
        this.created = created;
    }

    public static UserDataBuilder builder() {
        return new UserDataBuilder();
    }

    public UserDataBuilder toBuilder() {
        return new UserDataBuilder().subject(this.subject).password(this.password).name(this.name).metaId(this.metaId).providerOrg(this.providerOrg).locale(this.locale).created(this.created);
    }

    public String getSubject() {
        return this.subject;
    }

    public String getPassword() {
        return this.password;
    }

    public String getName() {
        return this.name;
    }

    public String getMetaId() {
        return this.metaId;
    }

    public String getProviderOrg() {
        return this.providerOrg;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Instant getCreated() {
        return this.created;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserData)) {
            return false;
        }
        UserData other = (UserData)o;
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$metaId = this.getMetaId();
        String other$metaId = other.getMetaId();
        if (this$metaId == null ? other$metaId != null : !this$metaId.equals(other$metaId)) {
            return false;
        }
        String this$providerOrg = this.getProviderOrg();
        String other$providerOrg = other.getProviderOrg();
        if (this$providerOrg == null ? other$providerOrg != null : !this$providerOrg.equals(other$providerOrg)) {
            return false;
        }
        Locale this$locale = this.getLocale();
        Locale other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !((Object)this$locale).equals(other$locale)) {
            return false;
        }
        Instant this$created = this.getCreated();
        Instant other$created = other.getCreated();
        return !(this$created == null ? other$created != null : !((Object)this$created).equals(other$created));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $metaId = this.getMetaId();
        result = result * 59 + ($metaId == null ? 43 : $metaId.hashCode());
        String $providerOrg = this.getProviderOrg();
        result = result * 59 + ($providerOrg == null ? 43 : $providerOrg.hashCode());
        Locale $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : ((Object)$locale).hashCode());
        Instant $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        return result;
    }

    public String toString() {
        return "UserData(subject=" + this.getSubject() + ", password=" + this.getPassword() + ", name=" + this.getName() + ", metaId=" + this.getMetaId() + ", providerOrg=" + this.getProviderOrg() + ", locale=" + this.getLocale() + ", created=" + this.getCreated() + ")";
    }

    public static class UserDataBuilder {
        private String subject;
        private String password;
        private String name;
        private String metaId;
        private String providerOrg;
        private Locale locale;
        private Instant created;

        UserDataBuilder() {
        }

        public UserDataBuilder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public UserDataBuilder password(String password) {
            this.password = password;
            return this;
        }

        public UserDataBuilder name(String name) {
            this.name = name;
            return this;
        }

        public UserDataBuilder metaId(String metaId) {
            this.metaId = metaId;
            return this;
        }

        public UserDataBuilder providerOrg(String providerOrg) {
            this.providerOrg = providerOrg;
            return this;
        }

        public UserDataBuilder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public UserDataBuilder created(Instant created) {
            this.created = created;
            return this;
        }

        public UserData build() {
            return new UserData(this.subject, this.password, this.name, this.metaId, this.providerOrg, this.locale, this.created);
        }

        public String toString() {
            return "UserData.UserDataBuilder(subject=" + this.subject + ", password=" + this.password + ", name=" + this.name + ", metaId=" + this.metaId + ", providerOrg=" + this.providerOrg + ", locale=" + this.locale + ", created=" + this.created + ")";
        }
    }
}

