/*
 * Decompiled with CFR 0.152.
 */
package dk.acto.fafnir.api.service.hazelcast;

import dk.acto.fafnir.api.service.CryptoService;
import dk.acto.fafnir.api.util.CryptoUtil;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Optional;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class CryptoServiceImpl
implements CryptoService {
    public final PasswordEncoder passwordEncoder = PasswordEncoderFactories.createDelegatingPasswordEncoder();

    @Override
    public String encodePassword(String password, PublicKey publicKey) {
        String hashedPass = this.passwordEncoder.encode((CharSequence)password);
        return Optional.ofNullable(publicKey).map(x -> CryptoUtil.encryptPassword(hashedPass, x)).orElse(hashedPass);
    }

    @Override
    public Boolean matches(String password, String encoded, PrivateKey privateKey) {
        String decoded = Optional.ofNullable(privateKey).map(x -> CryptoUtil.decryptPassword(encoded, x)).orElse(encoded);
        return this.passwordEncoder.matches((CharSequence)password, decoded);
    }
}

