/*
 * Decompiled with CFR 0.152.
 */
package dk.acto.fafnir.api.service.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.map.listener.EntryAddedListener;
import com.hazelcast.map.listener.EntryRemovedListener;
import com.hazelcast.map.listener.EntryUpdatedListener;
import com.hazelcast.map.listener.MapListener;
import dk.acto.fafnir.api.exception.ClaimAlreadyExists;
import dk.acto.fafnir.api.exception.NoOrganisationId;
import dk.acto.fafnir.api.exception.NoSubject;
import dk.acto.fafnir.api.exception.NoSuchClaim;
import dk.acto.fafnir.api.exception.NoSuchOrganisation;
import dk.acto.fafnir.api.exception.NoSuchUser;
import dk.acto.fafnir.api.exception.OrganisationAlreadyExists;
import dk.acto.fafnir.api.exception.UserAlreadyExists;
import dk.acto.fafnir.api.exception.UserUpdateFailed;
import dk.acto.fafnir.api.model.ClaimData;
import dk.acto.fafnir.api.model.OrganisationData;
import dk.acto.fafnir.api.model.OrganisationSubjectPair;
import dk.acto.fafnir.api.model.Slice;
import dk.acto.fafnir.api.model.TenantIdentifier;
import dk.acto.fafnir.api.model.UserData;
import dk.acto.fafnir.api.model.conf.HazelcastConf;
import dk.acto.fafnir.api.service.AdministrationService;
import dk.acto.fafnir.api.service.CryptoService;
import dk.acto.fafnir.api.util.CryptoUtil;
import dk.acto.fafnir.client.providers.PublicKeyProvider;
import java.beans.ConstructorProperties;
import java.security.PublicKey;
import java.time.Instant;
import java.util.Comparator;
import java.util.Optional;
import org.springframework.stereotype.Service;
import reactor.core.publisher.ConnectableFlux;
import reactor.core.publisher.Flux;

@Service
public class HazelcastAdministrationService
implements AdministrationService {
    public static final String USER_POSTFIX = "-fafnir-user";
    public static final String ORG_POSTFIX = "-fafnir-organisation";
    public static final String CLAIM_POSTFIX = "-fafnir-claim";
    private final HazelcastInstance hazelcastInstance;
    private final HazelcastConf hazelcastConf;
    private final PublicKeyProvider publicKeyProvider;
    private final CryptoService cryptoService;

    @Override
    public UserData createUser(UserData src) {
        UserData source = this.hazelcastRules(src);
        IMap userMap = this.hazelcastInstance.getMap(this.hazelcastConf.getPrefix() + USER_POSTFIX);
        if (userMap.containsKey((Object)source.getSubject())) {
            throw new UserAlreadyExists();
        }
        UserData create = source.toBuilder().created(Instant.now()).build();
        UserData temp = this.secure(create);
        userMap.put((Object)source.getSubject(), (Object)temp);
        return temp;
    }

    @Override
    public UserData readUser(String source) {
        String subject = this.hazelcastRules(source);
        IMap userMap = this.hazelcastInstance.getMap(this.hazelcastConf.getPrefix() + USER_POSTFIX);
        return Optional.ofNullable((UserData)userMap.get((Object)subject)).orElseThrow(NoSuchUser::new);
    }

    @Override
    public Slice<UserData> readUsers(Long page) {
        IMap userMap = this.hazelcastInstance.getMap(this.hazelcastConf.getPrefix() + USER_POSTFIX);
        Long offset = Slice.getOffset(page);
        Long total = userMap.size();
        return Slice.fromPartial(userMap.values().stream().skip(offset).limit(Slice.PAGE_SIZE), total, x -> x);
    }

    @Override
    public UserData[] readUsers() {
        IMap userMap = this.hazelcastInstance.getMap(this.hazelcastConf.getPrefix() + USER_POSTFIX);
        return (UserData[])userMap.values().toArray(UserData[]::new);
    }

    @Override
    public UserData updateUser(UserData source) {
        String subject = Optional.ofNullable(source.getSubject()).map(this::hazelcastRules).orElseThrow(NoSubject::new);
        IMap userMap = this.hazelcastInstance.getMap(this.hazelcastConf.getPrefix() + USER_POSTFIX);
        if (!userMap.containsKey((Object)subject)) {
            throw new NoSuchUser();
        }
        UserData updated = Optional.ofNullable((UserData)userMap.get((Object)subject)).map(x -> x.partialUpdate(source)).orElseThrow(UserUpdateFailed::new);
        UserData temp = source.getPassword() == null ? updated : this.secure(updated);
        userMap.put((Object)subject, (Object)temp);
        return temp;
    }

    @Override
    public UserData deleteUser(String source) {
        String subject = this.hazelcastRules(source);
        IMap userMap = this.hazelcastInstance.getMap(this.hazelcastConf.getPrefix() + USER_POSTFIX);
        if (!userMap.containsKey((Object)subject)) {
            throw new NoSuchUser();
        }
        return (UserData)userMap.remove((Object)subject);
    }

    @Override
    public OrganisationData createOrganisation(OrganisationData source) {
        String orgId = source.getOrganisationId();
        IMap orgMap = this.hazelcastInstance.getMap(this.hazelcastConf.getPrefix() + ORG_POSTFIX);
        if (orgMap.containsKey((Object)orgId)) {
            throw new OrganisationAlreadyExists();
        }
        OrganisationData create = source.toBuilder().created(Instant.now()).build();
        orgMap.put((Object)orgId, (Object)create);
        return create;
    }

    @Override
    public OrganisationData readOrganisation(String orgId) {
        IMap orgMap = this.hazelcastInstance.getMap(this.hazelcastConf.getPrefix() + ORG_POSTFIX);
        return Optional.ofNullable((OrganisationData)orgMap.get((Object)orgId)).orElseThrow(NoSuchOrganisation::new);
    }

    @Override
    public OrganisationData readOrganisation(TenantIdentifier identifier) {
        IMap orgMap = this.hazelcastInstance.getMap(this.hazelcastConf.getPrefix() + ORG_POSTFIX);
        return orgMap.values().stream().filter(entry -> identifier.matches(entry.getProviderConfiguration())).findAny().orElseThrow(NoSuchOrganisation::new);
    }

    @Override
    public OrganisationData updateOrganisation(OrganisationData source) {
        String orgId = Optional.ofNullable(source.getOrganisationId()).orElseThrow(NoOrganisationId::new);
        IMap orgMap = this.hazelcastInstance.getMap(this.hazelcastConf.getPrefix() + ORG_POSTFIX);
        if (!orgMap.containsKey((Object)orgId)) {
            throw new NoSuchOrganisation();
        }
        OrganisationData updated = Optional.of((OrganisationData)orgMap.get((Object)orgId)).map(x -> x.partialUpdate(source)).orElseThrow(NoOrganisationId::new);
        orgMap.put((Object)orgId, (Object)updated);
        return updated;
    }

    @Override
    public OrganisationData deleteOrganisation(String orgId) {
        IMap orgMap = this.hazelcastInstance.getMap(this.hazelcastConf.getPrefix() + ORG_POSTFIX);
        if (!orgMap.containsKey((Object)orgId)) {
            throw new NoSuchOrganisation();
        }
        return (OrganisationData)orgMap.remove((Object)orgId);
    }

    @Override
    public ClaimData createClaim(OrganisationSubjectPair pairSource, ClaimData source) {
        OrganisationSubjectPair pair = this.hazelcastRules(pairSource);
        this.readUser(pair.getSubject());
        this.readOrganisation(pair.getOrganisationId());
        IMap claimMap = this.hazelcastInstance.getMap(this.hazelcastConf.getPrefix() + CLAIM_POSTFIX);
        if (claimMap.containsKey((Object)pair)) {
            throw new ClaimAlreadyExists();
        }
        claimMap.put((Object)pair, (Object)source);
        return source;
    }

    @Override
    public ClaimData readClaims(OrganisationSubjectPair source) {
        OrganisationSubjectPair pair = this.hazelcastRules(source);
        IMap claimMap = this.hazelcastInstance.getMap(this.hazelcastConf.getPrefix() + CLAIM_POSTFIX);
        if (!claimMap.containsKey((Object)pair)) {
            throw new NoSuchClaim();
        }
        return (ClaimData)claimMap.get((Object)pair);
    }

    @Override
    public ClaimData updateClaims(OrganisationSubjectPair pairSource, ClaimData source) {
        OrganisationSubjectPair pair = this.hazelcastRules(pairSource);
        IMap claimMap = this.hazelcastInstance.getMap(this.hazelcastConf.getPrefix() + CLAIM_POSTFIX);
        if (!claimMap.containsKey((Object)pair)) {
            throw new NoSuchClaim();
        }
        claimMap.put((Object)pair, (Object)source);
        return source;
    }

    @Override
    public ClaimData deleteClaims(OrganisationSubjectPair source) {
        OrganisationSubjectPair pair = this.hazelcastRules(source);
        IMap claimMap = this.hazelcastInstance.getMap(this.hazelcastConf.getPrefix() + CLAIM_POSTFIX);
        if (!claimMap.containsKey((Object)pair)) {
            throw new NoSuchClaim();
        }
        ClaimData result = (ClaimData)claimMap.get((Object)pair);
        claimMap.remove((Object)pair);
        return result;
    }

    @Override
    public OrganisationData[] getOrganisationsForUser(String subject) {
        IMap claimMap = this.hazelcastInstance.getMap(this.hazelcastConf.getPrefix() + CLAIM_POSTFIX);
        return (OrganisationData[])claimMap.keySet().stream().filter(x -> x.getSubject().equals(this.hazelcastRules(subject))).map(OrganisationSubjectPair::getOrganisationId).map(this::readOrganisation).toArray(OrganisationData[]::new);
    }

    @Override
    public UserData[] getUsersForOrganisation(String orgId) {
        IMap claimMap = this.hazelcastInstance.getMap(this.hazelcastConf.getPrefix() + CLAIM_POSTFIX);
        return (UserData[])claimMap.keySet().stream().filter(x -> x.getOrganisationId().equals(orgId)).map(OrganisationSubjectPair::getSubject).sorted().map(this::readUser).toArray(UserData[]::new);
    }

    @Override
    public Slice<OrganisationData> readOrganisations(Long page) {
        IMap orgMap = this.hazelcastInstance.getMap(this.hazelcastConf.getPrefix() + ORG_POSTFIX);
        Long offset = Slice.getOffset(page);
        Long total = orgMap.size();
        return Slice.fromPartial(orgMap.values().stream().sorted(Comparator.comparing(OrganisationData::getOrganisationName)).skip(offset).limit(Slice.PAGE_SIZE), total, x -> x);
    }

    @Override
    public OrganisationData[] readOrganisations() {
        IMap orgMap = this.hazelcastInstance.getMap(this.hazelcastConf.getPrefix() + ORG_POSTFIX);
        return (OrganisationData[])orgMap.values().toArray(OrganisationData[]::new);
    }

    @Override
    public Long countOrganisations() {
        IMap orgMap = this.hazelcastInstance.getMap(this.hazelcastConf.getPrefix() + ORG_POSTFIX);
        return orgMap.entrySet().size();
    }

    @Override
    public ConnectableFlux<UserData> getUserFlux() {
        return this.getUserFlux(true);
    }

    @Override
    public ConnectableFlux<UserData> getUserFlux(Boolean publishOnUpdate) {
        IMap userMap = this.hazelcastInstance.getMap(this.hazelcastConf.getPrefix() + USER_POSTFIX);
        return Flux.create(x -> {
            userMap.addEntryListener((MapListener)((EntryAddedListener)d -> x.next((Object)((UserData)d.getValue()))), true);
            if (publishOnUpdate.booleanValue()) {
                userMap.addEntryListener((MapListener)((EntryUpdatedListener)d -> x.next((Object)((UserData)d.getValue()))), true);
            }
        }).publish();
    }

    @Override
    public ConnectableFlux<OrganisationData> getOrganisationFlux() {
        return this.getOrganisationFlux(true);
    }

    @Override
    public ConnectableFlux<OrganisationData> getOrganisationFlux(Boolean publishOnUpdate) {
        IMap orgMap = this.hazelcastInstance.getMap(this.hazelcastConf.getPrefix() + ORG_POSTFIX);
        return Flux.create(x -> {
            orgMap.addEntryListener((MapListener)((EntryAddedListener)d -> x.next((Object)((OrganisationData)d.getValue()))), true);
            if (publishOnUpdate.booleanValue()) {
                orgMap.addEntryListener((MapListener)((EntryUpdatedListener)d -> x.next((Object)((OrganisationData)d.getValue()))), true);
            }
        }).publish();
    }

    @Override
    public ConnectableFlux<String> getUserDeletionFlux() {
        IMap userMap = this.hazelcastInstance.getMap(this.hazelcastConf.getPrefix() + USER_POSTFIX);
        return Flux.create(x -> userMap.addEntryListener((MapListener)((EntryRemovedListener)d -> x.next((Object)((String)d.getKey()))), false)).publish();
    }

    @Override
    public ConnectableFlux<String> getOrganisationDeletionFlux() {
        IMap orgMap = this.hazelcastInstance.getMap(this.hazelcastConf.getPrefix() + ORG_POSTFIX);
        return Flux.create(x -> orgMap.addEntryListener((MapListener)((EntryRemovedListener)d -> x.next((Object)((String)d.getKey()))), false)).publish();
    }

    private UserData secure(UserData source) {
        PublicKey pk = this.hazelcastConf.isPasswordIsEncrypted() ? CryptoUtil.toPublicKey(this.publicKeyProvider) : null;
        return source.toBuilder().password(this.cryptoService.encodePassword(source.getPassword(), pk)).build();
    }

    private String hazelcastRules(String source) {
        String subject = this.hazelcastConf.isTrimUsername() ? source.trim() : source;
        return this.hazelcastConf.isUsernameIsEmail() ? subject.toLowerCase() : subject;
    }

    private OrganisationSubjectPair hazelcastRules(OrganisationSubjectPair source) {
        String subject = this.hazelcastRules(source.getSubject());
        return source.toBuilder().subject(subject).build();
    }

    private UserData hazelcastRules(UserData source) {
        String subject = this.hazelcastRules(source.getSubject());
        return source.toBuilder().subject(subject).build();
    }

    @ConstructorProperties(value={"hazelcastInstance", "hazelcastConf", "publicKeyProvider", "cryptoService"})
    public HazelcastAdministrationService(HazelcastInstance hazelcastInstance, HazelcastConf hazelcastConf, PublicKeyProvider publicKeyProvider, CryptoService cryptoService) {
        this.hazelcastInstance = hazelcastInstance;
        this.hazelcastConf = hazelcastConf;
        this.publicKeyProvider = publicKeyProvider;
        this.cryptoService = cryptoService;
    }
}

