/*
 * Decompiled with CFR 0.152.
 */
package dk.acto.fafnir.api.util;

import dk.acto.fafnir.api.exception.InvalidPublicKey;
import dk.acto.fafnir.api.exception.PasswordDecryptionFailed;
import dk.acto.fafnir.api.exception.PasswordEncryptionFailed;
import dk.acto.fafnir.api.exception.PasswordHashingFailed;
import dk.acto.fafnir.client.providers.PublicKeyProvider;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Try;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Optional;
import javax.crypto.Cipher;
import org.bouncycastle.crypto.generators.BCrypt;

public final class CryptoUtil {
    public static String decryptPassword(String encrypted, PrivateKey privateKey) {
        return (String)Try.of((CheckedFunction0 & Serializable)() -> Cipher.getInstance("RSA/None/OAEPWITHSHA-256ANDMGF1PADDING")).andThenTry(x -> x.init(2, privateKey)).mapTry((CheckedFunction1 & Serializable)x -> x.doFinal(Base64.getDecoder().decode(encrypted))).map(x -> new String((byte[])x, StandardCharsets.UTF_8)).getOrElseThrow(PasswordDecryptionFailed::new);
    }

    public static String encryptPassword(String password, PublicKey publicKey) {
        return (String)Try.of((CheckedFunction0 & Serializable)() -> Cipher.getInstance("RSA/None/OAEPWITHSHA-256ANDMGF1PADDING")).andThenTry(x -> x.init(1, publicKey)).mapTry((CheckedFunction1 & Serializable)x -> x.doFinal(password.getBytes(StandardCharsets.UTF_8))).map(x -> Base64.getEncoder().encodeToString((byte[])x)).getOrElseThrow(PasswordEncryptionFailed::new);
    }

    public static String hashPassword(String password) {
        return (String)Try.of((CheckedFunction0 & Serializable)() -> BCrypt.passwordToByteArray((char[])password.toCharArray())).map(Base64.getEncoder()::encodeToString).getOrElseThrow(PasswordHashingFailed::new);
    }

    public static PublicKey toPublicKey(PublicKeyProvider provider) {
        return Optional.of(provider.getPublicKey()).map(Base64.getDecoder()::decode).map(X509EncodedKeySpec::new).map(x -> (PublicKey)Try.of((CheckedFunction0 & Serializable)() -> KeyFactory.getInstance("RSA")).mapTry((CheckedFunction1 & Serializable)y -> y.generatePublic((KeySpec)x)).toJavaOptional().orElseThrow(InvalidPublicKey::new)).orElseThrow(InvalidPublicKey::new);
    }
}

