/*
 * Decompiled with CFR 0.152.
 */
package dk.acto.fafnir.client;

import dk.acto.fafnir.api.model.FafnirUser;
import java.beans.ConstructorProperties;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class JwtAuthentication
implements Authentication,
UserDetails {
    private final List<GrantedAuthority> authorities;
    private final FafnirUser details;

    public String getCredentials() {
        return this.getSubject();
    }

    public Principal getPrincipal() {
        return this;
    }

    public boolean isAuthenticated() {
        return this.getSubject() != null;
    }

    public void setAuthenticated(boolean isAuthenticated) {
        throw new IllegalArgumentException("Authentication is immutable.");
    }

    public String getName() {
        return Optional.ofNullable(this.details).map(FafnirUser::getName).orElse(null);
    }

    public String getPassword() {
        return null;
    }

    public String getUsername() {
        return this.getSubject();
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    private String getSubject() {
        return Optional.ofNullable(this.details).map(FafnirUser::getSubject).orElse(null);
    }

    public String getMetaId() {
        return Optional.ofNullable(this.details).map(FafnirUser::getMetaId).orElse(null);
    }

    public boolean hasMetaId() {
        return Optional.ofNullable(this.details).map(FafnirUser::getMetaId).isPresent();
    }

    public boolean isInOrganisation() {
        return Optional.ofNullable(this.details).map(FafnirUser::getOrganisationId).isPresent();
    }

    public String getOrganisationId() {
        return Optional.ofNullable(this.details).map(FafnirUser::getOrganisationId).orElse(null);
    }

    @ConstructorProperties(value={"authorities", "details"})
    JwtAuthentication(List<GrantedAuthority> authorities, FafnirUser details) {
        this.authorities = authorities;
        this.details = details;
    }

    public static JwtAuthenticationBuilder builder() {
        return new JwtAuthenticationBuilder();
    }

    public List<GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public FafnirUser getDetails() {
        return this.details;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtAuthentication)) {
            return false;
        }
        JwtAuthentication other = (JwtAuthentication)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Collection this$authorities = this.getAuthorities();
        Collection other$authorities = other.getAuthorities();
        if (this$authorities == null ? other$authorities != null : !((Object)this$authorities).equals(other$authorities)) {
            return false;
        }
        FafnirUser this$details = this.getDetails();
        FafnirUser other$details = other.getDetails();
        return !(this$details == null ? other$details != null : !((Object)this$details).equals(other$details));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JwtAuthentication;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Collection $authorities = this.getAuthorities();
        result = result * 59 + ($authorities == null ? 43 : ((Object)$authorities).hashCode());
        FafnirUser $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
        return result;
    }

    public String toString() {
        return "JwtAuthentication(authorities=" + (List)this.getAuthorities() + ", details=" + this.getDetails() + ")";
    }

    public static class JwtAuthenticationBuilder {
        private ArrayList<GrantedAuthority> authorities;
        private FafnirUser details;

        JwtAuthenticationBuilder() {
        }

        public JwtAuthenticationBuilder authority(GrantedAuthority authority) {
            if (this.authorities == null) {
                this.authorities = new ArrayList();
            }
            this.authorities.add(authority);
            return this;
        }

        public JwtAuthenticationBuilder authorities(Collection<? extends GrantedAuthority> authorities) {
            if (authorities == null) {
                throw new NullPointerException("authorities cannot be null");
            }
            if (this.authorities == null) {
                this.authorities = new ArrayList();
            }
            this.authorities.addAll(authorities);
            return this;
        }

        public JwtAuthenticationBuilder clearAuthorities() {
            if (this.authorities != null) {
                this.authorities.clear();
            }
            return this;
        }

        public JwtAuthenticationBuilder details(FafnirUser details) {
            this.details = details;
            return this;
        }

        public JwtAuthentication build() {
            return new JwtAuthentication(switch (this.authorities == null ? 0 : this.authorities.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.authorities.get(0));
                default -> Collections.unmodifiableList(new ArrayList<GrantedAuthority>(this.authorities));
            }, this.details);
        }

        public String toString() {
            return "JwtAuthentication.JwtAuthenticationBuilder(authorities=" + this.authorities + ", details=" + this.details + ")";
        }
    }
}

