/*
 * Decompiled with CFR 0.152.
 */
package dk.acto.fafnir.client;

import dk.acto.fafnir.client.JwtValidator;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Optional;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.GenericFilterBean;

@Component
public class JwtFilter
extends GenericFilterBean {
    private final JwtValidator validator;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest cast = (HttpServletRequest)request;
        Optional.ofNullable(cast.getHeader("Authorization")).map(this.validator::decodeToken).ifPresent(x -> SecurityContextHolder.getContext().setAuthentication((Authentication)x));
        chain.doFilter(request, response);
    }

    @ConstructorProperties(value={"validator"})
    public JwtFilter(JwtValidator validator) {
        this.validator = validator;
    }
}

