/*
 * Decompiled with CFR 0.152.
 */
package dk.acto.fafnir.client;

import dk.acto.fafnir.api.exception.InvalidPublicKey;
import dk.acto.fafnir.api.model.FafnirUser;
import dk.acto.fafnir.api.model.UserData;
import dk.acto.fafnir.client.JwtAuthentication;
import dk.acto.fafnir.client.providers.AuthoritiesProvider;
import dk.acto.fafnir.client.providers.PublicKeyProvider;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Try;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.springframework.stereotype.Component;

@Component
public class JwtValidator {
    private static final Pattern auth = Pattern.compile("^([Bb]earer\\s+)?(.+)$");
    private final PublicKeyProvider publicKeyProvider;
    private final AuthoritiesProvider ap;

    public JwtAuthentication decodeToken(String authHeader) {
        JwtParser decoder = Optional.of(this.publicKeyProvider.getPublicKey()).map(Base64.getDecoder()::decode).map(X509EncodedKeySpec::new).map(x -> (PublicKey)Try.of((CheckedFunction0 & Serializable)() -> KeyFactory.getInstance("RSA")).mapTry((CheckedFunction1 & Serializable)y -> y.generatePublic((KeySpec)x)).toJavaOptional().orElseThrow(InvalidPublicKey::new)).map(x -> Jwts.parserBuilder().setSigningKey((Key)x).build()).orElseThrow(InvalidPublicKey::new);
        Claims claims = (Claims)Try.of((CheckedFunction0 & Serializable)() -> auth.matcher(authHeader)).filter(Matcher::matches).map(x -> x.group(2)).mapTry(arg_0 -> ((JwtParser)decoder).parseClaimsJws(arg_0)).map(Jwt::getBody).getOrNull();
        return Optional.ofNullable(claims).map(c -> JwtAuthentication.builder().details(this.mapClaims(claims)).authorities(this.ap.mapAuthorities((Map<String, Object>)claims)).build()).orElse(null);
    }

    private FafnirUser mapClaims(Claims claims) {
        return FafnirUser.builder().data(UserData.builder().subject(claims.getSubject()).name((String)claims.get("name", String.class)).locale(Optional.ofNullable((String)claims.get("locale", String.class)).map(Locale::forLanguageTag).orElse(null)).metaId((String)claims.get("mId", String.class)).providerOrg((String)claims.get("provider_org", String.class)).created(claims.getIssuedAt().toInstant()).build()).organisationId((String)claims.get("org_id", String.class)).organisationName((String)claims.get("org_name", String.class)).provider(claims.getIssuer()).roles(this.mapRoles(claims.get((Object)"role"))).build();
    }

    private String[] mapRoles(Object roles) {
        Stream.Builder builder = Stream.builder();
        Optional.ofNullable(roles).ifPresent(r -> Try.of((CheckedFunction0 & Serializable)() -> (List)r).forEach(list -> list.forEach(each -> Try.of((CheckedFunction0 & Serializable)() -> (String)each).forEach((Consumer)builder))));
        return (String[])builder.build().toArray(String[]::new);
    }

    @ConstructorProperties(value={"publicKeyProvider", "ap"})
    public JwtValidator(PublicKeyProvider publicKeyProvider, AuthoritiesProvider ap) {
        this.publicKeyProvider = publicKeyProvider;
        this.ap = ap;
    }
}

