/*
 * Decompiled with CFR 0.152.
 */
package dk.acto.fafnir.client.providers.builtin;

import dk.acto.fafnir.api.exception.InvalidConfiguration;
import dk.acto.fafnir.api.exception.InvalidPublicKey;
import dk.acto.fafnir.client.providers.PublicKeyProvider;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.StandardCharsets;

public class RestfulPublicKeyProvider
implements PublicKeyProvider {
    private final String fafnirUrl;
    private final String fafnirPort;

    @Override
    public String getPublicKey() {
        URL url = (URL)Try.of((CheckedFunction0 & Serializable)() -> new URL(String.format("%s:%s/public-key", this.fafnirUrl, this.fafnirPort))).toJavaOptional().orElseThrow(InvalidConfiguration::new);
        return (String)Try.withResources(url::openStream).of(InputStream::readAllBytes).map(bytes -> new String((byte[])bytes, StandardCharsets.UTF_8)).toJavaOptional().orElseThrow(InvalidPublicKey::new);
    }

    @ConstructorProperties(value={"fafnirUrl", "fafnirPort"})
    public RestfulPublicKeyProvider(String fafnirUrl, String fafnirPort) {
        this.fafnirUrl = fafnirUrl;
        this.fafnirPort = fafnirPort;
    }
}

