/*
 * Decompiled with CFR 0.152.
 */
package dk.alexandra.fresco.lib.debug;

import dk.alexandra.fresco.framework.Application;
import dk.alexandra.fresco.framework.DRes;
import dk.alexandra.fresco.framework.TestThreadRunner;
import dk.alexandra.fresco.framework.builder.numeric.Numeric;
import dk.alexandra.fresco.framework.builder.numeric.ProtocolBuilderNumeric;
import dk.alexandra.fresco.framework.sce.resources.ResourcePool;
import dk.alexandra.fresco.lib.common.collections.Matrix;
import dk.alexandra.fresco.lib.debug.DefaultDebug;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;

public class ArithmeticDebugTests {

    public static class TestArithmeticOpenAndPrint<ResourcePoolT extends ResourcePool>
    extends TestThreadRunner.TestThreadFactory<ResourcePoolT, ProtocolBuilderNumeric> {
        public TestThreadRunner.TestThread<ResourcePoolT, ProtocolBuilderNumeric> next() {
            return new TestThreadRunner.TestThread<ResourcePoolT, ProtocolBuilderNumeric>(){
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                PrintStream stream = new PrintStream(this.bytes);

                public void test() throws Exception {
                    Application app = producer -> producer.seq(seq -> {
                        Numeric numeric = seq.numeric();
                        List toPrint = Arrays.stream(new BigInteger[]{BigInteger.ONE, BigInteger.TEN, BigInteger.ZERO, BigInteger.ONE}).map(n -> numeric.input(n, 1)).collect(Collectors.toList());
                        return () -> toPrint;
                    }).seq((seq, inputs) -> {
                        DefaultDebug debug = new DefaultDebug(seq);
                        debug.openAndPrint("testNumber", (DRes)inputs.get(0), this.stream);
                        debug.openAndPrint("testVector", inputs, this.stream);
                        ArrayList<DRes> r1 = new ArrayList<DRes>();
                        r1.add((DRes)inputs.get(0));
                        r1.add((DRes)inputs.get(1));
                        ArrayList<DRes> r2 = new ArrayList<DRes>();
                        r2.add((DRes)inputs.get(2));
                        r2.add((DRes)inputs.get(3));
                        ArrayList<ArrayList<DRes>> m = new ArrayList<ArrayList<DRes>>();
                        m.add(r1);
                        m.add(r2);
                        Matrix matrix = new Matrix(2, 2, m);
                        debug.openAndPrint("testMatrix", matrix, this.stream);
                        return null;
                    });
                    this.runApplication(app);
                    String output = this.bytes.toString("UTF-8");
                    Assert.assertEquals((Object)"testNumber\n1\ntestVector\n1, 10, 0, 1, \ntestMatrix\n1, 10, \n0, 1, \n\n", (Object)output.replace("\r", ""));
                }
            };
        }
    }
}

