/*
 * Decompiled with CFR 0.152.
 */
package dk.alexandra.fresco.lib.debug;

import dk.alexandra.fresco.framework.Application;
import dk.alexandra.fresco.framework.TestThreadRunner;
import dk.alexandra.fresco.framework.builder.binary.Binary;
import dk.alexandra.fresco.framework.builder.binary.ProtocolBuilderBinary;
import dk.alexandra.fresco.framework.sce.resources.ResourcePool;
import dk.alexandra.fresco.lib.bool.BooleanHelper;
import dk.alexandra.fresco.lib.debug.binary.DefaultBinaryDebug;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.List;
import org.junit.Assert;

public class BinaryDebugTests {

    public static class TestBinaryDebugToNullStream<ResourcePoolT extends ResourcePool>
    extends TestThreadRunner.TestThreadFactory<ResourcePoolT, ProtocolBuilderBinary> {
        public TestThreadRunner.TestThread<ResourcePoolT, ProtocolBuilderBinary> next() {
            return new TestThreadRunner.TestThread<ResourcePoolT, ProtocolBuilderBinary>(){

                public void test() throws Exception {
                    Application app = producer -> producer.seq(seq -> {
                        List toPrint = BooleanHelper.known((Boolean[])new Boolean[]{true, false, false, true}, (Binary)seq.binary());
                        return () -> toPrint;
                    }).seq((seq, inputs) -> {
                        DefaultBinaryDebug debug = new DefaultBinaryDebug(seq);
                        debug.openAndPrint("test", inputs);
                        debug.marker("test");
                        return null;
                    });
                    this.runApplication(app);
                }
            };
        }
    }

    public static class TestBinaryOpenAndPrint<ResourcePoolT extends ResourcePool>
    extends TestThreadRunner.TestThreadFactory<ResourcePoolT, ProtocolBuilderBinary> {
        public TestThreadRunner.TestThread<ResourcePoolT, ProtocolBuilderBinary> next() {
            return new TestThreadRunner.TestThread<ResourcePoolT, ProtocolBuilderBinary>(){
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                PrintStream stream = new PrintStream(this.bytes);

                public void test() throws Exception {
                    Application app = producer -> producer.seq(seq -> {
                        List toPrint = BooleanHelper.known((Boolean[])new Boolean[]{true, false, false, true}, (Binary)seq.binary());
                        return () -> toPrint;
                    }).seq((seq, inputs) -> {
                        DefaultBinaryDebug debug = new DefaultBinaryDebug(seq);
                        debug.openAndPrint("test", inputs, this.stream);
                        debug.marker("test", this.stream);
                        return null;
                    });
                    this.runApplication(app);
                    String output = this.bytes.toString("UTF-8");
                    Assert.assertEquals((Object)"test\n1001\ntest\n", (Object)output.replace("\r", ""));
                }
            };
        }
    }
}

