/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.kotlin.eventsourcing.adapters;

import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.EventStore;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.eventstream.AggregateEventStream;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.eventstream.PersistedEvent;
import dk.cloudcreate.essentials.components.kotlin.eventsourcing.AggregateTypeConfiguration;
import dk.cloudcreate.essentials.components.kotlin.eventsourcing.Decider;
import dk.cloudcreate.essentials.reactive.command.CommandHandler;
import dk.cloudcreate.essentials.shared.types.GenericType;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B+\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\rH\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0019H\u0002J\b\u0010\u001e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014\u00a8\u0006\u001f"}, d2={"Ldk/cloudcreate/essentials/components/kotlin/eventsourcing/adapters/DeciderCommandHandlerAdapter;", "CMD", "EVENT", "Ldk/cloudcreate/essentials/reactive/command/CommandHandler;", "decider", "Ldk/cloudcreate/essentials/components/kotlin/eventsourcing/Decider;", "aggregateTypeConfiguration", "Ldk/cloudcreate/essentials/components/kotlin/eventsourcing/AggregateTypeConfiguration;", "eventStore", "Ldk/cloudcreate/essentials/components/eventsourced/eventstore/postgresql/EventStore;", "<init>", "(Ldk/cloudcreate/essentials/components/kotlin/eventsourcing/Decider;Ldk/cloudcreate/essentials/components/kotlin/eventsourcing/AggregateTypeConfiguration;Ldk/cloudcreate/essentials/components/eventsourced/eventstore/postgresql/EventStore;)V", "deciderHandlesCommandOfType", "Ljava/lang/Class;", "deciderClassName", "", "deciderSimpleClassName", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "canHandle", "", "commandType", "handle", "", "command", "loadAggregateEventStream", "", "aggregateId", "toString", "kotlin-eventsourcing"})
public final class DeciderCommandHandlerAdapter<CMD, EVENT>
implements CommandHandler {
    @NotNull
    private final Decider<CMD, EVENT> decider;
    @NotNull
    private final AggregateTypeConfiguration aggregateTypeConfiguration;
    @NotNull
    private final EventStore eventStore;
    @Nullable
    private final Class<?> deciderHandlesCommandOfType;
    @Nullable
    private final String deciderClassName;
    @Nullable
    private final String deciderSimpleClassName;
    private final Logger log;

    public DeciderCommandHandlerAdapter(@NotNull Decider<CMD, EVENT> decider, @NotNull AggregateTypeConfiguration aggregateTypeConfiguration, @NotNull EventStore eventStore) {
        Intrinsics.checkNotNullParameter(decider, (String)"decider");
        Intrinsics.checkNotNullParameter((Object)aggregateTypeConfiguration, (String)"aggregateTypeConfiguration");
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        this.decider = decider;
        this.aggregateTypeConfiguration = aggregateTypeConfiguration;
        this.eventStore = eventStore;
        this.deciderHandlesCommandOfType = GenericType.resolveGenericTypeForInterface(this.decider.getClass(), Decider.class, (int)0);
        this.deciderClassName = Reflection.getOrCreateKotlinClass(this.decider.getClass()).getQualifiedName();
        this.deciderSimpleClassName = Reflection.getOrCreateKotlinClass(this.decider.getClass()).getSimpleName();
        this.log = LoggerFactory.getLogger((String)(this.getClass().getName() + "." + this.deciderSimpleClassName));
        if (this.deciderHandlesCommandOfType == null) {
            throw new IllegalArgumentException("Couldn't resolve the command type from " + this.deciderClassName);
        }
        Object[] objectArray = new Object[]{Reflection.getOrCreateKotlinClass(CommandHandler.class).getSimpleName(), Reflection.getOrCreateKotlinClass(Decider.class).getSimpleName(), this.deciderClassName};
        this.log.info("Creating {} for {} '{}'", objectArray);
    }

    public boolean canHandle(@Nullable Class<?> commandType) {
        return Intrinsics.areEqual(commandType, this.deciderHandlesCommandOfType);
    }

    @Nullable
    public Object handle(@NotNull Object command) {
        Object[] objectArray;
        Object aggregateId;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.log.trace("Received command '{}'", this.deciderHandlesCommandOfType);
        Object object = aggregateId = this.aggregateTypeConfiguration.getCommandAggregateIdResolver().invoke(command);
        List<EVENT> aggregateEventStream = object != null ? this.loadAggregateEventStream(object) : CollectionsKt.emptyList();
        EVENT possibleEventResult = this.decider.handle(command, aggregateEventStream);
        if (possibleEventResult == null) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = this.aggregateTypeConfiguration.getAggregateType();
            Object object2 = aggregateId;
            if (object2 == null) {
                object2 = "?";
            }
            objectArray2[1] = object2;
            objectArray2[2] = this.deciderHandlesCommandOfType;
            this.log.debug("[{}:{}] Handling handling command '{}' resulted in no events", objectArray2);
            return null;
        }
        if (aggregateId == null) {
            aggregateId = this.aggregateTypeConfiguration.getEventAggregateIdResolver().invoke(possibleEventResult);
            objectArray = new Object[]{this.aggregateTypeConfiguration.getAggregateType(), aggregateId, Reflection.getOrCreateKotlinClass(possibleEventResult.getClass()).getSimpleName(), this.deciderHandlesCommandOfType};
            this.log.debug("[{}:{}] Resolved aggregate id from event '{}' resulting from handling command '{}'", objectArray);
        }
        objectArray = new Object[]{this.aggregateTypeConfiguration.getAggregateType(), aggregateId, this.deciderHandlesCommandOfType, Reflection.getOrCreateKotlinClass(possibleEventResult.getClass()).getSimpleName(), Reflection.getOrCreateKotlinClass(EventStore.class).getSimpleName()};
        this.log.debug("[{}:{}] Handling handling command '{}' resulted in event '{}' that will be persisted in the {}", objectArray);
        objectArray = new Object[]{possibleEventResult};
        this.eventStore.appendToStream(this.aggregateTypeConfiguration.getAggregateType(), aggregateId, objectArray);
        return possibleEventResult;
    }

    private final List<EVENT> loadAggregateEventStream(Object aggregateId) {
        Optional potentialAggregateEventStream = this.eventStore.fetchStream(this.aggregateTypeConfiguration.getAggregateType(), aggregateId);
        if (potentialAggregateEventStream.isPresent()) {
            List<Object> deserializedEvents = ((AggregateEventStream)potentialAggregateEventStream.get()).events().map(arg_0 -> DeciderCommandHandlerAdapter.loadAggregateEventStream$lambda$1(DeciderCommandHandlerAdapter::loadAggregateEventStream$lambda$0, arg_0)).toList();
            Object[] objectArray = new Object[]{this.aggregateTypeConfiguration.getAggregateType(), aggregateId, deserializedEvents.size()};
            this.log.debug("[{}:{}] Resolved EventStream with {} event(s)", objectArray);
            Intrinsics.checkNotNull(deserializedEvents);
            return deserializedEvents;
        }
        this.log.debug("[{}:{}] Didn't find an existing EventStream", (Object)this.aggregateTypeConfiguration.getAggregateType(), aggregateId);
        return CollectionsKt.emptyList();
    }

    @NotNull
    public String toString() {
        Class<?> clazz = this.deciderHandlesCommandOfType;
        Intrinsics.checkNotNull(clazz);
        return "'" + this.deciderSimpleClassName + "' handling command '" + clazz.getSimpleName() + "'";
    }

    private static final Object loadAggregateEventStream$lambda$0(PersistedEvent it) {
        return it.event().deserialize();
    }

    private static final Object loadAggregateEventStream$lambda$1(Function1 $tmp0, Object p0) {
        return $tmp0.invoke(p0);
    }
}

