/*
 * Decompiled with CFR 0.152.
 */
package dk.fust.docgen.confluence;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import dk.fust.docgen.confluence.model.Body;
import dk.fust.docgen.confluence.model.Metadata;
import dk.fust.docgen.confluence.model.Page;
import dk.fust.docgen.confluence.model.PageSearch;
import dk.fust.docgen.confluence.model.Space;
import dk.fust.docgen.confluence.model.Storage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.AbstractHttpMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfluenceService.class);
    private final String baseUrl;
    private final String basicAuth;
    private final ObjectMapper objectMapper;

    public ConfluenceService(String baseUrl, String username, String accessToken) {
        this.baseUrl = baseUrl;
        String basicAuth = "%s:%s".formatted(username, accessToken);
        this.basicAuth = Base64.getMimeEncoder().encodeToString(basicAuth.getBytes(StandardCharsets.UTF_8));
        this.objectMapper = new ObjectMapper();
    }

    public Page getPage(String id) throws IOException {
        String url = "%s/content/%s".formatted(this.baseUrl, id);
        HttpGet get = new HttpGet("%s?expand=body.storage,version".formatted(url));
        return this.callAndParse((HttpRequestBase)get, Page.class);
    }

    public Page updatePage(Page page) throws IOException {
        page.setAncestors(null);
        page.setSpace(null);
        String url = "%s/content/%s".formatted(this.baseUrl, page.getId());
        HttpPut put = new HttpPut(url);
        String json = this.pageToString(page);
        log.info("Updating Confluence with: {}", (Object)json);
        put.setEntity((HttpEntity)new StringEntity(json));
        return this.callAndParse((HttpRequestBase)put, Page.class);
    }

    public Page getChildWithTitle(String id, String titleForChild) throws IOException {
        String url = "%s/content/%s/child".formatted(this.baseUrl, id);
        HttpGet get = new HttpGet("%s?expand=page&limit=100".formatted(url));
        PageSearch pageSearch = this.callAndParse((HttpRequestBase)get, PageSearch.class);
        if (pageSearch.getPage() != null && pageSearch.getPage().getResults() != null && !pageSearch.getPage().getResults().isEmpty()) {
            log.info("has child pages");
            Optional<Page> pages = pageSearch.getPage().getResults().stream().filter(page -> page.getTitle().equals(titleForChild)).findFirst();
            if (pages.isPresent()) {
                Page childPageInfo = pages.get();
                log.info("Found child page with title: {}", (Object)childPageInfo.getTitle());
                return this.getPage(childPageInfo.getId());
            }
        }
        return null;
    }

    public Page createChildPage(String id, String childTitle, String spaceKey, String html) throws IOException {
        String url = "%s/content/".formatted(this.baseUrl);
        HttpPost post = new HttpPost(url);
        Page createPage = new Page();
        createPage.setType("page");
        createPage.setTitle(childTitle);
        createPage.setMetadata(Metadata.fullPageWidthMetadata());
        Page ancestor = new Page();
        ancestor.setId(id);
        createPage.setAncestors(List.of(ancestor));
        createPage.setSpace(new Space(spaceKey));
        createPage.setBody(new Body(new Storage(html, "storage")));
        String json = this.pageToString(createPage);
        post.setEntity((HttpEntity)new StringEntity(json));
        return this.callAndParse((HttpRequestBase)post, Page.class);
    }

    private <T> T callAndParse(HttpRequestBase request, Class<T> clazz) throws IOException {
        ConfluenceService.addHeaders((AbstractHttpMessage)request, this.basicAuth);
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            CloseableHttpResponse response = client.execute((HttpUriRequest)request);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            if (response.getStatusLine().getStatusCode() != 200) {
                log.error("Result from Confluence: {}", (Object)bufferedReader.readLine());
                throw new RuntimeException("Confluence call failed. HttpCode: " + response.getStatusLine().getStatusCode() + ". Uri: " + request.getRequestLine().getUri());
            }
            Object object = this.objectMapper.readValue((Reader)bufferedReader, clazz);
            return (T)object;
        }
    }

    private static void addHeaders(AbstractHttpMessage message, String basicAuth) {
        message.addHeader("content-type", "application/json");
        message.addHeader("Authorization", "Basic " + basicAuth);
    }

    protected String pageToString(Page page) throws JsonProcessingException {
        return this.objectMapper.writeValueAsString((Object)page);
    }
}

