/*
 * Decompiled with CFR 0.152.
 */
package dk.fust.docgen.confluence.destination;

import dk.fust.docgen.UserInput;
import dk.fust.docgen.confluence.ConfluenceService;
import dk.fust.docgen.confluence.model.Page;
import dk.fust.docgen.confluence.model.Storage;
import dk.fust.docgen.destination.Destination;
import dk.fust.docgen.util.Assert;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceDestination
implements Destination {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfluenceDestination.class);
    private static final String EMPTY_PARAGRAPH = "<p></p>";
    private String baseUrl;
    private String documentationPageId;
    private String spaceKey;
    private String parentPageTitle;
    private String pageTitle;
    private UserInput username = new UserInput("Enter your Confluence username");
    private UserInput accessToken = new UserInput("Enter your Confluence personal access token");

    public void validate() {
        Assert.isNotNull((Object)this.baseUrl, (String)"baseUrl must not be null");
        Assert.isNotNull((Object)this.spaceKey, (String)"spaceKey must not be null");
        Assert.isNotNull((Object)this.documentationPageId, (String)"documentationPageId must not be null");
        Assert.isNotNull((Object)this.pageTitle, (String)"pageTitle must not be null");
        Assert.isNotNull((Object)this.username, (String)"username must not be null");
        Assert.isNotNull((Object)this.accessToken, (String)"accessToken must not be null");
    }

    public void sendDocumentToDestination(String document, String destination) throws IOException {
        if (this.username.getAnswer() != null && !this.username.getAnswer().isEmpty() && this.accessToken.getAnswer() != null && !this.accessToken.getAnswer().isEmpty()) {
            ConfluenceService confluenceService = new ConfluenceService(this.baseUrl, this.username.getAnswer(), this.accessToken.getAnswer());
            String id = this.documentationPageId;
            if (this.parentPageTitle != null) {
                Page parentPage = this.getOrCreateChildWithTitle(this.documentationPageId, this.parentPageTitle, confluenceService);
                id = parentPage.getId();
            }
            Page page = this.getOrCreateChildWithTitle(id, this.pageTitle, confluenceService);
            log.info("Got page: {}", (Object)page);
            String originalHtml = page.getBody().getStorage().getValue();
            this.replaceTable(page, document, destination);
            if (!originalHtml.equals(page.getBody().getStorage().getValue())) {
                log.info("Table has changed -> updating Confluence");
                page.getVersion().setNumber(page.getVersion().getNumber() + 1);
                confluenceService.updatePage(page);
                log.info("Table is updated");
            } else {
                log.info("Table has not changed -> Won't update Confluence");
            }
        }
    }

    private void replaceTable(Page page, String confluenceTable, String destination) {
        Storage storage = page.getBody().getStorage();
        String html = storage.getValue();
        if (html.contains("<table class=\"%s".formatted(destination))) {
            String tableReplacedHtml = html.replaceAll("(.*)<table class=\"datalineage.*</table>(.*)", "$1%s$2".formatted(confluenceTable));
            storage.setValue(tableReplacedHtml);
        } else {
            storage.setValue(confluenceTable);
        }
    }

    private Page getOrCreateChildWithTitle(String pageId, String childTitle, ConfluenceService confluenceService) throws IOException {
        Page page = confluenceService.getChildWithTitle(pageId, childTitle);
        if (page == null) {
            page = confluenceService.createChildPage(pageId, childTitle, this.spaceKey, EMPTY_PARAGRAPH);
        }
        Assert.isNotNull((Object)page, (String)("Could not find or create page with title " + childTitle));
        return page;
    }

    @Generated
    public ConfluenceDestination() {
    }

    @Generated
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Generated
    public String getDocumentationPageId() {
        return this.documentationPageId;
    }

    @Generated
    public String getSpaceKey() {
        return this.spaceKey;
    }

    @Generated
    public String getParentPageTitle() {
        return this.parentPageTitle;
    }

    @Generated
    public String getPageTitle() {
        return this.pageTitle;
    }

    @Generated
    public UserInput getUsername() {
        return this.username;
    }

    @Generated
    public UserInput getAccessToken() {
        return this.accessToken;
    }

    @Generated
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Generated
    public void setDocumentationPageId(String documentationPageId) {
        this.documentationPageId = documentationPageId;
    }

    @Generated
    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    @Generated
    public void setParentPageTitle(String parentPageTitle) {
        this.parentPageTitle = parentPageTitle;
    }

    @Generated
    public void setPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
    }

    @Generated
    public void setUsername(UserInput username) {
        this.username = username;
    }

    @Generated
    public void setAccessToken(UserInput accessToken) {
        this.accessToken = accessToken;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfluenceDestination)) {
            return false;
        }
        ConfluenceDestination other = (ConfluenceDestination)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        String this$documentationPageId = this.getDocumentationPageId();
        String other$documentationPageId = other.getDocumentationPageId();
        if (this$documentationPageId == null ? other$documentationPageId != null : !this$documentationPageId.equals(other$documentationPageId)) {
            return false;
        }
        String this$spaceKey = this.getSpaceKey();
        String other$spaceKey = other.getSpaceKey();
        if (this$spaceKey == null ? other$spaceKey != null : !this$spaceKey.equals(other$spaceKey)) {
            return false;
        }
        String this$parentPageTitle = this.getParentPageTitle();
        String other$parentPageTitle = other.getParentPageTitle();
        if (this$parentPageTitle == null ? other$parentPageTitle != null : !this$parentPageTitle.equals(other$parentPageTitle)) {
            return false;
        }
        String this$pageTitle = this.getPageTitle();
        String other$pageTitle = other.getPageTitle();
        if (this$pageTitle == null ? other$pageTitle != null : !this$pageTitle.equals(other$pageTitle)) {
            return false;
        }
        UserInput this$username = this.getUsername();
        UserInput other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        UserInput this$accessToken = this.getAccessToken();
        UserInput other$accessToken = other.getAccessToken();
        return !(this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConfluenceDestination;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        String $documentationPageId = this.getDocumentationPageId();
        result = result * 59 + ($documentationPageId == null ? 43 : $documentationPageId.hashCode());
        String $spaceKey = this.getSpaceKey();
        result = result * 59 + ($spaceKey == null ? 43 : $spaceKey.hashCode());
        String $parentPageTitle = this.getParentPageTitle();
        result = result * 59 + ($parentPageTitle == null ? 43 : $parentPageTitle.hashCode());
        String $pageTitle = this.getPageTitle();
        result = result * 59 + ($pageTitle == null ? 43 : $pageTitle.hashCode());
        UserInput $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        UserInput $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ConfluenceDestination(baseUrl=" + this.getBaseUrl() + ", documentationPageId=" + this.getDocumentationPageId() + ", spaceKey=" + this.getSpaceKey() + ", parentPageTitle=" + this.getParentPageTitle() + ", pageTitle=" + this.getPageTitle() + ", username=" + this.getUsername() + ", accessToken=" + this.getAccessToken() + ")";
    }
}

