/*
 * Decompiled with CFR 0.152.
 */
package dk.hyperdivision.multisig_hmac;

import dk.hyperdivision.multisig_hmac.Key;
import dk.hyperdivision.multisig_hmac.MultisigHMAC;
import dk.hyperdivision.multisig_hmac.Signature;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class DerivedMultisigHMAC
extends MultisigHMAC {
    public DerivedMultisigHMAC(MultisigHMAC.Algorithm alg) {
        super(alg);
    }

    public byte[] generateMasterKey() {
        byte[] masterKey = new byte[this.KEYBYTES];
        SecureRandom random = new SecureRandom();
        random.nextBytes(masterKey);
        return masterKey;
    }

    public Key generate(int index, byte[] masterKey) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] dataBytes = "derived".getBytes();
        byte[] indexArray = DerivedMultisigHMAC.intToLittleEndian(index);
        byte[] _scratch = ByteBuffer.allocate(dataBytes.length + indexArray.length).put(dataBytes).put(indexArray).array();
        byte[] ZERO = new byte[]{0};
        byte[] ONE = new byte[]{1};
        Mac HMAC0 = Mac.getInstance(this.PRIMITIVE);
        SecretKeySpec hmacKey = new SecretKeySpec(masterKey, this.PRIMITIVE);
        HMAC0.init(hmacKey);
        HMAC0.update(_scratch);
        byte[] h0 = HMAC0.doFinal(ZERO);
        Mac HMAC1 = Mac.getInstance(this.PRIMITIVE);
        HMAC1.init(hmacKey);
        HMAC1.update(h0);
        byte[] h1 = HMAC1.doFinal(ONE);
        return new Key(index, ByteBuffer.allocate(h0.length + h1.length).put(h0).put(h1).array());
    }

    protected static byte[] intToLittleEndian(int index) {
        byte[] b = new byte[]{(byte)(index & 0xFF), (byte)(index >> 8 & 0xFF), (byte)(index >> 16 & 0xFF), (byte)(index >> 24 & 0xFF)};
        return b;
    }

    public boolean verify(byte[] masterKey, Signature signatures, byte[] message, int threshold) throws NoSuchAlgorithmException, InvalidKeyException, IllegalArgumentException {
        if (masterKey.length != this.KEYBYTES) {
            throw new IllegalArgumentException("Master key must be KEYBYTES long");
        }
        if (signatures.signature.length != this.BYTES) {
            throw new IllegalArgumentException("Signature must be BYTES long");
        }
        if (message == null) {
            throw new IllegalArgumentException("message must be bytes");
        }
        if (threshold <= 0) {
            throw new IllegalArgumentException("Threshold must be at least 1");
        }
        int bitField = signatures.index;
        int nKeys = DerivedMultisigHMAC.popCount(bitField);
        if (nKeys < threshold) {
            return false;
        }
        List<Integer> usedKeys = DerivedMultisigHMAC.keyIndexes(bitField);
        byte[] sig = signatures.signature;
        for (Integer usedKey : usedKeys) {
            Key key = this.generate(usedKey, masterKey);
            Signature keySig = this.sign(key, message);
            sig = this.xorBytes(sig, keySig.signature);
            bitField ^= keySig.index;
        }
        return bitField == 0 && Arrays.equals(sig, new byte[this.BYTES]);
    }
}

