/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.java;

import bsh.NameSpace;
import org.drools.rule.Declaration;
import org.drools.semantics.java.ClassObjectType;
import org.drools.semantics.java.ExprAnalyzer;
import org.drools.semantics.java.Interp;

public class Expr
extends Interp {
    private static final Declaration[] EMPTY_DECLS = new Declaration[0];
    private static int counter = 0;
    private Declaration[] requiredDecls;
    private String methodName;
    private NameSpace ns;

    protected Expr() throws Exception {
    }

    protected Expr(String expr, Declaration[] availDecls) throws Exception {
        this.requiredDecls = this.analyze(expr, availDecls);
        this.setText(expr);
    }

    public String getExpression() {
        return this.getText();
    }

    public void setText(String text) {
        this.methodName = "drools$expression$" + ++counter;
        this.ns = new NameSpace(this.getInterpreter().getClassManager(), "");
        this.ns.importCommands("bsh");
        StringBuffer method = new StringBuffer();
        method.append(this.methodName + "(");
        Declaration[] params = this.getRequiredTupleMembers();
        int i = 0;
        while (i < params.length) {
            if (i > 0) {
                method.append(",");
            }
            method.append(((ClassObjectType)params[i].getObjectType()).getType().getName());
            method.append(" " + params[i].getIdentifier());
            ++i;
        }
        method.append(")");
        method.append("{");
        method.append("return " + text + ";");
        method.append("}");
        try {
            this.getInterpreter().eval(method.toString(), this.ns);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.setText(text);
    }

    protected String getMethodName() {
        return this.methodName;
    }

    protected NameSpace getNameSpace() {
        return this.ns;
    }

    protected Declaration[] analyze(String expr, Declaration[] available) throws Exception {
        ExprAnalyzer analyzer = new ExprAnalyzer();
        return analyzer.analyze(expr, available);
    }

    public Declaration[] getRequiredTupleMembers() {
        return this.requiredDecls;
    }
}

