/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.java;

import net.janino.ScriptEvaluator;
import org.drools.rule.Declaration;
import org.drools.semantics.java.ExprAnalyzer;
import org.drools.semantics.java.Interp;
import org.drools.spi.Tuple;

public class Expr
extends Interp {
    private static final Declaration[] EMPTY_DECLS = new Declaration[0];
    private Declaration[] requiredDecls;
    private ScriptEvaluator code;
    private Class returnType;

    protected Expr() throws Exception {
    }

    protected Expr(String expr, Declaration[] availDecls, Class returnType) throws Exception {
        super(expr);
        this.returnType = returnType;
        this.requiredDecls = this.analyze(expr, availDecls);
    }

    public String getExpression() {
        return this.getText();
    }

    private void compile(Tuple tuple) throws Exception {
        String[] paramNames = new String[this.requiredDecls.length + 2];
        Class[] paramTypes = new Class[this.requiredDecls.length + 2];
        String expr = this.getPreparedText(tuple, this.requiredDecls, paramNames, paramTypes);
        try {
            this.code = new ScriptEvaluator(expr, this.returnType, paramNames, paramTypes);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public Object evaluate(Object[] paramValues, Tuple tuple) throws Exception {
        if (this.code == null) {
            this.compile(tuple);
        }
        return this.code.evaluate(paramValues);
    }

    protected Declaration[] analyze(String expr, Declaration[] available) throws Exception {
        ExprAnalyzer analyzer = new ExprAnalyzer();
        return analyzer.analyze(expr, available);
    }

    public Declaration[] getRequiredTupleMembers() {
        return this.requiredDecls;
    }

    public Class getReturnType() {
        return this.returnType;
    }
}

