/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.java;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Iterator;
import org.drools.rule.Declaration;
import org.drools.semantics.java.MissingDeclarationException;
import org.drools.semantics.java.parser.JavaLexer;
import org.drools.semantics.java.parser.JavaRecognizer;
import org.drools.semantics.java.parser.JavaTreeParser;

public class ExprAnalyzer {
    public Declaration[] analyze(String expr, Declaration[] availDecls) throws TokenStreamException, RecognitionException, MissingDeclarationException {
        JavaLexer lexer = new JavaLexer(new StringReader(expr));
        JavaRecognizer parser = new JavaRecognizer(lexer);
        parser.ruleCondition();
        AST ast = parser.getAST();
        return this.analyze(expr, availDecls, ast);
    }

    private Declaration[] analyze(String expr, Declaration[] availDecls, AST ast) throws RecognitionException, MissingDeclarationException {
        JavaTreeParser treeParser = new JavaTreeParser();
        treeParser.init();
        treeParser.exprCondition(ast);
        HashSet<Declaration> availDeclSet = new HashSet<Declaration>();
        int i = 0;
        while (i < availDecls.length) {
            availDeclSet.add(availDecls[i]);
            ++i;
        }
        HashSet refs = new HashSet(treeParser.getVariableReferences());
        HashSet<Declaration> declSet = new HashSet<Declaration>();
        Iterator declIter = availDeclSet.iterator();
        Declaration eachDecl = null;
        while (declIter.hasNext()) {
            eachDecl = (Declaration)declIter.next();
            if (!refs.contains(eachDecl.getIdentifier())) continue;
            declSet.add(eachDecl);
            declIter.remove();
            refs.remove(eachDecl.getIdentifier());
        }
        Declaration[] decls = new Declaration[declSet.size()];
        declIter = declSet.iterator();
        eachDecl = null;
        int i2 = 0;
        while (declIter.hasNext()) {
            decls[i2++] = (Declaration)declIter.next();
        }
        return decls;
    }
}

