package earth.worldwind

import dev.icerock.moko.graphics.Color
import dev.icerock.moko.resources.AssetResource
import dev.icerock.moko.resources.ColorResource
import dev.icerock.moko.resources.FileResource
import dev.icerock.moko.resources.FontResource
import dev.icerock.moko.resources.ImageResource
import dev.icerock.moko.resources.PluralsResource
import dev.icerock.moko.resources.ResourceContainer
import dev.icerock.moko.resources.StringResource
import java.lang.ClassLoader
import kotlin.String

public actual object MR {
  private val stringsBundle: String = "localization/earthworldwind_mokoBundle"

  private val pluralsBundle: String = "localization/earthworldwind_mokoPluralsBundle"

  public actual object strings : ResourceContainer<StringResource> {
    public override val resourcesClassLoader: ClassLoader = MR::class.java.classLoader
  }

  public actual object plurals : ResourceContainer<PluralsResource> {
    public override val resourcesClassLoader: ClassLoader = MR::class.java.classLoader
  }

  public actual object images : ResourceContainer<ImageResource> {
    public override val resourcesClassLoader: ClassLoader = MR::class.java.classLoader

    public actual val dnb_land_ocean_ice_2012: ImageResource = ImageResource(resourcesClassLoader =
        resourcesClassLoader, filePath = "images/dnb_land_ocean_ice_2012.png")

    public actual val sun_texture: ImageResource = ImageResource(resourcesClassLoader =
        resourcesClassLoader, filePath = "images/sun_texture.png")

    public actual val worldwind_worldtopobathy2004053: ImageResource =
        ImageResource(resourcesClassLoader = resourcesClassLoader, filePath =
        "images/worldwind_worldtopobathy2004053.png")
  }

  public actual object fonts : ResourceContainer<FontResource> {
    public override val resourcesClassLoader: ClassLoader = MR::class.java.classLoader
  }

  public actual object files : ResourceContainer<FileResource> {
    public override val resourcesClassLoader: ClassLoader = MR::class.java.classLoader

    public actual val stars: FileResource = FileResource(resourcesClassLoader =
        resourcesClassLoader, filePath = "files/stars.json")
  }

  public actual object colors : ResourceContainer<ColorResource> {
    public override val resourcesClassLoader: ClassLoader = MR::class.java.classLoader
  }

  public actual object assets : ResourceContainer<AssetResource> {
    public override val resourcesClassLoader: ClassLoader = MR::class.java.classLoader
  }
}
