/*
 * Decompiled with CFR 0.152.
 */
package chisel3.iotesters;

import chisel3.ChiselExecutionFailure;
import chisel3.ChiselExecutionOptions;
import chisel3.ChiselExecutionResult;
import chisel3.ChiselExecutionSuccess;
import chisel3.MultiIOModule;
import chisel3.internal.firrtl.Circuit;
import chisel3.iotesters.Backend;
import chisel3.iotesters.IVLBackend;
import chisel3.iotesters.PeekPokeTester;
import chisel3.iotesters.ReplOptionsManager;
import chisel3.iotesters.TesterOptions;
import chisel3.iotesters.TesterOptionsManager;
import chisel3.iotesters.TesterProcess$;
import chisel3.iotesters.VCSBackend;
import chisel3.iotesters.VSIMBackend;
import chisel3.iotesters.VerilatorBackend;
import chisel3.iotesters.VerilatorBackend$;
import chisel3.iotesters.getTopModule$;
import chisel3.iotesters.setupFirrtlTerpBackend$;
import chisel3.iotesters.setupIVLBackend$;
import chisel3.iotesters.setupTreadleBackend$;
import chisel3.iotesters.setupVCSBackend$;
import chisel3.iotesters.setupVSIMBackend$;
import chisel3.iotesters.setupVerilatorBackend$;
import firrtl.ExecutionOptionsManager;
import firrtl.FirrtlExecutionOptions;
import firrtl.annotations.Annotation;
import firrtl.options.TargetDirAnnotation;
import firrtl.stage.FirrtlCircuitAnnotation;
import firrtl.stage.InfoModeAnnotation;
import firrtl_interpreter.FirrtlRepl$;
import firrtl_interpreter.InterpreterOptionsManager;
import firrtl_interpreter.ReplConfig;
import java.io.File;
import java.io.Serializable;
import logger.LogLevelAnnotation;
import logger.Logger$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.DynamicVariable;

public final class Driver$ {
    public static Driver$ MODULE$;
    private final DynamicVariable<Option<Backend>> backendVar;
    private final DynamicVariable<Option<TesterOptionsManager>> optionsManagerVar;

    static {
        new Driver$();
    }

    private DynamicVariable<Option<Backend>> backendVar() {
        return this.backendVar;
    }

    public Option<Backend> backend() {
        return (Option)this.backendVar().value();
    }

    private DynamicVariable<Option<TesterOptionsManager>> optionsManagerVar() {
        return this.optionsManagerVar;
    }

    public TesterOptionsManager optionsManager() {
        return (TesterOptionsManager)((Option)this.optionsManagerVar().value()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new TesterOptionsManager());
    }

    public <T extends MultiIOModule> boolean execute(Function0<T> dutGenerator, TesterOptionsManager optionsManager, Option<String> firrtlSourceOverride, Function1<T, PeekPokeTester<T>> testerGen) {
        return BoxesRunTime.unboxToBoolean((Object)this.optionsManagerVar().withValue((Object)new Some((Object)optionsManager), (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)Logger$.MODULE$.makeScope((ExecutionOptionsManager)optionsManager, (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2;
            TesterOptions testerOptions;
            String string;
            if (optionsManager.topName().isEmpty()) {
                String string2 = optionsManager.targetDirName();
                String string3 = ".";
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    optionsManager.setTargetDirName("test_run_dir");
                }
                String genClassName = testerGen.getClass().getName();
                String testerName = new StringBuilder(0).append((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])genClassName.split("\\$\\$"))).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(genClassName.hashCode()))).toString();
                optionsManager.setTargetDirName(new StringBuilder(1).append(optionsManager.targetDirName()).append("/").append(testerName).toString());
            }
            if ("firrtl".equals(string = (testerOptions = optionsManager.testerOptions()).backendName())) {
                tuple2 = setupFirrtlTerpBackend$.MODULE$.apply(dutGenerator, optionsManager, firrtlSourceOverride);
            } else if ("treadle".equals(string)) {
                tuple2 = setupTreadleBackend$.MODULE$.apply(dutGenerator, optionsManager);
            } else if ("verilator".equals(string)) {
                tuple2 = setupVerilatorBackend$.MODULE$.apply(dutGenerator, optionsManager, firrtlSourceOverride);
            } else if ("ivl".equals(string)) {
                tuple2 = setupIVLBackend$.MODULE$.apply(dutGenerator, optionsManager);
            } else if ("vcs".equals(string)) {
                tuple2 = setupVCSBackend$.MODULE$.apply(dutGenerator, optionsManager);
            } else if ("vsim".equals(string)) {
                tuple2 = setupVSIMBackend$.MODULE$.apply(dutGenerator, optionsManager);
            } else {
                throw new Exception(new StringBuilder(26).append("Unrecognized backend name ").append(testerOptions.backendName()).toString());
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            MultiIOModule dut = (MultiIOModule)tuple22._1();
            Backend backend = (Backend)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)dut, (Object)backend);
            Tuple2 tuple24 = tuple23;
            MultiIOModule dut2 = (MultiIOModule)tuple24._1();
            Backend backend2 = (Backend)tuple24._2();
            return BoxesRunTime.unboxToBoolean((Object)MODULE$.backendVar().withValue((Object)new Some((Object)backend2), (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                boolean bl;
                try {
                    bl = ((PeekPokeTester)testerGen.apply((Object)dut2)).finish();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    Backend backend = backend2;
                    if (backend instanceof IVLBackend) {
                        IVLBackend iVLBackend = (IVLBackend)backend;
                        TesterProcess$.MODULE$.kill(iVLBackend);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (backend instanceof VCSBackend) {
                        VCSBackend vCSBackend = (VCSBackend)backend;
                        TesterProcess$.MODULE$.kill(vCSBackend);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (backend instanceof VSIMBackend) {
                        VSIMBackend vSIMBackend = (VSIMBackend)backend;
                        TesterProcess$.MODULE$.kill(vSIMBackend);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (backend instanceof VerilatorBackend) {
                        VerilatorBackend verilatorBackend = (VerilatorBackend)backend;
                        TesterProcess$.MODULE$.kill(verilatorBackend);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    throw e;
                }
                return bl;
            }));
        }))));
    }

    public <T extends MultiIOModule> boolean execute(String[] args, Function0<T> dut, Function1<T, PeekPokeTester<T>> testerGen) {
        TesterOptionsManager optionsManager = new TesterOptionsManager();
        boolean bl = optionsManager.parse(args);
        boolean bl2 = bl ? this.execute(dut, optionsManager, this.execute$default$3(), testerGen) : false;
        return bl2;
    }

    public <T extends MultiIOModule> Option<String> execute$default$3() {
        return None$.MODULE$;
    }

    public <T extends MultiIOModule> boolean executeFirrtlRepl(Function0<T> dutGenerator, ReplOptionsManager optionsManager) {
        if (optionsManager.topName().isEmpty()) {
            String string = optionsManager.targetDirName();
            String string2 = ".";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                optionsManager.setTargetDirName("test_run_dir");
            }
            String genClassName = dutGenerator.getClass().getName();
            String testerName = new StringBuilder(0).append((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])genClassName.split("\\$\\$"))).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(genClassName.hashCode()))).toString();
            optionsManager.setTargetDirName(new StringBuilder(1).append(optionsManager.targetDirName()).append("/").append(testerName).toString());
        }
        ChiselExecutionOptions qual$1 = optionsManager.chiselOptions();
        boolean x$1 = false;
        boolean x$2 = qual$1.copy$default$2();
        optionsManager.chiselOptions_$eq(qual$1.copy(x$1, x$2));
        FirrtlExecutionOptions qual$2 = optionsManager.firrtlOptions();
        String x$3 = "low";
        String x$4 = qual$2.copy$default$1();
        String x$5 = qual$2.copy$default$2();
        String x$6 = qual$2.copy$default$4();
        Seq x$7 = qual$2.copy$default$5();
        Option x$8 = qual$2.copy$default$6();
        Seq x$9 = qual$2.copy$default$7();
        List x$10 = qual$2.copy$default$8();
        String x$11 = qual$2.copy$default$9();
        String x$12 = qual$2.copy$default$10();
        boolean x$13 = qual$2.copy$default$11();
        boolean x$14 = qual$2.copy$default$12();
        boolean x$15 = qual$2.copy$default$13();
        List x$16 = qual$2.copy$default$14();
        Option x$17 = qual$2.copy$default$15();
        optionsManager.firrtlOptions_$eq(qual$2.copy(x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17));
        return BoxesRunTime.unboxToBoolean((Object)Logger$.MODULE$.makeScope((ExecutionOptionsManager)optionsManager, (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            ChiselExecutionResult chiselResult = chisel3.Driver$.MODULE$.execute((ExecutionOptionsManager)optionsManager, dutGenerator);
            ChiselExecutionResult chiselExecutionResult = chiselResult;
            if (chiselExecutionResult instanceof ChiselExecutionSuccess) {
                ChiselExecutionSuccess chiselExecutionSuccess = (ChiselExecutionSuccess)chiselExecutionResult;
                String emitted = chiselExecutionSuccess.emitted();
                ReplConfig qual$3 = optionsManager.replConfig();
                String x$18 = emitted;
                String x$19 = qual$3.copy$default$1();
                String x$20 = qual$3.copy$default$2();
                boolean x$21 = qual$3.copy$default$4();
                String x$22 = qual$3.copy$default$5();
                boolean x$23 = qual$3.copy$default$6();
                optionsManager.replConfig_$eq(qual$3.copy(x$19, x$20, x$18, x$21, x$22, x$23));
                FirrtlRepl$.MODULE$.execute((InterpreterOptionsManager)optionsManager);
                bl = true;
            } else if (chiselExecutionResult instanceof ChiselExecutionFailure) {
                Predef$.MODULE$.println((Object)"Failed to compile circuit");
                bl = false;
            } else {
                throw new MatchError((Object)chiselExecutionResult);
            }
            return bl;
        }));
    }

    public <T extends MultiIOModule> boolean executeFirrtlRepl(String[] args, Function0<T> dutGenerator) {
        ReplOptionsManager optionsManager = new ReplOptionsManager();
        return optionsManager.parse(args) ? this.executeFirrtlRepl(dutGenerator, optionsManager) : false;
    }

    public <T extends MultiIOModule> ReplOptionsManager executeFirrtlRepl$default$2() {
        return new ReplOptionsManager();
    }

    public void main(String[] args) {
        this.execute((String[])((Object[])new String[]{"--help"}), null, null);
    }

    public <T extends MultiIOModule> boolean apply(Function0<T> dutGen, String backendType, boolean verbose, long testerSeed, Function1<T, PeekPokeTester<T>> testerGen) {
        TesterOptionsManager optionsManager = new TesterOptionsManager(backendType, verbose, testerSeed){
            {
                TesterOptions qual$1 = this.testerOptions();
                String x$1 = backendType$1;
                boolean x$2 = verbose$1;
                long x$3 = testerSeed$1;
                boolean x$4 = qual$1.copy$default$1();
                boolean x$5 = qual$1.copy$default$2();
                boolean x$6 = qual$1.copy$default$3();
                boolean x$7 = qual$1.copy$default$4();
                int x$8 = qual$1.copy$default$6();
                Seq<String> x$9 = qual$1.copy$default$8();
                Seq<String> x$10 = qual$1.copy$default$9();
                Seq<String> x$11 = qual$1.copy$default$10();
                String x$12 = qual$1.copy$default$11();
                String x$13 = qual$1.copy$default$13();
                Option<File> x$14 = qual$1.copy$default$14();
                Seq<String> x$15 = qual$1.copy$default$15();
                Seq<String> x$16 = qual$1.copy$default$16();
                String x$17 = qual$1.copy$default$17();
                Seq<String> x$18 = qual$1.copy$default$18();
                Seq<String> x$19 = qual$1.copy$default$19();
                Seq<String> x$20 = qual$1.copy$default$20();
                Seq<String> x$21 = qual$1.copy$default$21();
                String x$22 = qual$1.copy$default$22();
                String x$23 = qual$1.copy$default$23();
                String x$24 = qual$1.copy$default$24();
                this.testerOptions_$eq(qual$1.copy(x$4, x$5, x$6, x$7, x$2, x$8, x$3, x$9, x$10, x$11, x$12, x$1, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24));
            }
        };
        return this.execute(dutGen, optionsManager, this.execute$default$3(), testerGen);
    }

    public <T extends MultiIOModule> String apply$default$2() {
        return "firrtl";
    }

    public <T extends MultiIOModule> boolean apply$default$3() {
        return false;
    }

    public <T extends MultiIOModule> long apply$default$4() {
        return System.currentTimeMillis();
    }

    public <T extends MultiIOModule> boolean run(Function0<T> dutGen, Seq<String> cmd, Function1<T, PeekPokeTester<T>> testerGen) {
        Circuit circuit = chisel3.Driver$.MODULE$.elaborate(dutGen);
        MultiIOModule dut = (MultiIOModule)getTopModule$.MODULE$.apply(circuit);
        return BoxesRunTime.unboxToBoolean((Object)this.backendVar().withValue((Object)new Some((Object)new VerilatorBackend(dut, cmd, VerilatorBackend$.MODULE$.$lessinit$greater$default$3())), (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            try {
                return ((PeekPokeTester)testerGen.apply((Object)dut)).finish();
            }
            catch (Throwable e) {
                Backend b;
                Backend b2;
                Backend b3;
                e.printStackTrace();
                boolean bl = false;
                Some some = null;
                Option<Backend> option = MODULE$.backend();
                if (option instanceof Some) {
                    bl = true;
                    some = (Some)option;
                    Backend b4 = (Backend)some.value();
                    if (b4 instanceof IVLBackend) {
                        IVLBackend iVLBackend = (IVLBackend)b4;
                        TesterProcess$.MODULE$.kill(iVLBackend);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        throw e;
                    }
                }
                if (bl && (b3 = (Backend)some.value()) instanceof VCSBackend) {
                    VCSBackend vCSBackend = (VCSBackend)b3;
                    TesterProcess$.MODULE$.kill(vCSBackend);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    throw e;
                }
                if (bl && (b2 = (Backend)some.value()) instanceof VSIMBackend) {
                    VSIMBackend vSIMBackend = (VSIMBackend)b2;
                    TesterProcess$.MODULE$.kill(vSIMBackend);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    throw e;
                }
                if (bl && (b = (Backend)some.value()) instanceof VerilatorBackend) {
                    VerilatorBackend verilatorBackend = (VerilatorBackend)b;
                    TesterProcess$.MODULE$.kill(verilatorBackend);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    throw e;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                throw e;
            }
        }));
    }

    public <T extends MultiIOModule> boolean run(Function0<T> dutGen, String binary, Seq<String> args, Function1<T, PeekPokeTester<T>> testerGen) {
        String string = binary;
        return this.run(dutGen, (Seq<String>)((Seq)args.toSeq().$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())), testerGen);
    }

    public <T extends MultiIOModule> boolean run(Function0<T> dutGen, File binary, Option<File> waveform, Function1<T, PeekPokeTester<T>> testerGen) {
        Nil$ nil$;
        Option<File> option = waveform;
        if (None$.MODULE$.equals(option)) {
            nil$ = Nil$.MODULE$;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            File f = (File)some.value();
            nil$ = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append("+waveform=").append(f).toString()}));
        } else {
            throw new MatchError(option);
        }
        Nil$ args = nil$;
        String string = binary.toString();
        return this.run(dutGen, (Seq<String>)((Seq)args.toSeq().$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())), testerGen);
    }

    public <T extends MultiIOModule> Option<File> run$default$3() {
        return None$.MODULE$;
    }

    public Seq<Annotation> filterAnnotations(Seq<Annotation> annotations) {
        return (Seq)annotations.filterNot((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Driver$.$anonfun$filterAnnotations$1(x0$1)));
    }

    public static final /* synthetic */ boolean $anonfun$filterAnnotations$1(Annotation x0$1) {
        Annotation annotation = x0$1;
        boolean bl = annotation instanceof TargetDirAnnotation ? true : (annotation instanceof LogLevelAnnotation ? true : (annotation instanceof FirrtlCircuitAnnotation ? true : annotation instanceof InfoModeAnnotation));
        return bl;
    }

    private Driver$() {
        MODULE$ = this;
        this.backendVar = new DynamicVariable((Object)None$.MODULE$);
        this.optionsManagerVar = new DynamicVariable((Object)None$.MODULE$);
    }
}

