/*
 * Decompiled with CFR 0.152.
 */
package chiseltest.legacy.backends.verilator;

import chisel3.Element;
import chisel3.MultiIOModule;
import chisel3.internal.HasId;
import chiseltest.legacy.backends.verilator.getPorts$;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class VerilatorCppHarnessGenerator$ {
    public static VerilatorCppHarnessGenerator$ MODULE$;

    static {
        new VerilatorCppHarnessGenerator$();
    }

    public String codeGen(MultiIOModule dut, String vcdFilePath) {
        StringBuilder codeBuffer = new StringBuilder();
        Tuple2<Seq<Tuple2<Element, String>>, Seq<Tuple2<Element, String>>> tuple2 = getPorts$.MODULE$.apply(dut, "->");
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq inputs = (Seq)tuple2._1();
        Seq outputs = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)inputs, (Object)outputs);
        Tuple2 tuple23 = tuple22;
        Seq inputs2 = (Seq)tuple23._1();
        Seq outputs2 = (Seq)tuple23._2();
        String dutName = dut.name();
        String dutApiClassName = new java.lang.StringBuilder(6).append(dutName).append("_api_t").toString();
        String dutVerilatorClassName = new java.lang.StringBuilder(1).append("V").append(dutName).toString();
        codeBuffer.append(new java.lang.StringBuilder(450).append("\n#include \"").append(dutVerilatorClassName).append(".h\"\n#include \"verilated.h\"\n#include \"veri_api.h\"\n#if VM_TRACE\n#include \"verilated_vcd_c.h\"\n#endif\n#include <iostream>\nclass ").append(dutApiClassName).append(": public sim_api_t<VerilatorDataWrapper*> {\n    public:\n    ").append(dutApiClassName).append("(").append(dutVerilatorClassName).append("* _dut) {\n        dut = _dut;\n        main_time = 0L;\n        is_exit = false;\n#if VM_TRACE\n        tfp = NULL;\n#endif\n    }\n    void init_sim_data() {\n        sim_data.inputs.clear();\n        sim_data.outputs.clear();\n        sim_data.signals.clear();\n\n").toString());
        inputs2.toList().foreach((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            VerilatorCppHarnessGenerator$.$anonfun$codeGen$1(dutName, codeBuffer, x0$1);
            return BoxedUnit.UNIT;
        });
        outputs2.toList().foreach((Function1 & java.io.Serializable & Serializable)x0$2 -> {
            VerilatorCppHarnessGenerator$.$anonfun$codeGen$2(dutName, codeBuffer, x0$2);
            return BoxedUnit.UNIT;
        });
        VerilatorCppHarnessGenerator$.pushBack$1("signals", "dut->reset", BigInt$.MODULE$.int2bigInt(1), codeBuffer);
        codeBuffer.append(new java.lang.StringBuilder(2929).append("        sim_data.signal_map[\"").append(((HasId)dut.reset()).pathName()).append("\"] = 0;\n    }\n#if VM_TRACE\n     void init_dump(VerilatedVcdC* _tfp) { tfp = _tfp; }\n#endif\n    inline bool exit() { return is_exit; }\n\n    // required for sc_time_stamp()\n    virtual inline double get_time_stamp() {\n        return main_time;\n    }\n\n    private:\n    ").append(dutVerilatorClassName).append("* dut;\n    bool is_exit;\n    vluint64_t main_time;\n#if VM_TRACE\n    VerilatedVcdC* tfp;\n#endif\n    virtual inline size_t put_value(VerilatorDataWrapper* &sig, uint64_t* data, bool force=false) {\n        return sig->put_value(data);\n    }\n    virtual inline size_t get_value(VerilatorDataWrapper* &sig, uint64_t* data) {\n        return sig->get_value(data);\n    }\n    virtual inline size_t get_chunk(VerilatorDataWrapper* &sig) {\n        return sig->get_num_words();\n    }\n    virtual inline void reset() {\n        dut->reset = 1;\n        step();\n    }\n    virtual inline void start() {\n        dut->reset = 0;\n    }\n    virtual inline void finish() {\n        dut->eval();\n        is_exit = true;\n    }\n    virtual inline void step() {\n        dut->clock = 0;\n        dut->eval();\n#if VM_TRACE\n        if (tfp) tfp->dump(main_time);\n#endif\n        main_time++;\n        dut->clock = 1;\n        dut->eval();\n#if VM_TRACE\n        if (tfp) tfp->dump(main_time);\n#endif\n        main_time++;\n    }\n    virtual inline void update() {\n        // This seems to force a full eval of circuit, so registers with alternate clocks are update correctly\n        dut->eval();\n        // This was the original call, did not refresh registers when some  other clock transitioned\n        // dut->_eval_settle(dut->__VlSymsp);\n    }\n};\n\n// The following isn't strictly required unless we emit (possibly indirectly) something\n// requiring a time-stamp (such as an assert).\nstatic ").append(dutApiClassName).append(" * _Top_api;\ndouble sc_time_stamp () { return _Top_api->get_time_stamp(); }\n\n// Override Verilator definition so first $finish ends simulation\n// Note: VL_USER_FINISH needs to be defined when compiling Verilator code\nvoid vl_finish(const char* filename, int linenum, const char* hier) {\n  Verilated::flushCall();\n  exit(0);\n}\n\nint main(int argc, char **argv, char **env) {\n    Verilated::commandArgs(argc, argv);\n    ").append(dutVerilatorClassName).append("* top = new ").append(dutVerilatorClassName).append(";\n    std::string vcdfile = \"").append(vcdFilePath).append("\";\n    std::vector<std::string> args(argv+1, argv+argc);\n    std::vector<std::string>::const_iterator it;\n    for (it = args.begin() ; it != args.end() ; it++) {\n        if (it->find(\"+waveform=\") == 0) vcdfile = it->c_str()+10;\n    }\n#if VM_TRACE\n    Verilated::traceEverOn(true);\n    VL_PRINTF(\"Enabling waves..\");\n    VerilatedVcdC* tfp = new VerilatedVcdC;\n    top->trace(tfp, 99);\n    tfp->open(vcdfile.c_str());\n#endif\n    ").append(dutApiClassName).append(" api(top);\n    _Top_api = &api; /* required for sc_time_stamp() */\n    api.init_sim_data();\n    api.init_channels();\n#if VM_TRACE\n    api.init_dump(tfp);\n#endif\n    while(!api.exit()) api.tick();\n#if VM_TRACE\n    if (tfp) tfp->close();\n    delete tfp;\n#endif\n    delete top;\n    exit(0);\n}\n").toString());
        return codeBuffer.toString();
    }

    private static final void pushBack$1(String vector, String pathName, BigInt width, StringBuilder codeBuffer$1) {
        if (!BoxesRunTime.equalsNumObject((Number)width, (Object)BoxesRunTime.boxToInteger((int)0))) {
            if (width.$less$eq((Object)BigInt$.MODULE$.int2bigInt(8))) {
                codeBuffer$1.append(new java.lang.StringBuilder(54).append("        sim_data.").append(vector).append(".push_back(new VerilatorCData(&(").append(pathName).append(")));\n").toString());
            } else if (width.$less$eq((Object)BigInt$.MODULE$.int2bigInt(16))) {
                codeBuffer$1.append(new java.lang.StringBuilder(54).append("        sim_data.").append(vector).append(".push_back(new VerilatorSData(&(").append(pathName).append(")));\n").toString());
            } else if (width.$less$eq((Object)BigInt$.MODULE$.int2bigInt(32))) {
                codeBuffer$1.append(new java.lang.StringBuilder(54).append("        sim_data.").append(vector).append(".push_back(new VerilatorIData(&(").append(pathName).append(")));\n").toString());
            } else if (width.$less$eq((Object)BigInt$.MODULE$.int2bigInt(64))) {
                codeBuffer$1.append(new java.lang.StringBuilder(54).append("        sim_data.").append(vector).append(".push_back(new VerilatorQData(&(").append(pathName).append(")));\n").toString());
            } else {
                BigInt numWords = width.$minus(BigInt$.MODULE$.int2bigInt(1)).$div(BigInt$.MODULE$.int2bigInt(32)).$plus(BigInt$.MODULE$.int2bigInt(1));
                codeBuffer$1.append(new java.lang.StringBuilder(53).append("        sim_data.").append(vector).append(".push_back(new VerilatorWData(").append(pathName).append(", ").append(numWords).append("));\n").toString());
            }
        }
    }

    public static final /* synthetic */ void $anonfun$codeGen$1(String dutName$1, StringBuilder codeBuffer$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Element node = (Element)tuple2._1();
        String name = (String)tuple2._2();
        VerilatorCppHarnessGenerator$.pushBack$1("inputs", name.replaceFirst(dutName$1, "dut"), BigInt$.MODULE$.int2bigInt(node.getWidth()), codeBuffer$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$codeGen$2(String dutName$1, StringBuilder codeBuffer$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Element node = (Element)tuple2._1();
        String name = (String)tuple2._2();
        VerilatorCppHarnessGenerator$.pushBack$1("outputs", name.replaceFirst(dutName$1, "dut"), BigInt$.MODULE$.int2bigInt(node.getWidth()), codeBuffer$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private VerilatorCppHarnessGenerator$() {
        MODULE$ = this;
    }
}

