/*
 * Decompiled with CFR 0.152.
 */
package firrtl_interpreter;

import firrtl.ir.Direction;
import firrtl_interpreter.CircuitState$;
import firrtl_interpreter.Concrete;
import firrtl_interpreter.DependencyGraph;
import firrtl_interpreter.InterpreterException;
import firrtl_interpreter.InterpreterException$;
import firrtl_interpreter.Memory;
import firrtl_interpreter.Memory$;
import firrtl_interpreter.MonitorManager;
import firrtl_interpreter.vcd.VCD;
import firrtl_interpreter.vcd.VCD$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r\u0005r!\u0002,X\u0011\u0003Qf!\u0002/X\u0011\u0003i\u0006\"B4\u0002\t\u0003A\u0007\"B5\u0002\t\u0003Q\u0007b\u0002Bk\u0003\u0011\u0005!q\u001b\u0005\b\u00057\fA\u0011\u0001Bo\u0011!I\u0017!!A\u0005\u0002\nU\b\"CB\u0002\u0003E\u0005I\u0011\u0001BO\u0011%\u0019)!AA\u0001\n\u0003\u001b9\u0001C\u0005\u0004\u0016\u0005\t\n\u0011\"\u0001\u0003\u001e\"I1qC\u0001\u0002\u0002\u0013%1\u0011\u0004\u0004\u00059^\u0003E\u000e\u0003\u0005q\u0017\tU\r\u0011\"\u0001r\u0011%\t\tb\u0003B\tB\u0003%!\u000fC\u0005\u0002\u0014-\u0011)\u001a!C\u0001c\"I\u0011QC\u0006\u0003\u0012\u0003\u0006IA\u001d\u0005\n\u0003/Y!Q3A\u0005\u0002ED\u0011\"!\u0007\f\u0005#\u0005\u000b\u0011\u0002:\t\u0015\u0005m1B!f\u0001\n\u0003\ti\u0002\u0003\u0006\u0002(-\u0011\t\u0012)A\u0005\u0003?A!\"!\u000b\f\u0005+\u0007I\u0011AA\u0016\u0011)\t\u0019d\u0003B\tB\u0003%\u0011Q\u0006\u0005\u000b\u0003kY!Q3A\u0005\u0002\u0005]\u0002BCA#\u0017\tE\t\u0015!\u0003\u0002:!1qm\u0003C\u0001\u0003\u000fB\u0011\"!\u0016\f\u0005\u0004%\t!a\u0016\t\u0011\u0005}3\u0002)A\u0005\u00033B\u0011\"!\u0019\f\u0005\u0004%\t!a\u0016\t\u0011\u0005\r4\u0002)A\u0005\u00033B\u0011\"!\u001a\f\u0005\u0004%\t!a\u000b\t\u0011\u0005\u001d4\u0002)A\u0005\u0003[A\u0011\"!\u001b\f\u0001\u0004%\t!a\u0016\t\u0013\u0005-4\u00021A\u0005\u0002\u00055\u0004\u0002CA=\u0017\u0001\u0006K!!\u0017\t\u0013\u0005m4\u00021A\u0005\u0002\u0005u\u0004\"CAC\u0017\u0001\u0007I\u0011AAD\u0011!\tYi\u0003Q!\n\u0005}\u0004\"CAG\u0017\u0001\u0007I\u0011AAH\u0011%\t9j\u0003a\u0001\n\u0003\tI\n\u0003\u0005\u0002\u001e.\u0001\u000b\u0015BAI\u0011%\tyj\u0003a\u0001\n\u0003\ty\tC\u0005\u0002\".\u0001\r\u0011\"\u0001\u0002$\"A\u0011qU\u0006!B\u0013\t\t\nC\u0005\u0002*.\u0001\r\u0011\"\u0001\u0002,\"I\u00111X\u0006A\u0002\u0013\u0005\u0011Q\u0018\u0005\t\u0003\u0003\\\u0001\u0015)\u0003\u0002.\"I\u00111Y\u0006A\u0002\u0013\u0005\u0011Q\u0019\u0005\n\u0003+\\\u0001\u0019!C\u0001\u0003/D\u0001\"a7\fA\u0003&\u0011q\u0019\u0005\b\u0003;\\A\u0011IAp\u0011\u001d\t\to\u0003C\u0001\u0003GD\u0011\"a?\f#\u0003%\t!!@\t\u0013\tM1\"%A\u0005\u0002\tU\u0001b\u0002B\r\u0017\u0011\u0005!1\u0004\u0005\b\u0005;YA\u0011\u0001B\u000e\u0011\u001d\u0011yb\u0003C\u0001\u00057AqA!\t\f\t\u0003\u0011Y\u0002C\u0004\u0003$-!\tAa\u0007\t\u000f\t\u00152\u0002\"\u0001\u0003(!9!\u0011G\u0006\u0005\u0002\tm\u0001b\u0002B\u001a\u0017\u0011\u0005!1\u0004\u0005\b\u0005kYA\u0011\u0001B\u001c\u0011%\u0011\u0019eCI\u0001\n\u0003\u0011)\u0002C\u0004\u0003F-!\tAa\u0012\t\u000f\t53\u0002\"\u0001\u0003P!9!1K\u0006\u0005\u0002\tU\u0003b\u0002B-\u0017\u0011\u0005!1\f\u0005\b\u0005?ZA\u0011\u0001B1\u0011\u001d\u0011)g\u0003C\u0001\u0005OBqAa\u001b\f\t\u0003\u0011i\u0007C\u0005\u0003t-\t\n\u0011\"\u0001\u0003\u0016!I!QO\u0006\u0002\u0002\u0013\u0005!q\u000f\u0005\n\u0005\u000b[\u0011\u0013!C\u0001\u0005\u000fC\u0011Ba#\f#\u0003%\tAa\"\t\u0013\t55\"%A\u0005\u0002\t\u001d\u0005\"\u0003BH\u0017E\u0005I\u0011\u0001BI\u0011%\u0011)jCI\u0001\n\u0003\u00119\nC\u0005\u0003\u001c.\t\n\u0011\"\u0001\u0003\u001e\"I!\u0011U\u0006\u0002\u0002\u0013\u0005\u0013Q\u0019\u0005\n\u0005G[\u0011\u0011!C\u0001\u0003{B\u0011B!*\f\u0003\u0003%\tAa*\t\u0013\tE6\"!A\u0005B\tM\u0006\"\u0003B_\u0017\u0005\u0005I\u0011\u0001B`\u0011%\u0011\u0019mCA\u0001\n\u0003\u0012)\rC\u0005\u0003H.\t\t\u0011\"\u0011\u0003J\"I!1Z\u0006\u0002\u0002\u0013\u0005#QZ\u0001\r\u0007&\u00148-^5u'R\fG/\u001a\u0006\u00021\u0006\u0011b-\u001b:si2|\u0016N\u001c;feB\u0014X\r^3s\u0007\u0001\u0001\"aW\u0001\u000e\u0003]\u0013AbQ5sGVLGo\u0015;bi\u0016\u001c2!\u00010e!\ty&-D\u0001a\u0015\u0005\t\u0017!B:dC2\f\u0017BA2a\u0005\u0019\te.\u001f*fMB\u0011q,Z\u0005\u0003M\u0002\u0014AbU3sS\u0006d\u0017N_1cY\u0016\fa\u0001P5oSRtD#\u0001.\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b-\u0014\tNa5\u0011\u0005m[1\u0003B\u0006_[\u0012\u0004\"a\u00188\n\u0005=\u0004'a\u0002)s_\u0012,8\r^\u0001\u000bS:\u0004X\u000f\u001e)peR\u001cX#\u0001:\u0011\u000bMD(0a\u0003\u000e\u0003QT!!\u001e<\u0002\u000f5,H/\u00192mK*\u0011q\u000fY\u0001\u000bG>dG.Z2uS>t\u0017BA=u\u0005\ri\u0015\r\u001d\t\u0004w\u0006\u0015ab\u0001?\u0002\u0002A\u0011Q\u0010Y\u0007\u0002}*\u0011q0W\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\r\u0001-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000f\tIA\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0007\u0001\u0007cA.\u0002\u000e%\u0019\u0011qB,\u0003\u0011\r{gn\u0019:fi\u0016\f1\"\u001b8qkR\u0004vN\u001d;tA\u0005Yq.\u001e;qkR\u0004vN\u001d;t\u00031yW\u000f\u001e9viB{'\u000f^:!\u0003%\u0011XmZ5ti\u0016\u00148/\u0001\u0006sK\u001eL7\u000f^3sg\u0002\n\u0001\"\\3n_JLWm]\u000b\u0003\u0003?\u0001Ra\u001d={\u0003C\u00012aWA\u0012\u0013\r\t)c\u0016\u0002\u0007\u001b\u0016lwN]=\u0002\u00135,Wn\u001c:jKN\u0004\u0013A\u0003<bY&$g*Y7fgV\u0011\u0011Q\u0006\t\u0005g\u0006=\"0C\u0002\u00022Q\u0014q\u0001S1tQN+G/A\u0006wC2LGMT1nKN\u0004\u0013!E7p]&$xN]'b]\u0006<WM](qiV\u0011\u0011\u0011\b\t\u0006?\u0006m\u0012qH\u0005\u0004\u0003{\u0001'AB(qi&|g\u000eE\u0002\\\u0003\u0003J1!a\u0011X\u00059iuN\\5u_Jl\u0015M\\1hKJ\f!#\\8oSR|'/T1oC\u001e,'o\u00149uAQi1.!\u0013\u0002L\u00055\u0013qJA)\u0003'BQ\u0001\u001d\rA\u0002IDa!a\u0005\u0019\u0001\u0004\u0011\bBBA\f1\u0001\u0007!\u000fC\u0004\u0002\u001ca\u0001\r!a\b\t\u000f\u0005%\u0002\u00041\u0001\u0002.!I\u0011Q\u0007\r\u0011\u0002\u0003\u0007\u0011\u0011H\u0001\u000e]\u0016DHOU3hSN$XM]:\u0016\u0005\u0005e\u0003CB:\u0002\\i\fY!C\u0002\u0002^Q\u0014q\u0001S1tQ6\u000b\u0007/\u0001\boKb$(+Z4jgR,'o\u001d\u0011\u0002\u0011\u0015\u0004\b.Z7fe\u0006\f\u0011\"\u001a9iK6,'/\u0019\u0011\u0002\u0015ID7oT;uaV$8/A\u0006sQN|U\u000f\u001e9viN\u0004\u0013a\u00058b[\u0016$vnQ8oGJ,G/\u001a,bYV,\u0017a\u00068b[\u0016$vnQ8oGJ,G/\u001a,bYV,w\fJ3r)\u0011\ty'!\u001e\u0011\u0007}\u000b\t(C\u0002\u0002t\u0001\u0014A!\u00168ji\"I\u0011q\u000f\u0011\u0002\u0002\u0003\u0007\u0011\u0011L\u0001\u0004q\u0012\n\u0014\u0001\u00068b[\u0016$vnQ8oGJ,G/\u001a,bYV,\u0007%\u0001\u0007ti\u0006$XmQ8v]R,'/\u0006\u0002\u0002\u0000A\u0019q,!!\n\u0007\u0005\r\u0005MA\u0002J]R\f\u0001c\u001d;bi\u0016\u001cu.\u001e8uKJ|F%Z9\u0015\t\u0005=\u0014\u0011\u0012\u0005\n\u0003o\u001a\u0013\u0011!a\u0001\u0003\u007f\nQb\u001d;bi\u0016\u001cu.\u001e8uKJ\u0004\u0013aB5t'R\fG.Z\u000b\u0003\u0003#\u00032aXAJ\u0013\r\t)\n\u0019\u0002\b\u0005>|G.Z1o\u0003-I7o\u0015;bY\u0016|F%Z9\u0015\t\u0005=\u00141\u0014\u0005\n\u0003o2\u0013\u0011!a\u0001\u0003#\u000b\u0001\"[:Ti\u0006dW\rI\u0001\nG2|7m\u001b%jO\"\fQb\u00197pG.D\u0015n\u001a5`I\u0015\fH\u0003BA8\u0003KC\u0011\"a\u001e*\u0003\u0003\u0005\r!!%\u0002\u0015\rdwnY6IS\u001eD\u0007%A\bwG\u0012dunZ4fe>\u0003H/[8o+\t\ti\u000bE\u0003`\u0003w\ty\u000b\u0005\u0003\u00022\u0006]VBAAZ\u0015\r\t)lV\u0001\u0004m\u000e$\u0017\u0002BA]\u0003g\u00131AV\"E\u0003M18\r\u001a'pO\u001e,'o\u00149uS>tw\fJ3r)\u0011\ty'a0\t\u0013\u0005]D&!AA\u0002\u00055\u0016\u0001\u0005<dI2{wmZ3s\u001fB$\u0018n\u001c8!\u0003E18\rZ(viB,HOR5mK:\u000bW.Z\u000b\u0003\u0003\u000f\u0004B!!3\u0002T6\u0011\u00111\u001a\u0006\u0005\u0003\u001b\fy-\u0001\u0003mC:<'BAAi\u0003\u0011Q\u0017M^1\n\t\u0005\u001d\u00111Z\u0001\u0016m\u000e$w*\u001e;qkR4\u0015\u000e\\3OC6,w\fJ3r)\u0011\ty'!7\t\u0013\u0005]t&!AA\u0002\u0005\u001d\u0017A\u0005<dI>+H\u000f];u\r&dWMT1nK\u0002\nQa\u00197p]\u0016$\u0012a[\u0001\u000e[\u0006\\WMV\"E\u0019><w-\u001a:\u0015\u0015\u0005=\u0014Q]Ax\u0003g\f9\u0010C\u0004\u0002hJ\u0002\r!!;\u0002\u001f\u0011,\u0007/\u001a8eK:\u001c\u0017p\u0012:ba\"\u00042aWAv\u0013\r\tio\u0016\u0002\u0010\t\u0016\u0004XM\u001c3f]\u000eLxI]1qQ\"1\u0011\u0011\u001f\u001aA\u0002-\fAbY5sGVLGo\u0015;bi\u0016D\u0001\"!>3!\u0003\u0005\rA_\u0001\tM&dWMT1nK\"I\u0011\u0011 \u001a\u0011\u0002\u0003\u0007\u0011\u0011S\u0001\u0010g\"|w/\u00168eKJ\u001c8m\u001c:fI\u00069R.Y6f-\u000e#Ej\\4hKJ$C-\u001a4bk2$HeM\u000b\u0003\u0003\u007fT3A\u001fB\u0001W\t\u0011\u0019\u0001\u0005\u0003\u0003\u0006\t=QB\u0001B\u0004\u0015\u0011\u0011IAa\u0003\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0007A\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tE!q\u0001\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aF7bW\u001646\t\u0012'pO\u001e,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u00119B\u000b\u0003\u0002\u0012\n\u0005\u0011\u0001C<sSR,gk\u0011#\u0015\u0005\u0005=\u0014A\u00033jg\u0006\u0014G.\u001a,D\t\u0006q\u0002O]3qCJ,gi\u001c:EKB,g\u000eZ3oGf\u0014Vm]8mkRLwN\\\u0001\u000em\u000e$'+Y5tK\u000ecwnY6\u0002\u001bY\u001cG\rT8xKJ\u001cEn\\2l\u0003I18\rZ,je\u0016\u001c\u0005.\u00198hK\u0012<\u0018N]3\u0015\r\u0005=$\u0011\u0006B\u0017\u0011\u0019\u0011YC\u000fa\u0001u\u0006\u00191.Z=\t\u000f\t=\"\b1\u0001\u0002\f\u0005A1m\u001c8de\u0016$X-A\u0003ds\u000edW-A\u0007ds\u000edW-T3n_JLWm]\u0001\tg\u0016$h+\u00197vKRA\u00111\u0002B\u001d\u0005w\u0011y\u0004\u0003\u0004\u0003,u\u0002\rA\u001f\u0005\b\u0005{i\u0004\u0019AA\u0006\u00035\u0019wN\\2sKR,g+\u00197vK\"I!\u0011I\u001f\u0011\u0002\u0003\u0007\u0011\u0011S\u0001\re\u0016<\u0017n\u001d;feB{7.Z\u0001\u0013g\u0016$h+\u00197vK\u0012\"WMZ1vYR$3'\u0001\u0005hKR4\u0016\r\\;f)\u0011\u0011IEa\u0013\u0011\u000b}\u000bY$a\u0003\t\r\t-r\b1\u0001{\u0003\u001dI7/\u00138qkR$B!!%\u0003R!1!1\u0006!A\u0002i\f\u0001\"[:PkR\u0004X\u000f\u001e\u000b\u0005\u0003#\u00139\u0006\u0003\u0004\u0003,\u0005\u0003\rA_\u0001\u000bSN\u0014VmZ5ti\u0016\u0014H\u0003BAI\u0005;BaAa\u000bC\u0001\u0004Q\u0018AC5t\u000bBDW-\\3sCR!\u0011\u0011\u0013B2\u0011\u0019\u0011Yc\u0011a\u0001u\u0006A\u0011n]'f[>\u0014\u0018\u0010\u0006\u0003\u0002\u0012\n%\u0004B\u0002B\u0016\t\u0002\u0007!0\u0001\u0007qe\u0016$H/_*ue&tw\rF\u0002{\u0005_B\u0011B!\u001dF!\u0003\u0005\r!!%\u0002\u000b\u0011,gn]3\u0002-A\u0014X\r\u001e;z'R\u0014\u0018N\\4%I\u00164\u0017-\u001e7uIE\nAaY8qsRi1N!\u001f\u0003|\tu$q\u0010BA\u0005\u0007Cq\u0001]$\u0011\u0002\u0003\u0007!\u000f\u0003\u0005\u0002\u0014\u001d\u0003\n\u00111\u0001s\u0011!\t9b\u0012I\u0001\u0002\u0004\u0011\b\"CA\u000e\u000fB\u0005\t\u0019AA\u0010\u0011%\tIc\u0012I\u0001\u0002\u0004\ti\u0003C\u0005\u00026\u001d\u0003\n\u00111\u0001\u0002:\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001BEU\r\u0011(\u0011A\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0003\u0014*\"\u0011q\u0004B\u0001\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU*\"A!'+\t\u00055\"\u0011A\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011yJ\u000b\u0003\u0002:\t\u0005\u0011!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\t%&q\u0016\t\u0004?\n-\u0016b\u0001BWA\n\u0019\u0011I\\=\t\u0013\u0005]\u0004+!AA\u0002\u0005}\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\tU\u0006C\u0002B\\\u0005s\u0013I+D\u0001w\u0013\r\u0011YL\u001e\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u0012\n\u0005\u0007\"CA<%\u0006\u0005\t\u0019\u0001BU\u0003!A\u0017m\u001d5D_\u0012,GCAA@\u0003!!xn\u0015;sS:<GCAAd\u0003\u0019)\u0017/^1mgR!\u0011\u0011\u0013Bh\u0011%\t9(VA\u0001\u0002\u0004\u0011I\u000bC\u0004\u0002h\u000e\u0001\r!!;\t\u000f\u0005U2\u00011\u0001\u0002:\u0005qR.Y6f%\u0016<\u0017n\u001d;feR{7i\u001c8de\u0016$XMV1mk\u0016l\u0015\r\u001d\u000b\u0004e\ne\u0007bBAt\t\u0001\u0007\u0011\u0011^\u0001\u001b[\u0006\\W\rU8siR{7i\u001c8de\u0016$XMV1mk\u0016l\u0015\r\u001d\u000b\u0006e\n}'\u0011\u001d\u0005\b\u0003O,\u0001\u0019AAu\u0011\u001d\u0011\u0019/\u0002a\u0001\u0005K\f\u0011\u0002Z5sK\u000e$\u0018n\u001c8\u0011\t\t\u001d(\u0011_\u0007\u0003\u0005STAAa;\u0003n\u0006\u0011\u0011N\u001d\u0006\u0003\u0005_\faAZ5seRd\u0017\u0002\u0002Bz\u0005S\u0014\u0011\u0002R5sK\u000e$\u0018n\u001c8\u0015\u001b-\u00149P!?\u0003|\nu(q`B\u0001\u0011\u0015\u0001h\u00011\u0001s\u0011\u0019\t\u0019B\u0002a\u0001e\"1\u0011q\u0003\u0004A\u0002IDq!a\u0007\u0007\u0001\u0004\ty\u0002C\u0004\u0002*\u0019\u0001\r!!\f\t\u0013\u0005Ub\u0001%AA\u0002\u0005e\u0012aD1qa2LH\u0005Z3gCVdG\u000f\n\u001c\u0002\u000fUt\u0017\r\u001d9msR!1\u0011BB\t!\u0015y\u00161HB\u0006!1y6Q\u0002:se\u0006}\u0011QFA\u001d\u0013\r\u0019y\u0001\u0019\u0002\u0007)V\u0004H.\u001a\u001c\t\u0011\rM\u0001\"!AA\u0002-\f1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%m\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0019Y\u0002\u0005\u0003\u0002J\u000eu\u0011\u0002BB\u0010\u0003\u0017\u0014aa\u00142kK\u000e$\b")
public class CircuitState
implements Product,
scala.Serializable {
    private final Map<String, Concrete> inputPorts;
    private final Map<String, Concrete> outputPorts;
    private final Map<String, Concrete> registers;
    private final Map<String, Memory> memories;
    private final HashSet<String> validNames;
    private final Option<MonitorManager> monitorManagerOpt;
    private final HashMap<String, Concrete> nextRegisters;
    private final HashMap<String, Concrete> ephemera;
    private final HashSet<String> rhsOutputs;
    private HashMap<String, Concrete> nameToConcreteValue;
    private int stateCounter;
    private boolean isStale;
    private boolean clockHigh;
    private Option<VCD> vcdLoggerOption;
    private String vcdOutputFileName;

    public static Option<MonitorManager> $lessinit$greater$default$6() {
        return CircuitState$.MODULE$.$lessinit$greater$default$6();
    }

    public static Option<Tuple6<Map<String, Concrete>, Map<String, Concrete>, Map<String, Concrete>, Map<String, Memory>, HashSet<String>, Option<MonitorManager>>> unapply(CircuitState circuitState) {
        return CircuitState$.MODULE$.unapply(circuitState);
    }

    public static Option<MonitorManager> apply$default$6() {
        return CircuitState$.MODULE$.apply$default$6();
    }

    public static CircuitState apply(Map<String, Concrete> map, Map<String, Concrete> map2, Map<String, Concrete> map3, Map<String, Memory> map4, HashSet<String> hashSet, Option<MonitorManager> option) {
        return CircuitState$.MODULE$.apply(map, map2, map3, map4, hashSet, option);
    }

    public static Map<String, Concrete> makePortToConcreteValueMap(DependencyGraph dependencyGraph, Direction direction) {
        return CircuitState$.MODULE$.makePortToConcreteValueMap(dependencyGraph, direction);
    }

    public static Map<String, Concrete> makeRegisterToConcreteValueMap(DependencyGraph dependencyGraph) {
        return CircuitState$.MODULE$.makeRegisterToConcreteValueMap(dependencyGraph);
    }

    public static CircuitState apply(DependencyGraph dependencyGraph, Option<MonitorManager> option) {
        return CircuitState$.MODULE$.apply(dependencyGraph, option);
    }

    public Map<String, Concrete> inputPorts() {
        return this.inputPorts;
    }

    public Map<String, Concrete> outputPorts() {
        return this.outputPorts;
    }

    public Map<String, Concrete> registers() {
        return this.registers;
    }

    public Map<String, Memory> memories() {
        return this.memories;
    }

    public HashSet<String> validNames() {
        return this.validNames;
    }

    public Option<MonitorManager> monitorManagerOpt() {
        return this.monitorManagerOpt;
    }

    public HashMap<String, Concrete> nextRegisters() {
        return this.nextRegisters;
    }

    public HashMap<String, Concrete> ephemera() {
        return this.ephemera;
    }

    public HashSet<String> rhsOutputs() {
        return this.rhsOutputs;
    }

    public HashMap<String, Concrete> nameToConcreteValue() {
        return this.nameToConcreteValue;
    }

    public void nameToConcreteValue_$eq(HashMap<String, Concrete> x$1) {
        this.nameToConcreteValue = x$1;
    }

    public int stateCounter() {
        return this.stateCounter;
    }

    public void stateCounter_$eq(int x$1) {
        this.stateCounter = x$1;
    }

    public boolean isStale() {
        return this.isStale;
    }

    public void isStale_$eq(boolean x$1) {
        this.isStale = x$1;
    }

    public boolean clockHigh() {
        return this.clockHigh;
    }

    public void clockHigh_$eq(boolean x$1) {
        this.clockHigh = x$1;
    }

    public Option<VCD> vcdLoggerOption() {
        return this.vcdLoggerOption;
    }

    public void vcdLoggerOption_$eq(Option<VCD> x$1) {
        this.vcdLoggerOption = x$1;
    }

    public String vcdOutputFileName() {
        return this.vcdOutputFileName;
    }

    public void vcdOutputFileName_$eq(String x$1) {
        this.vcdOutputFileName = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public CircuitState clone() {
        void var1_1;
        CircuitState newState = new CircuitState((Map<String, Concrete>)((MapLike)Map$.MODULE$.apply((Seq)Nil$.MODULE$)).$plus$plus(this.inputPorts()), (Map<String, Concrete>)((MapLike)Map$.MODULE$.apply((Seq)Nil$.MODULE$)).$plus$plus(this.outputPorts()), (Map<String, Concrete>)((MapLike)Map$.MODULE$.apply((Seq)Nil$.MODULE$)).$plus$plus(this.registers()), (Map<String, Memory>)((MapLike)Map$.MODULE$.apply((Seq)Nil$.MODULE$)).$plus$plus(this.memories()), this.validNames(), CircuitState$.MODULE$.apply$default$6());
        newState.nextRegisters().$plus$plus$eq(this.nextRegisters());
        newState.ephemera().$plus$plus$eq(this.ephemera());
        newState.rhsOutputs().$plus$plus$eq(this.rhsOutputs());
        newState.stateCounter_$eq(this.stateCounter());
        newState.isStale_$eq(this.isStale());
        newState.clockHigh_$eq(this.clockHigh());
        return var1_1;
    }

    public void makeVCDLogger(DependencyGraph dependencyGraph, CircuitState circuitState, String fileName, boolean showUnderscored) {
        VCD vcd = VCD$.MODULE$.apply(dependencyGraph.circuit().main(), VCD$.MODULE$.apply$default$2(), VCD$.MODULE$.apply$default$3());
        this.vcdLoggerOption_$eq((Option<VCD>)new Some((Object)vcd));
        this.vcdOutputFileName_$eq(fileName);
        dependencyGraph.instanceNames().keys().foreach((Function1 & Serializable & scala.Serializable)instanceName -> {
            CircuitState.$anonfun$makeVCDLogger$1(dependencyGraph, vcd, instanceName);
            return BoxedUnit.UNIT;
        });
        vcd.timeStamp_$eq(-1L);
        circuitState.nameToConcreteValue().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)CircuitState.$anonfun$makeVCDLogger$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CircuitState.$anonfun$makeVCDLogger$3(vcd, x$2)));
        vcd.timeStamp_$eq(0L);
    }

    public String makeVCDLogger$default$3() {
        return "out.firrtl_interpreter.vcd";
    }

    public boolean makeVCDLogger$default$4() {
        return false;
    }

    public void writeVCD() {
        this.vcdLoggerOption().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.write(this.vcdOutputFileName());
            return BoxedUnit.UNIT;
        });
    }

    public void disableVCD() {
        this.vcdLoggerOption().foreach((Function1 & Serializable & scala.Serializable)vcd -> {
            vcd.write(this.vcdOutputFileName());
            return BoxedUnit.UNIT;
        });
        this.vcdLoggerOption_$eq((Option<VCD>)None$.MODULE$);
        this.vcdOutputFileName_$eq("");
    }

    public void prepareForDependencyResolution() {
        this.nameToConcreteValue_$eq((HashMap<String, Concrete>)((HashMap)HashMap$.MODULE$.apply(this.inputPorts().$plus$plus(this.outputPorts()).$plus$plus(this.registers()).toSeq())));
        this.ephemera().clear();
        this.rhsOutputs().clear();
    }

    public void vcdRaiseClock() {
        block0: {
            if (this.clockHigh()) break block0;
            this.vcdLoggerOption().foreach((Function1 & Serializable & scala.Serializable)vcd -> {
                vcd.raiseClock();
                return BoxedUnit.UNIT;
            });
            this.clockHigh_$eq(true);
        }
    }

    public void vcdLowerClock() {
        block0: {
            if (!this.clockHigh()) break block0;
            this.vcdLoggerOption().foreach((Function1 & Serializable & scala.Serializable)vcd -> {
                vcd.lowerClock();
                return BoxedUnit.UNIT;
            });
            this.clockHigh_$eq(false);
        }
    }

    public void vcdWireChangedwire(String key, Concrete concrete) {
        this.vcdLoggerOption().foreach((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.wireChanged(key, concrete.value(), concrete.width(), concrete.poisoned())));
    }

    public void cycle() {
        this.registers().keys().foreach((Function1 & Serializable & scala.Serializable)key -> {
            CircuitState.$anonfun$cycle$1(this, key);
            return BoxedUnit.UNIT;
        });
        this.cycleMemories();
        this.nameToConcreteValue_$eq((HashMap<String, Concrete>)((HashMap)HashMap$.MODULE$.apply(this.inputPorts().$plus$plus(this.outputPorts()).$plus$plus(this.registers()).toSeq())));
        this.isStale_$eq(true);
        this.stateCounter_$eq(this.stateCounter() + 1);
    }

    public void cycleMemories() {
        this.memories().values().foreach((Function1 & Serializable & scala.Serializable)memory -> {
            memory.cycle();
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Concrete setValue(String key, Concrete concreteValue, boolean registerPoke) {
        this.monitorManagerOpt().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.monitorSetValue(key, concreteValue);
            return BoxedUnit.UNIT;
        });
        if (this.isInput(key)) {
            this.inputPorts().update((Object)key, (Object)concreteValue);
            this.nameToConcreteValue().update((Object)key, (Object)concreteValue);
            this.vcdWireChangedwire(key, concreteValue);
        } else if (this.isOutput(key)) {
            this.outputPorts().update((Object)key, (Object)concreteValue);
            this.nameToConcreteValue().update((Object)key, (Object)concreteValue);
            this.vcdWireChangedwire(key, concreteValue);
        } else if (this.registers().contains((Object)key)) {
            if (registerPoke) {
                this.registers().update((Object)key, (Object)concreteValue);
            } else {
                this.nextRegisters().update((Object)key, (Object)concreteValue);
            }
        } else if (this.isMemory(key)) {
            String string = key;
            Option option = Memory$.MODULE$.KeyPattern().unapplySeq((CharSequence)string);
            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(3) != 0) throw new InterpreterException(new StringBuilder(34).append("Error:failed memory(").append(key).append(").setValue(").append(key).append(", ").append(concreteValue).append(")").toString());
            String memoryName = (String)((LinearSeqOptimized)option.get()).apply(0);
            ((Memory)this.memories().apply((Object)memoryName)).setValue(key, concreteValue);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!this.validNames().contains((Object)key)) throw InterpreterException$.MODULE$.apply(new StringBuilder(54).append("Error: setValue(").append(key).append(", ").append(concreteValue).append(") ").append(key).append(" is not an element of this circuit").toString());
            this.ephemera().update((Object)key, (Object)concreteValue);
            this.nameToConcreteValue().update((Object)key, (Object)concreteValue);
            this.vcdWireChangedwire(key, concreteValue);
        }
        this.isStale_$eq(true);
        return concreteValue;
    }

    public boolean setValue$default$3() {
        return false;
    }

    public Option<Concrete> getValue(String key) {
        Some some;
        Option option = this.nameToConcreteValue().get((Object)key);
        if (option instanceof Some) {
            Some some2 = (Some)option;
            Concrete value = (Concrete)some2.value();
            some = new Some((Object)value);
        } else {
            None$ none$;
            String string = key;
            Option option2 = Memory$.MODULE$.KeyPattern().unapplySeq((CharSequence)string);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(3) == 0) {
                String memoryName = (String)((LinearSeqOptimized)option2.get()).apply(0);
                none$ = this.memories().contains((Object)memoryName) ? new Some((Object)((Memory)this.memories().apply((Object)memoryName)).getValue(key)) : None$.MODULE$;
            } else {
                none$ = None$.MODULE$;
            }
            some = none$;
        }
        return some;
    }

    public boolean isInput(String key) {
        return this.inputPorts().contains((Object)key);
    }

    public boolean isOutput(String key) {
        return this.outputPorts().contains((Object)key);
    }

    public boolean isRegister(String key) {
        return this.registers().contains((Object)key);
    }

    public boolean isEphemera(String key) {
        return !this.isInput(key) && !this.isOutput(key) && !this.isRegister(key);
    }

    public boolean isMemory(String key) {
        String memKey = Memory$.MODULE$.memoryKey(key);
        return this.memories().contains((Object)memKey);
    }

    public String prettyString(boolean dense) {
        Tuple3 tuple3;
        Tuple3 tuple32 = tuple3 = dense ? new Tuple3((Object)": ", (Object)", ", (Object)"") : new Tuple3((Object)":\n  ", (Object)"\n  ", (Object)"");
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        String prefix = (String)tuple3._1();
        String separator = (String)tuple3._2();
        String postfix = (String)tuple3._3();
        Tuple3 tuple33 = new Tuple3((Object)prefix, (Object)separator, (Object)postfix);
        Tuple3 tuple34 = tuple33;
        String prefix2 = (String)tuple34._1();
        String separator2 = (String)tuple34._2();
        String postfix2 = (String)tuple34._3();
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(87).append("\n       |CircuitState ").append(this.stateCounter()).append(" (").append((Object)(this.isStale() ? "STALE" : "FRESH")).append(")\n       |").append(CircuitState.showConcreteValues$1("Inputs", this.inputPorts().toMap(Predef$.MODULE$.$conforms()), prefix2, separator2, postfix2)).append("\n       |").append(CircuitState.showConcreteValues$1("Outputs", this.outputPorts().toMap(Predef$.MODULE$.$conforms()), prefix2, separator2, postfix2)).append("\n       |").append(CircuitState.showConcreteValues$1("Registers      ", this.registers().toMap(Predef$.MODULE$.$conforms()), prefix2, separator2, postfix2)).append("\n       |").append(CircuitState.showConcreteValues$1("FutureRegisters", this.nextRegisters().toMap(Predef$.MODULE$.$conforms()), prefix2, separator2, postfix2)).append("\n       |").append(CircuitState.showConcreteValues$1("Ephemera", this.ephemera().toMap(Predef$.MODULE$.$conforms()), prefix2, separator2, postfix2)).append("\n       |Memories").append(this.memories().values().mkString("\n", "\n  ", "")).toString())).stripMargin();
    }

    public boolean prettyString$default$1() {
        return true;
    }

    public CircuitState copy(Map<String, Concrete> inputPorts, Map<String, Concrete> outputPorts, Map<String, Concrete> registers, Map<String, Memory> memories, HashSet<String> validNames, Option<MonitorManager> monitorManagerOpt) {
        return new CircuitState(inputPorts, outputPorts, registers, memories, validNames, monitorManagerOpt);
    }

    public Map<String, Concrete> copy$default$1() {
        return this.inputPorts();
    }

    public Map<String, Concrete> copy$default$2() {
        return this.outputPorts();
    }

    public Map<String, Concrete> copy$default$3() {
        return this.registers();
    }

    public Map<String, Memory> copy$default$4() {
        return this.memories();
    }

    public HashSet<String> copy$default$5() {
        return this.validNames();
    }

    public Option<MonitorManager> copy$default$6() {
        return this.monitorManagerOpt();
    }

    public String productPrefix() {
        return "CircuitState";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.inputPorts();
                break;
            }
            case 1: {
                object = this.outputPorts();
                break;
            }
            case 2: {
                object = this.registers();
                break;
            }
            case 3: {
                object = this.memories();
                break;
            }
            case 4: {
                object = this.validNames();
                break;
            }
            case 5: {
                object = this.monitorManagerOpt();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CircuitState;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CircuitState)) return false;
        boolean bl = true;
        if (!bl) return false;
        CircuitState circuitState = (CircuitState)x$1;
        Map<String, Concrete> map = this.inputPorts();
        Map<String, Concrete> map2 = circuitState.inputPorts();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Map<String, Concrete> map3 = this.outputPorts();
        Map<String, Concrete> map4 = circuitState.outputPorts();
        if (map3 == null) {
            if (map4 != null) {
                return false;
            }
        } else if (!map3.equals(map4)) return false;
        Map<String, Concrete> map5 = this.registers();
        Map<String, Concrete> map6 = circuitState.registers();
        if (map5 == null) {
            if (map6 != null) {
                return false;
            }
        } else if (!map5.equals(map6)) return false;
        Map<String, Memory> map7 = this.memories();
        Map<String, Memory> map8 = circuitState.memories();
        if (map7 == null) {
            if (map8 != null) {
                return false;
            }
        } else if (!map7.equals(map8)) return false;
        HashSet<String> hashSet = this.validNames();
        HashSet<String> hashSet2 = circuitState.validNames();
        if (hashSet == null) {
            if (hashSet2 != null) {
                return false;
            }
        } else if (!hashSet.equals(hashSet2)) return false;
        Option<MonitorManager> option = this.monitorManagerOpt();
        Option<MonitorManager> option2 = circuitState.monitorManagerOpt();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!circuitState.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$makeVCDLogger$1(DependencyGraph dependencyGraph$2, VCD vcd$1, String instanceName) {
        block0: {
            String string = instanceName;
            String string2 = dependencyGraph$2.circuit().main();
            if (!(string == null ? string2 != null : !string.equals(string2))) break block0;
            vcd$1.scopeRoot().addScope(instanceName);
        }
    }

    public static final /* synthetic */ boolean $anonfun$makeVCDLogger$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$makeVCDLogger$3(VCD vcd$1, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        Concrete concreteValue = (Concrete)tuple2._2();
        boolean bl = vcd$1.wireChanged(name, concreteValue.value(), concreteValue.width(), concreteValue.poisoned());
        return bl;
    }

    public static final /* synthetic */ void $anonfun$cycle$1(CircuitState $this, String key) {
        Concrete nextValue = (Concrete)$this.nextRegisters().apply((Object)key);
        $this.vcdWireChangedwire(key, nextValue);
        $this.registers().update((Object)key, (Object)nextValue);
    }

    private static final String showConcreteValues$1(String msg, scala.collection.immutable.Map m, String prefix$1, String separator$1, String postfix$1) {
        return ((TraversableOnce)((TraversableLike)m.keys().toSeq().sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)key -> new StringBuilder(1).append((String)key).append("=").append(((Concrete)m.apply(key)).showValue()).toString(), Seq$.MODULE$.canBuildFrom())).mkString(new StringBuilder(0).append(msg).append(prefix$1).toString(), separator$1, postfix$1);
    }

    public CircuitState(Map<String, Concrete> inputPorts, Map<String, Concrete> outputPorts, Map<String, Concrete> registers, Map<String, Memory> memories, HashSet<String> validNames, Option<MonitorManager> monitorManagerOpt) {
        this.inputPorts = inputPorts;
        this.outputPorts = outputPorts;
        this.registers = registers;
        this.memories = memories;
        this.validNames = validNames;
        this.monitorManagerOpt = monitorManagerOpt;
        Product.$init$((Product)this);
        this.nextRegisters = new HashMap();
        this.ephemera = new HashMap();
        this.rhsOutputs = new HashSet();
        this.nameToConcreteValue = (HashMap)HashMap$.MODULE$.apply(inputPorts.$plus$plus(outputPorts).$plus$plus(registers).toSeq());
        this.stateCounter = 0;
        this.isStale = true;
        this.clockHigh = false;
        this.vcdLoggerOption = Option$.MODULE$.empty();
        this.vcdOutputFileName = "";
    }
}

