/*
 * Decompiled with CFR 0.152.
 */
package firrtl_interpreter;

import firrtl.CommonOptions;
import firrtl.ExecutionOptionsManager;
import firrtl.HasCommonOptions;
import firrtl_interpreter.Concrete;
import firrtl_interpreter.Concrete$;
import firrtl_interpreter.ConcreteClock;
import firrtl_interpreter.ConcreteSInt;
import firrtl_interpreter.ConcreteUInt;
import firrtl_interpreter.FirrtlTerp;
import firrtl_interpreter.FirrtlTerp$;
import firrtl_interpreter.HasInterpreterSuite;
import firrtl_interpreter.InterpreterException;
import firrtl_interpreter.InterpreterException$;
import firrtl_interpreter.InterpreterOptions;
import firrtl_interpreter.InterpretiveTester$;
import firrtl_interpreter.Memory;
import firrtl_interpreter.MonitorManager;
import firrtl_interpreter.package$;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00055g\u0001B\u0016-\u0001=B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\")q\t\u0001C\u0001\u0011\"9A\n\u0001a\u0001\n\u0003i\u0005bB)\u0001\u0001\u0004%\tA\u0015\u0005\u00071\u0002\u0001\u000b\u0015\u0002(\t\u000fe\u0003!\u0019!C\u00015\"1a\f\u0001Q\u0001\nmCqa\u0018\u0001C\u0002\u0013\u0005\u0001\r\u0003\u0004e\u0001\u0001\u0006I!\u0019\u0005\bK\u0002\u0011\r\u0011\"\u0001g\u0011\u0019i\u0007\u0001)A\u0005O\")a\u000e\u0001C\u0001_\"9Q\u000fAI\u0001\n\u00031\b\"CA\u0002\u0001\t\u0007I\u0011AA\u0003\u0011!\ti\u0001\u0001Q\u0001\n\u0005\u001d\u0001\"CA\b\u0001\u0001\u0007I\u0011BA\u0003\u0011%\t\t\u0002\u0001a\u0001\n\u0013\t\u0019\u0002\u0003\u0005\u0002\u0018\u0001\u0001\u000b\u0015BA\u0004\u0011%\tI\u0002\u0001a\u0001\n\u0013\tY\u0002C\u0005\u0002$\u0001\u0001\r\u0011\"\u0003\u0002&!A\u0011\u0011\u0006\u0001!B\u0013\ti\u0002C\u0004\u0002,\u0001!\t!!\f\t\u000f\u0005-\u0002\u0001\"\u0001\u00024!I\u0011q\u000b\u0001\u0012\u0002\u0013\u0005\u0011\u0011\f\u0005\b\u0003;\u0002A\u0011AA0\u0011\u001d\t\t\u0007\u0001C\u0001\u0003GBq!!\u0019\u0001\t\u0003\t\t\bC\u0004\u0002~\u0001!\t!a \t\u000f\u0005%\u0005\u0001\"\u0001\u0002\f\"9\u0011q\u0012\u0001\u0005\u0002\u0005E\u0005bBAL\u0001\u0011\u0005\u0011\u0011\u0014\u0005\b\u0003;\u0003A\u0011AAP\u0011\u001d\t9\u000b\u0001C\u0001\u0003SC\u0011\"a,\u0001#\u0003%\t!!-\t\u000f\u0005U\u0006\u0001\"\u0001\u00028\"9\u0011\u0011\u0018\u0001\u0005\u0002\u0005m\u0006bBA_\u0001\u0011\u0005\u0011qL\u0004\n\u0003\u007fc\u0013\u0011!E\u0001\u0003\u00034\u0001b\u000b\u0017\u0002\u0002#\u0005\u00111\u0019\u0005\u0007\u000f\"\"\t!!2\t\u0013\u0005\u001d\u0007&%A\u0005\u0002\u0005%'AE%oi\u0016\u0014\bO]3uSZ,G+Z:uKJT\u0011!L\u0001\u0013M&\u0014(\u000f\u001e7`S:$XM\u001d9sKR,'o\u0001\u0001\u0014\u0005\u0001\u0001\u0004CA\u00195\u001b\u0005\u0011$\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0012$AB!osJ+g-A\u0003j]B,H\u000f\u0005\u00029\u007f9\u0011\u0011(\u0010\t\u0003uIj\u0011a\u000f\u0006\u0003y9\na\u0001\u0010:p_Rt\u0014B\u0001 3\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001)\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005y\u0012\u0014AD8qi&|gn]'b]\u0006<WM\u001d\t\u0003\t\u0016k\u0011\u0001L\u0005\u0003\r2\u00121\u0003S1t\u0013:$XM\u001d9sKR,'oU;ji\u0016\fa\u0001P5oSRtDcA%K\u0017B\u0011A\t\u0001\u0005\u0006m\r\u0001\ra\u000e\u0005\b\u0005\u000e\u0001\n\u00111\u0001D\u0003=)\u0007\u0010]3di\u0006$\u0018n\u001c8t\u001b\u0016$X#\u0001(\u0011\u0005Ez\u0015B\u0001)3\u0005\rIe\u000e^\u0001\u0014Kb\u0004Xm\u0019;bi&|gn]'fi~#S-\u001d\u000b\u0003'Z\u0003\"!\r+\n\u0005U\u0013$\u0001B+oSRDqaV\u0003\u0002\u0002\u0003\u0007a*A\u0002yIE\n\u0001#\u001a=qK\u000e$\u0018\r^5p]NlU\r\u001e\u0011\u0002\u0017%tG/\u001a:qe\u0016$XM]\u000b\u00027B\u0011A\tX\u0005\u0003;2\u0012!BR5seRdG+\u001a:q\u00031Ig\u000e^3saJ,G/\u001a:!\u0003IIg\u000e^3saJ,G/\u001a:PaRLwN\\:\u0016\u0003\u0005\u0004\"\u0001\u00122\n\u0005\rd#AE%oi\u0016\u0014\bO]3uKJ|\u0005\u000f^5p]N\f1#\u001b8uKJ\u0004(/\u001a;fe>\u0003H/[8og\u0002\nQbY8n[>tw\n\u001d;j_:\u001cX#A4\u0011\u0005!\\W\"A5\u000b\u0003)\faAZ5seRd\u0017B\u00017j\u00055\u0019u.\\7p]>\u0003H/[8og\u0006q1m\\7n_:|\u0005\u000f^5p]N\u0004\u0013AC:fiZ+'OY8tKR\u00111\u000b\u001d\u0005\bc6\u0001\n\u00111\u0001s\u0003\u00151\u0018\r\\;f!\t\t4/\u0003\u0002ue\t9!i\\8mK\u0006t\u0017\u0001F:fiZ+'OY8tK\u0012\"WMZ1vYR$\u0013'F\u0001xU\t\u0011\bpK\u0001z!\tQx0D\u0001|\u0015\taX0A\u0005v]\u000eDWmY6fI*\u0011aPM\u0001\u000bC:tw\u000e^1uS>t\u0017bAA\u0001w\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0013M$\u0018M\u001d;US6,WCAA\u0004!\r\t\u0014\u0011B\u0005\u0004\u0003\u0017\u0011$\u0001\u0002'p]\u001e\f!b\u001d;beR$\u0016.\\3!\u0003-1\u0017-\u001b7ve\u0016$\u0016.\\3\u0002\u001f\u0019\f\u0017\u000e\\;sKRKW.Z0%KF$2aUA\u000b\u0011!9&#!AA\u0002\u0005\u001d\u0011\u0001\u00044bS2,(/\u001a+j[\u0016\u0004\u0013\u0001\u00034bS2\u001cu\u000eZ3\u0016\u0005\u0005u\u0001\u0003B\u0019\u0002 9K1!!\t3\u0005\u0019y\u0005\u000f^5p]\u0006aa-Y5m\u0007>$Wm\u0018\u0013fcR\u00191+a\n\t\u0011]+\u0012\u0011!a\u0001\u0003;\t\u0011BZ1jY\u000e{G-\u001a\u0011\u0002\t\u0019\f\u0017\u000e\u001c\u000b\u0004'\u0006=\u0002BBA\u0019/\u0001\u0007a*\u0001\u0003d_\u0012,GCBA\u001b\u0003w\t\t\u0006E\u00022\u0003oI1!!\u000f3\u0005\u001dqu\u000e\u001e5j]\u001eDq!!\u0010\u0019\u0001\u0004\ty$\u0001\u0002fqB!\u0011\u0011IA&\u001d\u0011\t\u0019%a\u0012\u000f\u0007i\n)%C\u00014\u0013\r\tIEM\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti%a\u0014\u0003\u0013QC'o\\<bE2,'bAA%e!I\u00111\u000b\r\u0011\u0002\u0003\u0007\u0011QK\u0001\u0004[N<\u0007\u0003B\u0019\u0002 ]\naBZ1jY\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\\)\u001a\u0011Q\u000b=\u0002\t%\u001cxjS\u000b\u0002e\u0006!\u0001o\\6f)\u0015\u0019\u0016QMA5\u0011\u0019\t9g\u0007a\u0001o\u0005!a.Y7f\u0011\u0019\t8\u00041\u0001\u0002lA!\u0011\u0011IA7\u0013\u0011\ty'a\u0014\u0003\r\tKw-\u00138u)\u0015\u0019\u00161OA;\u0011\u0019\t9\u0007\ba\u0001o!1\u0011\u000f\ba\u0001\u0003o\u00022\u0001RA=\u0013\r\tY\b\f\u0002\t\u0007>t7M]3uK\u0006Q\u0001o\\6f\u001b\u0016lwN]=\u0015\u000fM\u000b\t)a!\u0002\b\"1\u0011qM\u000fA\u0002]Ba!!\"\u001e\u0001\u0004q\u0015!B5oI\u0016D\bBB9\u001e\u0001\u0004\tY'\u0001\u0003qK\u0016\\G\u0003BA6\u0003\u001bCa!a\u001a\u001f\u0001\u00049\u0014A\u00039fK.lU-\\8ssR1\u00111NAJ\u0003+Ca!a\u001a \u0001\u00049\u0004BBAC?\u0001\u0007a*\u0001\u0007qK\u0016\\7i\u001c8de\u0016$X\r\u0006\u0003\u0002x\u0005m\u0005BBA4A\u0001\u0007q'\u0001\u0004fqB,7\r\u001e\u000b\u0006'\u0006\u0005\u00161\u0015\u0005\u0007\u0003O\n\u0003\u0019A\u001c\t\u000f\u0005\u0015\u0016\u00051\u0001\u0002l\u0005iQ\r\u001f9fGR,GMV1mk\u0016\fAa\u001d;faR\u00191+a+\t\u0011\u00055&\u0005%AA\u00029\u000b\u0011A\\\u0001\u000fgR,\u0007\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\t\u0019L\u000b\u0002Oq\u0006a!/\u001a9peR\u001cFO]5oOV\tq'\u0001\u0004sKB|'\u000f\u001e\u000b\u0002'\u00061a-\u001b8jg\"\f!#\u00138uKJ\u0004(/\u001a;jm\u0016$Vm\u001d;feB\u0011A\tK\n\u0003QA\"\"!!1\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tYM\u000b\u0002Dq\u0002")
public class InterpretiveTester {
    private final HasInterpreterSuite optionsManager;
    private int expectationsMet;
    private final FirrtlTerp interpreter;
    private final InterpreterOptions interpreterOptions;
    private final CommonOptions commonOptions;
    private final long startTime;
    private long failureTime;
    private Option<Object> failCode;

    public static HasInterpreterSuite $lessinit$greater$default$2() {
        return InterpretiveTester$.MODULE$.$lessinit$greater$default$2();
    }

    public int expectationsMet() {
        return this.expectationsMet;
    }

    public void expectationsMet_$eq(int x$1) {
        this.expectationsMet = x$1;
    }

    public FirrtlTerp interpreter() {
        return this.interpreter;
    }

    public InterpreterOptions interpreterOptions() {
        return this.interpreterOptions;
    }

    public CommonOptions commonOptions() {
        return this.commonOptions;
    }

    public void setVerbose(boolean value) {
        this.interpreter().setVerbose(value);
    }

    public boolean setVerbose$default$1() {
        return true;
    }

    public long startTime() {
        return this.startTime;
    }

    private long failureTime() {
        return this.failureTime;
    }

    private void failureTime_$eq(long x$1) {
        this.failureTime = x$1;
    }

    private Option<Object> failCode() {
        return this.failCode;
    }

    private void failCode_$eq(Option<Object> x$1) {
        this.failCode = x$1;
    }

    public void fail(int code) {
        block0: {
            this.interpreter().circuitState().writeVCD();
            if (!this.failCode().isEmpty()) break block0;
            this.failureTime_$eq(System.nanoTime());
            this.failCode_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)code)));
        }
    }

    public Nothing$ fail(Throwable ex, Option<String> msg) {
        Option<String> option = msg;
        if (option instanceof Some) {
            Some some = (Some)option;
            String s = (String)some.value();
            Predef$.MODULE$.println((Object)s);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.fail(2);
        throw ex;
    }

    public Option<String> fail$default$2() {
        return None$.MODULE$;
    }

    public boolean isOK() {
        Some some;
        int n;
        Option<Object> option = this.failCode();
        boolean bl = None$.MODULE$.equals(option) ? true : option instanceof Some && 0 == (n = BoxesRunTime.unboxToInt((Object)(some = (Some)option).value()));
        boolean bl2 = bl;
        return bl2;
    }

    public void poke(String name, BigInt value) {
        if (this.interpreter().checkStopped(new StringBuilder(8).append("poke(").append(name).append(", ").append(value).append(")").toString())) {
            return;
        }
        try {
            boolean isRegister = this.interpreter().circuitState().registers().contains((Object)name);
            this.interpreter().circuitState().vcdLowerClock();
            String x$1 = name;
            BigInt x$2 = value;
            boolean x$3 = isRegister;
            boolean x$4 = this.interpreter().setValueWithBigInt$default$3();
            this.interpreter().setValueWithBigInt(x$1, x$2, x$4, x$3);
        }
        catch (InterpreterException ie) {
            throw this.fail(ie, (Option<String>)new Some((Object)new StringBuilder(15).append("Error: poke(").append(name).append(", ").append(value).append(")").toString()));
        }
    }

    public void poke(String name, Concrete value) {
        if (this.interpreter().checkStopped(new StringBuilder(8).append("poke(").append(name).append(", ").append(value).append(")").toString())) {
            return;
        }
        try {
            boolean isRegister = this.interpreter().circuitState().registers().contains((Object)name);
            this.interpreter().circuitState().vcdLowerClock();
            this.interpreter().circuitState().setValue(name, value, isRegister);
        }
        catch (InterpreterException ie) {
            throw this.fail(ie, (Option<String>)new Some((Object)new StringBuilder(15).append("Error: poke(").append(name).append(", ").append(value).append(")").toString()));
        }
    }

    public void pokeMemory(String name, int index, BigInt value) {
        if (this.interpreter().checkStopped(new StringBuilder(14).append("pokeMemory(").append(name).append(", ").append(value).append(")").toString())) {
            return;
        }
        Option option = this.interpreter().circuitState().memories().get((Object)name);
        if (!(option instanceof Some)) {
            throw InterpreterException$.MODULE$.apply(new StringBuilder(47).append("Error: memory ").append(name).append(".forceWrite(").append(index).append(", ").append(value).append("). memory not found").toString());
        }
        Some some = (Some)option;
        Memory memory = (Memory)some.value();
        memory.forceWrite(index, value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public BigInt peek(String name) {
        BigInt bigInt;
        if (this.interpreter().checkStopped(new StringBuilder(6).append("peek(").append(name).append(")").toString())) {
            return BigInt$.MODULE$.int2bigInt(0);
        }
        Concrete concrete = this.interpreter().getValue(name);
        if (concrete instanceof ConcreteUInt) {
            BigInt value;
            ConcreteUInt concreteUInt = (ConcreteUInt)concrete;
            bigInt = value = concreteUInt.value();
        } else if (concrete instanceof ConcreteSInt) {
            BigInt value;
            ConcreteSInt concreteSInt = (ConcreteSInt)concrete;
            bigInt = value = concreteSInt.value();
        } else {
            throw this.fail(new InterpreterException(new StringBuilder(28).append("Error:peek(").append(name).append(") value not found").toString()), this.fail$default$2());
        }
        return bigInt;
    }

    public BigInt peekMemory(String name, int index) {
        return this.interpreter().getMemory(name, index);
    }

    public Concrete peekConcrete(String name) {
        Concrete concrete;
        if (this.interpreter().checkStopped(new StringBuilder(14).append("peekConcrete(").append(name).append(")").toString())) {
            return Concrete$.MODULE$.poisonedUInt(1);
        }
        Concrete concrete2 = this.interpreter().getValue(name);
        if (concrete2 == null) {
            throw this.fail(new InterpreterException(new StringBuilder(28).append("Error:peek(").append(name).append(") value not found").toString()), this.fail$default$2());
        }
        Concrete concrete3 = concrete = concrete2;
        return concrete3;
    }

    public void expect(String name, BigInt expectedValue) {
        if (this.interpreter().checkStopped(new StringBuilder(10).append("expect(").append(name).append(", ").append(expectedValue).append(")").toString())) {
            return;
        }
        Concrete concrete = this.interpreter().getValue(name);
        if (concrete instanceof ConcreteUInt) {
            ConcreteUInt concreteUInt = (ConcreteUInt)concrete;
            this.testValue$1(concreteUInt, expectedValue, name);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (concrete instanceof ConcreteSInt) {
            ConcreteSInt concreteSInt = (ConcreteSInt)concrete;
            this.testValue$1(concreteSInt, expectedValue, name);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (concrete instanceof ConcreteClock) {
            ConcreteClock concreteClock = (ConcreteClock)concrete;
            this.testValue$1(concreteClock, expectedValue, name);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw this.fail(new InterpreterException(new StringBuilder(32).append("Error:expect(").append(name).append(", ").append(expectedValue).append(") value not found").toString()), this.fail$default$2());
        }
        this.expectationsMet_$eq(this.expectationsMet() + 1);
    }

    public void step(int n) {
        if (this.interpreter().checkStopped(new StringBuilder(6).append("step(").append(n).append(")").toString())) {
            return;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> this.interpreter().cycle(this.interpreter().cycle$default$1()));
    }

    public int step$default$1() {
        return 1;
    }

    public String reportString() {
        String string;
        long endTime = System.nanoTime();
        double elapsedSeconds = (double)(endTime - this.startTime()) / 1.0E9;
        if (new StringOps(Predef$.MODULE$.augmentString(this.optionsManager.interpreterOptions().getMonitorReportFile((ExecutionOptionsManager)this.optionsManager))).nonEmpty()) {
            String string2;
            Option<MonitorManager> option = this.interpreter().monitorManagerOpt();
            if (option instanceof Some) {
                Some some = (Some)option;
                MonitorManager monitorManager = (MonitorManager)some.value();
                File file = new File(this.optionsManager.interpreterOptions().getMonitorReportFile((ExecutionOptionsManager)this.optionsManager));
                PrintWriter writer = new PrintWriter(file);
                writer.write(monitorManager.monitorReport());
                writer.close();
                Predef$.MODULE$.println((Object)new StringBuilder(36).append("Bit Monitor report written to file ").append(file.getAbsolutePath()).append(" ").toString());
                string2 = "";
            } else {
                string2 = "";
            }
            string = string2;
        } else {
            String string3;
            Option<MonitorManager> option = this.interpreter().monitorManagerOpt();
            if (option instanceof Some) {
                Some some = (Some)option;
                MonitorManager monitorManager = (MonitorManager)some.value();
                string3 = monitorManager.monitorReport();
            } else {
                string3 = "";
            }
            string = string3;
        }
        String monitorReport = string;
        double arg$macro$1 = elapsedSeconds;
        return new StringBuilder(33).append("test ").append(this.interpreter().loweredAst().main()).append(" ").append(this.status$1()).append(" ").append(this.expectationsMet()).append(" tests passed ").append("in ").append(this.interpreter().circuitState().stateCounter()).append(" cycles ").append(new StringOps("taking %.6f seconds").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$1)}))).append("\n").append(monitorReport).toString();
    }

    public void report() {
        this.interpreter().writeVCD();
        Predef$.MODULE$.println((Object)this.reportString());
    }

    public boolean finish() {
        return this.isOK();
    }

    private final void testValue$1(Concrete concrete, BigInt expectedValue$1, String name$1) {
        BigInt bigInt = concrete.value();
        BigInt bigInt2 = expectedValue$1;
        if (bigInt == null ? bigInt2 != null : !bigInt.equals(bigInt2)) {
            if (!this.interpreter().verbose()) {
                this.interpreter().reEvaluate(name$1);
            }
            throw this.fail(new InterpreterException(new StringBuilder(21).append("Error:expect(").append(name$1).append(", ").append(expectedValue$1).append(") got ").append(concrete.showValue()).toString()), this.fail$default$2());
        }
    }

    private final String status$1() {
        String string;
        Option<Object> option = this.interpreter().lastStopResult();
        if (option instanceof Some) {
            Some some = (Some)option;
            int stopResult = BoxesRunTime.unboxToInt((Object)some.value());
            string = new StringBuilder(21).append("Failed: Stop result ").append(stopResult).append(":").toString();
        } else {
            string = this.isOK() ? "Success:" : new StringBuilder(13).append("Failed: Code ").append(this.failCode().get()).toString();
        }
        return string;
    }

    public InterpretiveTester(String input, HasInterpreterSuite optionsManager) {
        this.optionsManager = optionsManager;
        this.expectationsMet = 0;
        package$.MODULE$.random().setSeed(optionsManager.interpreterOptions().randomSeed());
        this.interpreter = FirrtlTerp$.MODULE$.apply(input, optionsManager);
        this.interpreterOptions = optionsManager.interpreterOptions();
        this.commonOptions = ((HasCommonOptions)optionsManager).commonOptions();
        this.interpreter().evaluator().allowCombinationalLoops_$eq(this.interpreterOptions().allowCycles());
        this.interpreter().evaluator().useTopologicalSortedKeys_$eq(this.interpreterOptions().setOrderedExec());
        this.interpreter().evaluator().evaluationStack().maxExecutionDepth_$eq(this.interpreterOptions().maxExecutionDepth());
        this.interpreter().setVerbose(this.interpreterOptions().setVerbose());
        this.setVerbose(this.interpreterOptions().setVerbose());
        if (this.interpreterOptions().writeVCD()) {
            ((ExecutionOptionsManager)optionsManager).setTopNameIfNotSet(this.interpreter().loweredAst().main());
            ((ExecutionOptionsManager)optionsManager).makeTargetDir();
            this.interpreter().makeVCDLogger(this.interpreterOptions().vcdOutputFileName((ExecutionOptionsManager)optionsManager), this.interpreterOptions().vcdShowUnderscored());
        }
        this.startTime = System.nanoTime();
        this.failureTime = -1L;
        this.failCode = None$.MODULE$;
    }
}

