/*
 * Decompiled with CFR 0.152.
 */
package firrtl_interpreter;

import firrtl.PrimOps;
import firrtl.WRef$;
import firrtl.ir.ClockType$;
import firrtl.ir.DefRegister;
import firrtl.ir.DoPrim;
import firrtl.ir.Expression;
import firrtl.ir.IntWidth;
import firrtl.ir.IntWidth$;
import firrtl.ir.Mux;
import firrtl.ir.PrimOp;
import firrtl.ir.Print;
import firrtl.ir.Reference;
import firrtl.ir.SIntLiteral;
import firrtl.ir.SIntType;
import firrtl.ir.Stop;
import firrtl.ir.SubField;
import firrtl.ir.SubIndex;
import firrtl.ir.Type;
import firrtl.ir.UIntLiteral;
import firrtl.ir.UIntType;
import firrtl.ir.ValidIf;
import firrtl.ir.Width;
import firrtl_interpreter.BlackBoxOutput;
import firrtl_interpreter.CircuitState;
import firrtl_interpreter.Concrete;
import firrtl_interpreter.Concrete$;
import firrtl_interpreter.ConcreteClock;
import firrtl_interpreter.ConcreteSInt;
import firrtl_interpreter.ConcreteUInt;
import firrtl_interpreter.ConcreteUInt$;
import firrtl_interpreter.DependencyGraph;
import firrtl_interpreter.ExpressionExecutionStack;
import firrtl_interpreter.InterpreterException;
import firrtl_interpreter.InterpreterException$;
import firrtl_interpreter.Memory;
import firrtl_interpreter.Timer;
import firrtl_interpreter.package;
import firrtl_interpreter.package$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\tEh\u0001\u0002!B\u0001\u0011C\u0001b\u0015\u0001\u0003\u0006\u0004%\t\u0001\u0016\u0005\t1\u0002\u0011\t\u0011)A\u0005+\"A\u0011\f\u0001BC\u0002\u0013\u0005!\f\u0003\u0005_\u0001\t\u0005\t\u0015!\u0003\\\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u001d!\u0007\u00011A\u0005\u0002\u0015Dq!\u001f\u0001A\u0002\u0013\u0005!\u0010C\u0004\u0002\u0002\u0001\u0001\u000b\u0015\u00024\t\u0013\u0005\r\u0001\u00011A\u0005\u0002\u0005\u0015\u0001\"CA\u0007\u0001\u0001\u0007I\u0011AA\b\u0011!\t\u0019\u0002\u0001Q!\n\u0005\u001d\u0001\"CA\u000b\u0001\u0001\u0007I\u0011AA\u0003\u0011%\t9\u0002\u0001a\u0001\n\u0003\tI\u0002\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0015BA\u0004\u0011%\ty\u0002\u0001a\u0001\n\u0003\t)\u0001C\u0005\u0002\"\u0001\u0001\r\u0011\"\u0001\u0002$!A\u0011q\u0005\u0001!B\u0013\t9\u0001C\u0005\u0002*\u0001\u0001\r\u0011\"\u0001\u0002\u0006!I\u00111\u0006\u0001A\u0002\u0013\u0005\u0011Q\u0006\u0005\t\u0003c\u0001\u0001\u0015)\u0003\u0002\b!I\u00111\u0007\u0001C\u0002\u0013\u0005\u0011Q\u0007\u0005\t\u0003{\u0001\u0001\u0015!\u0003\u00028!I\u0011q\b\u0001A\u0002\u0013\u0005\u0011\u0011\t\u0005\n\u0003\u0013\u0002\u0001\u0019!C\u0001\u0003\u0017B\u0001\"a\u0014\u0001A\u0003&\u00111\t\u0005\n\u0003#\u0002\u0001\u0019!C\u0001\u0003\u000bA\u0011\"a\u0015\u0001\u0001\u0004%\t!!\u0016\t\u0011\u0005e\u0003\u0001)Q\u0005\u0003\u000fA\u0011\"a\u0017\u0001\u0005\u0004%\t!!\u0018\t\u0011\u0005\u0015\u0004\u0001)A\u0005\u0003?B\u0011\"a\u001a\u0001\u0005\u0004%\t!!\u001b\t\u0011\u0005E\u0004\u0001)A\u0005\u0003WBq!a\u001d\u0001\t\u0003\t)\bC\u0004\u0002\u0002\u0002!\t!a!\t\u000f\u0005u\u0005\u0001\"\u0001\u0002 \"9\u0011Q\u0015\u0001\u0005\u0002\u0005\u001d\u0006bBAW\u0001\u0011\u0005\u0011q\u0016\u0005\b\u0003\u001f\u0004A\u0011AAi\u0011\u001d\ti\u000e\u0001C\u0001\u0003?Dq!a;\u0001\t\u0003\ti\u000fC\u0004\u0003\f\u0001!\tA!\u0004\t\u000f\tm\u0001\u0001\"\u0001\u0003\u001e!9!Q\u0005\u0001\u0005\u0002\t\u001d\u0002b\u0002B\u0019\u0001\u0011\u0005!1\u0007\u0005\b\u0005w\u0001A\u0011\u0001B\u001f\u0011\u001d\u00119\u0005\u0001C\u0001\u0005\u0013BqAa\u0015\u0001\t\u0003\u0011)\u0006C\u0004\u0003`\u0001!\tA!\u0019\t\u000f\t%\u0004\u0001\"\u0001\u0003l!I!1\u0010\u0001\u0012\u0002\u0013\u0005!Q\u0010\u0005\b\u0005'\u0003A\u0011\u0001BK\u0011\u001d\u00119\n\u0001C\u0001\u00053CqA!(\u0001\t\u0013\u0011y\nC\u0004\u0003$\u0002!\tA!*\t\u000f\tE\u0006\u0001\"\u0001\u00034\"9!Q\u0018\u0001\u0005\u0002\t}\u0006b\u0002Bi\u0001\u0011\u0005!Q\u0013\u0005\n\u0005'\u0004\u0001\u0019!C\u0005\u0005+D\u0011Ba6\u0001\u0001\u0004%IA!7\t\u0011\tu\u0007\u0001)Q\u0005\u0005oCqAa8\u0001\t\u0013\u0011)\nC\u0004\u0003b\u0002!IA!&\t\u000f\t\r\b\u0001\"\u0011\u0003f\nYBj\u001c$jeJ$H.\u0012=qe\u0016\u001c8/[8o\u000bZ\fG.^1u_JT\u0011AQ\u0001\u0013M&\u0014(\u000f\u001e7`S:$XM\u001d9sKR,'o\u0001\u0001\u0014\u0007\u0001)5\n\u0005\u0002G\u00136\tqIC\u0001I\u0003\u0015\u00198-\u00197b\u0013\tQuI\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0019Bs!!\u0014(\u000e\u0003\u0005K!aT!\u0002\u000fA\f7m[1hK&\u0011\u0011K\u0015\u0002\r'&l\u0007\u000f\\3M_\u001e<WM\u001d\u0006\u0003\u001f\u0006\u000bq\u0002Z3qK:$WM\\2z\u000fJ\f\u0007\u000f[\u000b\u0002+B\u0011QJV\u0005\u0003/\u0006\u0013q\u0002R3qK:$WM\\2z\u000fJ\f\u0007\u000f[\u0001\u0011I\u0016\u0004XM\u001c3f]\u000eLxI]1qQ\u0002\nAbY5sGVLGo\u0015;bi\u0016,\u0012a\u0017\t\u0003\u001brK!!X!\u0003\u0019\rK'oY;jiN#\u0018\r^3\u0002\u001b\rL'oY;jiN#\u0018\r^3!\u0003\u0019a\u0014N\\5u}Q\u0019\u0011MY2\u0011\u00055\u0003\u0001\"B*\u0006\u0001\u0004)\u0006\"B-\u0006\u0001\u0004Y\u0016!\u0003;p%\u0016\u001cx\u000e\u001c<f+\u00051\u0007cA4m]6\t\u0001N\u0003\u0002jU\u00069Q.\u001e;bE2,'BA6H\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003[\"\u0014q\u0001S1tQN+G\u000f\u0005\u0002pm:\u0011\u0001\u000f\u001e\t\u0003c\u001ek\u0011A\u001d\u0006\u0003g\u000e\u000ba\u0001\u0010:p_Rt\u0014BA;H\u0003\u0019\u0001&/\u001a3fM&\u0011q\u000f\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005U<\u0015!\u0004;p%\u0016\u001cx\u000e\u001c<f?\u0012*\u0017\u000f\u0006\u0002|}B\u0011a\t`\u0005\u0003{\u001e\u0013A!\u00168ji\"9qpBA\u0001\u0002\u00041\u0017a\u0001=%c\u0005QAo\u001c*fg>dg/\u001a\u0011\u0002\u0017\u00154\u0018\r\\;bi\u0016\fE\u000e\\\u000b\u0003\u0003\u000f\u00012ARA\u0005\u0013\r\tYa\u0012\u0002\b\u0005>|G.Z1o\u0003=)g/\u00197vCR,\u0017\t\u001c7`I\u0015\fHcA>\u0002\u0012!AqPCA\u0001\u0002\u0004\t9!\u0001\u0007fm\u0006dW/\u0019;f\u00032d\u0007%A\bfq\u000e,\u0007\u000f^5p]\u000e\u000bWo\u001a5u\u0003M)\u0007pY3qi&|gnQ1vO\"$x\fJ3r)\rY\u00181\u0004\u0005\t\u007f6\t\t\u00111\u0001\u0002\b\u0005\u0001R\r_2faRLwN\\\"bk\u001eDG\u000fI\u0001\u0019kN,Gk\u001c9pY><\u0017nY1m'>\u0014H/\u001a3LKf\u001c\u0018\u0001H;tKR{\u0007o\u001c7pO&\u001c\u0017\r\\*peR,GmS3zg~#S-\u001d\u000b\u0004w\u0006\u0015\u0002\u0002C@\u0011\u0003\u0003\u0005\r!a\u0002\u00023U\u001cX\rV8q_2|w-[2bYN{'\u000f^3e\u0017\u0016L8\u000fI\u0001\u0018C2dwn^\"p[\nLg.\u0019;j_:\fG\u000eT8paN\f1$\u00197m_^\u001cu.\u001c2j]\u0006$\u0018n\u001c8bY2{w\u000e]:`I\u0015\fHcA>\u00020!AqpEA\u0001\u0002\u0004\t9!\u0001\rbY2|woQ8nE&t\u0017\r^5p]\u0006dGj\\8qg\u0002\nq\"\u001a<bYV\fG/[8o'R\f7m[\u000b\u0003\u0003o\u00012!TA\u001d\u0013\r\tY$\u0011\u0002\u0019\u000bb\u0004(/Z:tS>tW\t_3dkRLwN\\*uC\u000e\\\u0017\u0001E3wC2,\u0018\r^5p]N#\u0018mY6!\u0003Q!WMZ1vYR\\U-_:U_J+7o\u001c7wKV\u0011\u00111\t\t\u0005\r\u0006\u0015c.C\u0002\u0002H\u001d\u0013Q!\u0011:sCf\f\u0001\u0004Z3gCVdGoS3zgR{'+Z:pYZ,w\fJ3r)\rY\u0018Q\n\u0005\t\u007fb\t\t\u00111\u0001\u0002D\u0005)B-\u001a4bk2$8*Z=t)>\u0014Vm]8mm\u0016\u0004\u0013aE6fs>\u0013H-\u001a:J]&$\u0018.\u00197ju\u0016$\u0017aF6fs>\u0013H-\u001a:J]&$\u0018.\u00197ju\u0016$w\fJ3r)\rY\u0018q\u000b\u0005\t\u007fn\t\t\u00111\u0001\u0002\b\u0005!2.Z=Pe\u0012,'/\u00138ji&\fG.\u001b>fI\u0002\nAc\u001c:eKJ,GmS3zgR{'+Z:pYZ,WCAA0!\u00119\u0017\u0011\r8\n\u0007\u0005\r\u0004NA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\u0018!F8sI\u0016\u0014X\rZ&fsN$vNU3t_24X\rI\u0001\u0006i&lWM]\u000b\u0003\u0003W\u00022!TA7\u0013\r\ty'\u0011\u0002\u0006)&lWM]\u0001\u0007i&lWM\u001d\u0011\u0002\u0011\u001d,GOV1mk\u0016$B!a\u001e\u0002~A\u0019Q*!\u001f\n\u0007\u0005m\u0014I\u0001\u0005D_:\u001c'/\u001a;f\u0011\u0019\ty(\ta\u0001]\u0006\u00191.Z=\u0002\t5\f7o\u001b\u000b\u0007\u0003\u000b\u000b)*!'\u0011\t\u0005\u001d\u0015q\u0012\b\u0005\u0003\u0013\u000biID\u0002r\u0003\u0017K\u0011\u0001S\u0005\u0003\u001f\u001eKA!!%\u0002\u0014\n1!)[4J]RT!aT$\t\u000f\u0005]%\u00051\u0001\u0002\u0006\u00061a.^7cKJDq!a'#\u0001\u0004\t))\u0001\u0003tSj,\u0017AC:iS\u001a$(+[4iiR1\u0011QQAQ\u0003GCq!a&$\u0001\u0004\t)\tC\u0004\u0002\u001c\u000e\u0002\r!!\"\u0002\u0013MD\u0017N\u001a;MK\u001a$HCBAC\u0003S\u000bY\u000bC\u0004\u0002\u0018\u0012\u0002\r!!\"\t\u000f\u0005mE\u00051\u0001\u0002\u0006\u0006iQ.Y6f+&sGOV1mk\u0016$b!!-\u0002B\u0006\u0015\u0007\u0003BAZ\u0003{k!!!.\u000b\t\u0005]\u0016\u0011X\u0001\u0003SJT!!a/\u0002\r\u0019L'O\u001d;m\u0013\u0011\ty,!.\u0003\u0017UKe\u000e\u001e'ji\u0016\u0014\u0018\r\u001c\u0005\b\u0003\u0007,\u0003\u0019AAC\u0003\u00151\u0018\r\\;f\u0011\u001d\t9-\na\u0001\u0003\u0013\f\u0001\"\u001b8u/&$G\u000f\u001b\t\u0005\u0003g\u000bY-\u0003\u0003\u0002N\u0006U&\u0001C%oi^KG\r\u001e5\u0002\u001b5\f7.Z*J]R4\u0016\r\\;f)\u0019\t\u0019.!7\u0002\\B!\u00111WAk\u0013\u0011\t9.!.\u0003\u0017MKe\u000e\u001e'ji\u0016\u0014\u0018\r\u001c\u0005\b\u0003\u00074\u0003\u0019AAC\u0011\u001d\t9M\na\u0001\u0003\u0013\f\u0001bZ3u/&$G\u000f\u001b\u000b\u0005\u0003\u0013\f\t\u000fC\u0004\u0002d\u001e\u0002\r!!:\u0002\u0007Q\u0004X\r\u0005\u0003\u00024\u0006\u001d\u0018\u0002BAu\u0003k\u0013A\u0001V=qK\u0006iQ.\u0019;i!JLW.\u001b;jm\u0016$\u0002\"a\u001e\u0002p\u0006e(\u0011\u0002\u0005\b\u0003cD\u0003\u0019AAz\u0003\u0019y\u0007oQ8eKB!\u00111WA{\u0013\u0011\t90!.\u0003\rA\u0013\u0018.\\(q\u0011\u001d\tY\u0010\u000ba\u0001\u0003{\fA!\u0019:hgB1\u0011qQA\u0000\u0005\u0007IAA!\u0001\u0002\u0014\n\u00191+Z9\u0011\t\u0005M&QA\u0005\u0005\u0005\u000f\t)L\u0001\u0006FqB\u0014Xm]:j_:Dq!a9)\u0001\u0004\t)/A\u0006cSR\u001cV\r\\3di>\u0003HCCA<\u0005\u001f\u0011\tBa\u0005\u0003\u001a!9\u0011\u0011_\u0015A\u0002\u0005M\bbBA~S\u0001\u0007\u0011Q \u0005\b\u0005+I\u0003\u0019\u0001B\f\u0003)\u0001\u0018M]1nKR,'o\u001d\t\u0007\u0003\u000f\u000by0!\"\t\u000f\u0005\r\u0018\u00061\u0001\u0002f\u0006a1m\\7qCJL7o\u001c8PaRA\u0011q\u000fB\u0010\u0005C\u0011\u0019\u0003C\u0004\u0002r*\u0002\r!a=\t\u000f\u0005m(\u00061\u0001\u0002~\"9\u00111\u001d\u0016A\u0002\u0005\u0015\u0018!\u00039bI\u0012LgnZ(q))\t9H!\u000b\u0003,\t5\"q\u0006\u0005\b\u0003c\\\u0003\u0019AAz\u0011\u001d\tYp\u000ba\u0001\u0003{DqA!\u0006,\u0001\u0004\u00119\u0002C\u0004\u0002d.\u0002\r!!:\u0002\u0013\r\f7\u000f^5oO>\u0003H\u0003CA<\u0005k\u00119D!\u000f\t\u000f\u0005EH\u00061\u0001\u0002t\"9\u00111 \u0017A\u0002\u0005u\bbBArY\u0001\u0007\u0011Q]\u0001\u0007E&$x\n]:\u0015\u0015\u0005]$q\bB!\u0005\u0007\u0012)\u0005C\u0004\u0002r6\u0002\r!a=\t\u000f\u0005mX\u00061\u0001\u0002~\"9!QC\u0017A\u0002\t]\u0001bBAr[\u0001\u0007\u0011Q]\u0001\u000eIft\u0017-\\5d\u0005&$x\n]:\u0015\u0015\u0005]$1\nB'\u0005\u001f\u0012\t\u0006C\u0004\u0002r:\u0002\r!a=\t\u000f\u0005mh\u00061\u0001\u0002~\"9!Q\u0003\u0018A\u0002\t]\u0001bBAr]\u0001\u0007\u0011Q]\u0001\n_:,\u0017I]4PaN$\"\"a\u001e\u0003X\te#1\fB/\u0011\u001d\t\tp\fa\u0001\u0003gDq!a?0\u0001\u0004\ti\u0010C\u0004\u0003\u0016=\u0002\rAa\u0006\t\u000f\u0005\rx\u00061\u0001\u0002f\u0006i!-\u001b8bef\u0014\u0015\u000e^,jg\u0016$\u0002\"a\u001e\u0003d\t\u0015$q\r\u0005\b\u0003c\u0004\u0004\u0019AAz\u0011\u001d\tY\u0010\ra\u0001\u0003{Dq!a91\u0001\u0004\t)/\u0001\u0005fm\u0006dW/\u0019;f)\u0019\t9H!\u001c\u0003r!9!qN\u0019A\u0002\t\r\u0011AC3yaJ,7o]5p]\"I!1O\u0019\u0011\u0002\u0003\u0007!QO\u0001\u0013Y\u00164G\u000fS1oINKG-Z(qi&|g\u000e\u0005\u0003G\u0005or\u0017b\u0001B=\u000f\n1q\n\u001d;j_:\f!#\u001a<bYV\fG/\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\u0010\u0016\u0005\u0005k\u0012\ti\u000b\u0002\u0003\u0004B!!Q\u0011BH\u001b\t\u00119I\u0003\u0003\u0003\n\n-\u0015!C;oG\",7m[3e\u0015\r\u0011iiR\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002BI\u0005\u000f\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003%\u0019\bn\\<Ti\u0006\u001c7\u000eF\u0001|\u0003=\u0011Xm]8mm\u0016\u0014VmZ5ti\u0016\u0014H\u0003BA<\u00057Ca!a 5\u0001\u0004q\u0017!\u0005:fg>dg/\u001a#fa\u0016tG-\u001a8dsR!\u0011q\u000fBQ\u0011\u0019\ty(\u000ea\u0001]\u0006\u0019\"/Z:pYZ,G)\u001a9f]\u0012,gnY5fgR\u00191Pa*\t\u000f\t%f\u00071\u0001\u0003,\u0006!2\u000f]3dS\u001aL7\rR3qK:$WM\\2jKN\u0004R!a\"\u0003.:LAAa,\u0002\u0014\nA\u0011\n^3sC\ndW-\u0001\u0006dQ\u0016\u001c7n\u0015;paN$\"A!.\u0011\u000b\u0019\u00139Ha.\u0011\u0007\u0019\u0013I,C\u0002\u0003<\u001e\u00131!\u00138u\u0003U)\u00070Z2vi\u00164uN]7biR,G\r\u0015:j]R$RA\u001cBa\u0005\u000bDaAa19\u0001\u0004q\u0017\u0001\u00044pe6\fGo\u0015;sS:<\u0007b\u0002Bdq\u0001\u0007!\u0011Z\u0001\bC2d\u0017I]4t!\u0019\t9)a@\u0003LB\u0019aI!4\n\u0007\t=wIA\u0002B]f\f1b\u00195fG.\u0004&/\u001b8ug\u0006a!/Z:pYZ,G)\u001a9uQV\u0011!qW\u0001\u0011e\u0016\u001cx\u000e\u001c<f\t\u0016\u0004H\u000f[0%KF$2a\u001fBn\u0011!y8(!AA\u0002\t]\u0016!\u0004:fg>dg/\u001a#faRD\u0007%\u0001\u0004j]\u0012,g\u000e^\u0001\u0007I\u0016$WM\u001c;\u0002\u00071|w\rF\u0002|\u0005OD\u0001B!;@\t\u0003\u0007!1^\u0001\b[\u0016\u001c8/Y4f!\u00111%Q\u001e8\n\u0007\t=xI\u0001\u0005=Eft\u0017-\\3?\u0001")
public class LoFirrtlExpressionEvaluator
implements package.SimpleLogger {
    private final DependencyGraph dependencyGraph;
    private final CircuitState circuitState;
    private HashSet<String> toResolve;
    private boolean evaluateAll;
    private boolean exceptionCaught;
    private boolean useTopologicalSortedKeys;
    private boolean allowCombinationalLoops;
    private final ExpressionExecutionStack evaluationStack;
    private String[] defaultKeysToResolve;
    private boolean keyOrderInitialized;
    private final ArrayBuffer<String> orderedKeysToResolve;
    private final Timer timer;
    private int resolveDepth;
    private boolean verbose;

    @Override
    public void setVerbose(boolean value) {
        package.SimpleLogger.setVerbose$(this, value);
    }

    @Override
    public boolean setVerbose$default$1() {
        return package.SimpleLogger.setVerbose$default$1$(this);
    }

    @Override
    public boolean verbose() {
        return this.verbose;
    }

    @Override
    public void verbose_$eq(boolean x$1) {
        this.verbose = x$1;
    }

    public DependencyGraph dependencyGraph() {
        return this.dependencyGraph;
    }

    public CircuitState circuitState() {
        return this.circuitState;
    }

    public HashSet<String> toResolve() {
        return this.toResolve;
    }

    public void toResolve_$eq(HashSet<String> x$1) {
        this.toResolve = x$1;
    }

    public boolean evaluateAll() {
        return this.evaluateAll;
    }

    public void evaluateAll_$eq(boolean x$1) {
        this.evaluateAll = x$1;
    }

    public boolean exceptionCaught() {
        return this.exceptionCaught;
    }

    public void exceptionCaught_$eq(boolean x$1) {
        this.exceptionCaught = x$1;
    }

    public boolean useTopologicalSortedKeys() {
        return this.useTopologicalSortedKeys;
    }

    public void useTopologicalSortedKeys_$eq(boolean x$1) {
        this.useTopologicalSortedKeys = x$1;
    }

    public boolean allowCombinationalLoops() {
        return this.allowCombinationalLoops;
    }

    public void allowCombinationalLoops_$eq(boolean x$1) {
        this.allowCombinationalLoops = x$1;
    }

    public ExpressionExecutionStack evaluationStack() {
        return this.evaluationStack;
    }

    public String[] defaultKeysToResolve() {
        return this.defaultKeysToResolve;
    }

    public void defaultKeysToResolve_$eq(String[] x$1) {
        this.defaultKeysToResolve = x$1;
    }

    public boolean keyOrderInitialized() {
        return this.keyOrderInitialized;
    }

    public void keyOrderInitialized_$eq(boolean x$1) {
        this.keyOrderInitialized = x$1;
    }

    public ArrayBuffer<String> orderedKeysToResolve() {
        return this.orderedKeysToResolve;
    }

    public Timer timer() {
        return this.timer;
    }

    public Concrete getValue(String key) {
        Concrete concrete;
        BoxedUnit boxedUnit;
        if (this.dependencyGraph().memoryOutputKeys().contains((Object)key)) {
            Seq dependentKeys = (Seq)this.dependencyGraph().memoryOutputKeys().apply((Object)key);
            dependentKeys.foreach((Function1 & Serializable & scala.Serializable)elem -> this.resolveDependency((String)elem));
        }
        if (this.circuitState().isOutput(key)) {
            if (!this.circuitState().rhsOutputs().contains((Object)key) && this.dependencyGraph().nameToExpression().contains((Object)key)) {
                this.resolveDependency(key);
                boxedUnit = this.circuitState().rhsOutputs().$plus$eq((Object)key);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Option<Concrete> option = this.circuitState().getValue(key);
        if (option instanceof Some) {
            Concrete value;
            Some some = (Some)option;
            concrete = value = (Concrete)some.value();
        } else {
            concrete = this.resolveDependency(key);
        }
        return concrete;
    }

    public BigInt mask(BigInt number, BigInt size) {
        if (size.$less((Object)BigInt$.MODULE$.int2bigInt(1))) {
            return package$.MODULE$.Big0();
        }
        int convenientShiftSize = 30;
        BigInt modulo = BigInt$.MODULE$.int2bigInt(1);
        BigInt toShift = size.$minus(BigInt$.MODULE$.int2bigInt(1)).max(BigInt$.MODULE$.int2bigInt(0)).$plus(BigInt$.MODULE$.int2bigInt(1));
        while (toShift.$greater((Object)BigInt$.MODULE$.int2bigInt(0))) {
            modulo = modulo.$less$less(toShift.min(BigInt$.MODULE$.int2bigInt(convenientShiftSize)).toInt());
            toShift = toShift.$minus(BigInt$.MODULE$.int2bigInt(convenientShiftSize));
        }
        return number.$percent(modulo);
    }

    public BigInt shiftRight(BigInt number, BigInt size) {
        int convenientShiftSize = 30;
        BigInt toShift = size.max(BigInt$.MODULE$.int2bigInt(0));
        BigInt shiftedNumber = number;
        while (toShift.$greater((Object)BigInt$.MODULE$.int2bigInt(0))) {
            shiftedNumber = shiftedNumber.$greater$greater(toShift.min(BigInt$.MODULE$.int2bigInt(convenientShiftSize)).toInt());
            toShift = toShift.$minus(BigInt$.MODULE$.int2bigInt(convenientShiftSize));
        }
        return shiftedNumber;
    }

    public BigInt shiftLeft(BigInt number, BigInt size) {
        int convenientShiftSize = 30;
        BigInt toShift = size.max(BigInt$.MODULE$.int2bigInt(0));
        BigInt shiftedNumber = number;
        while (toShift.$greater((Object)BigInt$.MODULE$.int2bigInt(0))) {
            shiftedNumber = shiftedNumber.$less$less(toShift.min(BigInt$.MODULE$.int2bigInt(convenientShiftSize)).toInt());
            toShift = toShift.$minus(BigInt$.MODULE$.int2bigInt(convenientShiftSize));
        }
        return shiftedNumber;
    }

    public UIntLiteral makeUIntValue(BigInt value, IntWidth intWidth) {
        BigInt maskedValue = this.mask(value, intWidth.width());
        return new UIntLiteral(maskedValue, (Width)intWidth);
    }

    public SIntLiteral makeSIntValue(BigInt value, IntWidth intWidth) {
        BigInt maskedValue = this.mask(value, intWidth.width());
        return new SIntLiteral(maskedValue, (Width)intWidth);
    }

    /*
     * WARNING - void declaration
     */
    public IntWidth getWidth(Type tpe) {
        void var3_10;
        SIntType sIntType;
        Width width;
        IntWidth intWidth;
        UIntType uIntType;
        Width width2;
        Type type = tpe;
        if (type instanceof UIntType && (width2 = (uIntType = (UIntType)type).width()) instanceof IntWidth) {
            IntWidth intWidth2;
            intWidth = intWidth2 = (IntWidth)width2;
        } else if (type instanceof SIntType && (width = (sIntType = (SIntType)type).width()) instanceof IntWidth) {
            IntWidth intWidth3;
            intWidth = intWidth3 = (IntWidth)width;
        } else {
            throw new MatchError((Object)type);
        }
        IntWidth intWidth4 = intWidth;
        return var3_10;
    }

    public Concrete mathPrimitive(PrimOp opCode, Seq<Expression> args, Type tpe) {
        Concrete concrete;
        Concrete arg1 = this.evaluate((Expression)args.head(), this.evaluate$default$2());
        Concrete arg2 = this.evaluate((Expression)((IterableLike)args.tail()).head(), this.evaluate$default$2());
        PrimOp primOp = opCode;
        if (PrimOps.Add$.MODULE$.equals(primOp)) {
            concrete = arg1.$plus(arg2);
        } else if (PrimOps.Sub$.MODULE$.equals(primOp)) {
            concrete = arg1.$minus(arg2);
        } else if (PrimOps.Mul$.MODULE$.equals(primOp)) {
            concrete = arg1.$times(arg2);
        } else if (PrimOps.Div$.MODULE$.equals(primOp)) {
            concrete = arg1.$div(arg2);
        } else if (PrimOps.Rem$.MODULE$.equals(primOp)) {
            concrete = arg1.$percent(arg2);
        } else {
            throw new MatchError((Object)primOp);
        }
        return concrete;
    }

    public Concrete bitSelectOp(PrimOp opCode, Seq<Expression> args, Seq<BigInt> parameters, Type tpe) {
        Concrete e = this.evaluate((Expression)args.head(), this.evaluate$default$2());
        BigInt hi = (BigInt)parameters.head();
        BigInt lo = (BigInt)((IterableLike)parameters.tail()).head();
        return e.bits(hi, lo);
    }

    public Concrete comparisonOp(PrimOp opCode, Seq<Expression> args, Type tpe) {
        ConcreteUInt concreteUInt;
        Concrete arg1 = this.evaluate((Expression)args.head(), this.evaluate$default$2());
        Concrete arg2 = this.evaluate((Expression)((IterableLike)args.tail()).head(), this.evaluate$default$2());
        PrimOp primOp = opCode;
        if (PrimOps.Eq$.MODULE$.equals(primOp)) {
            concreteUInt = arg1.$eq$eq(arg2);
        } else if (PrimOps.Neq$.MODULE$.equals(primOp)) {
            concreteUInt = arg1.$bang$eq(arg2);
        } else if (PrimOps.Lt$.MODULE$.equals(primOp)) {
            concreteUInt = arg1.$less(arg2);
        } else if (PrimOps.Leq$.MODULE$.equals(primOp)) {
            concreteUInt = arg1.$less$eq(arg2);
        } else if (PrimOps.Gt$.MODULE$.equals(primOp)) {
            concreteUInt = arg1.$greater(arg2);
        } else if (PrimOps.Geq$.MODULE$.equals(primOp)) {
            concreteUInt = arg1.$greater$eq(arg2);
        } else {
            throw new MatchError((Object)primOp);
        }
        return concreteUInt;
    }

    public Concrete paddingOp(PrimOp opCode, Seq<Expression> args, Seq<BigInt> parameters, Type tpe) {
        Concrete e = this.evaluate((Expression)args.head(), this.evaluate$default$2());
        BigInt n = (BigInt)parameters.head();
        return e.pad(n);
    }

    public Concrete castingOp(PrimOp opCode, Seq<Expression> args, Type tpe) {
        Product product;
        Concrete e = this.evaluate((Expression)args.head(), this.evaluate$default$2());
        PrimOp primOp = opCode;
        if (PrimOps.AsUInt$.MODULE$.equals(primOp)) {
            product = e.asUInt();
        } else if (PrimOps.AsSInt$.MODULE$.equals(primOp)) {
            product = e.asSInt();
        } else if (PrimOps.AsClock$.MODULE$.equals(primOp)) {
            product = e.asClock();
        } else {
            throw new MatchError((Object)primOp);
        }
        return product;
    }

    public Concrete bitOps(PrimOp opCode, Seq<Expression> args, Seq<BigInt> parameters, Type tpe) {
        Concrete concrete;
        Concrete e = this.evaluate((Expression)args.head(), this.evaluate$default$2());
        BigInt n = (BigInt)parameters.head();
        PrimOp primOp = opCode;
        if (PrimOps.Shl$.MODULE$.equals(primOp)) {
            concrete = e.$less$less(n);
        } else if (PrimOps.Shr$.MODULE$.equals(primOp)) {
            concrete = e.$greater$greater(n);
        } else if (PrimOps.Head$.MODULE$.equals(primOp)) {
            concrete = e.head(n);
        } else if (PrimOps.Tail$.MODULE$.equals(primOp)) {
            concrete = e.tail(n);
        } else {
            throw new MatchError((Object)primOp);
        }
        return concrete;
    }

    public Concrete dynamicBitOps(PrimOp opCode, Seq<Expression> args, Seq<BigInt> parameters, Type tpe) {
        Concrete concrete;
        Concrete e = this.evaluate((Expression)args.head(), this.evaluate$default$2());
        Concrete n = this.evaluate((Expression)((IterableLike)args.tail()).head(), this.evaluate$default$2());
        PrimOp primOp = opCode;
        if (PrimOps.Dshl$.MODULE$.equals(primOp)) {
            concrete = e.$less$less(n);
        } else if (PrimOps.Dshr$.MODULE$.equals(primOp)) {
            concrete = e.$greater$greater(n);
        } else {
            throw new MatchError((Object)primOp);
        }
        return concrete;
    }

    public Concrete oneArgOps(PrimOp opCode, Seq<Expression> args, Seq<BigInt> parameters, Type tpe) {
        Concrete concrete;
        Concrete e = this.evaluate((Expression)args.head(), this.evaluate$default$2());
        PrimOp primOp = opCode;
        if (PrimOps.Cvt$.MODULE$.equals(primOp)) {
            concrete = e.cvt();
        } else if (PrimOps.Neg$.MODULE$.equals(primOp)) {
            concrete = e.neg();
        } else if (PrimOps.Not$.MODULE$.equals(primOp)) {
            concrete = e.not();
        } else if (PrimOps.Andr$.MODULE$.equals(primOp)) {
            concrete = e.andReduce();
        } else if (PrimOps.Orr$.MODULE$.equals(primOp)) {
            concrete = e.orReduce();
        } else if (PrimOps.Xorr$.MODULE$.equals(primOp)) {
            concrete = e.xorReduce();
        } else {
            throw new MatchError((Object)primOp);
        }
        return concrete;
    }

    public Concrete binaryBitWise(PrimOp opCode, Seq<Expression> args, Type tpe) {
        ConcreteUInt concreteUInt;
        Concrete arg1 = this.evaluate((Expression)args.head(), this.evaluate$default$2());
        Concrete arg2 = this.evaluate((Expression)((IterableLike)args.tail()).head(), this.evaluate$default$2());
        PrimOp primOp = opCode;
        if (PrimOps.And$.MODULE$.equals(primOp)) {
            concreteUInt = arg1.$amp(arg2);
        } else if (PrimOps.Or$.MODULE$.equals(primOp)) {
            concreteUInt = arg1.$bar(arg2);
        } else if (PrimOps.Xor$.MODULE$.equals(primOp)) {
            concreteUInt = arg1.$up(arg2);
        } else if (PrimOps.Cat$.MODULE$.equals(primOp)) {
            concreteUInt = arg1.cat(arg2);
        } else {
            throw new MatchError((Object)primOp);
        }
        return concreteUInt;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Concrete evaluate(Expression expression, Option<String> leftHandSideOption) {
        Concrete concrete;
        this.log((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            String string;
            Option option = leftHandSideOption;
            if (option instanceof Some) {
                Some some = (Some)option;
                String key = (String)some.value();
                string = new java.lang.StringBuilder(18).append("evaluate     ").append(leftHandSideOption.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(" <= ").append(expression.serialize()).append(" ").append(this.dependencyGraph().getInfo(key)).toString();
            } else {
                string = new java.lang.StringBuilder(13).append("evaluate     ").append(expression.serialize()).toString();
            }
            return string;
        });
        this.indent();
        if (!this.evaluationStack().push(leftHandSideOption, expression) && this.allowCombinationalLoops()) {
            this.log((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(65).append("Combinational loop detected, second evaluation of ").append(leftHandSideOption.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(", returning 1.U").toString());
            return new ConcreteUInt(BigInt$.MODULE$.int2bigInt(1), 1, ConcreteUInt$.MODULE$.apply$default$3());
        }
        try {
            Reference reference;
            Option option;
            Concrete concrete2;
            Expression expression2 = expression;
            if (expression2 instanceof Mux) {
                Concrete concrete3;
                Mux mux = (Mux)expression2;
                Expression condition = mux.cond();
                Expression trueExpression = mux.tval();
                Expression falseExpression = mux.fval();
                Type tpe = mux.tpe();
                Concrete concrete4 = this.evaluate(condition, this.evaluate$default$2());
                if (!(concrete4 instanceof ConcreteUInt)) throw InterpreterException$.MODULE$.apply(new java.lang.StringBuilder(30).append("mux(").append(condition).append(") must be (0|1).U<1> was ").append(concrete4).append(" ").append(this.sourceInfo$1(leftHandSideOption)).toString());
                ConcreteUInt concreteUInt = (ConcreteUInt)concrete4;
                BigInt value = concreteUInt.value();
                int n = concreteUInt.width();
                if (1 != n) throw InterpreterException$.MODULE$.apply(new java.lang.StringBuilder(30).append("mux(").append(condition).append(") must be (0|1).U<1> was ").append(concrete4).append(" ").append(this.sourceInfo$1(leftHandSideOption)).toString());
                if (value.$greater((Object)BigInt$.MODULE$.int2bigInt(0))) {
                    Object object = this.evaluateAll() ? this.evaluate(falseExpression, this.evaluate$default$2()) : BoxedUnit.UNIT;
                    concrete3 = this.evaluate(trueExpression, this.evaluate$default$2());
                } else {
                    Object object = this.evaluateAll() ? this.evaluate(trueExpression, this.evaluate$default$2()) : BoxedUnit.UNIT;
                    concrete3 = this.evaluate(falseExpression, this.evaluate$default$2());
                }
                Concrete v = concrete3;
                Concrete concrete5 = v.forceWidth(tpe);
                concrete2 = concrete5;
            } else if (expression2 instanceof Reference && !(option = WRef$.MODULE$.unapply(reference = (Reference)expression2)).isEmpty()) {
                String name = (String)((Tuple4)option.get())._1();
                Type tpe = (Type)((Tuple4)option.get())._2();
                concrete2 = this.getValue(name).forceWidth(tpe);
            } else if (expression2 instanceof SubField) {
                SubField subField = (SubField)expression2;
                String name = subField.serialize();
                concrete2 = this.getValue(name).forceWidth(subField.tpe());
            } else if (expression2 instanceof SubIndex) {
                SubIndex subIndex = (SubIndex)expression2;
                String name = subIndex.serialize();
                concrete2 = this.getValue(name).forceWidth(subIndex.tpe());
            } else if (expression2 instanceof ValidIf) {
                Concrete concrete6;
                ValidIf validIf = (ValidIf)expression2;
                Expression condition = validIf.cond();
                Expression value = validIf.value();
                Type tpe = validIf.tpe();
                if (this.evaluate(condition, this.evaluate$default$2()).value().$greater((Object)BigInt$.MODULE$.int2bigInt(0))) {
                    concrete6 = this.evaluate(value, this.evaluate$default$2()).forceWidth(tpe);
                } else {
                    void var5_37;
                    IntWidth intWidth;
                    Option option2;
                    SIntType sIntType;
                    Width width;
                    IntWidth intWidth2;
                    Option option3;
                    UIntType uIntType;
                    Width width2;
                    Object object = this.evaluateAll() ? this.evaluate(value, this.evaluate$default$2()) : BoxedUnit.UNIT;
                    Type type = tpe;
                    if (type instanceof UIntType && (width2 = (uIntType = (UIntType)type).width()) instanceof IntWidth && !(option3 = IntWidth$.MODULE$.unapply(intWidth2 = (IntWidth)width2)).isEmpty()) {
                        BigInt w = (BigInt)option3.get();
                        ConcreteUInt concreteUInt = Concrete$.MODULE$.randomUInt(w.toInt(), Concrete$.MODULE$.randomUInt$default$2());
                    } else if (type instanceof SIntType && (width = (sIntType = (SIntType)type).width()) instanceof IntWidth && !(option2 = IntWidth$.MODULE$.unapply(intWidth = (IntWidth)width)).isEmpty()) {
                        BigInt w = (BigInt)option2.get();
                        ConcreteSInt concreteSInt = Concrete$.MODULE$.randomSInt(w.toInt(), Concrete$.MODULE$.randomSInt$default$2());
                    } else {
                        if (!ClockType$.MODULE$.equals(type)) throw InterpreterException$.MODULE$.apply(new java.lang.StringBuilder(32).append("ValidIf found unsupported type: ").append(type).toString());
                        ConcreteClock concreteClock = Concrete$.MODULE$.randomClock();
                    }
                    concrete6 = (Concrete)var5_37;
                }
                concrete2 = concrete6;
            } else if (expression2 instanceof DoPrim) {
                Concrete concrete7;
                DoPrim doPrim = (DoPrim)expression2;
                PrimOp op = doPrim.op();
                Seq args = doPrim.args();
                Seq seq = doPrim.consts();
                Type tpe = doPrim.tpe();
                PrimOp primOp = op;
                if (PrimOps.Add$.MODULE$.equals(primOp)) {
                    concrete7 = this.mathPrimitive(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Sub$.MODULE$.equals(primOp)) {
                    concrete7 = this.mathPrimitive(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Mul$.MODULE$.equals(primOp)) {
                    concrete7 = this.mathPrimitive(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Div$.MODULE$.equals(primOp)) {
                    concrete7 = this.mathPrimitive(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Rem$.MODULE$.equals(primOp)) {
                    concrete7 = this.mathPrimitive(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Eq$.MODULE$.equals(primOp)) {
                    concrete7 = this.comparisonOp(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Neq$.MODULE$.equals(primOp)) {
                    concrete7 = this.comparisonOp(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Lt$.MODULE$.equals(primOp)) {
                    concrete7 = this.comparisonOp(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Leq$.MODULE$.equals(primOp)) {
                    concrete7 = this.comparisonOp(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Gt$.MODULE$.equals(primOp)) {
                    concrete7 = this.comparisonOp(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Geq$.MODULE$.equals(primOp)) {
                    concrete7 = this.comparisonOp(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Pad$.MODULE$.equals(primOp)) {
                    concrete7 = this.paddingOp(op, (Seq<Expression>)args, (Seq<BigInt>)seq, tpe);
                } else if (PrimOps.AsUInt$.MODULE$.equals(primOp)) {
                    concrete7 = this.castingOp(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.AsSInt$.MODULE$.equals(primOp)) {
                    concrete7 = this.castingOp(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.AsClock$.MODULE$.equals(primOp)) {
                    concrete7 = this.castingOp(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Shl$.MODULE$.equals(primOp)) {
                    concrete7 = this.bitOps(op, (Seq<Expression>)args, (Seq<BigInt>)seq, tpe);
                } else if (PrimOps.Shr$.MODULE$.equals(primOp)) {
                    concrete7 = this.bitOps(op, (Seq<Expression>)args, (Seq<BigInt>)seq, tpe);
                } else if (PrimOps.Dshl$.MODULE$.equals(primOp)) {
                    concrete7 = this.dynamicBitOps(op, (Seq<Expression>)args, (Seq<BigInt>)seq, tpe);
                } else if (PrimOps.Dshr$.MODULE$.equals(primOp)) {
                    concrete7 = this.dynamicBitOps(op, (Seq<Expression>)args, (Seq<BigInt>)seq, tpe);
                } else if (PrimOps.Cvt$.MODULE$.equals(primOp)) {
                    concrete7 = this.oneArgOps(op, (Seq<Expression>)args, (Seq<BigInt>)seq, tpe);
                } else if (PrimOps.Neg$.MODULE$.equals(primOp)) {
                    concrete7 = this.oneArgOps(op, (Seq<Expression>)args, (Seq<BigInt>)seq, tpe);
                } else if (PrimOps.Not$.MODULE$.equals(primOp)) {
                    concrete7 = this.oneArgOps(op, (Seq<Expression>)args, (Seq<BigInt>)seq, tpe);
                } else if (PrimOps.And$.MODULE$.equals(primOp)) {
                    concrete7 = this.binaryBitWise(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Or$.MODULE$.equals(primOp)) {
                    concrete7 = this.binaryBitWise(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Xor$.MODULE$.equals(primOp)) {
                    concrete7 = this.binaryBitWise(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Andr$.MODULE$.equals(primOp)) {
                    concrete7 = this.oneArgOps(op, (Seq<Expression>)args, (Seq<BigInt>)seq, tpe);
                } else if (PrimOps.Orr$.MODULE$.equals(primOp)) {
                    concrete7 = this.oneArgOps(op, (Seq<Expression>)args, (Seq<BigInt>)seq, tpe);
                } else if (PrimOps.Xorr$.MODULE$.equals(primOp)) {
                    concrete7 = this.oneArgOps(op, (Seq<Expression>)args, (Seq<BigInt>)seq, tpe);
                } else if (PrimOps.Cat$.MODULE$.equals(primOp)) {
                    concrete7 = this.binaryBitWise(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Bits$.MODULE$.equals(primOp)) {
                    concrete7 = this.bitSelectOp(op, (Seq<Expression>)args, (Seq<BigInt>)seq, tpe);
                } else if (PrimOps.Head$.MODULE$.equals(primOp)) {
                    concrete7 = this.bitOps(op, (Seq<Expression>)args, (Seq<BigInt>)seq, tpe);
                } else {
                    if (!PrimOps.Tail$.MODULE$.equals(primOp)) throw new InterruptedException(new java.lang.StringBuilder(30).append("PrimOP ").append(op).append(" in ").append(expression).append(" not yet supported ").append(this.sourceInfo$1(leftHandSideOption)).toString());
                    concrete7 = this.bitOps(op, (Seq<Expression>)args, (Seq<BigInt>)seq, tpe);
                }
                Concrete v = concrete7;
                concrete2 = v.forceWidth(tpe);
            } else if (expression2 instanceof UIntLiteral) {
                UIntLiteral uIntLiteral = (UIntLiteral)expression2;
                concrete2 = Concrete$.MODULE$.apply(uIntLiteral).forceWidth((Type)uIntLiteral.tpe());
            } else if (expression2 instanceof SIntLiteral) {
                SIntLiteral sIntLiteral = (SIntLiteral)expression2;
                concrete2 = Concrete$.MODULE$.apply(sIntLiteral).forceWidth((Type)sIntLiteral.tpe());
            } else {
                if (!(expression2 instanceof BlackBoxOutput)) throw new MatchError((Object)expression2);
                BlackBoxOutput blackBoxOutput = (BlackBoxOutput)expression2;
                this.log((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(17).append("got a black box, ").append((Object)blackBoxOutput).toString());
                Seq concreteInputs = (Seq)blackBoxOutput.dependentInputs().map((Function1 & Serializable & scala.Serializable)input -> this.getValue((String)input), Seq$.MODULE$.canBuildFrom());
                concrete2 = blackBoxOutput.execute((Seq<Concrete>)concreteInputs);
            }
            concrete = concrete2;
        }
        catch (Exception ie) {
            if (this.exceptionCaught()) throw ie;
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(30).append("Exception during evaluation: ").append(ie.getMessage()).append(" ").append(this.sourceInfo$1(leftHandSideOption)).toString());
            this.showStack();
            this.exceptionCaught_$eq(true);
            throw ie;
        }
        catch (AssertionError ie) {
            if (this.exceptionCaught()) throw ie;
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(30).append("Assertion during evaluation: ").append(((Throwable)((Object)ie)).getMessage()).append(" ").append(this.sourceInfo$1(leftHandSideOption)).toString());
            this.showStack();
            this.exceptionCaught_$eq(true);
            throw ie;
        }
        Concrete result = concrete;
        this.evaluationStack().pop();
        this.dedent();
        this.log((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            Option option = leftHandSideOption;
            String string = option instanceof Some ? new java.lang.StringBuilder(17).append("evaluated    ").append(leftHandSideOption.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(" <= ").append(result).toString() : new java.lang.StringBuilder(14).append("evaluated     ").append(result).toString();
            return string;
        });
        return result;
    }

    public Option<String> evaluate$default$2() {
        return None$.MODULE$;
    }

    public void showStack() {
        Predef$.MODULE$.println((Object)"Expression Evaluation stack");
        Predef$.MODULE$.println((Object)this.evaluationStack().stackListing());
    }

    public Concrete resolveRegister(String key) {
        Concrete concrete;
        DefRegister registerDef = (DefRegister)this.dependencyGraph().registers().apply((Object)key);
        Concrete resetCondition = this.evaluate(registerDef.reset(), this.evaluate$default$2());
        if (resetCondition.value().$greater((Object)BigInt$.MODULE$.int2bigInt(0))) {
            Concrete resetValue;
            concrete = resetValue = this.evaluate(registerDef.init(), this.evaluate$default$2()).forceWidth(package$.MODULE$.typeToWidth((Type)this.dependencyGraph().nameToType().apply((Object)registerDef.name())));
        } else {
            Expression expression = (Expression)this.dependencyGraph().nameToExpression().apply((Object)key);
            concrete = this.evaluate(expression, (Option<String>)new Some((Object)key));
        }
        Concrete newValue = concrete;
        return newValue;
    }

    /*
     * WARNING - void declaration
     */
    private Concrete resolveDependency(String key) {
        void var2_2;
        this.resolveDepth_$eq(this.resolveDepth() + 1);
        Concrete value = (Concrete)this.timer().apply(key, (Function0 & Serializable & scala.Serializable)() -> {
            Concrete concrete;
            if (this.circuitState().isInput(key)) {
                concrete = (Concrete)this.circuitState().getValue(key).get();
            } else if (this.circuitState().isRegister(key)) {
                concrete = this.resolveRegister(key);
            } else if (this.dependencyGraph().nameToExpression().contains((Object)key)) {
                Expression expression = (Expression)this.dependencyGraph().nameToExpression().apply((Object)key);
                concrete = this.evaluate(expression, (Option<String>)new Some((Object)key));
            } else if (this.dependencyGraph().memoryKeys().contains((Object)key)) {
                concrete = ((Memory)this.dependencyGraph().memoryKeys().apply((Object)key)).getValue(key);
            } else {
                throw new InterpreterException(new java.lang.StringBuilder(38).append("error: don't know what to do with key ").append(key).toString());
            }
            return concrete;
        });
        Object object = this.useTopologicalSortedKeys() && !this.keyOrderInitialized() ? this.orderedKeysToResolve().$plus$eq((Object)key) : BoxedUnit.UNIT;
        this.circuitState().setValue(key, value, this.circuitState().setValue$default$3());
        this.resolveDepth_$eq(this.resolveDepth() - 1);
        return var2_2;
    }

    public void resolveDependencies(Iterable<String> specificDependencies) {
        block1: {
            WrappedArray toResolve = specificDependencies.nonEmpty() ? specificDependencies : (this.useTopologicalSortedKeys() && this.keyOrderInitialized() ? this.orderedKeysToResolve() : Predef$.MODULE$.wrapRefArray((Object[])this.defaultKeysToResolve()));
            this.exceptionCaught_$eq(false);
            this.evaluationStack().clear();
            toResolve.foreach((Function1 & Serializable & scala.Serializable)key -> this.resolveDependency((String)key));
            if (!this.useTopologicalSortedKeys() || this.keyOrderInitialized()) break block1;
            if (this.verbose()) {
                Predef$.MODULE$.println((Object)new java.lang.StringBuilder(10).append("Key order ").append(this.orderedKeysToResolve().mkString("\n")).toString());
            }
            this.keyOrderInitialized_$eq(true);
        }
    }

    public Option<Object> checkStops() {
        None$ none$;
        Object object = new Object();
        try {
            this.dependencyGraph().stops().foreach((Function1 & Serializable & scala.Serializable)stopStatement -> {
                LoFirrtlExpressionEvaluator.$anonfun$checkStops$1(this, object, stopStatement);
                return BoxedUnit.UNIT;
            });
            none$ = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                none$ = (Option)ex.value();
            }
            throw ex;
        }
        return none$;
    }

    public String executeFormattedPrint(String formatString, Seq<Object> allArgs) {
        StringBuilder outBuffer = new StringBuilder();
        String s = formatString;
        Seq args = allArgs;
        block3: while (new StringOps(Predef$.MODULE$.augmentString(s)).nonEmpty()) {
            char c;
            char c2;
            BoxedUnit boxedUnit;
            int n = s.indexOf("%");
            switch (n) {
                case -1: {
                    outBuffer.$plus$plus$eq(s);
                    s = "";
                    continue block3;
                }
            }
            outBuffer.$plus$plus$eq((String)new StringOps(Predef$.MODULE$.augmentString(s)).take(n));
            s = (String)new StringOps(Predef$.MODULE$.augmentString(s)).drop(n + 1);
            boolean bl = false;
            Some some = null;
            Option option = new StringOps(Predef$.MODULE$.augmentString(s)).headOption();
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                char c3 = BoxesRunTime.unboxToChar((Object)some.value());
                if ('%' == c3) {
                    outBuffer.$plus$plus$eq("%");
                    s = (String)new StringOps(Predef$.MODULE$.augmentString(s)).tail();
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
            }
            if (bl && 'b' == (c2 = BoxesRunTime.unboxToChar((Object)some.value()))) {
                outBuffer.$plus$plus$eq(scala.package$.MODULE$.BigInt().apply(args.head().toString()).toString(2));
                args = (Seq)args.tail();
                s = (String)new StringOps(Predef$.MODULE$.augmentString(s)).tail();
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (bl && 'c' == (c = BoxesRunTime.unboxToChar((Object)some.value()))) {
                outBuffer.$plus$eq(scala.package$.MODULE$.BigInt().apply(args.head().toString()).toChar());
                args = (Seq)args.tail();
                s = (String)new StringOps(Predef$.MODULE$.augmentString(s)).tail();
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (bl) {
                char specifier = BoxesRunTime.unboxToChar((Object)some.value());
                outBuffer.$plus$plus$eq(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(1).append("%").append(specifier).toString())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scala.package$.MODULE$.BigInt().apply(args.head().toString())})));
                args = (Seq)args.tail();
                s = (String)new StringOps(Predef$.MODULE$.augmentString(s)).tail();
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            s = "";
            boxedUnit = BoxedUnit.UNIT;
        }
        return StringContext$.MODULE$.treatEscapes(outBuffer.toString());
    }

    public void checkPrints() {
        this.dependencyGraph().prints().foreach((Function1 & Serializable & scala.Serializable)printStatement -> {
            LoFirrtlExpressionEvaluator.$anonfun$checkPrints$1(this, printStatement);
            return BoxedUnit.UNIT;
        });
    }

    private int resolveDepth() {
        return this.resolveDepth;
    }

    private void resolveDepth_$eq(int x$1) {
        this.resolveDepth = x$1;
    }

    private void indent() {
        this.resolveDepth_$eq(this.resolveDepth() + 1);
    }

    private void dedent() {
        this.resolveDepth_$eq(this.resolveDepth() - 1);
    }

    @Override
    public void log(Function0<String> message) {
        block0: {
            if (!this.verbose()) break block0;
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(this.resolveDepth() * 2)).append(message.apply()).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$defaultKeysToResolve$2(LoFirrtlExpressionEvaluator $this, String key) {
        return $this.dependencyGraph().nameToExpression().contains((Object)key);
    }

    private final String sourceInfo$1(Option leftHandSideOption$1) {
        String string;
        Option option = leftHandSideOption$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            String key = (String)some.value();
            string = this.dependencyGraph().getInfo(key);
        } else {
            string = "";
        }
        return string;
    }

    public static final /* synthetic */ void $anonfun$checkStops$1(LoFirrtlExpressionEvaluator $this, Object nonLocalReturnKey1$1, Stop stopStatement) {
        if ($this.evaluate(stopStatement.en(), (Option<String>)new Some((Object)"stop")).value().$greater((Object)BigInt$.MODULE$.int2bigInt(0))) {
            if (stopStatement.ret() == 0) {
                Predef$.MODULE$.println((Object)new java.lang.StringBuilder(8).append("Success:").append(stopStatement.info()).toString());
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)));
            }
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(18).append("Failure:").append(stopStatement.info()).append(" returned ").append(stopStatement.ret()).toString());
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)BoxesRunTime.boxToInteger((int)stopStatement.ret())));
        }
    }

    public static final /* synthetic */ void $anonfun$checkPrints$1(LoFirrtlExpressionEvaluator $this, Print printStatement) {
        block0: {
            Concrete condition = $this.evaluate(printStatement.en(), $this.evaluate$default$2());
            if (!condition.value().$greater((Object)BigInt$.MODULE$.int2bigInt(0))) break block0;
            Seq resolvedArgs = (Seq)printStatement.args().map((Function1 & Serializable & scala.Serializable)arg -> $this.evaluate((Expression)arg, $this.evaluate$default$2()).value(), Seq$.MODULE$.canBuildFrom());
            String formatString = printStatement.string().serialize();
            Predef$.MODULE$.print((Object)$this.executeFormattedPrint(formatString, (Seq<Object>)resolvedArgs));
        }
    }

    public LoFirrtlExpressionEvaluator(DependencyGraph dependencyGraph, CircuitState circuitState) {
        this.dependencyGraph = dependencyGraph;
        this.circuitState = circuitState;
        package.SimpleLogger.$init$(this);
        this.toResolve = (HashSet)HashSet$.MODULE$.apply(dependencyGraph.keys().toSeq());
        this.evaluateAll = false;
        this.exceptionCaught = false;
        this.useTopologicalSortedKeys = false;
        this.allowCombinationalLoops = false;
        this.evaluationStack = new ExpressionExecutionStack(this);
        HashSet keys = new HashSet();
        keys.$plus$plus$eq((TraversableOnce)((TraversableLike)circuitState.memories().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Memory memory = (Memory)tuple2._2();
            Seq<String> seq = memory.getAllFieldDependencies();
            return seq;
        }, Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)LoFirrtlExpressionEvaluator.$anonfun$defaultKeysToResolve$2(this, key))));
        keys.$plus$plus$eq(dependencyGraph.outputPorts());
        keys.$plus$plus$eq(dependencyGraph.registerNames());
        this.defaultKeysToResolve = (String[])keys.toArray(ClassTag$.MODULE$.apply(String.class));
        this.keyOrderInitialized = false;
        this.orderedKeysToResolve = new ArrayBuffer();
        this.timer = new Timer();
        this.timer().enabled_$eq(false);
        this.resolveDepth = 0;
    }
}

