/*
 * Decompiled with CFR 0.152.
 */
package firrtl_interpreter;

import firrtl_interpreter.Concrete;
import firrtl_interpreter.ConcreteSInt;
import firrtl_interpreter.InterpreterException$;
import firrtl_interpreter.InterpreterOptions;
import firrtl_interpreter.NumberMonitor;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001E4Aa\u0005\u000b\u0001/!Aa\u0004\u0001B\u0001B\u0003%q\u0004C\u0003$\u0001\u0011\u0005A\u0005C\u0004(\u0001\t\u0007I\u0011\u0001\u0015\t\r}\u0002\u0001\u0015!\u0003*\u0011\u001d\u0001\u0005A1A\u0005\u0002\u0005Ca!\u0012\u0001!\u0002\u0013\u0011\u0005b\u0002$\u0001\u0005\u0004%\ta\u0012\u0005\u0007!\u0002\u0001\u000b\u0011\u0002%\t\u000fE\u0003!\u0019!C\u0001%\"1a\u000b\u0001Q\u0001\nMCqa\u0016\u0001C\u0002\u0013\u0005\u0011\t\u0003\u0004Y\u0001\u0001\u0006IA\u0011\u0005\b3\u0002\u0011\r\u0011\"\u0003[\u0011\u0019q\u0006\u0001)A\u00057\")q\f\u0001C\u0001A\")1\r\u0001C\u0001I\")a\u000e\u0001C\u0001_\")\u0001\u000f\u0001C\u0001_\nqQj\u001c8ji>\u0014X*\u00198bO\u0016\u0014(\"A\u000b\u0002%\u0019L'O\u001d;m?&tG/\u001a:qe\u0016$XM]\u0002\u0001'\t\u0001\u0001\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VMZ\u0001\b_B$\u0018n\u001c8t!\t\u0001\u0013%D\u0001\u0015\u0013\t\u0011CC\u0001\nJ]R,'\u000f\u001d:fi\u0016\u0014x\n\u001d;j_:\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u0002&MA\u0011\u0001\u0005\u0001\u0005\u0006=\t\u0001\raH\u0001\u000e[>t\u0017\u000e^8s%\u0016\u001cwN\u001d3\u0016\u0003%\u0002BAK\u00182y5\t1F\u0003\u0002-[\u00059Q.\u001e;bE2,'B\u0001\u0018\u001b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003a-\u0012q\u0001S1tQ6\u000b\u0007\u000f\u0005\u00023s9\u00111g\u000e\t\u0003iii\u0011!\u000e\u0006\u0003mY\ta\u0001\u0010:p_Rt\u0014B\u0001\u001d\u001b\u0003\u0019\u0001&/\u001a3fM&\u0011!h\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005aR\u0002C\u0001\u0011>\u0013\tqDCA\u0007Ok6\u0014WM]'p]&$xN]\u0001\u000f[>t\u0017\u000e^8s%\u0016\u001cwN\u001d3!\u00031)\u0007p\u00197vI\u0016$V-\u001c9t+\u0005\u0011\u0005CA\rD\u0013\t!%DA\u0004C_>dW-\u00198\u0002\u001b\u0015D8\r\\;eKR+W\u000e]:!\u0003)a\u0015.\\5u%\u0016<W\r_\u000b\u0002\u0011B\u0011\u0011JT\u0007\u0002\u0015*\u00111\nT\u0001\t[\u0006$8\r[5oO*\u0011QJG\u0001\u0005kRLG.\u0003\u0002P\u0015\n)!+Z4fq\u0006YA*[7jiJ+w-\u001a=!\u00031qW/\u001c2fe>3')\u001b8t+\u0005\u0019\u0006CA\rU\u0013\t)&DA\u0002J]R\fQB\\;nE\u0016\u0014xJ\u001a\"j]N\u0004\u0013!\u00059sKR$\u0018\u0010\u0015:j]R\u0014V\r]8si\u0006\u0011\u0002O]3uif\u0004&/\u001b8u%\u0016\u0004xN\u001d;!\u0003)\u0011\u0017N\u001c'pONK'0Z\u000b\u00027B\u0011\u0011\u0004X\u0005\u0003;j\u0011a\u0001R8vE2,\u0017a\u00032j]2{wmU5{K\u0002\n1\"\u001b8dYV$W\r\u00165jgR\u0011!)\u0019\u0005\u0006E>\u0001\r!M\u0001\u0004W\u0016L\u0018aD7p]&$xN]*fiZ\u000bG.^3\u0015\u0007\u0015D\u0017\u000e\u0005\u0002\u001aM&\u0011qM\u0007\u0002\u0005+:LG\u000fC\u0003c!\u0001\u0007\u0011\u0007C\u0003k!\u0001\u00071.\u0001\u0005d_:\u001c'/\u001a;f!\t\u0001C.\u0003\u0002n)\tA1i\u001c8de\u0016$X-\u0001\u0007sK:$WM\u001d%fC\u0012,'/F\u00012\u00035iwN\\5u_J\u0014V\r]8si\u0002")
public class MonitorManager {
    private final HashMap<String, NumberMonitor> monitorRecord = new HashMap();
    private final boolean excludeTemps;
    private final Regex LimitRegex;
    private final int numberOfBins;
    private final boolean prettyPrintReport;
    private final double binLogSize;

    public HashMap<String, NumberMonitor> monitorRecord() {
        return this.monitorRecord;
    }

    public boolean excludeTemps() {
        return this.excludeTemps;
    }

    public Regex LimitRegex() {
        return this.LimitRegex;
    }

    public int numberOfBins() {
        return this.numberOfBins;
    }

    public boolean prettyPrintReport() {
        return this.prettyPrintReport;
    }

    private double binLogSize() {
        return this.binLogSize;
    }

    public boolean includeThis(String key) {
        return this.LimitRegex().findFirstIn((CharSequence)key).isEmpty() || !this.excludeTemps();
    }

    public void monitorSetValue(String key, Concrete concrete) {
        block2: {
            NumberMonitor numberMonitor;
            if (concrete.poisoned() || !this.includeThis(key)) break block2;
            Option option = this.monitorRecord().get((Object)key);
            if (option instanceof Some) {
                NumberMonitor m;
                Some some = (Some)option;
                numberMonitor = m = (NumberMonitor)some.value();
            } else {
                this.monitorRecord().update((Object)key, (Object)new NumberMonitor(key, concrete instanceof ConcreteSInt, concrete.width(), this.numberOfBins()));
                numberMonitor = (NumberMonitor)this.monitorRecord().apply((Object)key);
            }
            NumberMonitor monitor = numberMonitor;
            monitor.update(concrete.value());
        }
    }

    public String renderHeader() {
        String string;
        if (this.prettyPrintReport()) {
            String arg$macro$1 = "type";
            String arg$macro$2 = "n";
            String arg$macro$3 = "min";
            String arg$macro$4 = "max";
            String arg$macro$5 = "mean";
            String arg$macro$7 = "stddev";
            String arg$macro$8 = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numberOfBins()).map((Function1 & Serializable & scala.Serializable)x -> MonitorManager.$anonfun$renderHeader$1(BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(",", ",", "");
            string = new StringBuilder(0).append(new StringOps("%10s,%8s,%8s,%16s,%16s,").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, arg$macro$3, arg$macro$4, arg$macro$5}))).append(new StringOps("%16s%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$7, arg$macro$8}))).toString();
        } else {
            string = new StringBuilder(26).append("type").append(",").append("n").append(",").append("min").append(",").append("max").append(",").append("mean").append(",").append("stddev").append(((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numberOfBins()).map((Function1 & Serializable & scala.Serializable)x -> MonitorManager.$anonfun$renderHeader$2(BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(",", ",", "")).toString();
        }
        return string;
    }

    public String monitorReport() {
        String string;
        Option option = this.monitorRecord().values().headOption();
        if (option instanceof Some) {
            String string2;
            if (this.prettyPrintReport()) {
                String arg$macro$1 = "key,";
                String arg$macro$2 = this.renderHeader();
                string2 = new StringOps("%-40.40s%s\n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2}));
            } else {
                string2 = new StringBuilder(5).append("key").append(",").append(this.renderHeader()).append("\n").toString();
            }
            string = string2;
        } else {
            string = "";
        }
        String headerString = string;
        return new StringBuilder(0).append(headerString).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.monitorRecord().keys().toArray(ClassTag$.MODULE$.apply(String.class)))).sorted((Ordering)Ordering.String$.MODULE$))).map((Function1 & Serializable & scala.Serializable)key -> {
            String string;
            if (this.prettyPrintReport()) {
                String arg$macro$3 = key;
                String arg$macro$4 = ((NumberMonitor)this.monitorRecord().apply(key)).render(this.prettyPrintReport());
                string = new StringOps("%-40.40s %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$3, arg$macro$4}));
            } else {
                string = new StringBuilder(1).append((String)key).append(",").append(((NumberMonitor)this.monitorRecord().apply(key)).render(this.prettyPrintReport())).toString();
            }
            return string;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("\n")).toString();
    }

    public static final /* synthetic */ String $anonfun$renderHeader$1(int x) {
        String arg$macro$6 = new StringBuilder(3).append("bin").append(x).toString();
        return new StringOps("%8s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$6}));
    }

    public static final /* synthetic */ String $anonfun$renderHeader$2(int x) {
        return new StringBuilder(3).append("bin").append(x).toString();
    }

    public MonitorManager(InterpreterOptions options) {
        this.excludeTemps = !options.monitorTrackTempNodes();
        this.LimitRegex = new StringOps(Predef$.MODULE$.augmentString("^_?(GEN_|T_).*")).r();
        this.numberOfBins = options.monitorHistogramBins();
        this.prettyPrintReport = options.prettyPrintReport();
        this.binLogSize = package$.MODULE$.log((double)this.numberOfBins()) / package$.MODULE$.log(2.0);
        if (this.numberOfBins() > 0 && this.binLogSize() != (double)((int)this.binLogSize())) {
            throw InterpreterException$.MODULE$.apply(new StringBuilder(54).append("monitorHistogramBins ").append(this.numberOfBins()).append(" must be a power of 2, but is not").toString());
        }
    }
}

