/*
 * Decompiled with CFR 0.152.
 */
package firrtl_interpreter;

import firrtl_interpreter.Timer$;
import firrtl_interpreter.TimerEvent;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y<Q!\u0006\f\t\u0002e1Qa\u0007\f\t\u0002qAQaI\u0001\u0005\u0002\u0011Bq!J\u0001C\u0002\u0013\u0005a\u0005\u0003\u0004+\u0003\u0001\u0006Ia\n\u0004\u00057Y\u00011\u0006C\u0003$\u000b\u0011\u0005A\u0006C\u0004/\u000b\u0001\u0007I\u0011A\u0018\t\u000fM*\u0001\u0019!C\u0001i!1!(\u0002Q!\nABqaO\u0003C\u0002\u0013\u0005A\b\u0003\u0004T\u000b\u0001\u0006I!\u0010\u0005\b)\u0016\u0011\r\u0011\"\u0001V\u0011\u00191V\u0001)A\u0005!\")q+\u0002C\u00011\")Q.\u0002C\u0001]\")\u0001/\u0002C\u0001c\")A/\u0002C\u0001k\")q/\u0002C\u0001q\")!0\u0002C\u0001w\")A0\u0002C\u0001{\u0006)A+[7fe*\tq#\u0001\ngSJ\u0014H\u000f\\0j]R,'\u000f\u001d:fi\u0016\u00148\u0001\u0001\t\u00035\u0005i\u0011A\u0006\u0002\u0006)&lWM]\n\u0003\u0003u\u0001\"AH\u0011\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001a\u0003!!VM\u001c+psQDW#A\u0014\u0011\u0005yA\u0013BA\u0015 \u0005\u0019!u.\u001e2mK\u0006IA+\u001a8U_f\"\b\u000eI\n\u0003\u000bu!\u0012!\f\t\u00035\u0015\tq!\u001a8bE2,G-F\u00011!\tq\u0012'\u0003\u00023?\t9!i\\8mK\u0006t\u0017aC3oC\ndW\rZ0%KF$\"!\u000e\u001d\u0011\u0005y1\u0014BA\u001c \u0005\u0011)f.\u001b;\t\u000feB\u0011\u0011!a\u0001a\u0005\u0019\u0001\u0010J\u0019\u0002\u0011\u0015t\u0017M\u00197fI\u0002\n\u0011\u0002^5nS:<Gj\\4\u0016\u0003u\u0002BAP\"F!6\tqH\u0003\u0002A\u0003\u00069Q.\u001e;bE2,'B\u0001\" \u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\t~\u0012q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002G\u001b:\u0011qi\u0013\t\u0003\u0011~i\u0011!\u0013\u0006\u0003\u0015b\ta\u0001\u0010:p_Rt\u0014B\u0001' \u0003\u0019\u0001&/\u001a3fM&\u0011aj\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u00051{\u0002C\u0001\u000eR\u0013\t\u0011fC\u0001\u0006US6,'/\u0012<f]R\f!\u0002^5nS:<Gj\\4!\u0003)!x\u000e^1m\u000bZ,g\u000e^\u000b\u0002!\u0006YAo\u001c;bY\u00163XM\u001c;!\u0003\u0015\t\u0007\u000f\u001d7z+\tIV\f\u0006\u0002[WR\u00111L\u001a\t\u00039vc\u0001\u0001B\u0003_\u001d\t\u0007qLA\u0001S#\t\u00017\r\u0005\u0002\u001fC&\u0011!m\b\u0002\b\u001d>$\b.\u001b8h!\tqB-\u0003\u0002f?\t\u0019\u0011I\\=\t\r\u001dtA\u00111\u0001i\u0003\u0015\u0011Gn\\2l!\rq\u0012nW\u0005\u0003U~\u0011\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\u0006Y:\u0001\r!R\u0001\u0004i\u0006<\u0017\u0001C3oiJLhi\u001c:\u0015\u0005\u0015{\u0007\"\u00027\u0010\u0001\u0004)\u0015a\u00039sKR$\u00180\u00128uef$\"!\u0012:\t\u000bM\u0004\u0002\u0019\u0001)\u0002\u000b\u0015tGO]=\u0002#A\u0014X\r\u001e;z\u000b:$(/\u001f$peR\u000bw\r\u0006\u0002Fm\")A.\u0005a\u0001\u000b\u0006q\u0001O]3uifd\u0015m\u001d;US6,GCA#z\u0011\u0015a'\u00031\u0001F\u0003\u0015\u0019G.Z1s)\u0005)\u0014A\u0002:fa>\u0014H\u000fF\u0001F\u0001")
public class Timer {
    private boolean enabled = true;
    private final HashMap<String, TimerEvent> timingLog = new HashMap();
    private final TimerEvent totalEvent = new TimerEvent("Total");

    public static double TenTo9th() {
        return Timer$.MODULE$.TenTo9th();
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void enabled_$eq(boolean x$1) {
        this.enabled = x$1;
    }

    public HashMap<String, TimerEvent> timingLog() {
        return this.timingLog;
    }

    public TimerEvent totalEvent() {
        return this.totalEvent;
    }

    public <R> R apply(String tag, Function0<R> block) {
        Object object;
        if (this.enabled()) {
            long t0 = System.nanoTime();
            Object result = block.apply();
            long t1 = System.nanoTime();
            TimerEvent timerEvent = (TimerEvent)this.timingLog().getOrElseUpdate((Object)tag, (Function0 & java.io.Serializable & Serializable)() -> new TimerEvent(tag));
            timerEvent.events_$eq(timerEvent.events() + 1L);
            this.totalEvent().events_$eq(this.totalEvent().events() + 1L);
            long delta = t1 - t0;
            timerEvent.nanoseconds_$eq(timerEvent.nanoseconds() + delta);
            timerEvent.lastEventNanoseconds_$eq(delta);
            this.totalEvent().nanoseconds_$eq(this.totalEvent().nanoseconds() + delta);
            this.totalEvent().lastEventNanoseconds_$eq(delta);
            object = result;
        } else {
            object = block.apply();
        }
        return (R)object;
    }

    public String entryFor(String tag) {
        String string;
        Option option = this.timingLog().get((Object)tag);
        if (option instanceof Some) {
            Some some = (Some)option;
            TimerEvent entry = (TimerEvent)some.value();
            string = new StringBuilder(2).append(entry.events()).append(":").append(entry.nanoseconds()).append(":").append(entry.nanoseconds() / entry.events()).toString();
        } else {
            string = "";
        }
        return string;
    }

    public String prettyEntry(TimerEvent entry) {
        double total_seconds = (double)entry.nanoseconds() / Timer$.MODULE$.TenTo9th();
        double averageSeconds = (double)entry.nanoseconds() / (double)entry.events() / Timer$.MODULE$.TenTo9th() * 1000000.0;
        long arg$macro$1 = entry.events();
        double arg$macro$2 = total_seconds;
        double arg$macro$3 = averageSeconds;
        return new StringOps("%10d events %12.6f total seconds %12.6f average usec").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1), BoxesRunTime.boxToDouble((double)arg$macro$2), BoxesRunTime.boxToDouble((double)arg$macro$3)}));
    }

    public String prettyEntryForTag(String tag) {
        String string;
        Option option = this.timingLog().get((Object)tag);
        if (option instanceof Some) {
            Some some = (Some)option;
            TimerEvent entry = (TimerEvent)some.value();
            string = this.prettyEntry(entry);
        } else {
            string = "";
        }
        return string;
    }

    public String prettyLastTime(String tag) {
        String string;
        Option option = this.timingLog().get((Object)tag);
        if (option instanceof Some) {
            Some some = (Some)option;
            TimerEvent entry = (TimerEvent)some.value();
            double lastEventSeconds = (double)entry.lastEventNanoseconds() / Timer$.MODULE$.TenTo9th();
            string = String.valueOf(BoxesRunTime.boxToDouble((double)lastEventSeconds));
        } else {
            string = "";
        }
        return string;
    }

    public void clear() {
        this.timingLog().clear();
    }

    public String report() {
        Seq sortedTags = (Seq)this.timingLog().keys().toSeq().sorted((Ordering)Ordering.String$.MODULE$);
        String arg$macro$3 = "Total";
        String arg$macro$4 = this.prettyEntry(this.totalEvent());
        return new StringBuilder(1).append(((TraversableOnce)sortedTags.map((Function1 & java.io.Serializable & Serializable)tag -> {
            String arg$macro$1 = tag;
            String arg$macro$2 = this.prettyEntryForTag((String)tag);
            return new StringOps("%-20s %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2}));
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n").append(new StringOps("%-20s %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$3, arg$macro$4}))).toString();
    }
}

