/*
 * Decompiled with CFR 0.152.
 */
package firrtl_interpreter;

import firrtl.ir.ClockType$;
import firrtl.ir.SIntType;
import firrtl.ir.Type;
import firrtl.ir.UIntType;
import firrtl_interpreter.Concrete;
import firrtl_interpreter.Concrete$;
import firrtl_interpreter.ConcreteClock;
import firrtl_interpreter.ConcreteSInt;
import firrtl_interpreter.ConcreteUInt;
import firrtl_interpreter.ConcreteUInt$;
import firrtl_interpreter.InterpreterException;
import firrtl_interpreter.package$;
import scala.MatchError;
import scala.Product;
import scala.math.BigInt;
import scala.math.BigInt$;

public final class TypeInstanceFactory$ {
    public static TypeInstanceFactory$ MODULE$;

    static {
        new TypeInstanceFactory$();
    }

    private ConcreteSInt makeSInt(BigInt value, int width, boolean poisoned) {
        ConcreteSInt concreteSInt;
        if (value.$greater((Object)BigInt$.MODULE$.int2bigInt(0))) {
            ConcreteUInt uInt = new ConcreteUInt(value, width, poisoned);
            concreteSInt = uInt.asSInt();
        } else {
            concreteSInt = new ConcreteSInt(value, width, poisoned);
        }
        return concreteSInt;
    }

    private boolean makeSInt$default$3() {
        return false;
    }

    public Concrete apply(Type typ) {
        Product product;
        Type type = typ;
        if (type instanceof UIntType) {
            UIntType uIntType = (UIntType)type;
            product = Concrete$.MODULE$.poisonedUInt(package$.MODULE$.widthToInt(uIntType.width()));
        } else if (type instanceof SIntType) {
            SIntType sIntType = (SIntType)type;
            product = Concrete$.MODULE$.poisonedSInt(package$.MODULE$.widthToInt(sIntType.width()));
        } else if (ClockType$.MODULE$.equals(type)) {
            product = new ConcreteUInt(BigInt$.MODULE$.int2bigInt(0), 1, ConcreteUInt$.MODULE$.apply$default$3());
        } else {
            throw new InterpreterException(new StringBuilder(42).append("Unsupported LoFIRRTL type for interpreter ").append(typ).toString());
        }
        return product;
    }

    public Concrete apply(Type typ, BigInt initialValue, boolean poisoned) {
        Product product;
        Type type = typ;
        if (type instanceof UIntType) {
            UIntType uIntType = (UIntType)type;
            product = new ConcreteUInt(initialValue, package$.MODULE$.widthToInt(uIntType.width()), poisoned);
        } else if (type instanceof SIntType) {
            SIntType sIntType = (SIntType)type;
            product = this.makeSInt(initialValue, package$.MODULE$.widthToInt(sIntType.width()), poisoned);
        } else if (ClockType$.MODULE$.equals(type)) {
            product = new ConcreteClock(initialValue.$greater((Object)BigInt$.MODULE$.int2bigInt(0)) ? BigInt$.MODULE$.int2bigInt(1) : BigInt$.MODULE$.int2bigInt(0));
        } else {
            throw new InterpreterException(new StringBuilder(42).append("Unsupported LoFIRRTL type for interpreter ").append(typ).toString());
        }
        return product;
    }

    public boolean apply$default$3() {
        return false;
    }

    public Concrete makeRandomSimilar(Concrete template, boolean poisoned) {
        Product product;
        Concrete concrete = template;
        if (concrete instanceof ConcreteUInt) {
            ConcreteUInt concreteUInt = (ConcreteUInt)concrete;
            product = Concrete$.MODULE$.randomUInt(concreteUInt.width(), poisoned);
        } else if (concrete instanceof ConcreteSInt) {
            ConcreteSInt concreteSInt = (ConcreteSInt)concrete;
            product = Concrete$.MODULE$.randomSInt(concreteSInt.width(), poisoned);
        } else if (concrete instanceof ConcreteClock) {
            product = Concrete$.MODULE$.randomClock();
        } else {
            throw new InterpreterException(new StringBuilder(42).append("Unsupported LoFIRRTL type for interpreter ").append(template).toString());
        }
        return product;
    }

    public Concrete makeSimilar(Concrete template, BigInt value, boolean poisoned) {
        Product product;
        Concrete concrete = template;
        if (concrete instanceof ConcreteUInt) {
            ConcreteUInt concreteUInt = (ConcreteUInt)concrete;
            int width = concreteUInt.width();
            product = new ConcreteUInt(value, width, poisoned);
        } else if (concrete instanceof ConcreteSInt) {
            ConcreteSInt concreteSInt = (ConcreteSInt)concrete;
            int width = concreteSInt.width();
            product = this.makeSInt(value, width, poisoned);
        } else {
            throw new MatchError((Object)concrete);
        }
        return product;
    }

    private TypeInstanceFactory$() {
        MODULE$ = this;
    }
}

