/*
 * Decompiled with CFR 0.152.
 */
package firrtl_interpreter.vcd;

import firrtl_interpreter.vcd.Change;
import firrtl_interpreter.vcd.Change$;
import firrtl_interpreter.vcd.Scope;
import firrtl_interpreter.vcd.Scope$;
import firrtl_interpreter.vcd.VCD;
import firrtl_interpreter.vcd.VCDConfig;
import firrtl_interpreter.vcd.VCDOptionsManager;
import firrtl_interpreter.vcd.Wire;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import logger.LazyLogging;
import logger.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.matching.Regex;

public final class VCD$
implements LazyLogging,
scala.Serializable {
    public static VCD$ MODULE$;
    private final String Version;
    private final String DateDeclaration;
    private final String VersionDeclaration;
    private final String CommentDeclaration;
    private final String TimeScaleDeclaration;
    private final String ScopeDeclaration;
    private final String VarDeclaration;
    private final String UpScopeDeclaration;
    private final String EndDefinitionsDeclaration;
    private final String DumpVarsDeclaration;
    private final String End;
    private final String firrtl_interpreter$vcd$VCD$$ClockName;
    private final String ResetName;
    private final Seq<String> idChars;
    private final int numberOfIdChars;
    private final Regex SectionHeader;
    private final Regex EndSection;
    private final Regex ScopedModule;
    private final Regex JustScoped;
    private final Regex VarSpec;
    private final Regex ValueChangeScalar;
    private final Regex ValueChangeVector;
    private final Regex ValueChangeVectorX;
    private final Regex TimeStamp;
    private final Logger logger;

    static {
        new VCD$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void logger$LazyLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public String Version() {
        return this.Version;
    }

    public String DateDeclaration() {
        return this.DateDeclaration;
    }

    public String VersionDeclaration() {
        return this.VersionDeclaration;
    }

    public String CommentDeclaration() {
        return this.CommentDeclaration;
    }

    public String TimeScaleDeclaration() {
        return this.TimeScaleDeclaration;
    }

    public String ScopeDeclaration() {
        return this.ScopeDeclaration;
    }

    public String VarDeclaration() {
        return this.VarDeclaration;
    }

    public String UpScopeDeclaration() {
        return this.UpScopeDeclaration;
    }

    public String EndDefinitionsDeclaration() {
        return this.EndDefinitionsDeclaration;
    }

    public String DumpVarsDeclaration() {
        return this.DumpVarsDeclaration;
    }

    public String End() {
        return this.End;
    }

    public String firrtl_interpreter$vcd$VCD$$ClockName() {
        return this.firrtl_interpreter$vcd$VCD$$ClockName;
    }

    private String ResetName() {
        return this.ResetName;
    }

    public Seq<String> idChars() {
        return this.idChars;
    }

    public int numberOfIdChars() {
        return this.numberOfIdChars;
    }

    public Regex SectionHeader() {
        return this.SectionHeader;
    }

    public Regex EndSection() {
        return this.EndSection;
    }

    public Regex ScopedModule() {
        return this.ScopedModule;
    }

    public Regex JustScoped() {
        return this.JustScoped;
    }

    public Regex VarSpec() {
        return this.VarSpec;
    }

    public Regex ValueChangeScalar() {
        return this.ValueChangeScalar;
    }

    public Regex ValueChangeVector() {
        return this.ValueChangeVector;
    }

    public Regex ValueChangeVectorX() {
        return this.ValueChangeVectorX;
    }

    public Regex TimeStamp() {
        return this.TimeStamp;
    }

    public VCD apply(String moduleName, String timeScale, String comment) {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ");
        df.setTimeZone(tz);
        String nowAsISO = df.format(new Date());
        return new VCD(nowAsISO, this.Version(), comment, timeScale, moduleName, true);
    }

    public String apply$default$2() {
        return "1ps";
    }

    public String apply$default$3() {
        return "";
    }

    public VCD read(String vcdFile, String startScope, String renameStartScope, String varPrefix, String newVarPrefix) {
        VCD.WordIterator words = new VCD.WordIterator(vcdFile);
        StringBuilder dateHeader = new StringBuilder();
        StringBuilder versionHeader = new StringBuilder();
        StringBuilder commentHeader = new StringBuilder();
        StringBuilder timeScaleHeader = new StringBuilder();
        StringBuilder scopeBuffer = new StringBuilder();
        StringBuilder endDefinition = new StringBuilder();
        StringBuilder currentVar = new StringBuilder();
        ObjectRef scopeRoot = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef currentScope = ObjectRef.create((Object)None$.MODULE$);
        BooleanRef desiredScopeFound = BooleanRef.create((boolean)false);
        Map supportedVectorRadix = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"o"), (Object)BoxesRunTime.boxToInteger((int)8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"h"), (Object)BoxesRunTime.boxToInteger((int)16))}));
        HashMap wires = new HashMap();
        HashMap<String, HashSet<Wire>> aliasedWires = new HashMap<String, HashSet<Wire>>(){

            public HashSet<Wire> default(String key) {
                this.update(key, new HashSet());
                return (HashSet)this.apply(key);
            }
        };
        HashMap skippedWires = new HashMap();
        LongRef currentTime = LongRef.create((long)-1L);
        HashMap<Object, HashSet<Change>> valuesAtTime = new HashMap<Object, HashSet<Change>>(){

            public HashSet<Change> default(long key) {
                this.update(BoxesRunTime.boxToLong((long)key), new HashSet());
                return (HashSet)this.apply(BoxesRunTime.boxToLong((long)key));
            }
        };
        HashSet initialValues = new HashSet();
        this.processSections$1(words, dateHeader, versionHeader, commentHeader, timeScaleHeader, endDefinition, scopeBuffer, currentScope, startScope, renameStartScope, scopeRoot, desiredScopeFound, currentVar, wires, (HashMap)aliasedWires, skippedWires, varPrefix, newVarPrefix, currentTime, initialValues, (HashMap)valuesAtTime, supportedVectorRadix);
        if (((Option)scopeRoot.elem).isEmpty()) {
            this.logger().error((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(51).append("Error: No start scope found, desired StartScope is ").append(startScope).toString());
        }
        VCD vcd = new VCD(dateHeader.toString().trim(), versionHeader.toString().trim(), commentHeader.toString().trim(), timeScaleHeader.toString().trim(), "", true);
        vcd.wires().$plus$plus$eq((TraversableOnce)wires);
        vcd.initialValues().$plus$plus$eq((TraversableOnce)initialValues);
        vcd.valuesAtTime().$plus$plus$eq((TraversableOnce)valuesAtTime);
        vcd.aliasedWires_$eq(aliasedWires);
        Option option = (Option)scopeRoot.elem;
        if (option instanceof Some) {
            Some some = (Some)option;
            Scope scope = (Scope)some.value();
            vcd.scopeRoot_$eq(scope);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
        return vcd;
    }

    public String read$default$2() {
        return "";
    }

    public String read$default$3() {
        return "";
    }

    public String read$default$4() {
        return "";
    }

    public String read$default$5() {
        return "";
    }

    public void main(String[] args) {
        VCDOptionsManager manager = new VCDOptionsManager();
        if (manager.parse(args)) {
            VCDConfig config = manager.vcdConfig();
            VCD vcd = this.read(config.vcdSourceName(), config.startScope(), config.renameStartScope(), config.varPrefix(), config.newVarPrefix());
            Predef$.MODULE$.println((Object)String.valueOf(vcd.info()));
            if (new StringOps(Predef$.MODULE$.augmentString(config.vcdTargetName())).nonEmpty()) {
                vcd.write(config.vcdTargetName());
            }
        } else {
            manager.parser().showUsageAsError();
        }
    }

    public VCD apply(String date, String version, String comment, String timeScale, String scope, boolean ignoreUnderscoredNames) {
        return new VCD(date, version, comment, timeScale, scope, ignoreUnderscoredNames);
    }

    public Option<Tuple6<String, String, String, String, String, Object>> unapply(VCD x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple6((Object)x$0.date(), (Object)x$0.version(), (Object)x$0.comment(), (Object)x$0.timeScale(), (Object)x$0.scope(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.ignoreUnderscoredNames())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ String $anonfun$idChars$1(int asciiValue) {
        return ((Object)BoxesRunTime.boxToCharacter((char)((char)asciiValue))).toString();
    }

    /*
     * Unable to fully structure code
     */
    private static final void addScope$1(String name, ObjectRef currentScope$1, String startScope$1, String renameStartScope$1, ObjectRef scopeRoot$1, BooleanRef desiredScopeFound$1) {
        block3: {
            block2: {
                var7_6 = (Option)currentScope$1.elem;
                if (!(var7_6 instanceof Some)) break block2;
                var8_7 = (Some)var7_6;
                scope = (Scope)var8_7.value();
                currentScope$1.elem = new Some((Object)new Scope(name, (Option<Scope>)((Option)currentScope$1.elem)));
                scope.subScopes().$plus$eq(((Option)currentScope$1.elem).get());
                var6_9 = BoxedUnit.UNIT;
                break block3;
            }
            if (startScope$1.isEmpty()) ** GOTO lbl-1000
            v0 = name;
            var10_11 = startScope$1;
            if (!(v0 != null ? v0.equals(var10_11) == false : var10_11 != null)) lbl-1000:
            // 2 sources

            {
                newName = renameStartScope$1.isEmpty() != false ? name : renameStartScope$1;
                scopeRoot$1.elem = new Some((Object)new Scope(newName, Scope$.MODULE$.apply$default$2()));
                currentScope$1.elem = (Option)scopeRoot$1.elem;
                desiredScopeFound$1.elem = true;
                v1 = BoxedUnit.UNIT;
            } else {
                v1 = BoxedUnit.UNIT;
            }
            var6_10 = v1;
        }
    }

    private final void processScope$1(VCD.WordIterator words$1, StringBuilder scopeBuffer$1, ObjectRef currentScope$1, String startScope$1, String renameStartScope$1, ObjectRef scopeRoot$1, BooleanRef desiredScopeFound$1) {
        block6: {
            BoxedUnit boxedUnit;
            while (words$1.hasNext()) {
                String string = words$1.next();
                Option option = this.EndSection().unapplySeq((CharSequence)string);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(0) == 0) {
                    String string2 = scopeBuffer$1.toString();
                    Option option2 = this.ScopedModule().unapplySeq((CharSequence)string2);
                    if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                        String kind = (String)((LinearSeqOptimized)option2.get()).apply(0);
                        String moduleName = (String)((LinearSeqOptimized)option2.get()).apply(1);
                        String string3 = kind;
                        String string4 = "module";
                        if (string3 == null ? string4 != null : !string3.equals(string4)) {
                            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(32).append("unsupported scope type ").append(scopeBuffer$1.toString()).append(" at line ").append(words$1.currentLineNumber()).toString());
                        }
                        VCD$.addScope$1(moduleName, currentScope$1, startScope$1, renameStartScope$1, scopeRoot$1, desiredScopeFound$1);
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(30).append("unknown scope format ").append(scopeBuffer$1.toString()).append(" at line ").append(words$1.currentLineNumber()).toString());
                        BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                    }
                } else {
                    scopeBuffer$1.append(new java.lang.StringBuilder(1).append(" ").append(string).toString());
                    continue;
                }
                scopeBuffer$1.clear();
                BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                boxedUnit = BoxedUnit.UNIT;
                break block6;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private final void processUpScope$1(VCD.WordIterator words$1, ObjectRef currentScope$1, BooleanRef desiredScopeFound$1, StringBuilder scopeBuffer$1, String startScope$1, String renameStartScope$1, ObjectRef scopeRoot$1) {
        block6: {
            if (!words$1.hasNext()) break block6;
            String string = words$1.next();
            Option option = this.EndSection().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(0) == 0) {
                None$ none$;
                Option option2 = (Option)currentScope$1.elem;
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    Scope scope = (Scope)some.value();
                    none$ = scope.parent();
                } else if (None$.MODULE$.equals(option2)) {
                    desiredScopeFound$1.elem = false;
                    none$ = None$.MODULE$;
                } else {
                    throw new MatchError((Object)option2);
                }
                currentScope$1.elem = none$;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.processScope$1(words$1, scopeBuffer$1, currentScope$1, startScope$1, renameStartScope$1, scopeRoot$1, desiredScopeFound$1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private static final String scopePathString$1(Option scopeOption, String path) {
        String string;
        Option option = scopeOption;
        if (option instanceof Some) {
            Some some = (Some)option;
            Scope scope = (Scope)some.value();
            string = new java.lang.StringBuilder(1).append(VCD$.scopePathString$1(scope.parent(), VCD$.scopePathString$default$2$1())).append(scope.name()).append(".").toString();
        } else if (None$.MODULE$.equals(option)) {
            string = "";
        } else {
            throw new MatchError((Object)option);
        }
        return string;
    }

    private static final List walkPath$1(Option scopeOption) {
        Nil$ nil$;
        Option option = scopeOption;
        if (option instanceof Some) {
            Some some = (Some)option;
            Scope scope = (Scope)some.value();
            String string = scope.name();
            nil$ = VCD$.walkPath$1(scope.parent()).$colon$colon((Object)string);
        } else if (None$.MODULE$.equals(option)) {
            nil$ = Nil$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        return nil$;
    }

    private static final List scopePath$1(Option scopeOption) {
        Nil$ nil$;
        List list = VCD$.walkPath$1(scopeOption).reverse();
        if (Nil$.MODULE$.equals(list)) {
            nil$ = Nil$.MODULE$;
        } else if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List tail = colon2.tl$access$1();
            nil$ = tail;
        } else {
            throw new MatchError((Object)list);
        }
        return nil$;
    }

    private static final String scopePathString$default$2$1() {
        return "";
    }

    private static final Option checkName$1(String name, String varPrefix$1, String newVarPrefix$1) {
        Object object;
        String string = name;
        String string2 = MODULE$.firrtl_interpreter$vcd$VCD$$ClockName();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            object = new Some((Object)name);
        } else {
            String string3 = name;
            String string4 = MODULE$.ResetName();
            object = !(string3 != null ? !string3.equals(string4) : string4 != null) ? new Some((Object)name) : (name.startsWith(varPrefix$1) ? (new StringOps(Predef$.MODULE$.augmentString(newVarPrefix$1)).nonEmpty() ? new Some((Object)new java.lang.StringBuilder(0).append(newVarPrefix$1).append(new StringOps(Predef$.MODULE$.augmentString(name)).drop(varPrefix$1.length())).toString()) : new Some((Object)name)) : None$.MODULE$);
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void addVar$1(String s, BooleanRef desiredScopeFound$1, ObjectRef currentScope$1, HashMap wires$1, VCD.WordIterator words$1, HashMap aliasedWires$1, HashMap skippedWires$1, String varPrefix$1, String newVarPrefix$1) {
        String string = s;
        Option option = this.VarSpec().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(4) == 0) {
            String string2 = (String)((LinearSeqOptimized)option.get()).apply(0);
            String sizeString = (String)((LinearSeqOptimized)option.get()).apply(1);
            String idString = (String)((LinearSeqOptimized)option.get()).apply(2);
            String referenceString = (String)((LinearSeqOptimized)option.get()).apply(3);
            if ("wire".equals(string2)) {
                Option option2 = VCD$.checkName$1((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])referenceString.split(" +"))).head(), varPrefix$1, newVarPrefix$1);
                if (option2 instanceof Some) {
                    BoxedUnit boxedUnit;
                    Some some = (Some)option2;
                    String varName = (String)some.value();
                    if (desiredScopeFound$1.elem) {
                        Wire wire = new Wire(varName, idString, new StringOps(Predef$.MODULE$.augmentString(sizeString)).toInt(), (String[])VCD$.scopePath$1((Option)currentScope$1.elem).toArray(ClassTag$.MODULE$.apply(String.class)));
                        if (!wires$1.contains((Object)idString)) {
                            wires$1.update((Object)idString, (Object)wire);
                            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(16).append("AddVar ").append(wire).append(" at line ").append(words$1.currentLineNumber()).toString());
                            ((Option)currentScope$1.elem).foreach((Function1 & Serializable & scala.Serializable)x$2 -> x$2.wires().$plus$eq((Object)wire));
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(29).append("AddVar aliased wire ").append(wire).append(" at line ").append(words$1.currentLineNumber()).toString());
                            ((HashSet)aliasedWires$1.apply((Object)idString)).$plus$eq((Object)wire);
                            ((Option)currentScope$1.elem).foreach((Function1 & Serializable & scala.Serializable)x$3 -> x$3.wires().$plus$eq((Object)wire));
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(20).append("Ignore var ").append(VCD$.scopePathString$1((Option)currentScope$1.elem, VCD$.scopePathString$default$2$1())).append(varName).append(" at line ").append(words$1.currentLineNumber()).toString());
                        skippedWires$1.update((Object)idString, (Object)new Wire(varName, idString, new StringOps(Predef$.MODULE$.augmentString(sizeString)).toInt(), (String[])VCD$.scopePath$1((Option)currentScope$1.elem).toArray(ClassTag$.MODULE$.apply(String.class))));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else {
                    String varName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])referenceString.split(" +"))).head();
                    this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(20).append("Ignore var ").append(VCD$.scopePathString$1((Option)currentScope$1.elem, VCD$.scopePathString$default$2$1())).append(varName).append(" at line ").append(words$1.currentLineNumber()).toString());
                    skippedWires$1.update((Object)idString, (Object)new Wire(varName, idString, new StringOps(Predef$.MODULE$.augmentString(sizeString)).toInt(), (String[])VCD$.scopePath$1((Option)currentScope$1.elem).toArray(ClassTag$.MODULE$.apply(String.class))));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(29).append("Could not parse var ").append(s).append(" at line ").append(words$1.currentLineNumber()).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void processVar$1(VCD.WordIterator words$1, StringBuilder currentVar$1, BooleanRef desiredScopeFound$1, ObjectRef currentScope$1, HashMap wires$1, HashMap aliasedWires$1, HashMap skippedWires$1, String varPrefix$1, String newVarPrefix$1) {
        block2: {
            BoxedUnit boxedUnit;
            while (words$1.hasNext()) {
                String string = words$1.next();
                Option option = this.EndSection().unapplySeq((CharSequence)string);
                if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(0) != 0) {
                    currentVar$1.append(new java.lang.StringBuilder(1).append(" ").append(string).toString());
                    continue;
                }
                this.addVar$1(currentVar$1.toString(), desiredScopeFound$1, currentScope$1, wires$1, words$1, aliasedWires$1, skippedWires$1, varPrefix$1, newVarPrefix$1);
                currentVar$1.clear();
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                boxedUnit = BoxedUnit.UNIT;
                break block2;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private final void processHeader$1(StringBuilder builder, VCD.WordIterator words$1) {
        block3: {
            BoxedUnit boxedUnit;
            while (words$1.hasNext()) {
                boolean bl;
                String string = words$1.next();
                Option option = this.EndSection().unapplySeq((CharSequence)string);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(0) == 0) {
                    bl = false;
                } else {
                    builder.append(new java.lang.StringBuilder(1).append(" ").append(string).toString());
                    bl = true;
                }
                if (bl) continue;
                boxedUnit = BoxedUnit.UNIT;
                break block3;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private final void processDump$1(VCD.WordIterator words$1, HashMap wires$1, LongRef currentTime$1, HashSet initialValues$1, HashMap valuesAtTime$1, Map supportedVectorRadix$1) {
        while (words$1.hasNext()) {
            BoxedUnit boxedUnit;
            String nextWord;
            String string = nextWord = words$1.next();
            Option option = this.ValueChangeScalar().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                BoxedUnit boxedUnit2;
                String value = (String)((LinearSeqOptimized)option.get()).apply(0);
                String varCode = (String)((LinearSeqOptimized)option.get()).apply(1);
                if (wires$1.contains((Object)varCode)) {
                    this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(24).append("Change scalar ").append(wires$1.apply((Object)varCode)).append(" ").append(package$.MODULE$.BigInt().apply(value)).append(" at line ").append(words$1.currentLineNumber()).toString());
                    boxedUnit2 = BigInt$.MODULE$.long2bigInt(currentTime$1.elem).$less((Object)package$.MODULE$.BigInt().apply(0)) ? initialValues$1.$plus$eq((Object)new Change((Wire)wires$1.apply((Object)varCode), package$.MODULE$.BigInt().apply(value), Change$.MODULE$.apply$default$3())) : ((HashSet)valuesAtTime$1.apply((Object)BoxesRunTime.boxToLong((long)currentTime$1.elem))).$plus$eq((Object)new Change((Wire)wires$1.apply((Object)varCode), package$.MODULE$.BigInt().apply(value), Change$.MODULE$.apply$default$3()));
                } else {
                    this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(58).append("Found change value for ").append(varCode).append(" but this key not defined  at line ").append(words$1.currentLineNumber()).toString());
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
                continue;
            }
            Option option2 = this.ValueChangeVector().unapplySeq((CharSequence)string);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                BoxedUnit boxedUnit3;
                String radixString = (String)((LinearSeqOptimized)option2.get()).apply(0);
                String value = (String)((LinearSeqOptimized)option2.get()).apply(1);
                if (words$1.hasNext()) {
                    String varCode = words$1.next();
                    if (wires$1.contains((Object)varCode)) {
                        BoxedUnit boxedUnit4;
                        Option option3 = supportedVectorRadix$1.get((Object)radixString);
                        if (option3 instanceof Some) {
                            Some some = (Some)option3;
                            int radix = BoxesRunTime.unboxToInt((Object)some.value());
                            boxedUnit4 = BigInt$.MODULE$.long2bigInt(currentTime$1.elem).$less((Object)package$.MODULE$.BigInt().apply(0)) ? initialValues$1.$plus$eq((Object)new Change((Wire)wires$1.apply((Object)varCode), package$.MODULE$.BigInt().apply(value, radix), Change$.MODULE$.apply$default$3())) : ((HashSet)valuesAtTime$1.apply((Object)BoxesRunTime.boxToLong((long)currentTime$1.elem))).$plus$eq((Object)new Change((Wire)wires$1.apply((Object)varCode), package$.MODULE$.BigInt().apply(value, radix), Change$.MODULE$.apply$default$3()));
                        } else if (None$.MODULE$.equals(option3)) {
                            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(57).append("Found change value for ").append(varCode).append(" but ").append("radix ").append(radixString).append(" not supported at line ").append(words$1.currentLineNumber()).toString());
                            boxedUnit4 = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError((Object)option3);
                        }
                        boxedUnit3 = boxedUnit4;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit3;
                continue;
            }
            Option option4 = this.ValueChangeVectorX().unapplySeq((CharSequence)string);
            if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(1) == 0) {
                BoxedUnit boxedUnit5;
                String radixString = (String)((LinearSeqOptimized)option4.get()).apply(0);
                if (words$1.hasNext()) {
                    String varCode = words$1.next();
                    if (wires$1.contains((Object)varCode)) {
                        BoxedUnit boxedUnit6;
                        Option option5 = supportedVectorRadix$1.get((Object)radixString);
                        if (option5 instanceof Some) {
                            boxedUnit6 = BigInt$.MODULE$.long2bigInt(currentTime$1.elem).$less((Object)package$.MODULE$.BigInt().apply(0)) ? initialValues$1.$plus$eq((Object)new Change((Wire)wires$1.apply((Object)varCode), package$.MODULE$.BigInt().apply(-1), Change$.MODULE$.apply$default$3())) : ((HashSet)valuesAtTime$1.apply((Object)BoxesRunTime.boxToLong((long)currentTime$1.elem))).$plus$eq((Object)new Change((Wire)wires$1.apply((Object)varCode), package$.MODULE$.BigInt().apply(-1), Change$.MODULE$.apply$default$3()));
                        } else if (None$.MODULE$.equals(option5)) {
                            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(57).append("Found change value for ").append(varCode).append(" but ").append("radix ").append(radixString).append(" not supported at line ").append(words$1.currentLineNumber()).toString());
                            boxedUnit6 = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError((Object)option5);
                        }
                        boxedUnit5 = boxedUnit6;
                    } else {
                        boxedUnit5 = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit5 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit5;
                continue;
            }
            Option option6 = this.TimeStamp().unapplySeq((CharSequence)string);
            if (!option6.isEmpty() && option6.get() != null && ((LinearSeqOptimized)option6.get()).lengthCompare(1) == 0) {
                String timeValue = (String)((LinearSeqOptimized)option6.get()).apply(0);
                currentTime$1.elem = new StringOps(Predef$.MODULE$.augmentString(timeValue)).toLong();
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(26).append("current time now ").append(currentTime$1.elem).append(" at line ").append(words$1.currentLineNumber()).toString());
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Option option7 = this.EndSection().unapplySeq((CharSequence)string);
            if (!option7.isEmpty() && option7.get() != null && ((LinearSeqOptimized)option7.get()).lengthCompare(0) == 0) {
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(20).append("end of dump at line ").append(words$1.currentLineNumber()).toString());
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private final void processSections$1(VCD.WordIterator words$1, StringBuilder dateHeader$1, StringBuilder versionHeader$1, StringBuilder commentHeader$1, StringBuilder timeScaleHeader$1, StringBuilder endDefinition$1, StringBuilder scopeBuffer$1, ObjectRef currentScope$1, String startScope$1, String renameStartScope$1, ObjectRef scopeRoot$1, BooleanRef desiredScopeFound$1, StringBuilder currentVar$1, HashMap wires$1, HashMap aliasedWires$1, HashMap skippedWires$1, String varPrefix$1, String newVarPrefix$1, LongRef currentTime$1, HashSet initialValues$1, HashMap valuesAtTime$1, Map supportedVectorRadix$1) {
        while (words$1.hasNext()) {
            BoxedUnit boxedUnit;
            String nextWord;
            String string = nextWord = words$1.next();
            Option option = this.SectionHeader().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                BoxedUnit boxedUnit2;
                String sectionHeader = (String)((LinearSeqOptimized)option.get()).apply(0);
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(35).append("processing section header ").append(sectionHeader).append(" at line ").append(words$1.currentLineNumber()).toString());
                String string2 = sectionHeader;
                if ("date".equals(string2)) {
                    this.processHeader$1(dateHeader$1, words$1);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if ("version".equals(string2)) {
                    this.processHeader$1(versionHeader$1, words$1);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if ("comment".equals(string2)) {
                    this.processHeader$1(commentHeader$1, words$1);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if ("timescale".equals(string2)) {
                    this.processHeader$1(timeScaleHeader$1, words$1);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if ("scope".equals(string2)) {
                    this.processScope$1(words$1, scopeBuffer$1, currentScope$1, startScope$1, renameStartScope$1, scopeRoot$1, desiredScopeFound$1);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if ("upscope".equals(string2)) {
                    this.processUpScope$1(words$1, currentScope$1, desiredScopeFound$1, scopeBuffer$1, startScope$1, renameStartScope$1, scopeRoot$1);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if ("var".equals(string2)) {
                    this.processVar$1(words$1, currentVar$1, desiredScopeFound$1, currentScope$1, wires$1, aliasedWires$1, skippedWires$1, varPrefix$1, newVarPrefix$1);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if ("enddefinitions".equals(string2)) {
                    this.processHeader$1(endDefinition$1, words$1);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if ("dumpvars".equals(string2)) {
                    this.processDump$1(words$1, wires$1, currentTime$1, initialValues$1, valuesAtTime$1, supportedVectorRadix$1);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            this.processDump$1(words$1, wires$1, currentTime$1, initialValues$1, valuesAtTime$1, supportedVectorRadix$1);
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "skipping at line ${words.currentLineNumber}");
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private VCD$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.Version = "0.2";
        this.DateDeclaration = "$date";
        this.VersionDeclaration = "$version";
        this.CommentDeclaration = "$comment";
        this.TimeScaleDeclaration = "$timescale";
        this.ScopeDeclaration = "$scope";
        this.VarDeclaration = "$var";
        this.UpScopeDeclaration = "$upscope";
        this.EndDefinitionsDeclaration = "$enddefinitions";
        this.DumpVarsDeclaration = "$dumpvars";
        this.End = "$end";
        this.firrtl_interpreter$vcd$VCD$$ClockName = "clock";
        this.ResetName = "reset";
        this.idChars = (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(33), 126).map((Function1 & Serializable & scala.Serializable)asciiValue -> VCD$.$anonfun$idChars$1(BoxesRunTime.unboxToInt((Object)asciiValue)), IndexedSeq$.MODULE$.canBuildFrom());
        this.numberOfIdChars = this.idChars().length();
        this.SectionHeader = new StringOps(Predef$.MODULE$.augmentString("^\\$([^\\$]+) *$")).r();
        this.EndSection = new StringOps(Predef$.MODULE$.augmentString("^\\$end *$")).r();
        this.ScopedModule = new StringOps(Predef$.MODULE$.augmentString("\\s*(?i)(\\S+)\\s+(\\S+)\\s*")).r();
        this.JustScoped = new StringOps(Predef$.MODULE$.augmentString("\\s*(\\S+)\\s*")).r();
        this.VarSpec = new StringOps(Predef$.MODULE$.augmentString("\\s*(\\w+)\\s+(\\d+)\\s+(\\S+)\\s+([\\S ]+)\\s*")).r();
        this.ValueChangeScalar = new StringOps(Predef$.MODULE$.augmentString("\\s*(\\d+)(\\S+)\\s*")).r();
        this.ValueChangeVector = new StringOps(Predef$.MODULE$.augmentString("\\s*([rbh])([0-9\\.]+)\\s*")).r();
        this.ValueChangeVectorX = new StringOps(Predef$.MODULE$.augmentString("\\s*([rbh]).*x.*\\s*")).r();
        this.TimeStamp = new StringOps(Predef$.MODULE$.augmentString("\\s*#(\\d+)\\s*")).r();
    }
}

