/*
 * Decompiled with CFR 0.152.
 */
package gem.ocs2;

import cats.Applicative;
import cats.ApplicativeError;
import cats.Functor;
import cats.effect.Bracket;
import cats.effect.ConcurrentEffect;
import cats.effect.Resource;
import cats.effect.Sync;
import cats.implicits$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.EitherOps$;
import doobie.package;
import doobie.util.transactor;
import gem.Dataset;
import gem.Observation;
import gem.Program;
import gem.Program$;
import gem.ProgramId;
import gem.ocs2.Decoders$;
import gem.ocs2.Importer$;
import gem.ocs2.pio.PioDecoder;
import gem.ocs2.pio.PioDecoder$;
import gem.ocs2.pio.PioError;
import java.io.Serializable;
import java.net.URLEncoder;
import org.http4s.client.asynchttpclient.AsyncHttpClient$;
import org.http4s.scalaxml.package$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.xml.Node;

public final class OdbClient$ {
    public static final OdbClient$ MODULE$ = new OdbClient$();

    public <M> M fetchObservation(String host, Observation.Id id, ConcurrentEffect<M> evidence$1) {
        return this.fetch(host, id.format(), Decoders$.MODULE$.ObservationDecoder(), evidence$1);
    }

    public <M> M fetchProgram(String host, ProgramId id, ConcurrentEffect<M> evidence$2) {
        return this.fetch(host, (String)Program$.MODULE$.Id().fromString().reverseGet((Object)id), Decoders$.MODULE$.ProgramDecoder(), evidence$2);
    }

    public <M> M importObservation(String host, Observation.Id id, transactor.Transactor<M> xa, ConcurrentEffect<M> evidence$3) {
        return (M)implicits$.MODULE$.toFlatMapOps(this.fetchObservation(host, id, evidence$3), evidence$3).flatMap((Function1 & Serializable)x$1 -> EitherOps$.MODULE$.traverse$extension(implicits$.MODULE$.catsSyntaxEither(x$1), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Observation o = (Observation)tuple2._1();
            List ds = (List)tuple2._2();
            Object object = package.implicits$.MODULE$.toConnectionIOOps(Importer$.MODULE$.importObservation(id, o, (List<Dataset>)ds)).transact(xa, (Bracket)evidence$3);
            return object;
        }, (Applicative)evidence$3));
    }

    public <M> M importProgram(String host, ProgramId id, transactor.Transactor<M> xa, ConcurrentEffect<M> evidence$4) {
        return (M)implicits$.MODULE$.toFlatMapOps(this.fetchProgram(host, id, evidence$4), evidence$4).flatMap((Function1 & Serializable)x$2 -> EitherOps$.MODULE$.traverse$extension(implicits$.MODULE$.catsSyntaxEither(x$2), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Program p = (Program)tuple2._1();
            List ds = (List)tuple2._2();
            Object object = package.implicits$.MODULE$.toConnectionIOOps(Importer$.MODULE$.importProgram(p, (List<Dataset>)ds)).transact(xa, (Bracket)evidence$4);
            return object;
        }, (Applicative)evidence$4));
    }

    private String fetchServiceUrl(String host) {
        return new StringBuilder(23).append("http://").append(host).append(":8442/ocs3/fetch").toString();
    }

    private String uri(String host, String id) {
        return new StringBuilder(1).append(this.fetchServiceUrl(host)).append("/").append(URLEncoder.encode(id, "UTF-8")).toString();
    }

    private String errorMessage(PioError e) {
        String string;
        PioError pioError = e;
        if (pioError instanceof PioError.MissingKey) {
            PioError.MissingKey missingKey = (PioError.MissingKey)pioError;
            String name = missingKey.name();
            string = new StringBuilder(10).append("missing '").append(name).append("'").toString();
        } else if (pioError instanceof PioError.ParseError) {
            PioError.ParseError parseError = (PioError.ParseError)pioError;
            String value = parseError.value();
            String dataType = parseError.dataType();
            string = new StringBuilder(24).append("could not parse '").append(value).append("' as '").append(dataType).append("'").toString();
        } else {
            throw new MatchError((Object)pioError);
        }
        return string;
    }

    private <A, M> M fetch(String host, String id, PioDecoder<A> evidence$5, ConcurrentEffect<M> evidence$6) {
        Resource client = AsyncHttpClient$.MODULE$.resource(AsyncHttpClient$.MODULE$.resource$default$1(), evidence$6);
        return (M)client.use((Function1 & Serializable)c -> implicits$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(implicits$.MODULE$.catsSyntaxApplicativeError(implicits$.MODULE$.toFunctorOps(c.expect(MODULE$.uri(host, id), package$.MODULE$.xml((Sync)evidence$6)), (Functor)evidence$6).map((Function1 & Serializable)x$3 -> EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(PioDecoder$.MODULE$.apply(PioDecoder$.MODULE$.decode2(evidence$5, Decoders$.MODULE$.DatasetsDecoder())).decode((Node)x$3)), (Function1 & Serializable)e -> MODULE$.errorMessage((PioError)e))), (ApplicativeError)evidence$6), (ApplicativeError)evidence$6), (Functor)evidence$6).map((Function1 & Serializable)x$4 -> EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(x$4), (Function1 & Serializable)ex -> new StringBuilder(21).append("Problem fetching '").append(id).append("': ").append(ex.getMessage()).toString()).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl())), evidence$6);
    }

    private OdbClient$() {
    }
}

