// Copyright (c) 2016-2020 Association of Universities for Research in Astronomy, Inc. (AURA)
// For license information see LICENSE or https://opensource.org/licenses/BSD-3-Clause

package edu.gemini.grackle
package doobie

import _root_.doobie.util.transactor.Transactor
import cats.effect.Sync
import io.chrisdavenport.log4cats.Logger

trait DoobieMappingCompanion {
  def mkMapping[F[_]: Sync](transactor: Transactor[F], monitor: DoobieMonitor[F]): Mapping[F]

  def fromTransactor[F[_] : Sync](transactor: Transactor[F]): Mapping[F] = {
    val monitor: DoobieMonitor[F] = DoobieMonitor.noopMonitor[F]

    mkMapping(transactor, monitor)
  }
}

trait LoggedDoobieMappingCompanion {
  def mkMapping[F[_]: Sync](transactor: Transactor[F], monitor: DoobieMonitor[F]): Mapping[F]

  def fromTransactor[F[_] : Sync : Logger](transactor: Transactor[F]): Mapping[F] = {
    val monitor: DoobieMonitor[F] = DoobieMonitor.loggerMonitor[F](Logger[F])

    mkMapping(transactor, monitor)
  }
}
