/*
 * Decompiled with CFR 0.152.
 */
package edu.gemini.grackle.sql;

import cats.Applicative;
import cats.Applicative$;
import cats.data.Ior;
import cats.effect.kernel.Ref;
import cats.syntax.package;
import edu.gemini.grackle.Query;
import edu.gemini.grackle.sql.SqlMonitor;
import edu.gemini.grackle.sql.SqlStatsMonitor$SqlStats$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public abstract class SqlStatsMonitor<F, A>
implements SqlMonitor<F, A> {
    private final Ref<F, List<SqlStats>> ref;
    private final Applicative<F> evidence$1;

    public SqlStatsMonitor(Ref<F, List<SqlStats>> ref, Applicative<F> evidence$1) {
        this.ref = ref;
        this.evidence$1 = evidence$1;
    }

    public final F take() {
        return (F)package.all$.MODULE$.toFunctorOps(this.ref.getAndSet((Object)package$.MODULE$.Nil()), this.evidence$1).map((Function1 & Serializable)_$2 -> _$2.reverse());
    }

    @Override
    public final F queryMapped(Query query, A fragment, int rows, int cols) {
        return (F)this.ref.update((Function1 & Serializable)stats -> {
            Tuple2<String, List<Object>> tuple2 = this.inspect(fragment);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String sql = (String)tuple2._1();
            List args = (List)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)sql, (Object)args);
            String sql2 = (String)tuple22._1();
            List args2 = (List)tuple22._2();
            SqlStats sqlStats = SqlStatsMonitor$SqlStats$.MODULE$.apply(query, sql2, (List<Object>)args2, rows, cols);
            return stats.$colon$colon((Object)sqlStats);
        });
    }

    @Override
    public final F resultComputed(Ior<Object, Object> result) {
        return (F)Applicative$.MODULE$.apply(this.evidence$1).unit();
    }

    public abstract Tuple2<String, List<Object>> inspect(A var1);

    public static final class SqlStats
    implements Product,
    Serializable {
        private final Query query;
        private final String sql;
        private final List args;
        private final int rows;
        private final int cols;

        public static SqlStats apply(Query query, String string, List<Object> list, int n, int n2) {
            return SqlStatsMonitor$SqlStats$.MODULE$.apply(query, string, list, n, n2);
        }

        public static SqlStats fromProduct(Product product) {
            return SqlStatsMonitor$SqlStats$.MODULE$.fromProduct(product);
        }

        public static SqlStats unapply(SqlStats sqlStats) {
            return SqlStatsMonitor$SqlStats$.MODULE$.unapply(sqlStats);
        }

        public SqlStats(Query query, String sql, List<Object> args, int rows, int cols) {
            this.query = query;
            this.sql = sql;
            this.args = args;
            this.rows = rows;
            this.cols = cols;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.query()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.sql()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.args()));
            n = Statics.mix((int)n, (int)this.rows());
            n = Statics.mix((int)n, (int)this.cols());
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SqlStats)) return false;
            SqlStats sqlStats = (SqlStats)object;
            if (this.rows() != sqlStats.rows()) return false;
            if (this.cols() != sqlStats.cols()) return false;
            Query query = this.query();
            Query query2 = sqlStats.query();
            if (query == null) {
                if (query2 != null) {
                    return false;
                }
            } else if (!query.equals(query2)) return false;
            String string = this.sql();
            String string2 = sqlStats.sql();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            List<Object> list = this.args();
            List<Object> list2 = sqlStats.args();
            if (list == null) {
                if (list2 == null) return true;
                return false;
            } else {
                if (!list.equals(list2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SqlStats;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "SqlStats";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return BoxesRunTime.boxToInteger((int)this._4());
                }
                case 4: {
                    return BoxesRunTime.boxToInteger((int)this._5());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "query";
                }
                case 1: {
                    return "sql";
                }
                case 2: {
                    return "args";
                }
                case 3: {
                    return "rows";
                }
                case 4: {
                    return "cols";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Query query() {
            return this.query;
        }

        public String sql() {
            return this.sql;
        }

        public List<Object> args() {
            return this.args;
        }

        public int rows() {
            return this.rows;
        }

        public int cols() {
            return this.cols;
        }

        public SqlStats normalize() {
            String string = this.sql().replaceAll("\\s+", " ").trim();
            Query query = this.copy$default$1();
            List<Object> list = this.copy$default$3();
            int n = this.copy$default$4();
            int n2 = this.copy$default$5();
            return this.copy(query, string, list, n, n2);
        }

        public SqlStats copy(Query query, String sql, List<Object> args, int rows, int cols) {
            return new SqlStats(query, sql, args, rows, cols);
        }

        public Query copy$default$1() {
            return this.query();
        }

        public String copy$default$2() {
            return this.sql();
        }

        public List<Object> copy$default$3() {
            return this.args();
        }

        public int copy$default$4() {
            return this.rows();
        }

        public int copy$default$5() {
            return this.cols();
        }

        public Query _1() {
            return this.query();
        }

        public String _2() {
            return this.sql();
        }

        public List<Object> _3() {
            return this.args();
        }

        public int _4() {
            return this.rows();
        }

        public int _5() {
            return this.cols();
        }
    }
}

