/*
 * Decompiled with CFR 0.152.
 */
package lucuma.ags;

import cats.ApplicativeError;
import cats.Functor;
import cats.Invariant$;
import cats.Semigroupal;
import cats.Semigroupal$;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.NonEmptyMapImpl$;
import cats.effect.kernel.GenConcurrent;
import cats.kernel.Eq;
import cats.kernel.PartialOrder;
import cats.syntax.package;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import java.time.Instant;
import lucuma.ags.AgsAnalysis;
import lucuma.ags.AgsAnalysis$NoGuideStarForProbe$;
import lucuma.ags.AgsAnalysis$NoMagnitudeForBand$;
import lucuma.ags.AgsAnalysis$NotReachableAtPosition$;
import lucuma.ags.AgsAnalysis$ProperMotionNotAvailable$;
import lucuma.ags.AgsAnalysis$Usable$;
import lucuma.ags.AgsAnalysis$VignettesScience$;
import lucuma.ags.AgsGuideQuality;
import lucuma.ags.AgsGuideQuality$;
import lucuma.ags.AgsParams;
import lucuma.ags.AgsPosition;
import lucuma.ags.GuideStarCandidate;
import lucuma.ags.package$package$;
import lucuma.catalog.BrightnessConstraints;
import lucuma.core.enums.Band;
import lucuma.core.enums.GuideProbe;
import lucuma.core.enums.GuideSpeed;
import lucuma.core.enums.GuideSpeed$;
import lucuma.core.enums.ImageQuality;
import lucuma.core.enums.ImageQuality$;
import lucuma.core.geom.Area;
import lucuma.core.math.Coordinates;
import lucuma.core.math.Offset;
import lucuma.core.model.ConstraintSet;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.math.BigDecimal;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class Ags$
implements Serializable {
    public static final Ags$ MODULE$ = new Ags$();

    private Ags$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Ags$.class);
    }

    private Option<GuideSpeed> guideSpeedFor(List<Tuple2<GuideSpeed, BrightnessConstraints>> speeds, BigDecimal gMag) {
        return speeds.find((Function1 & Serializable)_$1 -> ((BrightnessConstraints)_$1._2()).contains((Band)Band.Gaia$.MODULE$, gMag)).map((Function1 & Serializable)_$2 -> (GuideSpeed)_$2._1());
    }

    public AgsAnalysis runAnalysis(ConstraintSet conditions, Offset gsOffset, List<Offset> scienceOffsets, AgsPosition pos, AgsParams params, GuideStarCandidate gsc, List<Tuple2<GuideSpeed, BrightnessConstraints>> speeds, Object calcs) {
        Option geoms = NonEmptyMapImpl$.MODULE$.catsNonEmptyMapOps(calcs).lookup((Object)pos);
        if (!geoms.exists((Function1 & Serializable)_$3 -> _$3.isReachable(gsOffset))) {
            Option guideSpeed = gsc.gBrightness().flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    BigDecimal g = (BigDecimal)tuple2._2();
                    return MODULE$.guideSpeedFor(speeds, g);
                }
                throw new MatchError((Object)tuple2);
            });
            return AgsAnalysis$NotReachableAtPosition$.MODULE$.apply(pos, params.probe(), (Option<GuideSpeed>)guideSpeed, gsc);
        }
        if (geoms.exists((Function1 & Serializable)g -> scienceOffsets.exists((Function1 & Serializable)_$4 -> g.overlapsScience((Offset)_$4)))) {
            return AgsAnalysis$VignettesScience$.MODULE$.apply(gsc, pos);
        }
        return this.magnitudeAnalysis(conditions, params.probe(), gsOffset, gsc, (Function1<Offset, Object>)((Function1)geoms.map((Function1 & Serializable)c -> (Function1 & Serializable)o -> c.vignettingArea((Offset)o)).getOrElse(Ags$::runAnalysis$$anonfun$4)), pos, speeds);
    }

    public AgsAnalysis magnitudeAnalysis(ConstraintSet constraints, GuideProbe guideProbe, Offset gsOffset, GuideStarCandidate guideStar, Function1<Offset, Object> vignettingArea, AgsPosition position, List<Tuple2<GuideSpeed, BrightnessConstraints>> speeds) {
        Tuple2 tuple2;
        Option<Tuple2<Band, BigDecimal>> option = guideStar.gBrightness();
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            BigDecimal g = (BigDecimal)tuple2._2();
            return (AgsAnalysis)this.guideSpeedFor(speeds, g).map((Function1 & Serializable)guideSpeed -> this.usable$1(constraints, guideProbe, guideStar, position, (Function1)vignettingArea, gsOffset, (GuideSpeed)guideSpeed)).getOrElse(() -> Ags$.magnitudeAnalysis$$anonfun$2(guideProbe, guideStar));
        }
        return AgsAnalysis$NoMagnitudeForBand$.MODULE$.apply(guideProbe, guideStar);
    }

    private Option<Offset> offsetAt(Function1<Instant, Option<Coordinates>> at, Instant instant, GuideStarCandidate gsc) {
        return (Option)package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply(at.apply((Object)instant), (Object)gsc.tracking().at(instant))).mapN((Function2 & Serializable)(_$6, _$7) -> _$6.diff(_$7).offset(), (Functor)Invariant$.MODULE$.catsInstancesForOption(), Semigroupal$.MODULE$.catsSemigroupalForOption());
    }

    private List<Offset> scienceOffsetsAt(List<Function1<Instant, Option<Coordinates>>> scienceAt, Instant instant, GuideStarCandidate gsc) {
        return (List)scienceAt.map((Function1 & Serializable)s -> MODULE$.offsetAt((Function1<Instant, Option<Coordinates>>)s, instant, gsc)).flatten(Predef$.MODULE$.$conforms());
    }

    public <F> Function1<Stream<F, GuideStarCandidate>, Stream<F, AgsAnalysis>> agsAnalysisStreamPM(ConstraintSet constraints, int wavelength, Function1<Instant, Option<Coordinates>> baseAt, List<Function1<Instant, Option<Coordinates>>> scienceAt, NonEmptyList<AgsPosition> positions, AgsParams params, Instant instant, GenConcurrent<F, Throwable> evidence$1) {
        List<Tuple2<GuideSpeed, BrightnessConstraints>> guideSpeeds = this.guideSpeedLimits(constraints, wavelength);
        Object calcs = params.posCalculations(positions);
        Option<BrightnessConstraints> bc = this.constraintsFor(guideSpeeds);
        return (Function1 & Serializable)in -> (Stream)package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply((Object)in.filter((Function1 & Serializable)c -> c.gBrightness().exists((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                BigDecimal g = (BigDecimal)tuple2._2();
                return bc.exists((Function1 & Serializable)_$9 -> _$9.contains((Band)Band.Gaia$.MODULE$, g));
            }
            throw new MatchError((Object)tuple2);
        })), (Object)Stream$.MODULE$.emits((Seq)positions.toList()).repeat())).mapN((Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                GuideStarCandidate gsc = (GuideStarCandidate)tuple2._1();
                AgsPosition position = (AgsPosition)tuple2._2();
                Option<Offset> offset2 = MODULE$.offsetAt(baseAt, instant, gsc);
                List<Offset> scienceOffsets = MODULE$.scienceOffsetsAt(scienceAt, instant, gsc);
                return (AgsAnalysis)offset2.map((Function1 & Serializable)offset -> MODULE$.runAnalysis(constraints, (Offset)offset, scienceOffsets, position, params, gsc, guideSpeeds, calcs)).getOrElse(() -> Ags$.agsAnalysisStreamPM$$anonfun$1$$anonfun$2$$anonfun$2(gsc));
            }
            throw new MatchError((Object)tuple2);
        }, (Functor)Stream$.MODULE$.monadErrorInstance((ApplicativeError)evidence$1), (Semigroupal)Stream$.MODULE$.monadErrorInstance((ApplicativeError)evidence$1));
    }

    public <F> Function1<Stream<F, GuideStarCandidate>, Stream<F, AgsAnalysis>> agsAnalysisStream(ConstraintSet constraints, int wavelength, Coordinates baseCoordinates, List<Coordinates> scienceCoordinates, NonEmptyList<AgsPosition> positions, AgsParams params) {
        List<Tuple2<GuideSpeed, BrightnessConstraints>> guideSpeeds = this.guideSpeedLimits(constraints, wavelength);
        Object calcs = params.posCalculations(positions);
        Option<BrightnessConstraints> bc = this.constraintsFor(guideSpeeds);
        return (Function1 & Serializable)in -> (Stream)package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply((Object)in.filter((Function1 & Serializable)c -> c.gBrightness().exists((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                BigDecimal g = (BigDecimal)tuple2._2();
                return bc.exists((Function1 & Serializable)_$11 -> _$11.contains((Band)Band.Gaia$.MODULE$, g));
            }
            throw new MatchError((Object)tuple2);
        })), (Object)Stream$.MODULE$.emits((Seq)positions.toList()))).mapN((Function2 & Serializable)(gsc, position) -> {
            Offset offset = baseCoordinates.diff(gsc.tracking().baseCoordinates()).offset();
            List scienceOffsets = scienceCoordinates.map((Function1 & Serializable)_$12 -> _$12.diff(gsc.tracking().baseCoordinates()).offset());
            return MODULE$.runAnalysis(constraints, offset, (List<Offset>)scienceOffsets, (AgsPosition)position, params, (GuideStarCandidate)gsc, guideSpeeds, calcs);
        }, (Functor)Stream$.MODULE$.monadInstance(), (Semigroupal)Stream$.MODULE$.monadInstance());
    }

    private Option<BrightnessConstraints> constraintsFor(List<Tuple2<GuideSpeed, BrightnessConstraints>> limits) {
        return (Option)package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply((Object)limits.find((Function1 & Serializable)_$13 -> package.all$.MODULE$.catsSyntaxEq(_$13._1(), (Eq)GuideSpeed$.MODULE$.GuideProbeEnumerated()).$eq$eq$eq((Object)GuideSpeed.Slow$.MODULE$)).map((Function1 & Serializable)_$14 -> (BrightnessConstraints)_$14._2()), (Object)limits.find((Function1 & Serializable)_$15 -> package.all$.MODULE$.catsSyntaxEq(_$15._1(), (Eq)GuideSpeed$.MODULE$.GuideProbeEnumerated()).$eq$eq$eq((Object)GuideSpeed.Fast$.MODULE$)).map((Function1 & Serializable)_$16 -> (BrightnessConstraints)_$16._2()))).mapN((Function2 & Serializable)(_$17, _$18) -> _$17.$u222A(_$18), (Functor)Invariant$.MODULE$.catsInstancesForOption(), Semigroupal$.MODULE$.catsSemigroupalForOption());
    }

    public List<AgsAnalysis> agsAnalysisPM(ConstraintSet constraints, int wavelength, Function1<Instant, Option<Coordinates>> baseAt, List<Function1<Instant, Option<Coordinates>>> scienceAt, NonEmptyList<AgsPosition> positions, AgsParams params, Instant instant, List<GuideStarCandidate> candidates) {
        List<Tuple2<GuideSpeed, BrightnessConstraints>> guideSpeeds = this.guideSpeedLimits(constraints, wavelength);
        Object calcs = params.posCalculations(positions);
        Option<BrightnessConstraints> bc = this.constraintsFor(guideSpeeds);
        return ((List)candidates.filter((Function1 & Serializable)c -> c.gBrightness().exists((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                BigDecimal g = (BigDecimal)tuple2._2();
                return bc.exists((Function1 & Serializable)_$19 -> _$19.contains((Band)Band.Gaia$.MODULE$, g));
            }
            throw new MatchError((Object)tuple2);
        })).zip((IterableOnce)positions.toList())).map((Function1 & Serializable)x$1 -> {
            GuideStarCandidate guideStarCandidate = (GuideStarCandidate)x$1._1();
            AgsPosition agsPosition = (AgsPosition)x$1._2();
            Option<Offset> offset2 = MODULE$.offsetAt(baseAt, instant, guideStarCandidate);
            List<Offset> scienceOffsets = MODULE$.scienceOffsetsAt(scienceAt, instant, guideStarCandidate);
            return (AgsAnalysis)offset2.map((Function1 & Serializable)offset -> MODULE$.runAnalysis(constraints, (Offset)offset, scienceOffsets, agsPosition, params, guideStarCandidate, guideSpeeds, calcs)).getOrElse(() -> Ags$.agsAnalysisPM$$anonfun$2$$anonfun$2(guideStarCandidate));
        });
    }

    public List<AgsAnalysis> agsAnalysis(ConstraintSet constraints, int wavelength, Coordinates baseCoordinates, List<Coordinates> scienceCoordinates, NonEmptyList<AgsPosition> positions, AgsParams params, List<GuideStarCandidate> candidates) {
        List<Tuple2<GuideSpeed, BrightnessConstraints>> guideSpeeds = this.guideSpeedLimits(constraints, wavelength);
        Object calcs = params.posCalculations(positions);
        Option<BrightnessConstraints> bc = this.constraintsFor(guideSpeeds);
        return candidates.filter((Function1 & Serializable)c -> c.gBrightness().exists((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                BigDecimal g = (BigDecimal)tuple2._2();
                return bc.exists((Function1 & Serializable)_$20 -> _$20.contains((Band)Band.Gaia$.MODULE$, g));
            }
            throw new MatchError((Object)tuple2);
        })).flatMap((Function1 & Serializable)gsc -> positions.toList().map((Function1 & Serializable)position -> {
            Offset offset = baseCoordinates.diff(gsc.tracking().baseCoordinates()).offset();
            List scienceOffsets = scienceCoordinates.map((Function1 & Serializable)_$21 -> _$21.diff(gsc.tracking().baseCoordinates()).offset());
            return MODULE$.runAnalysis(constraints, offset, (List<Offset>)scienceOffsets, (AgsPosition)position, params, (GuideStarCandidate)gsc, guideSpeeds, calcs);
        }));
    }

    public Option<GuideSpeed> fastestGuideSpeed(ConstraintSet constraints, int wavelength, BigDecimal magnitude) {
        return GuideSpeed$.MODULE$.all().find((Function1 & Serializable)speed -> package$package$.MODULE$.gaiaBrightnessConstraints(constraints, (GuideSpeed)speed, wavelength).contains((Band)Band.Gaia$.MODULE$, magnitude));
    }

    public List<Tuple2<GuideSpeed, BrightnessConstraints>> guideSpeedLimits(ConstraintSet constraints, int wavelength) {
        return GuideSpeed$.MODULE$.all().map((Function1 & Serializable)speed -> Tuple2$.MODULE$.apply(speed, (Object)package$package$.MODULE$.gaiaBrightnessConstraints(constraints, (GuideSpeed)speed, wavelength)));
    }

    private static final Function1 runAnalysis$$anonfun$4() {
        return (Function1 & Serializable)_$5 -> Area.package.Area$.MODULE$.MaxArea();
    }

    private final boolean worseOrEqual$1(ConstraintSet constraints$2, ImageQuality iq) {
        return package.all$.MODULE$.catsSyntaxPartialOrder((Object)constraints$2.imageQuality(), (PartialOrder)ImageQuality$.MODULE$.given_Enumerated_ImageQuality()).$greater$eq((Object)iq);
    }

    private final AgsAnalysis usable$1(ConstraintSet constraints$1, GuideProbe guideProbe$1, GuideStarCandidate guideStar$1, AgsPosition position$1, Function1 vignettingArea$1, Offset gsOffset$2, GuideSpeed guideSpeed) {
        AgsGuideQuality agsGuideQuality;
        GuideSpeed guideSpeed2 = guideSpeed;
        if (GuideSpeed.Fast$.MODULE$.equals(guideSpeed2)) {
            agsGuideQuality = AgsGuideQuality$.DeliversRequestedIq;
        } else if (GuideSpeed.Medium$.MODULE$.equals(guideSpeed2)) {
            agsGuideQuality = this.worseOrEqual$1(constraints$1, (ImageQuality)ImageQuality.PointSix$.MODULE$) ? AgsGuideQuality$.DeliversRequestedIq : AgsGuideQuality$.PossibleIqDegradation;
        } else if (GuideSpeed.Slow$.MODULE$.equals(guideSpeed2)) {
            agsGuideQuality = this.worseOrEqual$1(constraints$1, (ImageQuality)ImageQuality.PointEight$.MODULE$) ? AgsGuideQuality$.DeliversRequestedIq : (this.worseOrEqual$1(constraints$1, (ImageQuality)ImageQuality.PointSix$.MODULE$) ? AgsGuideQuality$.PossibleIqDegradation : AgsGuideQuality$.IqDegradation);
        } else {
            throw new MatchError((Object)guideSpeed2);
        }
        AgsGuideQuality quality = agsGuideQuality;
        return AgsAnalysis$Usable$.MODULE$.apply(guideProbe$1, guideStar$1, guideSpeed, quality, (NonEmptyList<Tuple2<Object, Object>>)NonEmptyList$.MODULE$.one((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)position$1.posAngle()), vignettingArea$1.apply((Object)gsOffset$2))));
    }

    private static final AgsAnalysis magnitudeAnalysis$$anonfun$2(GuideProbe guideProbe$2, GuideStarCandidate guideStar$2) {
        return AgsAnalysis$NoGuideStarForProbe$.MODULE$.apply(guideProbe$2, guideStar$2);
    }

    private static final AgsAnalysis agsAnalysisStreamPM$$anonfun$1$$anonfun$2$$anonfun$2(GuideStarCandidate gsc$3) {
        return AgsAnalysis$ProperMotionNotAvailable$.MODULE$.apply(gsc$3);
    }

    private static final AgsAnalysis agsAnalysisPM$$anonfun$2$$anonfun$2(GuideStarCandidate gsc$6) {
        return AgsAnalysis$ProperMotionNotAvailable$.MODULE$.apply(gsc$6);
    }
}

