/*
 * Decompiled with CFR 0.152.
 */
package lucuma.ags;

import cats.data.NonEmptyList;
import cats.kernel.Eq;
import cats.kernel.Eq$;
import cats.kernel.Order;
import cats.syntax.package;
import java.io.Serializable;
import lucuma.ags.AgsAnalysis$;
import lucuma.ags.AgsAnalysis$MagnitudeTooBright$;
import lucuma.ags.AgsAnalysis$MagnitudeTooFaint$;
import lucuma.ags.AgsAnalysis$NoGuideStarForProbe$;
import lucuma.ags.AgsAnalysis$NoMagnitudeForBand$;
import lucuma.ags.AgsAnalysis$NotReachableAtPosition$;
import lucuma.ags.AgsAnalysis$ProperMotionNotAvailable$;
import lucuma.ags.AgsAnalysis$Usable$;
import lucuma.ags.AgsAnalysis$VignettesScience$;
import lucuma.ags.AgsGuideQuality;
import lucuma.ags.AgsGuideQuality$;
import lucuma.ags.AgsPosition;
import lucuma.ags.GuideStarCandidate;
import lucuma.catalog.BandsList;
import lucuma.core.enums.Band;
import lucuma.core.enums.GuideProbe;
import lucuma.core.enums.GuideSpeed;
import lucuma.core.geom.Area;
import lucuma.core.geom.Area$package$;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public interface AgsAnalysis {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(AgsAnalysis$.class.getDeclaredField("derived$Eq$lzy9"));

    public static Eq<AgsAnalysis> derived$Eq() {
        return AgsAnalysis$.MODULE$.derived$Eq();
    }

    public static int ordinal(AgsAnalysis agsAnalysis) {
        return AgsAnalysis$.MODULE$.ordinal(agsAnalysis);
    }

    public static Option<Object> posAngle(AgsAnalysis agsAnalysis) {
        return AgsAnalysis$.MODULE$.posAngle(agsAnalysis);
    }

    public static Option<Object> posAngle(Option<AgsAnalysis> option) {
        return AgsAnalysis$.MODULE$.posAngle(option);
    }

    public static Order<AgsAnalysis> rankingOrder() {
        return AgsAnalysis$.MODULE$.rankingOrder();
    }

    public static Ordering<AgsAnalysis> rankingOrdering() {
        return AgsAnalysis$.MODULE$.rankingOrdering();
    }

    public static List<AgsAnalysis> sortUsablePositions(List<AgsAnalysis> list) {
        return AgsAnalysis$.MODULE$.sortUsablePositions(list);
    }

    public static AgsGuideQuality quality$(AgsAnalysis $this) {
        return $this.quality();
    }

    default public AgsGuideQuality quality() {
        return AgsGuideQuality$.Unusable;
    }

    public static boolean isUsable$(AgsAnalysis $this) {
        return $this.isUsable();
    }

    default public boolean isUsable() {
        return package.all$.MODULE$.catsSyntaxEq((Object)this.quality(), AgsGuideQuality$.MODULE$.derived$Enumerated()).$eq$bang$eq((Object)AgsGuideQuality$.Unusable);
    }

    public GuideStarCandidate target();

    public String message(boolean var1);

    public static class MagnitudeTooBright
    implements AgsAnalysis,
    Product,
    Serializable {
        private final GuideProbe guideProbe;
        private final GuideStarCandidate target;
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(AgsAnalysis$MagnitudeTooBright$.class.getDeclaredField("derived$Eq$lzy5"));

        public static MagnitudeTooBright apply(GuideProbe guideProbe, GuideStarCandidate guideStarCandidate) {
            return AgsAnalysis$MagnitudeTooBright$.MODULE$.apply(guideProbe, guideStarCandidate);
        }

        public static Eq<MagnitudeTooBright> derived$Eq() {
            return AgsAnalysis$MagnitudeTooBright$.MODULE$.derived$Eq();
        }

        public static MagnitudeTooBright fromProduct(Product product) {
            return AgsAnalysis$MagnitudeTooBright$.MODULE$.fromProduct(product);
        }

        public static MagnitudeTooBright unapply(MagnitudeTooBright magnitudeTooBright) {
            return AgsAnalysis$MagnitudeTooBright$.MODULE$.unapply(magnitudeTooBright);
        }

        public MagnitudeTooBright(GuideProbe guideProbe, GuideStarCandidate target) {
            this.guideProbe = guideProbe;
            this.target = target;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MagnitudeTooBright)) return false;
            MagnitudeTooBright magnitudeTooBright = (MagnitudeTooBright)object;
            GuideProbe guideProbe = this.guideProbe();
            GuideProbe guideProbe2 = magnitudeTooBright.guideProbe();
            if (guideProbe == null) {
                if (guideProbe2 != null) {
                    return false;
                }
            } else if (!guideProbe.equals(guideProbe2)) return false;
            GuideStarCandidate guideStarCandidate = this.target();
            GuideStarCandidate guideStarCandidate2 = magnitudeTooBright.target();
            if (guideStarCandidate == null) {
                if (guideStarCandidate2 != null) {
                    return false;
                }
            } else if (!((Object)guideStarCandidate).equals(guideStarCandidate2)) return false;
            if (!magnitudeTooBright.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MagnitudeTooBright;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "MagnitudeTooBright";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "guideProbe";
            }
            if (1 == n2) {
                return "target";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public GuideProbe guideProbe() {
            return this.guideProbe;
        }

        @Override
        public GuideStarCandidate target() {
            return this.target;
        }

        @Override
        public String message(boolean withProbe) {
            String p = withProbe ? this.guideProbe() + " g" : "G";
            return p + "uide star is too bright to guide.";
        }

        public MagnitudeTooBright copy(GuideProbe guideProbe, GuideStarCandidate target) {
            return new MagnitudeTooBright(guideProbe, target);
        }

        public GuideProbe copy$default$1() {
            return this.guideProbe();
        }

        public GuideStarCandidate copy$default$2() {
            return this.target();
        }

        public GuideProbe _1() {
            return this.guideProbe();
        }

        public GuideStarCandidate _2() {
            return this.target();
        }
    }

    public static class MagnitudeTooFaint
    implements AgsAnalysis,
    Product,
    Serializable {
        private final GuideProbe guideProbe;
        private final GuideStarCandidate target;
        private final boolean showGuideSpeed;
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(AgsAnalysis$MagnitudeTooFaint$.class.getDeclaredField("derived$Eq$lzy4"));

        public static MagnitudeTooFaint apply(GuideProbe guideProbe, GuideStarCandidate guideStarCandidate, boolean bl) {
            return AgsAnalysis$MagnitudeTooFaint$.MODULE$.apply(guideProbe, guideStarCandidate, bl);
        }

        public static Eq<MagnitudeTooFaint> derived$Eq() {
            return AgsAnalysis$MagnitudeTooFaint$.MODULE$.derived$Eq();
        }

        public static MagnitudeTooFaint fromProduct(Product product) {
            return AgsAnalysis$MagnitudeTooFaint$.MODULE$.fromProduct(product);
        }

        public static MagnitudeTooFaint unapply(MagnitudeTooFaint magnitudeTooFaint) {
            return AgsAnalysis$MagnitudeTooFaint$.MODULE$.unapply(magnitudeTooFaint);
        }

        public MagnitudeTooFaint(GuideProbe guideProbe, GuideStarCandidate target, boolean showGuideSpeed) {
            this.guideProbe = guideProbe;
            this.target = target;
            this.showGuideSpeed = showGuideSpeed;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.guideProbe()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.target()));
            n = Statics.mix((int)n, (int)(this.showGuideSpeed() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MagnitudeTooFaint)) return false;
            MagnitudeTooFaint magnitudeTooFaint = (MagnitudeTooFaint)object;
            if (this.showGuideSpeed() != magnitudeTooFaint.showGuideSpeed()) return false;
            GuideProbe guideProbe = this.guideProbe();
            GuideProbe guideProbe2 = magnitudeTooFaint.guideProbe();
            if (guideProbe == null) {
                if (guideProbe2 != null) {
                    return false;
                }
            } else if (!guideProbe.equals(guideProbe2)) return false;
            GuideStarCandidate guideStarCandidate = this.target();
            GuideStarCandidate guideStarCandidate2 = magnitudeTooFaint.target();
            if (guideStarCandidate == null) {
                if (guideStarCandidate2 != null) {
                    return false;
                }
            } else if (!((Object)guideStarCandidate).equals(guideStarCandidate2)) return false;
            if (!magnitudeTooFaint.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MagnitudeTooFaint;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "MagnitudeTooFaint";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean((boolean)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "guideProbe";
                }
                case 1: {
                    return "target";
                }
                case 2: {
                    return "showGuideSpeed";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public GuideProbe guideProbe() {
            return this.guideProbe;
        }

        @Override
        public GuideStarCandidate target() {
            return this.target;
        }

        public boolean showGuideSpeed() {
            return this.showGuideSpeed;
        }

        @Override
        public String message(boolean withProbe) {
            String p = withProbe ? "use " + this.guideProbe() : "guide";
            String gs = this.showGuideSpeed() ? ", even using the slowest guide speed" : "";
            return "Cannot " + p + " with the star in these conditions" + gs + ".";
        }

        public MagnitudeTooFaint copy(GuideProbe guideProbe, GuideStarCandidate target, boolean showGuideSpeed) {
            return new MagnitudeTooFaint(guideProbe, target, showGuideSpeed);
        }

        public GuideProbe copy$default$1() {
            return this.guideProbe();
        }

        public GuideStarCandidate copy$default$2() {
            return this.target();
        }

        public boolean copy$default$3() {
            return this.showGuideSpeed();
        }

        public GuideProbe _1() {
            return this.guideProbe();
        }

        public GuideStarCandidate _2() {
            return this.target();
        }

        public boolean _3() {
            return this.showGuideSpeed();
        }
    }

    public static class NoGuideStarForProbe
    implements AgsAnalysis,
    Product,
    Serializable {
        private final GuideProbe guideProbe;
        private final GuideStarCandidate target;
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(AgsAnalysis$NoGuideStarForProbe$.class.getDeclaredField("derived$Eq$lzy3"));

        public static NoGuideStarForProbe apply(GuideProbe guideProbe, GuideStarCandidate guideStarCandidate) {
            return AgsAnalysis$NoGuideStarForProbe$.MODULE$.apply(guideProbe, guideStarCandidate);
        }

        public static Eq<NoGuideStarForProbe> derived$Eq() {
            return AgsAnalysis$NoGuideStarForProbe$.MODULE$.derived$Eq();
        }

        public static NoGuideStarForProbe fromProduct(Product product) {
            return AgsAnalysis$NoGuideStarForProbe$.MODULE$.fromProduct(product);
        }

        public static NoGuideStarForProbe unapply(NoGuideStarForProbe noGuideStarForProbe) {
            return AgsAnalysis$NoGuideStarForProbe$.MODULE$.unapply(noGuideStarForProbe);
        }

        public NoGuideStarForProbe(GuideProbe guideProbe, GuideStarCandidate target) {
            this.guideProbe = guideProbe;
            this.target = target;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof NoGuideStarForProbe)) return false;
            NoGuideStarForProbe noGuideStarForProbe = (NoGuideStarForProbe)object;
            GuideProbe guideProbe = this.guideProbe();
            GuideProbe guideProbe2 = noGuideStarForProbe.guideProbe();
            if (guideProbe == null) {
                if (guideProbe2 != null) {
                    return false;
                }
            } else if (!guideProbe.equals(guideProbe2)) return false;
            GuideStarCandidate guideStarCandidate = this.target();
            GuideStarCandidate guideStarCandidate2 = noGuideStarForProbe.target();
            if (guideStarCandidate == null) {
                if (guideStarCandidate2 != null) {
                    return false;
                }
            } else if (!((Object)guideStarCandidate).equals(guideStarCandidate2)) return false;
            if (!noGuideStarForProbe.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof NoGuideStarForProbe;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "NoGuideStarForProbe";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "guideProbe";
            }
            if (1 == n2) {
                return "target";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public GuideProbe guideProbe() {
            return this.guideProbe;
        }

        @Override
        public GuideStarCandidate target() {
            return this.target;
        }

        @Override
        public String message(boolean withProbe) {
            String p = withProbe ? this.guideProbe() + " " : "";
            return "No " + p + "guide star selected.";
        }

        public NoGuideStarForProbe copy(GuideProbe guideProbe, GuideStarCandidate target) {
            return new NoGuideStarForProbe(guideProbe, target);
        }

        public GuideProbe copy$default$1() {
            return this.guideProbe();
        }

        public GuideStarCandidate copy$default$2() {
            return this.target();
        }

        public GuideProbe _1() {
            return this.guideProbe();
        }

        public GuideStarCandidate _2() {
            return this.target();
        }
    }

    public static class NoMagnitudeForBand
    implements AgsAnalysis,
    Product,
    Serializable {
        private final GuideProbe guideProbe;
        private final GuideStarCandidate target;
        private final List<Band> probeBands;
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(AgsAnalysis$NoMagnitudeForBand$.class.getDeclaredField("derived$Eq$lzy7"));

        public static NoMagnitudeForBand apply(GuideProbe guideProbe, GuideStarCandidate guideStarCandidate) {
            return AgsAnalysis$NoMagnitudeForBand$.MODULE$.apply(guideProbe, guideStarCandidate);
        }

        public static Eq<NoMagnitudeForBand> derived$Eq() {
            return AgsAnalysis$NoMagnitudeForBand$.MODULE$.derived$Eq();
        }

        public static NoMagnitudeForBand fromProduct(Product product) {
            return AgsAnalysis$NoMagnitudeForBand$.MODULE$.fromProduct(product);
        }

        public static NoMagnitudeForBand unapply(NoMagnitudeForBand noMagnitudeForBand) {
            return AgsAnalysis$NoMagnitudeForBand$.MODULE$.unapply(noMagnitudeForBand);
        }

        public NoMagnitudeForBand(GuideProbe guideProbe, GuideStarCandidate target) {
            this.guideProbe = guideProbe;
            this.target = target;
            this.probeBands = BandsList.GaiaBandsList$.MODULE$.bands();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof NoMagnitudeForBand)) return false;
            NoMagnitudeForBand noMagnitudeForBand = (NoMagnitudeForBand)object;
            GuideProbe guideProbe = this.guideProbe();
            GuideProbe guideProbe2 = noMagnitudeForBand.guideProbe();
            if (guideProbe == null) {
                if (guideProbe2 != null) {
                    return false;
                }
            } else if (!guideProbe.equals(guideProbe2)) return false;
            GuideStarCandidate guideStarCandidate = this.target();
            GuideStarCandidate guideStarCandidate2 = noMagnitudeForBand.target();
            if (guideStarCandidate == null) {
                if (guideStarCandidate2 != null) {
                    return false;
                }
            } else if (!((Object)guideStarCandidate).equals(guideStarCandidate2)) return false;
            if (!noMagnitudeForBand.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof NoMagnitudeForBand;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "NoMagnitudeForBand";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "guideProbe";
            }
            if (1 == n2) {
                return "target";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public GuideProbe guideProbe() {
            return this.guideProbe;
        }

        @Override
        public GuideStarCandidate target() {
            return this.target;
        }

        @Override
        public String message(boolean withProbe) {
            String p;
            String string = p = withProbe ? this.guideProbe() + " g" : "G";
            if (this.probeBands.length() == 1) {
                return p + "uide star " + this.probeBands.head() + "-band magnitude is missing. Cannot determine guiding performance.";
            }
            return p + "uide star " + this.probeBands.map(AgsAnalysis$::lucuma$ags$AgsAnalysis$NoMagnitudeForBand$$_$message$$anonfun$1).mkString(", ") + "-band magnitudes are missing. Cannot determine guiding performance.";
        }

        public NoMagnitudeForBand copy(GuideProbe guideProbe, GuideStarCandidate target) {
            return new NoMagnitudeForBand(guideProbe, target);
        }

        public GuideProbe copy$default$1() {
            return this.guideProbe();
        }

        public GuideStarCandidate copy$default$2() {
            return this.target();
        }

        public GuideProbe _1() {
            return this.guideProbe();
        }

        public GuideStarCandidate _2() {
            return this.target();
        }
    }

    public static class NotReachableAtPosition
    implements AgsAnalysis,
    Product,
    Serializable {
        private final AgsPosition position;
        private final GuideProbe guideProbe;
        private final Option<GuideSpeed> guideSpeed;
        private final GuideStarCandidate target;
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(AgsAnalysis$NotReachableAtPosition$.class.getDeclaredField("derived$Eq$lzy6"));

        public static NotReachableAtPosition apply(AgsPosition agsPosition, GuideProbe guideProbe, Option<GuideSpeed> option, GuideStarCandidate guideStarCandidate) {
            return AgsAnalysis$NotReachableAtPosition$.MODULE$.apply(agsPosition, guideProbe, option, guideStarCandidate);
        }

        public static Eq<NotReachableAtPosition> derived$Eq() {
            return AgsAnalysis$NotReachableAtPosition$.MODULE$.derived$Eq();
        }

        public static NotReachableAtPosition fromProduct(Product product) {
            return AgsAnalysis$NotReachableAtPosition$.MODULE$.fromProduct(product);
        }

        public static NotReachableAtPosition unapply(NotReachableAtPosition notReachableAtPosition) {
            return AgsAnalysis$NotReachableAtPosition$.MODULE$.unapply(notReachableAtPosition);
        }

        public NotReachableAtPosition(AgsPosition position, GuideProbe guideProbe, Option<GuideSpeed> guideSpeed, GuideStarCandidate target) {
            this.position = position;
            this.guideProbe = guideProbe;
            this.guideSpeed = guideSpeed;
            this.target = target;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof NotReachableAtPosition)) return false;
            NotReachableAtPosition notReachableAtPosition = (NotReachableAtPosition)object;
            AgsPosition agsPosition = this.position();
            AgsPosition agsPosition2 = notReachableAtPosition.position();
            if (agsPosition == null) {
                if (agsPosition2 != null) {
                    return false;
                }
            } else if (!((Object)agsPosition).equals(agsPosition2)) return false;
            GuideProbe guideProbe = this.guideProbe();
            GuideProbe guideProbe2 = notReachableAtPosition.guideProbe();
            if (guideProbe == null) {
                if (guideProbe2 != null) {
                    return false;
                }
            } else if (!guideProbe.equals(guideProbe2)) return false;
            Option<GuideSpeed> option = this.guideSpeed();
            Option<GuideSpeed> option2 = notReachableAtPosition.guideSpeed();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            GuideStarCandidate guideStarCandidate = this.target();
            GuideStarCandidate guideStarCandidate2 = notReachableAtPosition.target();
            if (guideStarCandidate == null) {
                if (guideStarCandidate2 != null) {
                    return false;
                }
            } else if (!((Object)guideStarCandidate).equals(guideStarCandidate2)) return false;
            if (!notReachableAtPosition.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof NotReachableAtPosition;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "NotReachableAtPosition";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "position";
                }
                case 1: {
                    return "guideProbe";
                }
                case 2: {
                    return "guideSpeed";
                }
                case 3: {
                    return "target";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public AgsPosition position() {
            return this.position;
        }

        public GuideProbe guideProbe() {
            return this.guideProbe;
        }

        public Option<GuideSpeed> guideSpeed() {
            return this.guideSpeed;
        }

        @Override
        public GuideStarCandidate target() {
            return this.target;
        }

        @Override
        public String message(boolean withProbe) {
            String p = withProbe ? "with " + this.guideProbe() + " " : "";
            return "The star is not reachable " + p + "at " + this.position() + ".";
        }

        public NotReachableAtPosition copy(AgsPosition position, GuideProbe guideProbe, Option<GuideSpeed> guideSpeed, GuideStarCandidate target) {
            return new NotReachableAtPosition(position, guideProbe, guideSpeed, target);
        }

        public AgsPosition copy$default$1() {
            return this.position();
        }

        public GuideProbe copy$default$2() {
            return this.guideProbe();
        }

        public Option<GuideSpeed> copy$default$3() {
            return this.guideSpeed();
        }

        public GuideStarCandidate copy$default$4() {
            return this.target();
        }

        public AgsPosition _1() {
            return this.position();
        }

        public GuideProbe _2() {
            return this.guideProbe();
        }

        public Option<GuideSpeed> _3() {
            return this.guideSpeed();
        }

        public GuideStarCandidate _4() {
            return this.target();
        }
    }

    public static class ProperMotionNotAvailable
    implements AgsAnalysis,
    Product,
    Serializable {
        private final GuideStarCandidate target;
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(AgsAnalysis$ProperMotionNotAvailable$.class.getDeclaredField("derived$Eq$lzy1"));

        public static ProperMotionNotAvailable apply(GuideStarCandidate guideStarCandidate) {
            return AgsAnalysis$ProperMotionNotAvailable$.MODULE$.apply(guideStarCandidate);
        }

        public static Eq<ProperMotionNotAvailable> derived$Eq() {
            return AgsAnalysis$ProperMotionNotAvailable$.MODULE$.derived$Eq();
        }

        public static ProperMotionNotAvailable fromProduct(Product product) {
            return AgsAnalysis$ProperMotionNotAvailable$.MODULE$.fromProduct(product);
        }

        public static ProperMotionNotAvailable unapply(ProperMotionNotAvailable properMotionNotAvailable) {
            return AgsAnalysis$ProperMotionNotAvailable$.MODULE$.unapply(properMotionNotAvailable);
        }

        public ProperMotionNotAvailable(GuideStarCandidate target) {
            this.target = target;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ProperMotionNotAvailable)) return false;
            ProperMotionNotAvailable properMotionNotAvailable = (ProperMotionNotAvailable)object;
            GuideStarCandidate guideStarCandidate = this.target();
            GuideStarCandidate guideStarCandidate2 = properMotionNotAvailable.target();
            if (guideStarCandidate == null) {
                if (guideStarCandidate2 != null) {
                    return false;
                }
            } else if (!((Object)guideStarCandidate).equals(guideStarCandidate2)) return false;
            if (!properMotionNotAvailable.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ProperMotionNotAvailable;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ProperMotionNotAvailable";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "target";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public GuideStarCandidate target() {
            return this.target;
        }

        @Override
        public String message(boolean withProbe) {
            return "Cannot calculate proper motion.";
        }

        public ProperMotionNotAvailable copy(GuideStarCandidate target) {
            return new ProperMotionNotAvailable(target);
        }

        public GuideStarCandidate copy$default$1() {
            return this.target();
        }

        public GuideStarCandidate _1() {
            return this.target();
        }
    }

    public static class Usable
    implements AgsAnalysis,
    Product,
    Serializable {
        private final GuideProbe guideProbe;
        private final GuideStarCandidate target;
        private final GuideSpeed guideSpeed;
        private final AgsGuideQuality quality;
        private final NonEmptyList<Tuple2<Object, Object>> vignetting;
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(AgsAnalysis$Usable$.class.getDeclaredField("derived$Eq$lzy8"));

        public static Usable apply(GuideProbe guideProbe, GuideStarCandidate guideStarCandidate, GuideSpeed guideSpeed, AgsGuideQuality agsGuideQuality, NonEmptyList<Tuple2<Object, Object>> nonEmptyList) {
            return AgsAnalysis$Usable$.MODULE$.apply(guideProbe, guideStarCandidate, guideSpeed, agsGuideQuality, nonEmptyList);
        }

        public static Eq<Usable> derived$Eq() {
            return AgsAnalysis$Usable$.MODULE$.derived$Eq();
        }

        public static Usable fromProduct(Product product) {
            return AgsAnalysis$Usable$.MODULE$.fromProduct(product);
        }

        public static Order<Usable> rankingOrder() {
            return AgsAnalysis$Usable$.MODULE$.rankingOrder();
        }

        public static Usable unapply(Usable usable) {
            return AgsAnalysis$Usable$.MODULE$.unapply(usable);
        }

        public Usable(GuideProbe guideProbe, GuideStarCandidate target, GuideSpeed guideSpeed, AgsGuideQuality quality, NonEmptyList<Tuple2<Object, Object>> vignetting) {
            this.guideProbe = guideProbe;
            this.target = target;
            this.guideSpeed = guideSpeed;
            this.quality = quality;
            this.vignetting = vignetting;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Usable)) return false;
            Usable usable = (Usable)object;
            GuideProbe guideProbe = this.guideProbe();
            GuideProbe guideProbe2 = usable.guideProbe();
            if (guideProbe == null) {
                if (guideProbe2 != null) {
                    return false;
                }
            } else if (!guideProbe.equals(guideProbe2)) return false;
            GuideStarCandidate guideStarCandidate = this.target();
            GuideStarCandidate guideStarCandidate2 = usable.target();
            if (guideStarCandidate == null) {
                if (guideStarCandidate2 != null) {
                    return false;
                }
            } else if (!((Object)guideStarCandidate).equals(guideStarCandidate2)) return false;
            GuideSpeed guideSpeed = this.guideSpeed();
            GuideSpeed guideSpeed2 = usable.guideSpeed();
            if (guideSpeed == null) {
                if (guideSpeed2 != null) {
                    return false;
                }
            } else if (!guideSpeed.equals(guideSpeed2)) return false;
            AgsGuideQuality agsGuideQuality = this.quality();
            AgsGuideQuality agsGuideQuality2 = usable.quality();
            if (agsGuideQuality == null) {
                if (agsGuideQuality2 != null) {
                    return false;
                }
            } else if (!agsGuideQuality.equals(agsGuideQuality2)) return false;
            NonEmptyList<Tuple2<Object, Object>> nonEmptyList = this.vignetting();
            NonEmptyList<Tuple2<Object, Object>> nonEmptyList2 = usable.vignetting();
            if (nonEmptyList == null) {
                if (nonEmptyList2 != null) {
                    return false;
                }
            } else if (!nonEmptyList.equals(nonEmptyList2)) return false;
            if (!usable.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Usable;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "Usable";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "guideProbe";
                }
                case 1: {
                    return "target";
                }
                case 2: {
                    return "guideSpeed";
                }
                case 3: {
                    return "quality";
                }
                case 4: {
                    return "vignetting";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public GuideProbe guideProbe() {
            return this.guideProbe;
        }

        @Override
        public GuideStarCandidate target() {
            return this.target;
        }

        public GuideSpeed guideSpeed() {
            return this.guideSpeed;
        }

        @Override
        public AgsGuideQuality quality() {
            return this.quality;
        }

        public NonEmptyList<Tuple2<Object, Object>> vignetting() {
            return this.vignetting;
        }

        @Override
        public String message(boolean withProbe) {
            AgsGuideQuality agsGuideQuality = this.quality();
            AgsGuideQuality agsGuideQuality2 = AgsGuideQuality$.DeliversRequestedIq;
            AgsGuideQuality agsGuideQuality3 = agsGuideQuality;
            String qualityMessage = !(agsGuideQuality2 != null ? !agsGuideQuality2.equals(agsGuideQuality3) : agsGuideQuality3 != null) ? "" : this.quality().message() + " ";
            String p = withProbe ? this.guideProbe() + " " : "";
            String gs = "Guide Speed: " + this.guideSpeed().toString();
            Area$package$ area$package$ = Area$package$.MODULE$;
            long a$proxy1 = ((Tuple2)this.vignetting().head())._2$mcJ$sp();
            String cfr_ignored_0 = qualityMessage + p + gs + ". vignetting: " + BoxesRunTime.boxToLong((long)a$proxy1) + " \u00b5as^2";
            Area$package$ area$package$2 = Area$package$.MODULE$;
            long a$proxy2 = ((Tuple2)this.vignetting().head())._2$mcJ$sp();
            return p + " " + this.quality() + " " + gs + ". vignetting: " + BoxesRunTime.boxToLong((long)a$proxy2) + " \u00b5as^2";
        }

        public Usable sortedVignetting() {
            NonEmptyList nonEmptyList = this.vignetting().sortBy(AgsAnalysis$::lucuma$ags$AgsAnalysis$Usable$$_$_$$anonfun$1, Area.package.Area$.MODULE$.given_Order_Area((Order)Eq$.MODULE$.catsKernelInstancesForLong()));
            GuideProbe guideProbe = this.copy$default$1();
            GuideStarCandidate guideStarCandidate = this.copy$default$2();
            GuideSpeed guideSpeed = this.copy$default$3();
            AgsGuideQuality agsGuideQuality = this.copy$default$4();
            return this.copy(guideProbe, guideStarCandidate, guideSpeed, agsGuideQuality, (NonEmptyList<Tuple2<Object, Object>>)nonEmptyList);
        }

        public Usable copy(GuideProbe guideProbe, GuideStarCandidate target, GuideSpeed guideSpeed, AgsGuideQuality quality, NonEmptyList<Tuple2<Object, Object>> vignetting) {
            return new Usable(guideProbe, target, guideSpeed, quality, vignetting);
        }

        public GuideProbe copy$default$1() {
            return this.guideProbe();
        }

        public GuideStarCandidate copy$default$2() {
            return this.target();
        }

        public GuideSpeed copy$default$3() {
            return this.guideSpeed();
        }

        public AgsGuideQuality copy$default$4() {
            return this.quality();
        }

        public NonEmptyList<Tuple2<Object, Object>> copy$default$5() {
            return this.vignetting();
        }

        public GuideProbe _1() {
            return this.guideProbe();
        }

        public GuideStarCandidate _2() {
            return this.target();
        }

        public GuideSpeed _3() {
            return this.guideSpeed();
        }

        public AgsGuideQuality _4() {
            return this.quality();
        }

        public NonEmptyList<Tuple2<Object, Object>> _5() {
            return this.vignetting();
        }
    }

    public static class VignettesScience
    implements AgsAnalysis,
    Product,
    Serializable {
        private final GuideStarCandidate target;
        private final AgsPosition position;
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(AgsAnalysis$VignettesScience$.class.getDeclaredField("derived$Eq$lzy2"));

        public static VignettesScience apply(GuideStarCandidate guideStarCandidate, AgsPosition agsPosition) {
            return AgsAnalysis$VignettesScience$.MODULE$.apply(guideStarCandidate, agsPosition);
        }

        public static Eq<VignettesScience> derived$Eq() {
            return AgsAnalysis$VignettesScience$.MODULE$.derived$Eq();
        }

        public static VignettesScience fromProduct(Product product) {
            return AgsAnalysis$VignettesScience$.MODULE$.fromProduct(product);
        }

        public static VignettesScience unapply(VignettesScience vignettesScience) {
            return AgsAnalysis$VignettesScience$.MODULE$.unapply(vignettesScience);
        }

        public VignettesScience(GuideStarCandidate target, AgsPosition position) {
            this.target = target;
            this.position = position;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof VignettesScience)) return false;
            VignettesScience vignettesScience = (VignettesScience)object;
            GuideStarCandidate guideStarCandidate = this.target();
            GuideStarCandidate guideStarCandidate2 = vignettesScience.target();
            if (guideStarCandidate == null) {
                if (guideStarCandidate2 != null) {
                    return false;
                }
            } else if (!((Object)guideStarCandidate).equals(guideStarCandidate2)) return false;
            AgsPosition agsPosition = this.position();
            AgsPosition agsPosition2 = vignettesScience.position();
            if (agsPosition == null) {
                if (agsPosition2 != null) {
                    return false;
                }
            } else if (!((Object)agsPosition).equals(agsPosition2)) return false;
            if (!vignettesScience.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof VignettesScience;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "VignettesScience";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "target";
            }
            if (1 == n2) {
                return "position";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public GuideStarCandidate target() {
            return this.target;
        }

        public AgsPosition position() {
            return this.position;
        }

        @Override
        public String message(boolean withProbe) {
            return "The target overlaps with the science target";
        }

        public VignettesScience copy(GuideStarCandidate target, AgsPosition position) {
            return new VignettesScience(target, position);
        }

        public GuideStarCandidate copy$default$1() {
            return this.target();
        }

        public AgsPosition copy$default$2() {
            return this.position();
        }

        public GuideStarCandidate _1() {
            return this.target();
        }

        public AgsPosition _2() {
            return this.position();
        }
    }
}

