/*
 * Decompiled with CFR 0.152.
 */
package lucuma.catalog.csv;

import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import java.io.Serializable;
import lucuma.catalog.csv.TargetCsvRow$;
import lucuma.core.enums.Band;
import lucuma.core.enums.Band$;
import lucuma.core.enums.StellarLibrarySpectrum;
import lucuma.core.math.Declination;
import lucuma.core.math.Epoch;
import lucuma.core.math.Parallax;
import lucuma.core.math.RadialVelocity;
import lucuma.core.math.Redshift;
import lucuma.core.math.RightAscension;
import lucuma.core.math.dimensional.Measure;
import lucuma.core.math.dimensional.Units;
import lucuma.core.math.dimensional.Units$;
import lucuma.core.model.SourceProfile;
import lucuma.core.model.SpectralDefinition;
import lucuma.core.model.UnnormalizedSED;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.SortedMap;
import scala.collection.immutable.SortedMap$;
import scala.math.BigDecimal;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class TargetCsvRow
implements Product,
Serializable {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(TargetCsvRow.class.getDeclaredField("surfaceBrightness$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(TargetCsvRow.class.getDeclaredField("integratedBrightness$lzy1"));
    private final Option<Object> line;
    private final String name;
    private final boolean bare;
    private final Option<RightAscension> ra;
    private final Option<Declination> dec;
    private final Option<Object> pmRA;
    private final Option<Object> pmDec;
    private final Option<Epoch> epoch;
    private final Map<Band, BigDecimal> brightnesses;
    private final Map<Band, Units> integratedUnits;
    private final Map<Band, Units> surfaceUnits;
    private final Option<Parallax> parallax;
    private final Option<RadialVelocity> rv;
    private final Option<Redshift> z;
    private volatile Object integratedBrightness$lzy1;
    private volatile Object surfaceBrightness$lzy1;
    private final SourceProfile sourceProfile;

    public static TargetCsvRow apply(Option<Object> option, String string, boolean bl, Option<RightAscension> option2, Option<Declination> option3, Option<Object> option4, Option<Object> option5, Option<Epoch> option6, Map<Band, BigDecimal> map, Map<Band, Units> map2, Map<Band, Units> map3, Option<Parallax> option7, Option<RadialVelocity> option8, Option<Redshift> option9) {
        return TargetCsvRow$.MODULE$.apply(option, string, bl, option2, option3, option4, option5, option6, map, map2, map3, option7, option8, option9);
    }

    public static TargetCsvRow fromProduct(Product product) {
        return TargetCsvRow$.MODULE$.fromProduct(product);
    }

    public static TargetCsvRow unapply(TargetCsvRow targetCsvRow) {
        return TargetCsvRow$.MODULE$.unapply(targetCsvRow);
    }

    public TargetCsvRow(Option<Object> line, String name, boolean bare, Option<RightAscension> ra, Option<Declination> dec, Option<Object> pmRA, Option<Object> pmDec, Option<Epoch> epoch, Map<Band, BigDecimal> brightnesses, Map<Band, Units> integratedUnits, Map<Band, Units> surfaceUnits, Option<Parallax> parallax, Option<RadialVelocity> rv, Option<Redshift> z) {
        SourceProfile.Point point;
        this.line = line;
        this.name = name;
        this.bare = bare;
        this.ra = ra;
        this.dec = dec;
        this.pmRA = pmRA;
        this.pmDec = pmDec;
        this.epoch = epoch;
        this.brightnesses = brightnesses;
        this.integratedUnits = integratedUnits;
        this.surfaceUnits = surfaceUnits;
        this.parallax = parallax;
        this.rv = rv;
        this.z = z;
        if (surfaceUnits.nonEmpty()) {
            UnnormalizedSED.StellarLibrary stellarLibrary = (UnnormalizedSED.StellarLibrary)package.all$.MODULE$.catsSyntaxOptionId((Object)UnnormalizedSED.StellarLibrary$.MODULE$.apply((StellarLibrarySpectrum)StellarLibrarySpectrum.O5V$.MODULE$));
            point = SourceProfile.Uniform$.MODULE$.apply((SpectralDefinition)SpectralDefinition.BandNormalized$.MODULE$.apply(OptionIdOps$.MODULE$.some$extension((Object)stellarLibrary), (SortedMap)SortedMap$.MODULE$.apply(this.surfaceBrightness(), Band$.MODULE$.given_Ordering_Band())));
        } else {
            point = SourceProfile.Point$.MODULE$.apply((SpectralDefinition)SpectralDefinition.BandNormalized$.MODULE$.apply((Option)None$.MODULE$, (SortedMap)SortedMap$.MODULE$.apply(this.integratedBrightness(), Band$.MODULE$.given_Ordering_Band())));
        }
        this.sourceProfile = point;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.line()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
        n = Statics.mix((int)n, (int)(this.bare() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.ra()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.dec()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.pmRA()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.pmDec()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.epoch()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.brightnesses()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.integratedUnits()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.surfaceUnits()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.parallax()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.rv()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.z()));
        return Statics.finalizeHash((int)n, (int)14);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof TargetCsvRow)) return false;
        TargetCsvRow targetCsvRow = (TargetCsvRow)object;
        if (this.bare() != targetCsvRow.bare()) return false;
        Option<Object> option = this.line();
        Option<Object> option2 = targetCsvRow.line();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        String string = this.name();
        String string2 = targetCsvRow.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Option<RightAscension> option3 = this.ra();
        Option<RightAscension> option4 = targetCsvRow.ra();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<Declination> option5 = this.dec();
        Option<Declination> option6 = targetCsvRow.dec();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        Option<Object> option7 = this.pmRA();
        Option<Object> option8 = targetCsvRow.pmRA();
        if (option7 == null) {
            if (option8 != null) {
                return false;
            }
        } else if (!option7.equals(option8)) return false;
        Option<Object> option9 = this.pmDec();
        Option<Object> option10 = targetCsvRow.pmDec();
        if (option9 == null) {
            if (option10 != null) {
                return false;
            }
        } else if (!option9.equals(option10)) return false;
        Option<Epoch> option11 = this.epoch();
        Option<Epoch> option12 = targetCsvRow.epoch();
        if (option11 == null) {
            if (option12 != null) {
                return false;
            }
        } else if (!option11.equals(option12)) return false;
        Map<Band, BigDecimal> map = this.brightnesses();
        Map<Band, BigDecimal> map2 = targetCsvRow.brightnesses();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Map<Band, Units> map3 = this.integratedUnits();
        Map<Band, Units> map4 = targetCsvRow.integratedUnits();
        if (map3 == null) {
            if (map4 != null) {
                return false;
            }
        } else if (!map3.equals(map4)) return false;
        Map<Band, Units> map5 = this.surfaceUnits();
        Map<Band, Units> map6 = targetCsvRow.surfaceUnits();
        if (map5 == null) {
            if (map6 != null) {
                return false;
            }
        } else if (!map5.equals(map6)) return false;
        Option<Parallax> option13 = this.parallax();
        Option<Parallax> option14 = targetCsvRow.parallax();
        if (option13 == null) {
            if (option14 != null) {
                return false;
            }
        } else if (!option13.equals(option14)) return false;
        Option<RadialVelocity> option15 = this.rv();
        Option<RadialVelocity> option16 = targetCsvRow.rv();
        if (option15 == null) {
            if (option16 != null) {
                return false;
            }
        } else if (!option15.equals(option16)) return false;
        Option<Redshift> option17 = this.z();
        Option<Redshift> option18 = targetCsvRow.z();
        if (option17 == null) {
            if (option18 != null) {
                return false;
            }
        } else if (!option17.equals(option18)) return false;
        if (!targetCsvRow.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof TargetCsvRow;
    }

    public int productArity() {
        return 14;
    }

    public String productPrefix() {
        return "TargetCsvRow";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return BoxesRunTime.boxToBoolean((boolean)this._3());
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
            case 6: {
                return this._7();
            }
            case 7: {
                return this._8();
            }
            case 8: {
                return this._9();
            }
            case 9: {
                return this._10();
            }
            case 10: {
                return this._11();
            }
            case 11: {
                return this._12();
            }
            case 12: {
                return this._13();
            }
            case 13: {
                return this._14();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "line";
            }
            case 1: {
                return "name";
            }
            case 2: {
                return "bare";
            }
            case 3: {
                return "ra";
            }
            case 4: {
                return "dec";
            }
            case 5: {
                return "pmRA";
            }
            case 6: {
                return "pmDec";
            }
            case 7: {
                return "epoch";
            }
            case 8: {
                return "brightnesses";
            }
            case 9: {
                return "integratedUnits";
            }
            case 10: {
                return "surfaceUnits";
            }
            case 11: {
                return "parallax";
            }
            case 12: {
                return "rv";
            }
            case 13: {
                return "z";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Option<Object> line() {
        return this.line;
    }

    public String name() {
        return this.name;
    }

    public boolean bare() {
        return this.bare;
    }

    public Option<RightAscension> ra() {
        return this.ra;
    }

    public Option<Declination> dec() {
        return this.dec;
    }

    public Option<Object> pmRA() {
        return this.pmRA;
    }

    public Option<Object> pmDec() {
        return this.pmDec;
    }

    public Option<Epoch> epoch() {
        return this.epoch;
    }

    public Map<Band, BigDecimal> brightnesses() {
        return this.brightnesses;
    }

    public Map<Band, Units> integratedUnits() {
        return this.integratedUnits;
    }

    public Map<Band, Units> surfaceUnits() {
        return this.surfaceUnits;
    }

    public Option<Parallax> parallax() {
        return this.parallax;
    }

    public Option<RadialVelocity> rv() {
        return this.rv;
    }

    public Option<Redshift> z() {
        return this.z;
    }

    private <A> List<Tuple2<Band, Measure<BigDecimal>>> brightnessAndUnit(Map<Band, BigDecimal> brightnesses, Map<Band, Units> units, Function1<Band, Units> defaultUnit) {
        return brightnesses.map((Function1 & Serializable)b -> {
            Band band = (Band)Predef$.MODULE$.ArrowAssoc(b._1());
            Units units = (Units)units.getOrElse(b._1(), () -> TargetCsvRow.$anonfun$1(defaultUnit, b));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)band, (Object)Units$.MODULE$.withValueTagged(units, b._2(), Units$.MODULE$.withValueTagged$default$3(units)));
        }).toList();
    }

    private List<Tuple2<Band, Measure<BigDecimal>>> integratedBrightness() {
        Object object = this.integratedBrightness$lzy1;
        if (object instanceof List) {
            return (List)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (List)this.integratedBrightness$lzyINIT1();
    }

    private Object integratedBrightness$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.integratedBrightness$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    List<Tuple2<Band, Measure<BigDecimal>>> list = null;
                    List<Tuple2<Band, Measure<BigDecimal>>> list2 = null;
                    try {
                        list2 = this.brightnessAndUnit(this.brightnesses(), this.integratedUnits(), (Function1<Band, Units>)(Function1 & Serializable)_$1 -> _$1.defaultIntegrated().units());
                        list = list2 == null ? LazyVals.NullValue$.MODULE$ : list2;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, list)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.integratedBrightness$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, list);
                            waiting.countDown();
                        }
                    }
                    return list2;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private List<Tuple2<Band, Measure<BigDecimal>>> surfaceBrightness() {
        Object object = this.surfaceBrightness$lzy1;
        if (object instanceof List) {
            return (List)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (List)this.surfaceBrightness$lzyINIT1();
    }

    private Object surfaceBrightness$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.surfaceBrightness$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    List<Tuple2<Band, Measure<BigDecimal>>> list = null;
                    List<Tuple2<Band, Measure<BigDecimal>>> list2 = null;
                    try {
                        list2 = this.brightnessAndUnit(this.brightnesses(), this.surfaceUnits(), (Function1<Band, Units>)(Function1 & Serializable)_$2 -> _$2.defaultSurface().units());
                        list = list2 == null ? LazyVals.NullValue$.MODULE$ : list2;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, list)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.surfaceBrightness$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, list);
                            waiting.countDown();
                        }
                    }
                    return list2;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public SourceProfile sourceProfile() {
        return this.sourceProfile;
    }

    public TargetCsvRow copy(Option<Object> line, String name, boolean bare, Option<RightAscension> ra, Option<Declination> dec, Option<Object> pmRA, Option<Object> pmDec, Option<Epoch> epoch, Map<Band, BigDecimal> brightnesses, Map<Band, Units> integratedUnits, Map<Band, Units> surfaceUnits, Option<Parallax> parallax, Option<RadialVelocity> rv, Option<Redshift> z) {
        return new TargetCsvRow(line, name, bare, ra, dec, pmRA, pmDec, epoch, brightnesses, integratedUnits, surfaceUnits, parallax, rv, z);
    }

    public Option<Object> copy$default$1() {
        return this.line();
    }

    public String copy$default$2() {
        return this.name();
    }

    public boolean copy$default$3() {
        return this.bare();
    }

    public Option<RightAscension> copy$default$4() {
        return this.ra();
    }

    public Option<Declination> copy$default$5() {
        return this.dec();
    }

    public Option<Object> copy$default$6() {
        return this.pmRA();
    }

    public Option<Object> copy$default$7() {
        return this.pmDec();
    }

    public Option<Epoch> copy$default$8() {
        return this.epoch();
    }

    public Map<Band, BigDecimal> copy$default$9() {
        return this.brightnesses();
    }

    public Map<Band, Units> copy$default$10() {
        return this.integratedUnits();
    }

    public Map<Band, Units> copy$default$11() {
        return this.surfaceUnits();
    }

    public Option<Parallax> copy$default$12() {
        return this.parallax();
    }

    public Option<RadialVelocity> copy$default$13() {
        return this.rv();
    }

    public Option<Redshift> copy$default$14() {
        return this.z();
    }

    public Option<Object> _1() {
        return this.line();
    }

    public String _2() {
        return this.name();
    }

    public boolean _3() {
        return this.bare();
    }

    public Option<RightAscension> _4() {
        return this.ra();
    }

    public Option<Declination> _5() {
        return this.dec();
    }

    public Option<Object> _6() {
        return this.pmRA();
    }

    public Option<Object> _7() {
        return this.pmDec();
    }

    public Option<Epoch> _8() {
        return this.epoch();
    }

    public Map<Band, BigDecimal> _9() {
        return this.brightnesses();
    }

    public Map<Band, Units> _10() {
        return this.integratedUnits();
    }

    public Map<Band, Units> _11() {
        return this.surfaceUnits();
    }

    public Option<Parallax> _12() {
        return this.parallax();
    }

    public Option<RadialVelocity> _13() {
        return this.rv();
    }

    public Option<Redshift> _14() {
        return this.z();
    }

    private static final Units $anonfun$1(Function1 defaultUnit$2, Tuple2 b$1) {
        return (Units)defaultUnit$2.apply(b$1._1());
    }
}

