/*
 * Decompiled with CFR 0.152.
 */
package lucuma.catalog.votable;

import cats.Foldable;
import cats.UnorderedFoldable$;
import cats.kernel.Semigroup$;
import cats.syntax.OptionOps$;
import cats.syntax.package;
import java.io.Serializable;
import lucuma.catalog.votable.CatalogProblem$;
import lucuma.catalog.votable.CatalogProblem$CatalogException$;
import lucuma.catalog.votable.CatalogProblem$FieldValueProblem$;
import lucuma.catalog.votable.CatalogProblem$GenericError$;
import lucuma.catalog.votable.CatalogProblem$InvalidFieldId$;
import lucuma.catalog.votable.CatalogProblem$InvalidUcd$;
import lucuma.catalog.votable.CatalogProblem$MissingValue$;
import lucuma.catalog.votable.CatalogProblem$MissingXmlAttribute$;
import lucuma.catalog.votable.CatalogProblem$MissingXmlTag$;
import lucuma.catalog.votable.CatalogProblem$UnexpectedTag$;
import lucuma.catalog.votable.CatalogProblem$UnknownXmlTag$;
import lucuma.catalog.votable.CatalogProblem$UnmatchedField$;
import lucuma.catalog.votable.CatalogProblem$UnsupportedField$;
import lucuma.catalog.votable.CatalogProblem$ValidationError$;
import lucuma.catalog.votable.FieldId;
import lucuma.catalog.votable.Ucd;
import lucuma.core.enums.CatalogName;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface CatalogProblem
extends Product,
Serializable {
    public static int ordinal(CatalogProblem catalogProblem) {
        return CatalogProblem$.MODULE$.ordinal(catalogProblem);
    }

    public String displayValue();

    public static String toString$(CatalogProblem $this) {
        return $this.toString();
    }

    default public String toString() {
        return this.displayValue();
    }

    public static class CatalogException
    extends RuntimeException
    implements Product {
        private final List<CatalogProblem> problems;

        public static CatalogException apply(List<CatalogProblem> list) {
            return CatalogProblem$CatalogException$.MODULE$.apply(list);
        }

        public static CatalogException fromProduct(Product product) {
            return CatalogProblem$CatalogException$.MODULE$.fromProduct(product);
        }

        public static CatalogException unapply(CatalogException catalogException) {
            return CatalogProblem$CatalogException$.MODULE$.unapply(catalogException);
        }

        public CatalogException(List<CatalogProblem> problems) {
            this.problems = problems;
            super(problems.mkString(", "));
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CatalogException)) return false;
            CatalogException catalogException = (CatalogException)object;
            List<CatalogProblem> list = this.problems();
            List<CatalogProblem> list2 = catalogException.problems();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            if (!catalogException.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof CatalogException;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "CatalogException";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "problems";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<CatalogProblem> problems() {
            return this.problems;
        }

        public String firstMessage() {
            Option option = package.all$.MODULE$.catsSyntaxOption(this.problems().headOption().map(CatalogProblem$::lucuma$catalog$votable$CatalogProblem$CatalogException$$_$firstMessage$$anonfun$1));
            return (String)OptionOps$.MODULE$.orEmpty$extension(option, Semigroup$.MODULE$.catsKernelMonoidForString());
        }

        public CatalogException copy(List<CatalogProblem> problems) {
            return new CatalogException(problems);
        }

        public List<CatalogProblem> copy$default$1() {
            return this.problems();
        }

        public List<CatalogProblem> _1() {
            return this.problems();
        }
    }

    public static class FieldValueProblem
    extends Throwable
    implements Product,
    CatalogProblem {
        private final Option<Ucd> ucd;
        private final String value;
        private final String displayValue;

        public static FieldValueProblem apply(Option<Ucd> option, String string) {
            return CatalogProblem$FieldValueProblem$.MODULE$.apply(option, string);
        }

        public static FieldValueProblem fromProduct(Product product) {
            return CatalogProblem$FieldValueProblem$.MODULE$.fromProduct(product);
        }

        public static FieldValueProblem unapply(FieldValueProblem fieldValueProblem) {
            return CatalogProblem$FieldValueProblem$.MODULE$.unapply(fieldValueProblem);
        }

        public FieldValueProblem(Option<Ucd> ucd, String value2) {
            this.ucd = ucd;
            this.value = value2;
            this.displayValue = "Error parsing field " + package.all$.MODULE$.toFoldableOps(ucd, (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForOption()).foldMap((Function1 & Serializable)_$1 -> _$1.toString(), Semigroup$.MODULE$.catsKernelMonoidForString()) + " with value " + value2;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FieldValueProblem)) return false;
            FieldValueProblem fieldValueProblem = (FieldValueProblem)object;
            Option<Ucd> option = this.ucd();
            Option<Ucd> option2 = fieldValueProblem.ucd();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            String string = this.value();
            String string2 = fieldValueProblem.value();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!fieldValueProblem.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof FieldValueProblem;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "FieldValueProblem";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "ucd";
            }
            if (1 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Option<Ucd> ucd() {
            return this.ucd;
        }

        public String value() {
            return this.value;
        }

        @Override
        public String displayValue() {
            return this.displayValue;
        }

        public FieldValueProblem copy(Option<Ucd> ucd, String value2) {
            return new FieldValueProblem(ucd, value2);
        }

        public Option<Ucd> copy$default$1() {
            return this.ucd();
        }

        public String copy$default$2() {
            return this.value();
        }

        public Option<Ucd> _1() {
            return this.ucd();
        }

        public String _2() {
            return this.value();
        }
    }

    public static class GenericError
    extends Throwable
    implements Product,
    CatalogProblem {
        private final String msg;
        private final String displayValue;

        public static GenericError apply(String string) {
            return CatalogProblem$GenericError$.MODULE$.apply(string);
        }

        public static GenericError fromProduct(Product product) {
            return CatalogProblem$GenericError$.MODULE$.fromProduct(product);
        }

        public static GenericError unapply(GenericError genericError) {
            return CatalogProblem$GenericError$.MODULE$.unapply(genericError);
        }

        public GenericError(String msg) {
            this.msg = msg;
            this.displayValue = msg;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof GenericError)) return false;
            GenericError genericError = (GenericError)object;
            String string = this.msg();
            String string2 = genericError.msg();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!genericError.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof GenericError;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "GenericError";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "msg";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String msg() {
            return this.msg;
        }

        @Override
        public String displayValue() {
            return this.displayValue;
        }

        public GenericError copy(String msg) {
            return new GenericError(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static class InvalidFieldId
    extends Throwable
    implements Product,
    CatalogProblem {
        private final String id;
        private final String displayValue;

        public static InvalidFieldId apply(String string) {
            return CatalogProblem$InvalidFieldId$.MODULE$.apply(string);
        }

        public static InvalidFieldId fromProduct(Product product) {
            return CatalogProblem$InvalidFieldId$.MODULE$.fromProduct(product);
        }

        public static InvalidFieldId unapply(InvalidFieldId invalidFieldId) {
            return CatalogProblem$InvalidFieldId$.MODULE$.unapply(invalidFieldId);
        }

        public InvalidFieldId(String id) {
            this.id = id;
            this.displayValue = "Invalid field id: '" + id + "'";
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof InvalidFieldId)) return false;
            InvalidFieldId invalidFieldId = (InvalidFieldId)object;
            String string = this.id();
            String string2 = invalidFieldId.id();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!invalidFieldId.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof InvalidFieldId;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "InvalidFieldId";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "id";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String id() {
            return this.id;
        }

        @Override
        public String displayValue() {
            return this.displayValue;
        }

        public InvalidFieldId copy(String id) {
            return new InvalidFieldId(id);
        }

        public String copy$default$1() {
            return this.id();
        }

        public String _1() {
            return this.id();
        }
    }

    public static class InvalidUcd
    extends Throwable
    implements Product,
    CatalogProblem {
        private final String ucd;
        private final String displayValue;

        public static InvalidUcd apply(String string) {
            return CatalogProblem$InvalidUcd$.MODULE$.apply(string);
        }

        public static InvalidUcd fromProduct(Product product) {
            return CatalogProblem$InvalidUcd$.MODULE$.fromProduct(product);
        }

        public static InvalidUcd unapply(InvalidUcd invalidUcd) {
            return CatalogProblem$InvalidUcd$.MODULE$.unapply(invalidUcd);
        }

        public InvalidUcd(String ucd) {
            this.ucd = ucd;
            this.displayValue = "Invalid ucd: '" + ucd + "'";
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof InvalidUcd)) return false;
            InvalidUcd invalidUcd = (InvalidUcd)object;
            String string = this.ucd();
            String string2 = invalidUcd.ucd();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!invalidUcd.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof InvalidUcd;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "InvalidUcd";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "ucd";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String ucd() {
            return this.ucd;
        }

        @Override
        public String displayValue() {
            return this.displayValue;
        }

        public InvalidUcd copy(String ucd) {
            return new InvalidUcd(ucd);
        }

        public String copy$default$1() {
            return this.ucd();
        }

        public String _1() {
            return this.ucd();
        }
    }

    public static class MissingValue
    extends Throwable
    implements Product,
    CatalogProblem {
        private final FieldId field;
        private final String displayValue;

        public static MissingValue apply(FieldId fieldId) {
            return CatalogProblem$MissingValue$.MODULE$.apply(fieldId);
        }

        public static MissingValue fromProduct(Product product) {
            return CatalogProblem$MissingValue$.MODULE$.fromProduct(product);
        }

        public static MissingValue unapply(MissingValue missingValue) {
            return CatalogProblem$MissingValue$.MODULE$.unapply(missingValue);
        }

        public MissingValue(FieldId field) {
            this.field = field;
            this.displayValue = "Missing required field '" + field.id() + "'";
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MissingValue)) return false;
            MissingValue missingValue = (MissingValue)object;
            FieldId fieldId = this.field();
            FieldId fieldId2 = missingValue.field();
            if (fieldId == null) {
                if (fieldId2 != null) {
                    return false;
                }
            } else if (!((Object)fieldId).equals(fieldId2)) return false;
            if (!missingValue.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof MissingValue;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "MissingValue";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "field";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public FieldId field() {
            return this.field;
        }

        @Override
        public String displayValue() {
            return this.displayValue;
        }

        public MissingValue copy(FieldId field) {
            return new MissingValue(field);
        }

        public FieldId copy$default$1() {
            return this.field();
        }

        public FieldId _1() {
            return this.field();
        }
    }

    public static class MissingXmlAttribute
    extends Throwable
    implements Product,
    CatalogProblem {
        private final String attr;
        private final String displayValue;

        public static MissingXmlAttribute apply(String string) {
            return CatalogProblem$MissingXmlAttribute$.MODULE$.apply(string);
        }

        public static MissingXmlAttribute fromProduct(Product product) {
            return CatalogProblem$MissingXmlAttribute$.MODULE$.fromProduct(product);
        }

        public static MissingXmlAttribute unapply(MissingXmlAttribute missingXmlAttribute) {
            return CatalogProblem$MissingXmlAttribute$.MODULE$.unapply(missingXmlAttribute);
        }

        public MissingXmlAttribute(String attr) {
            this.attr = attr;
            this.displayValue = "Missing attr: '" + attr + "'";
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MissingXmlAttribute)) return false;
            MissingXmlAttribute missingXmlAttribute = (MissingXmlAttribute)object;
            String string = this.attr();
            String string2 = missingXmlAttribute.attr();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!missingXmlAttribute.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof MissingXmlAttribute;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "MissingXmlAttribute";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "attr";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String attr() {
            return this.attr;
        }

        @Override
        public String displayValue() {
            return this.displayValue;
        }

        public MissingXmlAttribute copy(String attr) {
            return new MissingXmlAttribute(attr);
        }

        public String copy$default$1() {
            return this.attr();
        }

        public String _1() {
            return this.attr();
        }
    }

    public static class MissingXmlTag
    extends Throwable
    implements Product,
    CatalogProblem {
        private final String tag;
        private final String displayValue;

        public static MissingXmlTag apply(String string) {
            return CatalogProblem$MissingXmlTag$.MODULE$.apply(string);
        }

        public static MissingXmlTag fromProduct(Product product) {
            return CatalogProblem$MissingXmlTag$.MODULE$.fromProduct(product);
        }

        public static MissingXmlTag unapply(MissingXmlTag missingXmlTag) {
            return CatalogProblem$MissingXmlTag$.MODULE$.unapply(missingXmlTag);
        }

        public MissingXmlTag(String tag) {
            this.tag = tag;
            this.displayValue = "Missing tag: '" + tag + "'";
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MissingXmlTag)) return false;
            MissingXmlTag missingXmlTag = (MissingXmlTag)object;
            String string = this.tag();
            String string2 = missingXmlTag.tag();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!missingXmlTag.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof MissingXmlTag;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "MissingXmlTag";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "tag";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String tag() {
            return this.tag;
        }

        @Override
        public String displayValue() {
            return this.displayValue;
        }

        public MissingXmlTag copy(String tag) {
            return new MissingXmlTag(tag);
        }

        public String copy$default$1() {
            return this.tag();
        }

        public String _1() {
            return this.tag();
        }
    }

    public static class UnexpectedTag
    extends Throwable
    implements Product,
    CatalogProblem {
        private final String tag;
        private final String displayValue;

        public static UnexpectedTag apply(String string) {
            return CatalogProblem$UnexpectedTag$.MODULE$.apply(string);
        }

        public static UnexpectedTag fromProduct(Product product) {
            return CatalogProblem$UnexpectedTag$.MODULE$.fromProduct(product);
        }

        public static UnexpectedTag unapply(UnexpectedTag unexpectedTag) {
            return CatalogProblem$UnexpectedTag$.MODULE$.unapply(unexpectedTag);
        }

        public UnexpectedTag(String tag) {
            this.tag = tag;
            this.displayValue = "Unexpected tag " + tag;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UnexpectedTag)) return false;
            UnexpectedTag unexpectedTag = (UnexpectedTag)object;
            String string = this.tag();
            String string2 = unexpectedTag.tag();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!unexpectedTag.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof UnexpectedTag;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "UnexpectedTag";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "tag";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String tag() {
            return this.tag;
        }

        @Override
        public String displayValue() {
            return this.displayValue;
        }

        public UnexpectedTag copy(String tag) {
            return new UnexpectedTag(tag);
        }

        public String copy$default$1() {
            return this.tag();
        }

        public String _1() {
            return this.tag();
        }
    }

    public static class UnknownXmlTag
    extends Throwable
    implements Product,
    CatalogProblem {
        private final String tag;
        private final String displayValue;

        public static UnknownXmlTag apply(String string) {
            return CatalogProblem$UnknownXmlTag$.MODULE$.apply(string);
        }

        public static UnknownXmlTag fromProduct(Product product) {
            return CatalogProblem$UnknownXmlTag$.MODULE$.fromProduct(product);
        }

        public static UnknownXmlTag unapply(UnknownXmlTag unknownXmlTag) {
            return CatalogProblem$UnknownXmlTag$.MODULE$.unapply(unknownXmlTag);
        }

        public UnknownXmlTag(String tag) {
            this.tag = tag;
            this.displayValue = "Unknown tag: '" + tag + "'";
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UnknownXmlTag)) return false;
            UnknownXmlTag unknownXmlTag = (UnknownXmlTag)object;
            String string = this.tag();
            String string2 = unknownXmlTag.tag();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!unknownXmlTag.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof UnknownXmlTag;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "UnknownXmlTag";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "tag";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String tag() {
            return this.tag;
        }

        @Override
        public String displayValue() {
            return this.displayValue;
        }

        public UnknownXmlTag copy(String tag) {
            return new UnknownXmlTag(tag);
        }

        public String copy$default$1() {
            return this.tag();
        }

        public String _1() {
            return this.tag();
        }
    }

    public static class UnmatchedField
    extends Throwable
    implements Product,
    CatalogProblem {
        private final Option<Ucd> ucd;
        private final String displayValue;

        public static UnmatchedField apply(Option<Ucd> option) {
            return CatalogProblem$UnmatchedField$.MODULE$.apply(option);
        }

        public static UnmatchedField fromProduct(Product product) {
            return CatalogProblem$UnmatchedField$.MODULE$.fromProduct(product);
        }

        public static UnmatchedField unapply(UnmatchedField unmatchedField) {
            return CatalogProblem$UnmatchedField$.MODULE$.unapply(unmatchedField);
        }

        public UnmatchedField(Option<Ucd> ucd) {
            this.ucd = ucd;
            this.displayValue = "Unmatched field " + package.all$.MODULE$.toFoldableOps(ucd, (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForOption()).foldMap((Function1 & Serializable)_$2 -> _$2.toString(), Semigroup$.MODULE$.catsKernelMonoidForString());
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UnmatchedField)) return false;
            UnmatchedField unmatchedField = (UnmatchedField)object;
            Option<Ucd> option = this.ucd();
            Option<Ucd> option2 = unmatchedField.ucd();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!unmatchedField.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof UnmatchedField;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "UnmatchedField";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "ucd";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Option<Ucd> ucd() {
            return this.ucd;
        }

        @Override
        public String displayValue() {
            return this.displayValue;
        }

        public UnmatchedField copy(Option<Ucd> ucd) {
            return new UnmatchedField(ucd);
        }

        public Option<Ucd> copy$default$1() {
            return this.ucd();
        }

        public Option<Ucd> _1() {
            return this.ucd();
        }
    }

    public static class UnsupportedField
    extends Throwable
    implements Product,
    CatalogProblem {
        private final FieldId field;
        private final String displayValue;

        public static UnsupportedField apply(FieldId fieldId) {
            return CatalogProblem$UnsupportedField$.MODULE$.apply(fieldId);
        }

        public static UnsupportedField fromProduct(Product product) {
            return CatalogProblem$UnsupportedField$.MODULE$.fromProduct(product);
        }

        public static UnsupportedField unapply(UnsupportedField unsupportedField) {
            return CatalogProblem$UnsupportedField$.MODULE$.unapply(unsupportedField);
        }

        public UnsupportedField(FieldId field) {
            this.field = field;
            this.displayValue = "Unsupported field " + field;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UnsupportedField)) return false;
            UnsupportedField unsupportedField = (UnsupportedField)object;
            FieldId fieldId = this.field();
            FieldId fieldId2 = unsupportedField.field();
            if (fieldId == null) {
                if (fieldId2 != null) {
                    return false;
                }
            } else if (!((Object)fieldId).equals(fieldId2)) return false;
            if (!unsupportedField.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof UnsupportedField;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "UnsupportedField";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "field";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public FieldId field() {
            return this.field;
        }

        @Override
        public String displayValue() {
            return this.displayValue;
        }

        public UnsupportedField copy(FieldId field) {
            return new UnsupportedField(field);
        }

        public FieldId copy$default$1() {
            return this.field();
        }

        public FieldId _1() {
            return this.field();
        }
    }

    public static class ValidationError
    extends Throwable
    implements Product,
    CatalogProblem {
        private final CatalogName catalog;
        private final String displayValue;

        public static ValidationError apply(CatalogName catalogName) {
            return CatalogProblem$ValidationError$.MODULE$.apply(catalogName);
        }

        public static ValidationError fromProduct(Product product) {
            return CatalogProblem$ValidationError$.MODULE$.fromProduct(product);
        }

        public static ValidationError unapply(ValidationError validationError) {
            return CatalogProblem$ValidationError$.MODULE$.unapply(validationError);
        }

        public ValidationError(CatalogName catalog) {
            this.catalog = catalog;
            this.displayValue = "Invalid response from " + catalog;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ValidationError)) return false;
            ValidationError validationError = (ValidationError)object;
            CatalogName catalogName = this.catalog();
            CatalogName catalogName2 = validationError.catalog();
            if (catalogName == null) {
                if (catalogName2 != null) {
                    return false;
                }
            } else if (!catalogName.equals(catalogName2)) return false;
            if (!validationError.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof ValidationError;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ValidationError";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "catalog";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public CatalogName catalog() {
            return this.catalog;
        }

        @Override
        public String displayValue() {
            return this.displayValue;
        }

        public ValidationError copy(CatalogName catalog) {
            return new ValidationError(catalog);
        }

        public CatalogName copy$default$1() {
            return this.catalog();
        }

        public CatalogName _1() {
            return this.catalog();
        }
    }
}

