/*
 * Decompiled with CFR 0.152.
 */
package lucuma.core.enums;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import lucuma.core.enums.Site$;
import lucuma.core.math.Declination;
import lucuma.core.math.Place;
import lucuma.core.model.ObservingNight$;
import lucuma.core.util.DateInterval;
import lucuma.core.util.Enumerated;
import scala.Option;
import scala.Product;
import scala.collection.immutable.List;

public abstract class Site
implements Product,
Serializable {
    private final String tag;
    private final String shortName;
    private final String longName;
    private final Place place;
    private final String mountain;
    private final Declination latitude;
    private final long longitude;
    private final int altitude;
    private final ZoneId timezone;

    public static Enumerated<Site> SiteEnumerated() {
        return Site$.MODULE$.SiteEnumerated();
    }

    public static List<Site> all() {
        return Site$.MODULE$.all();
    }

    public static Option<Site> fromTag(String string2) {
        return Site$.MODULE$.fromTag(string2);
    }

    public static int ordinal(Site site) {
        return Site$.MODULE$.ordinal(site);
    }

    public static Site unsafeFromTag(String string2) {
        return Site$.MODULE$.unsafeFromTag(string2);
    }

    public Site(String tag, String shortName, String longName, Place place, String mountain) {
        this.tag = tag;
        this.shortName = shortName;
        this.longName = longName;
        this.place = place;
        this.mountain = mountain;
        this.latitude = place.latitude();
        this.longitude = place.longitude();
        this.altitude = place.altitude();
        this.timezone = place.timezone();
    }

    public String tag() {
        return this.tag;
    }

    public String shortName() {
        return this.shortName;
    }

    public String longName() {
        return this.longName;
    }

    public Place place() {
        return this.place;
    }

    public String mountain() {
        return this.mountain;
    }

    public Declination latitude() {
        return this.latitude;
    }

    public long longitude() {
        return this.longitude;
    }

    public int altitude() {
        return this.altitude;
    }

    public ZoneId timezone() {
        return this.timezone;
    }

    public Instant midpoint(DateInterval active) {
        Instant start = ObservingNight$.MODULE$.fromSiteAndLocalDate(this, active.start()).start();
        Instant end = ObservingNight$.MODULE$.fromSiteAndLocalDate(this, active.end()).end();
        Duration duration2 = Duration.between(start, end);
        return start.plus(duration2.dividedBy(2L));
    }
}

